/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.arithmeticFunctions;

import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class DoubleAbsFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:double-abs";
    private static final long serialVersionUID = 1L;

    @Override
    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length != 1) {
                throw new FunctionProcessingException("Invalid number of parameters.");
            }
            return Math.abs((Double)args[0]);
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.", e);
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    @Override
    public String getFunctionId() {
        return ID;
    }
}

