/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.arithmeticFunctions;

import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class DoubleAddFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:double-add";
    private static final long serialVersionUID = 1L;

    @Override
    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length < 2) {
                throw new FunctionProcessingException("Invalid number of parameters.");
            }
            Double[] integers = new Double[args.length];
            for (int i = 0; i < args.length; ++i) {
                integers[i] = (Double)args[i];
            }
            Double result = Double.valueOf("0");
            for (Double i : integers) {
                result = result + i;
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.", e);
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    @Override
    public String getFunctionId() {
        return ID;
    }
}

