/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.policy.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.converter.DataTypeJAXBTypeAdapter;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.herasaf.xacml.core.policy.ExpressionProcessingException;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.ActionAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.EnvironmentAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.ExpressionType;
import org.herasaf.xacml.core.policy.impl.ResourceAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.SubjectAttributeDesignatorType;

@XmlRootElement(name="AttributeDesignator", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os")
@XmlType(name="AttributeDesignatorType")
@XmlSeeAlso(value={SubjectAttributeDesignatorType.class, ResourceAttributeDesignatorType.class, EnvironmentAttributeDesignatorType.class, ActionAttributeDesignatorType.class})
public abstract class AttributeDesignatorType
extends ExpressionType {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="AttributeId", required=true)
    @XmlSchemaType(name="anyURI")
    private String attributeId;
    @XmlAttribute(name="DataType", required=true)
    @XmlJavaTypeAdapter(value=DataTypeJAXBTypeAdapter.class)
    @XmlSchemaType(name="anyURI")
    private DataTypeAttribute<?> dataType;
    @XmlAttribute(name="Issuer")
    private String issuer;
    @XmlAttribute(name="MustBePresent")
    private Boolean mustBePresent;

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String value) {
        this.attributeId = value;
    }

    public DataTypeAttribute<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeAttribute<?> value) {
        this.dataType = value;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String value) {
        this.issuer = value;
    }

    public boolean isMustBePresent() {
        if (this.mustBePresent == null) {
            return false;
        }
        return this.mustBePresent;
    }

    public void setMustBePresent(Boolean value) {
        this.mustBePresent = value;
    }

    @Override
    public abstract Object handle(RequestType var1, EvaluationContext var2) throws ExpressionProcessingException, MissingAttributeException, SyntaxException;

    protected List<Object> handle(List<AttributeType> requestAttributes) throws ExpressionProcessingException, MissingAttributeException, SyntaxException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (AttributeType attr : requestAttributes) {
            this.validateAttributeType(attr);
            if (!this.getAttributeId().equals(attr.getAttributeId()) || !this.getDataType().toString().equals(attr.getDataType().toString())) continue;
            if (this.getIssuer() != null) {
                if (!this.getIssuer().equals(attr.getIssuer())) continue;
                this.addAndConvertAttrValue(returnValues, attr.getAttributeValues());
                continue;
            }
            this.addAndConvertAttrValue(returnValues, attr.getAttributeValues());
        }
        return returnValues;
    }

    protected void addAndConvertAttrValue(List<Object> returnValues, List<AttributeValueType> attrValues) throws ExpressionProcessingException, SyntaxException {
        for (AttributeValueType attrVal : attrValues) {
            if (attrVal.getContent().size() > 1) {
                throw new ExpressionProcessingException("The content of the AttributeValueType can't be greater than 1");
            }
            try {
                returnValues.add(this.dataType.convertTo(attrVal.getContent()));
            }
            catch (ClassCastException e) {
                throw new SyntaxException(e);
            }
        }
    }

    protected void validateAttributeDesignator() throws SyntaxException {
        if (this.getAttributeId() == null) {
            String message = "Attribute AttributeId of AttributeDesignator must be present.";
            throw new SyntaxException(message);
        }
        if (this.getDataType() == null) {
            String message = "Attribute DataType of AttributeDesignator must be present.";
            throw new SyntaxException(message);
        }
    }

    private void validateAttributeType(AttributeType requestAttributeType) throws SyntaxException {
        if (requestAttributeType.getAttributeId() == null) {
            String message = "Attribute AttributeId of AttributeType must be present.";
            throw new SyntaxException(message);
        }
        if (requestAttributeType.getDataType() == null) {
            String message = "Attribute DataType of AttributeType must be present.";
            throw new SyntaxException(message);
        }
    }
}

