/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.policy.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.herasaf.xacml.core.policy.ExpressionProcessingException;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.AttributeDesignatorType;

@XmlRootElement(name="SubjectAttributeDesignator", namespace="urn:oasis:names:tc:xacml:2.0:policy:schema:os")
@XmlType(name="SubjectAttributeDesignatorType")
public class SubjectAttributeDesignatorType
extends AttributeDesignatorType {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="SubjectCategory")
    @XmlSchemaType(name="anyURI")
    private String subjectCategory;

    public String getSubjectCategory() {
        if (this.subjectCategory == null) {
            return "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
        }
        return this.subjectCategory;
    }

    public void setSubjectCategory(String value) {
        this.subjectCategory = value;
    }

    @Override
    public Object handle(RequestType request, EvaluationContext evaluationContext) throws ExpressionProcessingException, MissingAttributeException, SyntaxException {
        this.validateAttributeDesignator();
        List<Object> returnValues = this.handle(request);
        if (returnValues.size() == 0 && evaluationContext.getPIP() != null) {
            List<AttributeValueType> attrValues = evaluationContext.getPIP().fetchSubjectAttributes(request, this.getAttributeId(), this.getDataType().toString(), this.getIssuer(), this.getSubjectCategory());
            this.addAndConvertAttrValue(returnValues, attrValues);
        }
        if (returnValues.size() == 0 && this.isMustBePresent()) {
            throw new MissingAttributeException(this.getAttributeId(), this.getDataType(), this.getIssuer());
        }
        return returnValues;
    }

    public List<Object> handle(RequestType request) throws ExpressionProcessingException, MissingAttributeException, SyntaxException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        List<SubjectType> subjects = request.getSubjects();
        for (SubjectType sub : subjects) {
            if (!sub.getSubjectCategory().equals(this.getSubjectCategory())) continue;
            returnValues.addAll(this.handle(sub.getAttributes()));
        }
        return returnValues;
    }
}

