/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP;

import java.time.ZoneId;
import org.herasaf.xacml.core.InitializationException;
import org.herasaf.xacml.core.api.OrderedPolicyRepository;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PIP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyOrderedCombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyUnorderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.ResponseMarshaller;
import org.herasaf.xacml.core.context.StatusCodeComparator;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResponseType;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;
import org.herasaf.xacml.core.types.Date;
import org.herasaf.xacml.core.types.DateTime;
import org.herasaf.xacml.core.types.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SimplePDP
implements PDP {
    private final PolicyRetrievalPoint policyRepository;
    private final PIP pip;
    private final PolicyCombiningAlgorithm rootPolicyCombiningAlgorithm;
    private final TargetMatcher targetMatcher;
    private final boolean respectAbandonedEvaluatables;
    private static final Logger logger = LoggerFactory.getLogger(SimplePDP.class);
    private static final String MDC_REQUEST_TIME = "org:herasaf:request:xacml:evaluation:requesttime";
    private final StatusCodeComparator statusCodeComparator;

    public SimplePDP(SimplePDPConfiguration simplePDPConfiguration) {
        this.rootPolicyCombiningAlgorithm = simplePDPConfiguration.getRootCombiningAlgorithm();
        this.policyRepository = simplePDPConfiguration.getPolicyRetrievalPoint();
        if (!((PolicyOrderedCombiningAlgorithm.class.isInstance(this.rootPolicyCombiningAlgorithm) && OrderedPolicyRepository.class.isInstance(this.policyRepository)) ^ PolicyUnorderedCombiningAlgorithm.class.isInstance(this.rootPolicyCombiningAlgorithm))) {
            InitializationException ie = new InitializationException("Root combining algorithm and policy repository are not of the same type (type is either ordered or unordered).");
            logger.error(ie.getMessage());
            throw ie;
        }
        this.respectAbandonedEvaluatables = simplePDPConfiguration.isRespectAbandonedEvaluatables();
        this.pip = simplePDPConfiguration.getPip();
        this.targetMatcher = simplePDPConfiguration.getTargetMatcher();
        this.statusCodeComparator = simplePDPConfiguration.getStatusCodeComparator();
        if (this.pip == null) {
            logger.warn("No PIP is set. Attributes that are not present in the request cannot be resolved.");
        }
        boolean useZuluUtcRepresentation = simplePDPConfiguration.isZuluUtcRepresentation();
        ZoneId defaultZone = simplePDPConfiguration.getTimeZone();
        DateTime.configureWith(useZuluUtcRepresentation, defaultZone);
        Date.configureWith(useZuluUtcRepresentation, defaultZone);
        Time.useZuluUtcRepresentation(useZuluUtcRepresentation);
    }

    @Override
    public PolicyRetrievalPoint getPolicyRepository() {
        return this.policyRepository;
    }

    @Override
    public PIP getPIP() {
        return this.pip;
    }

    @Override
    public PolicyCombiningAlgorithm getRootCombiningAlgorithm() {
        return this.rootPolicyCombiningAlgorithm;
    }

    @Override
    public ResponseType evaluate(RequestType request) {
        MDC.put((String)MDC_REQUEST_TIME, (String)String.valueOf(System.currentTimeMillis()));
        logger.debug("Evaluating Request: {}", (Object)request);
        request.ensureThatCreationTimeIsSet();
        EvaluationContext evaluationContext = new EvaluationContext(this.targetMatcher, this.pip, this.respectAbandonedEvaluatables, this.statusCodeComparator, this.policyRepository);
        if (!this.containsOnlyOneResource(request)) {
            logger.error("The request must not contain multiple resources.");
            return this.createResponse(request, DecisionType.INDETERMINATE, evaluationContext);
        }
        DecisionType decision = this.rootPolicyCombiningAlgorithm.evaluateEvaluatableList(request, this.policyRepository.getEvaluatables(request), evaluationContext);
        MDC.remove((String)MDC_REQUEST_TIME);
        return this.createResponse(request, decision, evaluationContext);
    }

    protected ResponseType createResponse(RequestType request, DecisionType decision, EvaluationContext evaluationContext) {
        return ResponseMarshaller.create(request, decision, evaluationContext);
    }

    private boolean containsOnlyOneResource(RequestType request) {
        if (request.getResources().size() > 1) {
            logger.error("The request must not contain more than one <Resource> elements.");
            return false;
        }
        if (request.getResources().size() == 1) {
            for (AttributeType attr : request.getResources().get(0).getAttributes()) {
                if (!"urn:oasis:names:tc:xacml:2.0:resource:scope".startsWith(attr.getAttributeId())) continue;
                if ("Immediate".equals(attr.getAttributeValues().get(0))) {
                    return true;
                }
                if (!"Children".equals(attr.getAttributeValues().get(0)) && !"Descendants".equals(attr.getAttributeValues().get(0)) && !"XPath-expression".equals(attr.getAttributeValues().get(0)) && !"EntireHierarchy".equals(attr.getAttributeValues().get(0))) continue;
                logger.error("The request must not request a decision for multiple resources.");
                return false;
            }
            return true;
        }
        return true;
    }
}

