/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import org.herasaf.xacml.core.types.PortRange;

public class DnsName {
    private static final String DNS_NAME_PART_DELIMITER = "\\.";
    private static final String PORT_RANGE_DELIMITER = ":";
    private static final String AC = "[^!#\\$%&'()\\*\\+,/:;=\\?@\\[\\]\\s]";
    private static final String MATCHPATTERN = "^(([^!#\\$%&'()\\*\\+,/:;=\\?@\\[\\]\\s]+(\\.[^!#\\$%&'()\\*\\+,/:;=\\?@\\[\\]\\s]+)*)|(\\*)|(\\*\\.[^!#\\$%&'()\\*\\+,/:;=\\?@\\[\\]\\s]+(\\.[^!#\\$%&'()\\*\\+,/:;=\\?@\\[\\]\\s]+)*))(:[\\d\\-]+)??$";
    private PortRange portRange;
    private String[] dnsNameParts = null;

    public DnsName(String stringRepresentation) {
        if (!stringRepresentation.matches(MATCHPATTERN)) {
            throw new IllegalArgumentException("String is not a dns name: " + stringRepresentation);
        }
        int colonPosition = stringRepresentation.indexOf(PORT_RANGE_DELIMITER);
        if (colonPosition != -1) {
            this.portRange = new PortRange(stringRepresentation.substring(colonPosition + 1, stringRepresentation.length()));
            this.dnsNameParts = stringRepresentation.split(PORT_RANGE_DELIMITER)[0].split(DNS_NAME_PART_DELIMITER);
        } else {
            this.dnsNameParts = stringRepresentation.split(DNS_NAME_PART_DELIMITER);
        }
    }

    public String toString() {
        StringBuilder dnsName = new StringBuilder();
        for (int i = 0; i < this.dnsNameParts.length; ++i) {
            String dnsNamePart = this.dnsNameParts[i];
            if (i != 0) {
                dnsNamePart = "." + dnsNamePart;
            }
            dnsName.append(dnsNamePart);
        }
        if (this.portRange != null) {
            dnsName.append(PORT_RANGE_DELIMITER + this.portRange.toString());
        }
        return dnsName.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

