/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.util.Arrays;

public class HexBinary {
    private char[] value;

    public HexBinary(String stringRepresentation) {
        if (stringRepresentation.length() % 2 != 0) {
            throw new IllegalArgumentException("A HexBinary string must have even length.");
        }
        this.value = new char[stringRepresentation.length()];
        stringRepresentation = stringRepresentation.toLowerCase();
        stringRepresentation.getChars(0, stringRepresentation.length(), this.value, 0);
        for (char c : this.value) {
            if ('0' <= c && c <= '9' || 'a' <= c && c <= 'f') continue;
            throw new IllegalArgumentException("The String " + stringRepresentation + " is not a hex string");
        }
    }

    public char[] getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().isAssignableFrom(HexBinary.class)) {
            return Arrays.equals(((HexBinary)obj).getValue(), this.value);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

