/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.herasaf.xacml.core.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Time
implements Comparable<Time> {
    private static final Logger logger = LoggerFactory.getLogger(Time.class);
    private static DateTimeFormatter timeFormatter;
    private OffsetTime time;

    public static void useZuluUtcRepresentation(boolean useZuluUtcRepresentation) {
        timeFormatter = useZuluUtcRepresentation ? new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffsetId().toFormatter() : new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:MM", "+00:00").toFormatter();
    }

    public Time(String timeString) throws SyntaxException {
        try {
            TemporalAccessor parsed = timeFormatter.parseBest(timeString.trim().replace("Z", "+00:00"), OffsetTime::from, LocalTime::from);
            this.time = parsed instanceof LocalTime ? ((LocalTime)parsed).atOffset(ZoneOffset.UTC) : (OffsetTime)parsed;
        }
        catch (DateTimeParseException e) {
            String message = "Parsing time is not supported.";
            logger.error(message);
            throw new SyntaxException(message, e);
        }
    }

    public String toString() {
        return this.time.format(timeFormatter);
    }

    @Override
    public int compareTo(Time o) {
        OffsetTime thisTime = this.getTime();
        OffsetTime thatTime = o.getTime();
        return thisTime.withOffsetSameInstant(thatTime.getOffset()).compareTo(thatTime);
    }

    public boolean equals(Object obj) {
        if (obj == null || !Time.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        OffsetTime thisTime = this.getTime();
        OffsetTime thatTime = ((Time)obj).getTime();
        return thisTime.withOffsetSameInstant(thatTime.getOffset()).equals(thatTime);
    }

    public int hashCode() {
        return Objects.hash(this.time);
    }

    public OffsetTime getTime() {
        return this.time;
    }

    static {
        Time.useZuluUtcRepresentation(false);
    }
}

