/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.QueueTransferTask;

public class QueueTransferService {
    private final ConcurrentMap<String, QueueTransferTask> tasks = new ConcurrentHashMap<String, QueueTransferTask>();

    public synchronized void schedule(String name, QueueTransferTask task) {
        QueueTransferTask oldTask = this.tasks.putIfAbsent(name, task);
        if (oldTask == null) {
            task.start();
        } else {
            oldTask.incUsage();
        }
    }

    public synchronized void remove(String name) {
        QueueTransferTask task = (QueueTransferTask)this.tasks.get(name);
        if (task != null && task.decUsage() == 0) {
            this.tasks.remove(name, task);
            task.stop();
        }
    }
}

