/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public abstract class BaseEventCodec
implements Codec {
    protected final Codec codec;
    protected final OSType osType;

    public BaseEventCodec(Codec codec, OSType osType) {
        this.codec = codec;
        this.osType = osType;
    }

    protected Object decode(ByteBuf buf, State state, Decoder<?> decoder) throws IOException {
        int keyLen = this.osType == OSType.WINDOWS ? buf.readIntLE() : (this.osType == OSType.HPNONSTOP ? (int)buf.readLong() : (int)buf.readLongLE());
        ByteBuf keyBuf = buf.readSlice(keyLen);
        Object key = decoder.decode(keyBuf, state);
        return key;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public static enum OSType {
        WINDOWS,
        HPNONSTOP;

    }
}

