/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.decoder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class MapCacheGetAllDecoder
implements MultiDecoder<List<Object>> {
    private final int shiftIndex;
    private final List<Object> args;
    private final boolean allowNulls;

    public MapCacheGetAllDecoder(List<Object> args, int shiftIndex) {
        this(args, shiftIndex, false);
    }

    public MapCacheGetAllDecoder(List<Object> args, int shiftIndex, boolean allowNulls) {
        this.args = args;
        this.shiftIndex = shiftIndex;
        this.allowNulls = allowNulls;
    }

    @Override
    public List<Object> decode(List<Object> parts, State state) {
        if (parts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(parts.size() * 5);
        for (int index = 0; index < parts.size(); index += 4) {
            Object value = parts.get(index);
            if (!this.allowNulls && value == null) continue;
            Object key = this.args.get(index / 4 + this.shiftIndex);
            result.add(key);
            result.add(value);
            result.add(parts.get(index + 1));
            result.add(parts.get(index + 2));
            result.add(parts.get(index + 3));
        }
        return result;
    }
}

