/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation;

import org.redisson.RedissonBucket;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.RedissonTransactionalWriteLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class ExpireAtOperation
extends TransactionalOperation {
    private String writeLockName;
    private String lockName;
    private String transactionId;
    private long timestamp;
    private String param;
    private String[] keys;

    public ExpireAtOperation(String name) {
        this(name, null, 0L, null, 0L, null, (String[])null);
    }

    public ExpireAtOperation(String name, String lockName, long threadId, String transactionId, long timestamp, String param, String ... keys) {
        super(name, null, threadId);
        this.lockName = lockName;
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.param = param;
        this.keys = keys;
    }

    public ExpireAtOperation(String name, String lockName, String writeLockName, long threadId, String transactionId, long timestamp, String param, String ... keys) {
        super(name, null, threadId);
        this.lockName = lockName;
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.param = param;
        this.keys = keys;
        this.writeLockName = writeLockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock;
        RedissonBucketExtended bucket = new RedissonBucketExtended(commandExecutor, this.name);
        bucket.expireAtAsync(this.timestamp, this.param, this.keys);
        if (this.lockName != null) {
            lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
        if (this.writeLockName != null) {
            lock = new RedissonTransactionalWriteLock(commandExecutor, this.writeLockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock;
        if (this.lockName != null) {
            lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
        if (this.writeLockName != null) {
            lock = new RedissonTransactionalWriteLock(commandExecutor, this.writeLockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
    }

    public String getLockName() {
        return this.lockName;
    }

    public static final class RedissonBucketExtended
    extends RedissonBucket {
        public RedissonBucketExtended(CommandAsyncExecutor connectionManager, String name) {
            super(connectionManager, name);
        }

        @Override
        protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
            return super.expireAtAsync(timestamp, param, keys);
        }
    }
}

