/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.math.BigDecimal;
import org.everit.json.schema.NumberComparator;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.Visitor;

class NumberSchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private final ValidatingVisitor owner;
    private boolean exclusiveMinimum;
    private boolean exclusiveMaximum;
    private Number numberSubject;

    NumberSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = owner;
    }

    @Override
    void visitNumberSchema(NumberSchema numberSchema) {
        Class expectedType = numberSchema.requiresInteger() ? Integer.class : Number.class;
        boolean schemaRequiresType = numberSchema.requiresInteger() || numberSchema.isRequiresNumber();
        this.owner.ifPassesTypeCheck(expectedType, Number.class::cast, schemaRequiresType, numberSchema.isNullable(), numberSubject -> {
            this.numberSubject = numberSubject;
            super.visitNumberSchema(numberSchema);
        });
    }

    @Override
    void visitExclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    @Override
    void visitMinimum(Number minimum) {
        if (minimum == null) {
            return;
        }
        int comparison = NumberComparator.compare(this.numberSubject, minimum);
        if (this.exclusiveMinimum && comparison <= 0) {
            this.owner.failure(this.subject + " is not greater than " + minimum, "exclusiveMinimum");
        } else if (comparison < 0) {
            this.owner.failure(this.subject + " is not greater or equal to " + minimum, "minimum");
        }
    }

    @Override
    void visitExclusiveMinimumLimit(Number exclusiveMinimumLimit) {
        if (exclusiveMinimumLimit != null && NumberComparator.compare(this.numberSubject, exclusiveMinimumLimit) <= 0) {
            this.owner.failure(this.subject + " is not greater than " + exclusiveMinimumLimit, "exclusiveMinimum");
        }
    }

    @Override
    void visitMaximum(Number maximum) {
        if (maximum == null) {
            return;
        }
        int comparison = NumberComparator.compare(maximum, this.numberSubject);
        if (this.exclusiveMaximum && comparison <= 0) {
            this.owner.failure(this.subject + " is not less than " + maximum, "exclusiveMaximum");
        } else if (comparison < 0) {
            this.owner.failure(this.subject + " is not less or equal to " + maximum, "maximum");
        }
    }

    @Override
    void visitExclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    @Override
    void visitExclusiveMaximumLimit(Number exclusiveMaximumLimit) {
        if (exclusiveMaximumLimit != null && NumberComparator.compare(this.numberSubject, exclusiveMaximumLimit) >= 0) {
            this.owner.failure(this.subject + " is not less than " + exclusiveMaximumLimit, "exclusiveMaximum");
        }
    }

    @Override
    void visitMultipleOf(Number multipleOf) {
        BigDecimal remainder;
        if (multipleOf != null && (remainder = NumberComparator.getAsBigDecimal(this.numberSubject).remainder(NumberComparator.getAsBigDecimal(multipleOf))).compareTo(BigDecimal.ZERO) != 0) {
            this.owner.failure(this.subject + " is not a multiple of " + multipleOf, "multipleOf");
        }
    }
}

