/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.abstraction.template;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.activation.FileDataSource;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.TemplateUtils;

public class TemplateCore {
    private String zipName = "openspcoop_core_template";
    private String rootDirName = "core";
    private byte[] pdd;
    private byte[] soggetto;
    private byte[] fruitore;

    protected TemplateCore(boolean erogazione) throws ProtocolException {
        try {
            String baseUrl = "/templates/core.zip";
            InputStream is = TemplateCore.class.getResourceAsStream(baseUrl);
            if (is == null) {
                throw new ProtocolException("Resource with url [" + baseUrl + "] not found");
            }
            byte[] zipFile = Utilities.getAsByteArray((InputStream)is);
            is.close();
            this.updateTemplates(zipFile);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        if (erogazione) {
            this.zipName = "openspcoop_erogazione_template";
            this.rootDirName = "erogazione";
        } else {
            this.zipName = "openspcoop_fruizione_template";
            this.rootDirName = "fruizione";
        }
    }

    public String getZipName() {
        return this.zipName;
    }

    public String getRootDirName() {
        return this.rootDirName;
    }

    public byte[] getPdd() {
        return this.pdd;
    }

    public void setPdd(byte[] pdd) {
        this.pdd = pdd;
    }

    public Template getTemplatePdd() throws IOException {
        return TemplateUtils.buildTemplate((String)"pdd", (byte[])this.pdd);
    }

    public byte[] getSoggetto() {
        return this.soggetto;
    }

    public void setSoggetto(byte[] soggetto) {
        this.soggetto = soggetto;
    }

    public Template getTemplateSoggetto() throws IOException {
        return TemplateUtils.buildTemplate((String)"soggetto", (byte[])this.soggetto);
    }

    public byte[] getFruitore() {
        return this.fruitore;
    }

    public void setFruitore(byte[] fruitore) {
        this.fruitore = fruitore;
    }

    public Template getTemplateFruitore() throws IOException {
        return TemplateUtils.buildTemplate((String)"fruitore", (byte[])this.fruitore);
    }

    public void updateTemplates(byte[] zip) throws ProtocolException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = FileSystemUtilities.createTempFile((String)this.zipName, (String)".zip");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            this.updateTemplates(tmp);
            if (tmp != null && !tmp.delete()) {
                // empty if block
            }
        }
        catch (Exception e) {
            if (tmp != null) {
                throw new ProtocolException("[" + tmp.getAbsolutePath() + "] " + e.getMessage(), e);
            }
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateTemplates(File zip) throws ProtocolException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            this.updateTemplates(zipFile);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplates(ZipFile zip) throws ProtocolException {
        try {
            String rootDir = null;
            boolean foundPdd = false;
            boolean foundSoggetto = false;
            boolean foundFruitore = false;
            HashMap<String, Boolean> mapFound = new HashMap<String, Boolean>();
            Iterator it = ZipUtilities.entries((ZipFile)zip, (boolean)true);
            while (it.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)it.next();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                InputStream inputStream = zip.getInputStream(zipEntry);
                byte[] xml = Utilities.getAsByteArray((InputStream)inputStream);
                try {
                    String rootDirNameExpected = this.rootDirName + File.separatorChar;
                    if (rootDir.equals(rootDirNameExpected)) {
                        if (!entryName.endsWith(".ftl")) {
                            throw new ProtocolException("Elemento [" + entryName + "] non atteso (E' richiesto un file template .ftl)");
                        }
                        if (entryName.startsWith(rootDirNameExpected + "pdd" + File.separatorChar)) {
                            if (foundPdd) {
                                throw new ProtocolException("Elemento [" + entryName + "] non atteso (E' possibile indicare solamente una definizione di porta di dominio)");
                            }
                            this.pdd = xml;
                            foundPdd = true;
                            continue;
                        }
                        if (entryName.startsWith(rootDirNameExpected + "soggetto" + File.separatorChar)) {
                            if (foundSoggetto) {
                                throw new ProtocolException("Elemento [" + entryName + "] non atteso (E' possibile indicare solamente una definizione di soggetto)");
                            }
                            this.soggetto = xml;
                            foundSoggetto = true;
                            continue;
                        }
                        if (entryName.startsWith(rootDirNameExpected + "fruitore" + File.separatorChar)) {
                            if (foundFruitore) {
                                throw new ProtocolException("Elemento [" + entryName + "] non atteso (E' possibile indicare solamente una definizione di fruitore)");
                            }
                            this.fruitore = xml;
                            foundFruitore = true;
                            continue;
                        }
                        this.updateOtherResource(entryName, inputStream, xml, mapFound);
                        continue;
                    }
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso");
                }
                finally {
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public void updateOtherResource(String entryName, InputStream inputStream, byte[] xml, Map<String, Boolean> mapFound) throws ProtocolException {
        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
    }
}

