/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceParameter;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRepresentationJson;
import org.openspcoop2.core.registry.ResourceRepresentationXml;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.ParameterType;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.RepresentationType;
import org.openspcoop2.core.registry.constants.RepresentationXmlType;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapperUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.archive.APIUtils;
import org.openspcoop2.protocol.basic.archive.EsitoUtils;
import org.openspcoop2.protocol.basic.archive.ZIPReadUtils;
import org.openspcoop2.protocol.basic.archive.ZIPWriteUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoDelete;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.ImportMode;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.protocol.sdk.archive.MappingModeTypesExtensions;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.ParseWarningException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiBodyParameter;
import org.openspcoop2.utils.rest.api.ApiCookieParameter;
import org.openspcoop2.utils.rest.api.ApiHeaderParameter;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiReference;
import org.openspcoop2.utils.rest.api.ApiRequestDynamicPathParameter;
import org.openspcoop2.utils.rest.api.ApiRequestFormParameter;
import org.openspcoop2.utils.rest.api.ApiRequestQueryParameter;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class BasicArchive
extends BasicComponentFactory
implements IArchive {
    protected IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    protected IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    protected IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();
    protected EsitoUtils esitoUtils;
    private static boolean normalizeDescription255 = false;
    private static boolean normalizeDescription4000 = false;
    private static final String TROVATO_PARAMETRO_COOKIE_PREFIX = "Trovato parametro cookie '";
    private static final String TROVATO_PARAMETRO_HEADER_PREFIX = "Trovato parametro header '";
    private static final String SENZA_TIPO_SUFFIX = "' senza tipo";
    private static final String SENZA_SCHEMA_SUFFIX = "' senza schema";

    public BasicArchive(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
        this.esitoUtils = new EsitoUtils(protocolFactory);
    }

    @Override
    public MappingModeTypesExtensions getMappingTypesExtensions(ArchiveMode mode) throws ProtocolException {
        MappingModeTypesExtensions m = new MappingModeTypesExtensions();
        m.add("zip", Costanti.OPENSPCOOP_ARCHIVE_MODE_TYPE);
        return m;
    }

    public static boolean isNormalizeDescription255() {
        return normalizeDescription255;
    }

    public static void setNormalizeDescription255(boolean normalizeDescription255) {
        BasicArchive.normalizeDescription255 = normalizeDescription255;
    }

    public static boolean isNormalizeDescription4000() {
        return normalizeDescription4000;
    }

    public static void setNormalizeDescription4000(boolean normalizeDescription4000) {
        BasicArchive.normalizeDescription4000 = normalizeDescription4000;
    }

    private String normalizeDescriptionApi(String description) {
        if (normalizeDescription255) {
            return this.normalizeDescriptionEngine(description, 255);
        }
        if (normalizeDescription4000) {
            return this.normalizeDescriptionEngine(description, 4000);
        }
        return description;
    }

    private String normalizeDescriptionOtherElementApi(String description) {
        return this.normalizeDescriptionEngine(description, 255);
    }

    private String normalizeDescriptionEngine(String description, int maxSize) {
        if (description == null) {
            return null;
        }
        String descr = description;
        while (descr.contains("\r")) {
            descr = descr.replace("\r", "");
        }
        int offset = 15;
        if (descr.length() <= maxSize - offset) {
            return descr;
        }
        int ulterioreOffset = 10;
        if (maxSize == 4000) {
            ulterioreOffset = 50;
        }
        return descr.substring(0, maxSize - ulterioreOffset - offset) + " ...";
    }

    @Override
    public void setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune) throws ProtocolException {
        this.setProtocolInfoEngine(accordoServizioParteComune, this.protocolFactory.getLogger());
    }

    public void setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune, Logger log) throws ProtocolException {
        this.setProtocolInfoEngine(accordoServizioParteComune, log);
    }

    private void setProtocolInfoEngine(AccordoServizioParteComune accordoServizioParteComune, Logger log) throws ProtocolException {
        if (ServiceBinding.SOAP.equals((Object)accordoServizioParteComune.getServiceBinding())) {
            if (accordoServizioParteComune.sizePortTypeList() > 0) {
                throw new ProtocolException("Protocol Info already exists");
            }
            if (accordoServizioParteComune.getFormatoSpecifica() == null || FormatoSpecifica.WSDL_11.equals((Object)accordoServizioParteComune.getFormatoSpecifica())) {
                byte[] wsdlConcettuale = accordoServizioParteComune.getByteWsdlConcettuale();
                if (wsdlConcettuale != null) {
                    this.setProtocolInfoFromWsdlEngine(wsdlConcettuale, accordoServizioParteComune, "Concettuale", log);
                } else {
                    if (accordoServizioParteComune.getByteWsdlLogicoErogatore() != null) {
                        this.setProtocolInfoFromWsdlEngine(accordoServizioParteComune.getByteWsdlLogicoErogatore(), accordoServizioParteComune, "LogicoErogatore", log);
                    }
                    if (accordoServizioParteComune.getByteWsdlLogicoFruitore() != null) {
                        this.setProtocolInfoFromWsdlEngine(accordoServizioParteComune.getByteWsdlLogicoFruitore(), accordoServizioParteComune, "LogicoFruitore", log);
                    }
                }
            }
        } else {
            byte[] wsdlConcettuale;
            if (accordoServizioParteComune.sizeResourceList() > 0) {
                throw new ProtocolException("Protocol Info already exists");
            }
            if (accordoServizioParteComune.getFormatoSpecifica() != null && (wsdlConcettuale = accordoServizioParteComune.getByteWsdlConcettuale()) != null) {
                switch (accordoServizioParteComune.getFormatoSpecifica()) {
                    case WADL: {
                        this.setProtocolInfoFromRestInterfaceEngine(wsdlConcettuale, accordoServizioParteComune, ApiFormats.WADL, log);
                        break;
                    }
                    case SWAGGER_2: {
                        this.setProtocolInfoFromRestInterfaceEngine(wsdlConcettuale, accordoServizioParteComune, ApiFormats.SWAGGER_2, log);
                        break;
                    }
                    case OPEN_API_3: {
                        this.setProtocolInfoFromRestInterfaceEngine(wsdlConcettuale, accordoServizioParteComune, ApiFormats.OPEN_API_3, log);
                        break;
                    }
                }
            }
        }
    }

    private void setProtocolInfoFromWsdlEngine(byte[] wsdlBytes, AccordoServizioParteComune accordoServizioParteComune, String tipo, Logger log) throws ProtocolException {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            WSDLUtilities wsdlUtilities = new WSDLUtilities((AbstractXMLUtils)xmlUtils);
            Document d = xmlUtils.newDocument(wsdlBytes);
            wsdlUtilities.removeTypes(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)xmlUtils, false, false);
            Map porttypesWSDL = wsdl.getAllPortTypes();
            if (porttypesWSDL == null || porttypesWSDL.size() <= 0) {
                throw new ProtocolException("WSDL" + tipo + " corrotto: non contiene la definizione di nessun port-type");
            }
            if (porttypesWSDL != null && porttypesWSDL.size() > 0) {
                for (QName key : porttypesWSDL.keySet()) {
                    javax.wsdl.PortType ptWSDL = (javax.wsdl.PortType)porttypesWSDL.get(key);
                    String ptName = ptWSDL.getQName().getLocalPart();
                    boolean foundPortType = false;
                    PortType ptOpenSPCoop = null;
                    for (PortType ptCheck : accordoServizioParteComune.getPortTypeList()) {
                        if (!ptCheck.getNome().equals(ptName)) continue;
                        ptOpenSPCoop = ptCheck;
                        foundPortType = true;
                        break;
                    }
                    Map bindingsWSDL = wsdl.getAllBindings();
                    Binding bindingWSDL = null;
                    if (bindingsWSDL != null && bindingsWSDL.size() > 0) {
                        for (QName tmp : bindingsWSDL.keySet()) {
                            Binding tmpBinding;
                            if (tmp == null || (tmpBinding = wsdl.getBinding(tmp)) == null || tmpBinding.getPortType() == null || tmpBinding.getPortType().getQName() == null || !ptName.equals(tmpBinding.getPortType().getQName().getLocalPart())) continue;
                            bindingWSDL = tmpBinding;
                            break;
                        }
                    }
                    if (ptOpenSPCoop == null) {
                        ptOpenSPCoop = new PortType();
                        ptOpenSPCoop.setNome(ptName);
                        ptOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.SINCRONO);
                        ptOpenSPCoop.setProfiloPT("ridefinito");
                        ptOpenSPCoop.setFiltroDuplicati(CostantiRegistroServizi.ABILITATO);
                    }
                    ProfiloCollaborazione profiloPt = accordoServizioParteComune.getProfiloCollaborazione();
                    if ("ridefinito".equals(ptOpenSPCoop.getProfiloPT()) && ptOpenSPCoop.getProfiloCollaborazione() != null) {
                        profiloPt = ptOpenSPCoop.getProfiloCollaborazione();
                    }
                    if (bindingWSDL != null) {
                        AccordoServizioWrapperUtilities.setPortTypeSoapBindingStyle(bindingWSDL, (Logger)log, (PortType)ptOpenSPCoop);
                    }
                    for (int i = 0; i < ptWSDL.getOperations().size(); ++i) {
                        javax.wsdl.Operation opWSDL = (javax.wsdl.Operation)ptWSDL.getOperations().get(i);
                        String opNome = opWSDL.getName();
                        boolean foundOperation = false;
                        Operation opOpenSPCoop = null;
                        for (Operation opCheck : ptOpenSPCoop.getAzioneList()) {
                            if (!opCheck.getNome().equals(opNome)) continue;
                            foundOperation = true;
                            break;
                        }
                        if (foundOperation) continue;
                        opOpenSPCoop = new Operation();
                        opOpenSPCoop.setNome(opNome);
                        opOpenSPCoop.setProfAzione("ridefinito");
                        opOpenSPCoop.setFiltroDuplicati(CostantiRegistroServizi.ABILITATO);
                        HashMap mapPartQNameInput = new HashMap();
                        AccordoServizioWrapperUtilities.addMessageInputOperation((javax.wsdl.Operation)opWSDL, (Logger)log, (Operation)opOpenSPCoop, mapPartQNameInput);
                        HashMap mapPartQNameOutput = new HashMap();
                        AccordoServizioWrapperUtilities.addMessageOutputOperation((javax.wsdl.Operation)opWSDL, (Logger)log, (Operation)opOpenSPCoop, mapPartQNameOutput);
                        ProfiloCollaborazione profiloOp = null;
                        profiloOp = opOpenSPCoop.getMessageOutput() != null ? CostantiRegistroServizi.SINCRONO : CostantiRegistroServizi.ONEWAY;
                        opOpenSPCoop.setProfiloCollaborazione(profiloOp);
                        if (profiloPt.equals((Object)profiloOp)) {
                            opOpenSPCoop.setProfAzione("default");
                        }
                        if (bindingWSDL != null) {
                            List bindingsOperation = bindingWSDL.getBindingOperations();
                            for (int j = 0; j < bindingsOperation.size(); ++j) {
                                BindingOperation bindingOperationWSDL = (BindingOperation)bindingsOperation.get(j);
                                if (bindingOperationWSDL.getOperation() == null || !opNome.equals(bindingOperationWSDL.getOperation().getName())) continue;
                                AccordoServizioWrapperUtilities.setOperationSoapBindingInformation((BindingOperation)bindingOperationWSDL, (Logger)log, (Operation)opOpenSPCoop, (PortType)ptOpenSPCoop);
                                if (opOpenSPCoop.getMessageInput() != null) {
                                    AccordoServizioWrapperUtilities.setMessageInputSoapBindingInformation((BindingOperation)bindingOperationWSDL, (Logger)log, (Operation)opOpenSPCoop, (PortType)ptOpenSPCoop, mapPartQNameInput, (String)wsdl.getTargetNamespace());
                                }
                                if (opOpenSPCoop.getMessageOutput() == null) continue;
                                AccordoServizioWrapperUtilities.setMessageOutputSoapBindingInformation((BindingOperation)bindingOperationWSDL, (Logger)log, (Operation)opOpenSPCoop, (PortType)ptOpenSPCoop, mapPartQNameOutput, (String)wsdl.getTargetNamespace());
                            }
                        }
                        ptOpenSPCoop.addAzione(opOpenSPCoop);
                    }
                    if (foundPortType) continue;
                    accordoServizioParteComune.addPortType(ptOpenSPCoop);
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private void setProtocolInfoFromRestInterfaceEngine(byte[] bytes, AccordoServizioParteComune accordoServizioParteComune, ApiFormats format, Logger log) throws ProtocolException {
        try {
            ApiReaderConfig config = new ApiReaderConfig();
            config.setProcessInclude(false);
            IApiReader apiReader = ApiFactory.newApiReader((ApiFormats)format);
            apiReader.init(log, bytes, config);
            Api api = apiReader.read();
            try {
                boolean usingFromSetProtocolInfo = true;
                api.validate(usingFromSetProtocolInfo, false);
            }
            catch (ParseWarningException usingFromSetProtocolInfo) {
                // empty catch block
            }
            if ((accordoServizioParteComune.getDescrizione() == null || "".equals(accordoServizioParteComune.getDescrizione())) && api.getDescription() != null) {
                accordoServizioParteComune.setDescrizione(this.normalizeDescriptionApi(api.getDescription()));
            }
            if (api.sizeOperations() > 0) {
                for (ApiOperation apiOp : api.getOperations()) {
                    Resource resourceOpenSPCoop = null;
                    for (Resource resourceCheck : accordoServizioParteComune.getResourceList()) {
                        if (resourceCheck.getPath() == null || resourceCheck.getMethod() == null) continue;
                        HttpRequestMethod httpMethodCheck = HttpRequestMethod.valueOf((String)resourceCheck.getMethod().getValue());
                        if (!resourceCheck.getPath().equals(apiOp.getPath()) || httpMethodCheck == null || !httpMethodCheck.equals((Object)apiOp.getHttpMethod())) continue;
                        resourceOpenSPCoop = resourceCheck;
                        break;
                    }
                    if (resourceOpenSPCoop == null) {
                        resourceOpenSPCoop = new Resource();
                        resourceOpenSPCoop.setNome(APIUtils.normalizeResourceName(apiOp.getHttpMethod(), apiOp.getPath()));
                        resourceOpenSPCoop.setDescrizione(this.normalizeDescriptionOtherElementApi(apiOp.getDescription()));
                        resourceOpenSPCoop.setMethod(HttpMethod.toEnumConstant((String)apiOp.getHttpMethod().name()));
                        resourceOpenSPCoop.setPath(apiOp.getPath());
                        accordoServizioParteComune.addResource(resourceOpenSPCoop);
                    }
                    if (resourceOpenSPCoop.getRequest() == null) {
                        resourceOpenSPCoop.setRequest(new ResourceRequest());
                    }
                    if (apiOp.getRequest() != null) {
                        Object type;
                        ResourceParameter rp;
                        String nome;
                        if (apiOp.getRequest().sizeBodyParameters() > 0) {
                            for (ApiBodyParameter body : apiOp.getRequest().getBodyParameters()) {
                                String mediaType = body.getMediaType();
                                ResourceRepresentation rr = null;
                                for (ResourceRepresentation rrCheck : resourceOpenSPCoop.getRequest().getRepresentationList()) {
                                    if (!mediaType.equals(rrCheck.getMediaType())) continue;
                                    rr = rrCheck;
                                    break;
                                }
                                if (rr == null) {
                                    rr = new ResourceRepresentation();
                                    rr.setMediaType(mediaType);
                                    resourceOpenSPCoop.getRequest().addRepresentation(rr);
                                }
                                rr.setNome(body.getName());
                                rr.setDescrizione(this.normalizeDescriptionOtherElementApi(body.getDescription()));
                                if (body.getElement() != null) {
                                    if (body.getElement() instanceof QName) {
                                        QName qname = (QName)body.getElement();
                                        rr.setRepresentationType(RepresentationType.XML);
                                        ResourceRepresentationXml xml = new ResourceRepresentationXml();
                                        xml.setXmlType(RepresentationXmlType.ELEMENT);
                                        xml.setNome(qname.getLocalPart());
                                        xml.setNamespace(qname.getNamespaceURI());
                                        rr.setXml(xml);
                                        continue;
                                    }
                                    if (body.getElement() instanceof String) {
                                        String jsonType = (String)body.getElement();
                                        rr.setRepresentationType(RepresentationType.JSON);
                                        ResourceRepresentationJson json = new ResourceRepresentationJson();
                                        json.setTipo(jsonType);
                                        rr.setJson(json);
                                        continue;
                                    }
                                    if (body.getElement() instanceof ApiReference) {
                                        ApiReference apiRef = (ApiReference)body.getElement();
                                        String jsonType = apiRef.getType();
                                        rr.setRepresentationType(RepresentationType.JSON);
                                        ResourceRepresentationJson json = new ResourceRepresentationJson();
                                        json.setTipo(apiRef.getSchemaRef() + "#" + jsonType);
                                        rr.setJson(json);
                                        continue;
                                    }
                                    rr.setRepresentationType(null);
                                    rr.setJson(null);
                                    rr.setXml(null);
                                    continue;
                                }
                                rr.setRepresentationType(null);
                                rr.setJson(null);
                                rr.setXml(null);
                            }
                        }
                        if (apiOp.getRequest().sizeCookieParameters() > 0) {
                            for (ApiCookieParameter cookie : apiOp.getRequest().getCookieParameters()) {
                                nome = cookie.getName();
                                if (nome == null) {
                                    throw new ProtocolException("Trovato parametro cookie senza nome");
                                }
                                rp = null;
                                for (ResourceParameter rpCheck : resourceOpenSPCoop.getRequest().getParameterList()) {
                                    if (!ParameterType.COOKIE.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                    rp = rpCheck;
                                    break;
                                }
                                if (rp == null) {
                                    rp = new ResourceParameter();
                                    rp.setParameterType(ParameterType.COOKIE);
                                    rp.setNome(cookie.getName());
                                    resourceOpenSPCoop.getRequest().addParameter(rp);
                                }
                                rp.setDescrizione(this.normalizeDescriptionOtherElementApi(cookie.getDescription()));
                                rp.setRequired(cookie.isRequired());
                                if (cookie.getApiParameterSchema() != null) {
                                    type = cookie.getApiParameterSchema().getType();
                                    if (type == null) {
                                        throw new ProtocolException(TROVATO_PARAMETRO_COOKIE_PREFIX + rp.getNome() + SENZA_TIPO_SUFFIX);
                                    }
                                    rp.setTipo((String)type);
                                    rp.setRestrizioni(cookie.getApiParameterSchema().toString());
                                    continue;
                                }
                                throw new ProtocolException(TROVATO_PARAMETRO_COOKIE_PREFIX + rp.getNome() + SENZA_SCHEMA_SUFFIX);
                            }
                        }
                        if (apiOp.getRequest().sizeDynamicPathParameters() > 0) {
                            for (ApiRequestDynamicPathParameter dynamicPath : apiOp.getRequest().getDynamicPathParameters()) {
                                nome = dynamicPath.getName();
                                if (nome == null) {
                                    throw new ProtocolException("Trovato parametro dynamic path senza nome");
                                }
                                rp = null;
                                for (ResourceParameter rpCheck : resourceOpenSPCoop.getRequest().getParameterList()) {
                                    if (!ParameterType.DYNAMIC_PATH.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                    rp = rpCheck;
                                    break;
                                }
                                if (rp == null) {
                                    rp = new ResourceParameter();
                                    rp.setParameterType(ParameterType.DYNAMIC_PATH);
                                    rp.setNome(dynamicPath.getName());
                                    resourceOpenSPCoop.getRequest().addParameter(rp);
                                }
                                rp.setDescrizione(this.normalizeDescriptionOtherElementApi(dynamicPath.getDescription()));
                                rp.setRequired(dynamicPath.isRequired());
                                if (dynamicPath.getApiParameterSchema() != null) {
                                    type = dynamicPath.getApiParameterSchema().getType();
                                    if (type == null) {
                                        throw new ProtocolException("Trovato parametro dynamic path '" + rp.getNome() + SENZA_TIPO_SUFFIX);
                                    }
                                    rp.setTipo((String)type);
                                    rp.setRestrizioni(dynamicPath.getApiParameterSchema().toString());
                                    continue;
                                }
                                throw new ProtocolException("Trovato parametro dynamic path '" + rp.getNome() + SENZA_SCHEMA_SUFFIX);
                            }
                        }
                        if (apiOp.getRequest().sizeFormParameters() > 0) {
                            for (ApiRequestFormParameter form : apiOp.getRequest().getFormParameters()) {
                                nome = form.getName();
                                if (nome == null) {
                                    throw new ProtocolException("Trovato parametro form senza nome");
                                }
                                rp = null;
                                for (ResourceParameter rpCheck : resourceOpenSPCoop.getRequest().getParameterList()) {
                                    if (!ParameterType.FORM.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                    rp = rpCheck;
                                    break;
                                }
                                if (rp == null) {
                                    rp = new ResourceParameter();
                                    rp.setParameterType(ParameterType.FORM);
                                    rp.setNome(form.getName());
                                    resourceOpenSPCoop.getRequest().addParameter(rp);
                                }
                                rp.setDescrizione(this.normalizeDescriptionOtherElementApi(form.getDescription()));
                                rp.setRequired(form.isRequired());
                                if (form.getApiParameterSchema() != null) {
                                    type = form.getApiParameterSchema().getType();
                                    if (type == null) {
                                        throw new ProtocolException("Trovato parametro form '" + rp.getNome() + SENZA_TIPO_SUFFIX);
                                    }
                                    rp.setTipo((String)type);
                                    rp.setRestrizioni(form.getApiParameterSchema().toString());
                                    continue;
                                }
                                throw new ProtocolException("Trovato parametro form '" + rp.getNome() + SENZA_SCHEMA_SUFFIX);
                            }
                        }
                        if (apiOp.getRequest().sizeHeaderParameters() > 0) {
                            for (ApiHeaderParameter header : apiOp.getRequest().getHeaderParameters()) {
                                nome = header.getName();
                                if (nome == null) {
                                    throw new ProtocolException("Trovato parametro header senza nome");
                                }
                                rp = null;
                                for (ResourceParameter rpCheck : resourceOpenSPCoop.getRequest().getParameterList()) {
                                    if (!ParameterType.HEADER.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                    rp = rpCheck;
                                    break;
                                }
                                if (rp == null) {
                                    rp = new ResourceParameter();
                                    rp.setParameterType(ParameterType.HEADER);
                                    rp.setNome(header.getName());
                                    resourceOpenSPCoop.getRequest().addParameter(rp);
                                }
                                rp.setDescrizione(this.normalizeDescriptionOtherElementApi(header.getDescription()));
                                rp.setRequired(header.isRequired());
                                if (header.getApiParameterSchema() != null) {
                                    type = header.getApiParameterSchema().getType();
                                    if (type == null) {
                                        throw new ProtocolException(TROVATO_PARAMETRO_HEADER_PREFIX + rp.getNome() + SENZA_TIPO_SUFFIX);
                                    }
                                    rp.setTipo((String)type);
                                    rp.setRestrizioni(header.getApiParameterSchema().toString());
                                    continue;
                                }
                                throw new ProtocolException(TROVATO_PARAMETRO_HEADER_PREFIX + rp.getNome() + SENZA_SCHEMA_SUFFIX);
                            }
                        }
                        if (apiOp.getRequest().sizeQueryParameters() > 0) {
                            for (ApiRequestQueryParameter query : apiOp.getRequest().getQueryParameters()) {
                                nome = query.getName();
                                if (nome == null) {
                                    throw new ProtocolException("Trovato parametro query senza nome");
                                }
                                rp = null;
                                for (ResourceParameter rpCheck : resourceOpenSPCoop.getRequest().getParameterList()) {
                                    if (!ParameterType.QUERY.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                    rp = rpCheck;
                                    break;
                                }
                                if (rp == null) {
                                    rp = new ResourceParameter();
                                    rp.setParameterType(ParameterType.QUERY);
                                    rp.setNome(query.getName());
                                    resourceOpenSPCoop.getRequest().addParameter(rp);
                                }
                                rp.setDescrizione(this.normalizeDescriptionOtherElementApi(query.getDescription()));
                                rp.setRequired(query.isRequired());
                                if (query.getApiParameterSchema() != null) {
                                    type = query.getApiParameterSchema().getType();
                                    if (type == null) {
                                        throw new ProtocolException("Trovato parametro query '" + rp.getNome() + SENZA_TIPO_SUFFIX);
                                    }
                                    rp.setTipo((String)type);
                                    rp.setRestrizioni(query.getApiParameterSchema().toString());
                                    continue;
                                }
                                throw new ProtocolException("Trovato parametro query '" + rp.getNome() + SENZA_SCHEMA_SUFFIX);
                            }
                        }
                    }
                    if (apiOp.sizeResponses() <= 0) continue;
                    for (ApiResponse apiResponse : apiOp.getResponses()) {
                        Object type;
                        ResourceParameter rp;
                        String nome;
                        int status = apiResponse.getHttpReturnCode();
                        boolean defaultResponse = apiResponse.isDefaultHttpReturnCode();
                        ResourceResponse resourceOpenSPCoopResponse = null;
                        for (ResourceResponse resourceCheck : resourceOpenSPCoop.getResponseList()) {
                            if (status != resourceCheck.getStatus() && (!defaultResponse || !ApiResponse.isDefaultHttpReturnCode((int)resourceCheck.getStatus()))) continue;
                            resourceOpenSPCoopResponse = resourceCheck;
                            break;
                        }
                        if (resourceOpenSPCoopResponse == null) {
                            resourceOpenSPCoopResponse = new ResourceResponse();
                            if (defaultResponse) {
                                resourceOpenSPCoopResponse.setStatus(ApiResponse.getDefaultHttpReturnCode());
                            } else {
                                resourceOpenSPCoopResponse.setStatus(status);
                            }
                            resourceOpenSPCoop.addResponse(resourceOpenSPCoopResponse);
                        }
                        resourceOpenSPCoopResponse.setDescrizione(this.normalizeDescriptionOtherElementApi(apiResponse.getDescription()));
                        if (apiResponse.sizeBodyParameters() > 0) {
                            for (ApiBodyParameter body : apiResponse.getBodyParameters()) {
                                String mediaType = body.getMediaType();
                                ResourceRepresentation rr = null;
                                for (ResourceRepresentation rrCheck : resourceOpenSPCoopResponse.getRepresentationList()) {
                                    if (!mediaType.equals(rrCheck.getMediaType())) continue;
                                    rr = rrCheck;
                                    break;
                                }
                                if (rr == null) {
                                    rr = new ResourceRepresentation();
                                    rr.setMediaType(mediaType);
                                    resourceOpenSPCoopResponse.addRepresentation(rr);
                                }
                                rr.setNome(body.getName());
                                rr.setDescrizione(this.normalizeDescriptionOtherElementApi(body.getDescription()));
                                if (body.getElement() != null) {
                                    if (body.getElement() instanceof QName) {
                                        QName qname = (QName)body.getElement();
                                        rr.setRepresentationType(RepresentationType.XML);
                                        ResourceRepresentationXml xml = new ResourceRepresentationXml();
                                        xml.setXmlType(RepresentationXmlType.ELEMENT);
                                        xml.setNome(qname.getLocalPart());
                                        xml.setNamespace(qname.getNamespaceURI());
                                        rr.setXml(xml);
                                        continue;
                                    }
                                    if (body.getElement() instanceof String) {
                                        String jsonType = (String)body.getElement();
                                        rr.setRepresentationType(RepresentationType.JSON);
                                        ResourceRepresentationJson json = new ResourceRepresentationJson();
                                        json.setTipo(jsonType);
                                        rr.setJson(json);
                                        continue;
                                    }
                                    if (body.getElement() instanceof ApiReference) {
                                        ApiReference apiRef = (ApiReference)body.getElement();
                                        String jsonType = apiRef.getType();
                                        rr.setRepresentationType(RepresentationType.JSON);
                                        ResourceRepresentationJson json = new ResourceRepresentationJson();
                                        json.setTipo(apiRef.getSchemaRef() + "#" + jsonType);
                                        rr.setJson(json);
                                        continue;
                                    }
                                    rr.setRepresentationType(null);
                                    rr.setJson(null);
                                    rr.setXml(null);
                                    continue;
                                }
                                rr.setRepresentationType(null);
                                rr.setJson(null);
                                rr.setXml(null);
                            }
                        }
                        if (apiResponse.sizeCookieParameters() > 0) {
                            for (ApiCookieParameter cookie : apiResponse.getCookieParameters()) {
                                nome = cookie.getName();
                                if (nome == null) {
                                    throw new ProtocolException("Trovato parametro cookie nella risposta senza nome");
                                }
                                rp = null;
                                for (ResourceParameter rpCheck : resourceOpenSPCoopResponse.getParameterList()) {
                                    if (!ParameterType.COOKIE.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                    rp = rpCheck;
                                    break;
                                }
                                if (rp == null) {
                                    rp = new ResourceParameter();
                                    rp.setParameterType(ParameterType.COOKIE);
                                    rp.setNome(cookie.getName());
                                    resourceOpenSPCoopResponse.addParameter(rp);
                                }
                                rp.setDescrizione(this.normalizeDescriptionOtherElementApi(cookie.getDescription()));
                                rp.setRequired(cookie.isRequired());
                                if (cookie.getApiParameterSchema() != null) {
                                    type = cookie.getApiParameterSchema().getType();
                                    if (type == null) {
                                        throw new ProtocolException(TROVATO_PARAMETRO_COOKIE_PREFIX + rp.getNome() + "' nella risposta senza tipo");
                                    }
                                    rp.setTipo((String)type);
                                    rp.setRestrizioni(cookie.getApiParameterSchema().toString());
                                    continue;
                                }
                                throw new ProtocolException(TROVATO_PARAMETRO_COOKIE_PREFIX + rp.getNome() + "' nella risposta senza schema");
                            }
                        }
                        if (apiResponse.sizeHeaderParameters() <= 0) continue;
                        for (ApiHeaderParameter header : apiResponse.getHeaderParameters()) {
                            nome = header.getName();
                            if (nome == null) {
                                throw new ProtocolException("Trovato parametro header nella risposta senza nome");
                            }
                            rp = null;
                            for (ResourceParameter rpCheck : resourceOpenSPCoopResponse.getParameterList()) {
                                if (!ParameterType.HEADER.equals((Object)rpCheck.getParameterType()) || !nome.equals(rpCheck.getNome())) continue;
                                rp = rpCheck;
                                break;
                            }
                            if (rp == null) {
                                rp = new ResourceParameter();
                                rp.setParameterType(ParameterType.HEADER);
                                rp.setNome(header.getName());
                                resourceOpenSPCoopResponse.addParameter(rp);
                            }
                            rp.setDescrizione(this.normalizeDescriptionOtherElementApi(header.getDescription()));
                            rp.setRequired(header.isRequired());
                            if (header.getApiParameterSchema() != null) {
                                type = header.getApiParameterSchema().getType();
                                if (type == null) {
                                    throw new ProtocolException(TROVATO_PARAMETRO_HEADER_PREFIX + rp.getNome() + "' nella risposta senza tipo");
                                }
                                rp.setTipo((String)type);
                                rp.setRestrizioni(header.getApiParameterSchema().toString());
                                continue;
                            }
                            throw new ProtocolException(TROVATO_PARAMETRO_HEADER_PREFIX + rp.getNome() + "' nella risposta senza schema");
                        }
                    }
                }
            }
            if (accordoServizioParteComune.sizeResourceList() > 0) {
                boolean foundEquals = true;
                while (foundEquals) {
                    foundEquals = false;
                    for (int i = 0; i < accordoServizioParteComune.sizeResourceList(); ++i) {
                        Resource resource = accordoServizioParteComune.getResource(i);
                        ArrayList<Resource> lR = new ArrayList<Resource>();
                        for (Resource resourceCheck : accordoServizioParteComune.getResourceList()) {
                            if (!resourceCheck.getNome().equals(resource.getNome())) continue;
                            lR.add(resourceCheck);
                        }
                        if (lR.size() <= 1) continue;
                        for (int j = 0; j < lR.size(); ++j) {
                            Resource resourceDaModificare = (Resource)lR.get(j);
                            Object newName = resourceDaModificare.getNome();
                            newName = ((String)newName).length() > 250 ? ((String)newName).substring(0, 250) + "_" + (j + 1) : (String)newName + "_" + (j + 1);
                            resourceDaModificare.setNome((String)newName);
                        }
                        foundEquals = true;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public List<ImportMode> getImportModes() throws ProtocolException {
        ArrayList<ImportMode> list = new ArrayList<ImportMode>();
        list.add(Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE);
        return list;
    }

    @Override
    public Archive importArchive(byte[] archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        ZIPReadUtils zipUtils = new ZIPReadUtils(this.protocolFactory.getLogger(), registryReader, configIntegrationReader);
        return zipUtils.getArchive(archive, placeholder, validationDocuments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive importArchive(InputStream archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        try {
            ZIPReadUtils zipUtils = new ZIPReadUtils(this.protocolFactory.getLogger(), registryReader, configIntegrationReader);
            Archive archive2 = zipUtils.getArchive(archive, placeholder, validationDocuments);
            return archive2;
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void finalizeImportArchive(Archive archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
    }

    @Override
    public String toString(ArchiveEsitoImport esito, ArchiveMode archiveMode) throws ProtocolException {
        return this.esitoUtils.toString(esito, true, true);
    }

    @Override
    public String toString(ArchiveEsitoDelete esito, ArchiveMode archiveMode) throws ProtocolException {
        return this.esitoUtils.toString(esito, true, false);
    }

    @Override
    public List<ExportMode> getExportModes(ArchiveType archiveType) throws ProtocolException {
        ArrayList<ExportMode> list = new ArrayList<ExportMode>();
        list.add((ExportMode)Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.clone());
        return list;
    }

    @Override
    public MappingModeTypesExtensions getExportMappingTypesExtensions(Archive archive, ArchiveMode mode, IRegistryReader registroReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        return this.getMappingTypesExtensions(mode);
    }

    @Override
    public byte[] exportArchive(Archive archive, ArchiveMode mode, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        ZIPWriteUtils zipUtils = new ZIPWriteUtils(super.getProtocolFactory().getLogger(), registryReader, configIntegrationReader);
        return zipUtils.generateArchive(archive);
    }

    @Override
    public void exportArchive(Archive archive, OutputStream out, ArchiveMode mode, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        ZIPWriteUtils zipUtils = new ZIPWriteUtils(super.getProtocolFactory().getLogger(), registryReader, configIntegrationReader);
        zipUtils.generateArchive(archive, out);
    }
}

