/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.builder;

import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SOAPFaultCode;
import org.openspcoop2.protocol.basic.BasicStateComponentFactory;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.EccezioneProtocolloBuilderParameters;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.UniqueIdentifierManager;

public class BustaBuilder<BustaRawType>
extends BasicStateComponentFactory
implements IBustaBuilder<BustaRawType> {
    protected ITraduttore traduttore = this.protocolFactory.createTraduttore();
    protected IErroreApplicativoBuilder erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
    private static final String dateformatPattern = "yyyyMMddHHmmssSSS";

    public BustaBuilder(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
    }

    @Override
    public String newID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        return this.newID(idSoggetto, idTransazione, ruoloMessaggio, true);
    }

    public String newID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio, boolean generateIDasUUID) throws ProtocolException {
        if (generateIDasUUID) {
            try {
                return UniqueIdentifierManager.newUniqueIdentifier().getAsString();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
        String id = idTransazione;
        Date now = DateManager.getDate();
        DateTimeFormatterWrapper dateFormat = DateUtils.getDefaultDateTimeFormatter((String)dateformatPattern);
        if (RuoloMessaggio.RICHIESTA.equals(ruoloMessaggio)) {
            return dateFormat.format(now) + "-" + id;
        }
        return dateFormat.format(now) + "-" + id + "-response";
    }

    @Override
    public Date extractDateFromID(String id) throws ProtocolException {
        return this.extractDateFromID(id, true);
    }

    public Date extractDateFromID(String id, boolean generateIDasUUID) throws ProtocolException {
        if (id == null) {
            throw new ProtocolException("ID non fornito");
        }
        if (!generateIDasUUID) {
            if (!id.contains("-")) {
                throw new ProtocolException("ID fornito [" + id + "] non e' corretto (missing '-')");
            }
            String[] split = id.split("-");
            DateTimeFormatterWrapper dateFormat = DateUtils.getDefaultDateTimeFormatter((String)dateformatPattern);
            try {
                return dateFormat.parse(split[0].trim());
            }
            catch (Exception e) {
                throw new ProtocolException("ID fornito [" + id + "] non e' corretto: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public ProtocolMessage imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO.equals(faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        if (busta.getProfiloDiCollaborazione() != null) {
            switch (busta.getProfiloDiCollaborazione()) {
                case ONEWAY: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY, ProfiloDiCollaborazione.ONEWAY.getEngineValue());
                    break;
                }
                case SINCRONO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO, ProfiloDiCollaborazione.SINCRONO.getEngineValue());
                    break;
                }
                case ASINCRONO_ASIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO, ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.getEngineValue());
                    break;
                }
                case ASINCRONO_SIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.getEngineValue());
                    break;
                }
            }
        }
        if (busta.getTipoOraRegistrazione() != null) {
            switch (busta.getTipoOraRegistrazione()) {
                case LOCALE: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE, "Locale");
                    break;
                }
                case SINCRONIZZATO: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO, "Sincronizzato");
                    break;
                }
            }
        }
        if (busta.getInoltro() != null) {
            switch (busta.getInoltro()) {
                case CON_DUPLICATI: {
                    busta.setInoltro(Inoltro.CON_DUPLICATI, "PIUDIUNAVOLTA");
                    break;
                }
                case SENZA_DUPLICATI: {
                    busta.setInoltro(Inoltro.SENZA_DUPLICATI, "ALPIUUNAVOLTA");
                    break;
                }
            }
        }
        for (Riscontro riscontro : busta.getListaRiscontri()) {
            if (riscontro.getTipoOraRegistrazione() == null) continue;
            if (riscontro.getTipoOraRegistrazione().equals((Object)TipoOraRegistrazione.LOCALE)) {
                riscontro.setTipoOraRegistrazioneValue("Locale");
            }
            if (!riscontro.getTipoOraRegistrazione().equals((Object)TipoOraRegistrazione.SINCRONIZZATO)) continue;
            riscontro.setTipoOraRegistrazioneValue("Sincronizzato");
        }
        for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
            if (trasmissione.getTempo() == null) continue;
            if (trasmissione.getTempo().equals((Object)TipoOraRegistrazione.LOCALE)) {
                trasmissione.setTempoValue("Locale");
                continue;
            }
            trasmissione.setTempoValue("Sincronizzato");
        }
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setMessage(msg);
        return protocolMessage;
    }

    @Override
    public ProtocolMessage addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione, FaseImbustamento faseImbustamento) throws ProtocolException {
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setMessage(message);
        return protocolMessage;
    }

    @Override
    public ProtocolMessage sbustamento(OpenSPCoop2Message msg, Context context, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseSbustamento faseSbustamento, ServiceBinding integrationServiceBinding, ServiceBindingConfiguration serviceBindingConfiguration) throws ProtocolException {
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setMessage(msg);
        return protocolMessage;
    }

    protected void enrichFault(OpenSPCoop2Message msg, Busta busta, boolean ignoraEccezioniNonGravi, boolean modifyFault, boolean generateErroreApplicativoIntoDetail) throws ProtocolException {
        SOAPFault f = null;
        OpenSPCoop2SoapMessage soapMessage = null;
        try {
            if (!modifyFault && !generateErroreApplicativoIntoDetail) {
                return;
            }
            if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding()) && (soapMessage = msg.castAsSoap()).hasSOAPFault() && soapMessage.getSOAPBody() != null) {
                f = soapMessage.getSOAPBody().getFault();
            }
            if (soapMessage == null || f == null) {
                return;
            }
            Eccezione ecc = null;
            if (busta.sizeListaEccezioni() == 1) {
                ecc = busta.getEccezione(0);
            } else {
                ecc = Eccezione.getEccezioneProcessamento(ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), this.protocolFactory);
                StringBuilder bfDescrizione = new StringBuilder();
                for (int k = 0; k < busta.sizeListaEccezioni(); ++k) {
                    Eccezione eccLista = busta.getEccezione(k);
                    if (eccLista.getRilevanza() != null && !LivelloRilevanza.isEccezioneLivelloGrave(eccLista.getRilevanza()) || eccLista.getDescrizione(this.protocolFactory) == null) continue;
                    bfDescrizione.append("[" + this.traduttore.toString(eccLista.getCodiceEccezione(), eccLista.getSubCodiceEccezione()) + "] " + eccLista.getDescrizione(this.protocolFactory) + "\n");
                }
                if (bfDescrizione.length() > 0) {
                    ecc.setDescrizione(bfDescrizione.toString());
                }
            }
            if (ecc == null) {
                return;
            }
            EccezioneProtocolloBuilderParameters params = new EccezioneProtocolloBuilderParameters();
            params.setEccezioneProtocollo(ecc);
            if (modifyFault) {
                String codiceEccezione = this.traduttore.toString(ecc.getCodiceEccezione(), ecc.getSubCodiceEccezione());
                QName eccezioneName = this.erroreApplicativoBuilder.getQNameEccezioneProtocollo(null, codiceEccezione);
                SOAPFaultCode code = params.getSoapFaultCode();
                soapMessage.setFaultCode(f, code, eccezioneName);
                soapMessage.setFaultString(f, ecc.getDescrizione(this.protocolFactory));
                f.setFaultActor("GovWay");
            }
            if (generateErroreApplicativoIntoDetail) {
                IDSoggetto soggettoProduceEccezione = new IDSoggetto(busta.getTipoMittente(), busta.getMittente(), busta.getIdentificativoPortaMittente());
                params.setSoggettoProduceEccezione(soggettoProduceEccezione);
                params.setDominioPorta(soggettoProduceEccezione);
                if (busta.getTipoDestinatario() != null && busta.getDestinatario() != null) {
                    IDSoggetto idSoggettoMittente = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                    String idPortaMittente = busta.getIdentificativoPortaDestinatario();
                    if (idPortaMittente == null) {
                        idPortaMittente = this.traduttore.getIdentificativoPortaDefault(idSoggettoMittente);
                    }
                    idSoggettoMittente.setCodicePorta(idPortaMittente);
                    params.setMittente(idSoggettoMittente);
                }
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), soggettoProduceEccezione, busta.getVersioneServizio().intValue());
                idServizio.setAzione(busta.getAzione());
                params.setServizio(idServizio);
                params.setMessageType(msg.getMessageType());
                params.setIdFunzione("PortaApplicativa");
                params.setServizioApplicativo(busta.getServizioApplicativoErogatore());
                params.setTipoPorta(TipoPdD.APPLICATIVA);
                this.erroreApplicativoBuilder.insertInSOAPFault(params, msg);
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

