/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.eccezione.errore_applicativo.CodiceEccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.DatiCooperazione;
import org.openspcoop2.core.eccezione.errore_applicativo.Dominio;
import org.openspcoop2.core.eccezione.errore_applicativo.DominioSoggetto;
import org.openspcoop2.core.eccezione.errore_applicativo.Eccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.ErroreApplicativo;
import org.openspcoop2.core.eccezione.errore_applicativo.Servizio;
import org.openspcoop2.core.eccezione.errore_applicativo.Soggetto;
import org.openspcoop2.core.eccezione.errore_applicativo.SoggettoIdentificativo;
import org.openspcoop2.core.eccezione.errore_applicativo.constants.TipoEccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.constants.TipoPdD;
import org.openspcoop2.core.eccezione.errore_applicativo.utils.XMLUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.builder.CodeDetailsError;
import org.openspcoop2.protocol.basic.builder.ErroreApplicativoMessageUtils;
import org.openspcoop2.protocol.sdk.AbstractEccezioneBuilderParameter;
import org.openspcoop2.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import org.openspcoop2.protocol.sdk.EccezioneProtocolloBuilderParameters;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.KeyValueObject;
import org.openspcoop2.protocol.sdk.constants.SubCodiceErrore;
import org.openspcoop2.protocol.sdk.constants.TipoErroreApplicativo;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.rest.problem.JsonSerializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807Builder;
import org.openspcoop2.utils.rest.problem.XmlSerializer;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErroreApplicativoBuilder
extends BasicComponentFactory
implements IErroreApplicativoBuilder {
    private static Random _rnd = null;
    protected ITraduttore traduttore;
    protected OpenSPCoop2MessageFactory errorFactory = null;
    protected MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
    protected boolean omitXMLDeclaration;

    private static synchronized void initRandom() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (_rnd == null) {
            ErroreApplicativoBuilder.initRandom();
        }
        return _rnd;
    }

    public ErroreApplicativoBuilder(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
        this.traduttore = factory.createTraduttore();
        this.errorFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.omitXMLDeclaration = false;
    }

    public boolean isOmitXMLDeclaration() {
        return this.omitXMLDeclaration;
    }

    public void setOmitXMLDeclaration(boolean omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration;
    }

    @Override
    public String getNamespaceEccezioneProtocollo(String defaultNamespace) {
        if (defaultNamespace != null && StringUtils.isNotEmpty((String)defaultNamespace)) {
            return defaultNamespace;
        }
        return "http://govway.org/protocol/fault";
    }

    @Override
    public QName getQNameEccezioneProtocollo(String defaultNamespace, String codice) {
        return new QName(this.getNamespaceEccezioneProtocollo(defaultNamespace), codice, "protocol");
    }

    @Override
    public String getNamespaceEccezioneIntegrazione(String defaultNamespace) {
        if (defaultNamespace != null && StringUtils.isNotEmpty((String)defaultNamespace)) {
            return defaultNamespace;
        }
        return "http://govway.org/integration/fault";
    }

    @Override
    public QName getQNameEccezioneIntegrazione(String defaultNamespace, String codice) {
        return new QName(this.getNamespaceEccezioneIntegrazione(defaultNamespace), codice, "integration");
    }

    @Override
    public boolean isErroreApplicativo(Node node) {
        if (node == null) {
            return false;
        }
        return this.isErroreApplicativo(node.getNamespaceURI(), node.getLocalName());
    }

    @Override
    public boolean isErroreApplicativo(String namespace, String localName) {
        return "fault".equals(localName) && "http://govway.org/integration/fault".equals(namespace);
    }

    @Override
    public OpenSPCoop2Message toMessage(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        return this._buildErroreApplicativo_OpenSPCoop2Message(parameters, null);
    }

    @Override
    public OpenSPCoop2Message toMessage(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        return this._buildErroreApplicativo_OpenSPCoop2Message(null, parameters);
    }

    @Override
    public SOAPElement toSoapElement(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_SoapElement(nop, parameters, null);
    }

    @Override
    public SOAPElement toSoapElement(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_SoapElement(nop, null, parameters);
    }

    @Override
    public Element toElement(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_Element(nop, parameters, null);
    }

    @Override
    public Element toElement(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_Element(nop, null, parameters);
    }

    @Override
    public String toString(TipoErroreApplicativo tipoErroreApplicativo, EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_String(tipoErroreApplicativo, this.omitXMLDeclaration, nop, parameters, null);
    }

    @Override
    public String toString(TipoErroreApplicativo tipoErroreApplicativo, EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_String(tipoErroreApplicativo, this.omitXMLDeclaration, nop, null, parameters);
    }

    @Override
    public byte[] toByteArray(TipoErroreApplicativo tipoErroreApplicativo, EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_ByteArray(tipoErroreApplicativo, this.omitXMLDeclaration, nop, parameters, null);
    }

    @Override
    public byte[] toByteArray(TipoErroreApplicativo tipoErroreApplicativo, EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        CodeDetailsError nop = new CodeDetailsError();
        return this._buildErroreApplicativo_ByteArray(tipoErroreApplicativo, this.omitXMLDeclaration, nop, null, parameters);
    }

    @Override
    public AbstractEccezioneBuilderParameter readErroreApplicativo(TipoErroreApplicativo tipoErroreApplicativo, String erroreApplicativo, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        return this.readErroreApplicativo(tipoErroreApplicativo, erroreApplicativo.getBytes(), prefixCodiceErroreApplicativoIntegrazione);
    }

    @Override
    public AbstractEccezioneBuilderParameter readErroreApplicativo(TipoErroreApplicativo tipoErroreApplicativo, byte[] erroreApplicativo, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        ErroreApplicativo erroreApplicativoObject = null;
        switch (tipoErroreApplicativo) {
            case JSON: {
                try {
                    erroreApplicativoObject = XMLUtils.getErroreApplicativoFromJson((Logger)this.log, (InputStream)new ByteArrayInputStream(erroreApplicativo));
                    break;
                }
                catch (Exception e) {
                    throw new ProtocolException("JSon fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol() + ": " + e.getMessage(), e);
                }
            }
            default: {
                if (!XMLUtils.isErroreApplicativo((byte[])erroreApplicativo)) {
                    throw new ProtocolException("XML fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol());
                }
                try {
                    erroreApplicativoObject = XMLUtils.getErroreApplicativo((Logger)this.log, (byte[])erroreApplicativo);
                    break;
                }
                catch (Exception e) {
                    throw new ProtocolException("Xml fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol() + ": " + e.getMessage(), e);
                }
            }
        }
        return this._parseErroreApplicativo(erroreApplicativoObject, prefixCodiceErroreApplicativoIntegrazione);
    }

    @Override
    public AbstractEccezioneBuilderParameter readErroreApplicativo(Node erroreApplicativo, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        if (!this.isErroreApplicativo(erroreApplicativo)) {
            throw new ProtocolException("Node fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol());
        }
        try {
            byte[] xmlBytes = this.xmlUtils.toByteArray(erroreApplicativo, true);
            return this.readErroreApplicativo(TipoErroreApplicativo.XML, xmlBytes, prefixCodiceErroreApplicativoIntegrazione);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public void insertInSOAPFault(EccezioneProtocolloBuilderParameters parameters, OpenSPCoop2Message msg) throws ProtocolException {
        ErroreApplicativoMessageUtils.addErroreApplicativoIntoSOAPFaultDetail(this.toSoapElement(parameters), msg, this.log);
    }

    @Override
    public void insertInSOAPFault(EccezioneIntegrazioneBuilderParameters parameters, OpenSPCoop2Message msg) throws ProtocolException {
        ErroreApplicativoMessageUtils.addErroreApplicativoIntoSOAPFaultDetail(this.toSoapElement(parameters), msg, this.log);
    }

    @Override
    public void insertRoutingErrorInSOAPFault(IDSoggetto identitaRouter, String idFunzione, String msgErrore, OpenSPCoop2Message msg) throws ProtocolException {
        ErroreApplicativoMessageUtils.insertRoutingErrorInSOAPFault(identitaRouter, idFunzione, msgErrore, msg, this.log, (AbstractXMLUtils)this.xmlUtils);
    }

    protected SOAPElement _buildErroreApplicativo_SoapElement(CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        Element elementErroreApplicativo = this._buildErroreApplicativo_Element(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
        try {
            MessageType messageType = null;
            messageType = eccezioneProtocollo != null ? eccezioneProtocollo.getMessageType() : eccezioneIntegrazione.getMessageType();
            SOAPFactory sf = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)this.errorFactory, (MessageType)messageType);
            SOAPElement erroreApplicativoElementSOAP = sf.createElement(elementErroreApplicativo);
            return erroreApplicativoElementSOAP;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("buildErroreApplicativoElement failed: " + e.getMessage(), e);
        }
    }

    protected Element _buildErroreApplicativo_Element(CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ConfigurationRFC7807 rfc7807 = null;
            rfc7807 = eccezioneIntegrazione != null ? eccezioneIntegrazione.getRfc7807() : eccezioneProtocollo.getRfc7807();
            if (rfc7807 != null) {
                ProblemRFC7807 problemRFC7807 = this._buildErroreApplicativo_problemRFC7807(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                XmlSerializer xmlSerializer = new XmlSerializer();
                return xmlSerializer.toNode(problemRFC7807);
            }
            ErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(false, codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
            byte[] xmlErroreApplicativo = XMLUtils.generateErroreApplicativo((ErroreApplicativo)erroreApplicativo);
            Element elementErroreApplicativo = this.xmlUtils.newElement(xmlErroreApplicativo);
            ErroreApplicativoMessageUtils.addPrefixToElement(elementErroreApplicativo, "op2ErrAppl");
            return elementErroreApplicativo;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("buildErroreApplicativoElement failed: " + e.getMessage(), e);
        }
    }

    protected String _buildErroreApplicativo_String(TipoErroreApplicativo tipoErroreApplicativo, boolean omitXMLDeclaration, CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ConfigurationRFC7807 rfc7807 = null;
            rfc7807 = eccezioneIntegrazione != null ? eccezioneIntegrazione.getRfc7807() : eccezioneProtocollo.getRfc7807();
            if (rfc7807 != null) {
                ProblemRFC7807 problemRFC7807 = this._buildErroreApplicativo_problemRFC7807(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                if (TipoErroreApplicativo.JSON.equals(tipoErroreApplicativo)) {
                    JsonSerializer jsonSerializer = new JsonSerializer();
                    return jsonSerializer.toString(problemRFC7807);
                }
                XmlSerializer xmlSerializer = new XmlSerializer();
                return xmlSerializer.toString(problemRFC7807, omitXMLDeclaration);
            }
            if (TipoErroreApplicativo.JSON.equals(tipoErroreApplicativo)) {
                ErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(false, codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                return XMLUtils.generateErroreApplicativoAsJson((ErroreApplicativo)erroreApplicativo);
            }
            Element element = this._buildErroreApplicativo_Element(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
            return this.xmlUtils.toString(element, omitXMLDeclaration);
        }
        catch (Exception e) {
            throw new ProtocolException("toString failed: " + e.getMessage(), e);
        }
    }

    protected byte[] _buildErroreApplicativo_ByteArray(TipoErroreApplicativo tipoErroreApplicativo, boolean omitXMLDeclaration, CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ConfigurationRFC7807 rfc7807 = null;
            rfc7807 = eccezioneIntegrazione != null ? eccezioneIntegrazione.getRfc7807() : eccezioneProtocollo.getRfc7807();
            if (rfc7807 != null) {
                ProblemRFC7807 problemRFC7807 = this._buildErroreApplicativo_problemRFC7807(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                if (TipoErroreApplicativo.JSON.equals(tipoErroreApplicativo)) {
                    JsonSerializer jsonSerializer = new JsonSerializer();
                    return jsonSerializer.toByteArray(problemRFC7807);
                }
                XmlSerializer xmlSerializer = new XmlSerializer();
                return xmlSerializer.toByteArray(problemRFC7807, omitXMLDeclaration);
            }
            if (TipoErroreApplicativo.JSON.equals(tipoErroreApplicativo)) {
                ErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(false, codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                return XMLUtils.generateErroreApplicativoAsJson((ErroreApplicativo)erroreApplicativo).getBytes();
            }
            Element element = this._buildErroreApplicativo_Element(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
            return this.xmlUtils.toByteArray(element, omitXMLDeclaration);
        }
        catch (Exception e) {
            throw new ProtocolException("toByteArray failed: " + e.getMessage(), e);
        }
    }

    private ProblemRFC7807 _buildErroreApplicativo_problemRFC7807(CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            String webSite;
            IntegrationFunctionError functionError;
            String transactionId;
            String nomePorta;
            int govwayCode;
            ErroriProperties erroriProperties = ErroriProperties.getInstance(this.log);
            ConfigurationRFC7807 rfc7807 = null;
            boolean genericDetails = true;
            if (eccezioneIntegrazione != null) {
                rfc7807 = eccezioneIntegrazione.getRfc7807();
                govwayCode = eccezioneIntegrazione.getReturnConfig().getGovwayReturnCode();
                nomePorta = eccezioneIntegrazione.getNomePorta();
                transactionId = eccezioneIntegrazione.getTransactionId();
                functionError = eccezioneIntegrazione.getFunctionError();
                genericDetails = eccezioneIntegrazione.getReturnConfig().isGenericDetails();
            } else {
                rfc7807 = eccezioneProtocollo.getRfc7807();
                govwayCode = eccezioneProtocollo.getReturnConfig().getGovwayReturnCode();
                nomePorta = eccezioneProtocollo.getNomePorta();
                transactionId = eccezioneProtocollo.getTransactionId();
                functionError = eccezioneProtocollo.getFunctionError();
                genericDetails = eccezioneProtocollo.getReturnConfig().isGenericDetails();
            }
            if (!genericDetails && erroriProperties.isForceGenericDetails(functionError).booleanValue()) {
                genericDetails = true;
            }
            if (Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                genericDetails = false;
            }
            ProblemRFC7807Builder rfc7807ProblemBuilder = null;
            rfc7807ProblemBuilder = erroriProperties.isTypeEnabled() ? ((webSite = erroriProperties.getWebSite(functionError)) != null && !"".equals(webSite) ? new ProblemRFC7807Builder(webSite) : (rfc7807.isType() ? new ProblemRFC7807Builder(rfc7807.getTypeFormat()) : new ProblemRFC7807Builder(false))) : new ProblemRFC7807Builder(false);
            ErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(true, null, eccezioneProtocollo, eccezioneIntegrazione);
            if (erroreApplicativo.getException() != null) {
                codeDetailsErrorWrapper.setDetails(erroreApplicativo.getException().getDescription());
            }
            if (erroreApplicativo.getException() != null && erroreApplicativo.getException().getCode() != null && erroreApplicativo.getException().getCode().getBase() != null) {
                String prefixCodeStatus = null;
                prefixCodeStatus = erroreApplicativo.getException().getType() != null && TipoEccezione.PROTOCOL.equals((Object)erroreApplicativo.getException().getType()) ? "protocol:" : "integration:";
                String code = erroreApplicativo.getException().getCode().getBase();
                codeDetailsErrorWrapper.setPrefixCode(prefixCodeStatus);
                codeDetailsErrorWrapper.setCode(code);
            }
            ProblemRFC7807 problemRFC7807 = rfc7807ProblemBuilder.buildProblem(govwayCode);
            if (rfc7807.isDetails()) {
                if (codeDetailsErrorWrapper.getDetails() != null && !genericDetails) {
                    problemRFC7807.setDetail(codeDetailsErrorWrapper.getDetails());
                } else {
                    problemRFC7807.setDetail(erroriProperties.getGenericDetails(functionError));
                }
            }
            if (rfc7807.isGovwayType()) {
                String govwayType = erroriProperties.getErrorType(functionError);
                if (Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE().booleanValue()) {
                    if (Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE_CAMEL_CASE_DECODE().booleanValue()) {
                        problemRFC7807.setTitle(StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)govwayType), (char)' '));
                    } else {
                        problemRFC7807.setTitle(govwayType);
                    }
                    if (Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE_CUSTOM_CLAIM().booleanValue()) {
                        problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_TYPE(), govwayType);
                    }
                } else {
                    problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_TYPE(), govwayType);
                }
            }
            if (Costanti.isTRANSACTION_ERROR_STATUS_ABILITATO() && rfc7807.isGovwayStatus() && codeDetailsErrorWrapper.getCode() != null && codeDetailsErrorWrapper.getPrefixCode() != null) {
                problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_CODE(), codeDetailsErrorWrapper.getPrefixCode() + codeDetailsErrorWrapper.getCode());
            }
            if (Costanti.isTRANSACTION_ERROR_INSTANCE_ID_ABILITATO() && rfc7807.isInstance()) {
                problemRFC7807.setInstance(nomePorta);
            }
            if (rfc7807.isGovwayTransactionId()) {
                problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_TRANSACTION_ID(), transactionId);
            }
            return problemRFC7807;
        }
        catch (Exception e) {
            throw new ProtocolException("toProblemRFC7807 failed: " + e.getMessage());
        }
    }

    private ErroreApplicativo _buildErroreApplicativo_engine(boolean ignoreIntegrationFunctionErroreDirective, CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ErroriProperties erroriProperties = ErroriProperties.getInstance(this.log);
            ErroreApplicativo erroreApplicativo = new ErroreApplicativo();
            IDSoggetto idDominio = null;
            String idModulo = null;
            org.openspcoop2.core.constants.TipoPdD tipoPdD = null;
            IDSoggetto fruitore = null;
            IDServizio servizio = null;
            String servizioApplicativo = null;
            String codiceEccezione = null;
            Integer codiceEccezioneOpenSPCoop = null;
            Integer subCodiceEccezioneOpenSPCoop = null;
            String descrizioneEccezione = null;
            TipoEccezione tipoEccezione = null;
            Date oraRegistrazione = null;
            MessageType messageType = null;
            IntegrationFunctionError functionError = null;
            boolean genericDetails = true;
            int govwayCode = 500;
            if (eccezioneProtocollo != null) {
                idDominio = eccezioneProtocollo.getDominioPorta();
                idModulo = eccezioneProtocollo.getIdFunzione();
                tipoPdD = eccezioneProtocollo.getTipoPorta();
                fruitore = eccezioneProtocollo.getMittente();
                servizio = eccezioneProtocollo.getServizio();
                servizioApplicativo = eccezioneProtocollo.getServizioApplicativo();
                codiceEccezione = this.traduttore.toString(eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione(), eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione());
                codiceEccezioneOpenSPCoop = eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione().getCodice();
                if (eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione() != null) {
                    subCodiceEccezioneOpenSPCoop = eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione().getSubCodice();
                }
                descrizioneEccezione = eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.protocolFactory);
                tipoEccezione = TipoEccezione.PROTOCOL;
                oraRegistrazione = eccezioneProtocollo.getOraRegistrazione();
                messageType = eccezioneProtocollo.getMessageType();
                if (!ignoreIntegrationFunctionErroreDirective) {
                    functionError = eccezioneProtocollo.getFunctionError();
                    if (eccezioneProtocollo.getReturnConfig() != null) {
                        genericDetails = eccezioneProtocollo.getReturnConfig().isGenericDetails();
                        govwayCode = eccezioneProtocollo.getReturnConfig().getGovwayReturnCode();
                    }
                    codeDetailsErrorWrapper.setPrefixCode("protocol:");
                    codeDetailsErrorWrapper.setCode(codiceEccezione);
                    codeDetailsErrorWrapper.setDetails(descrizioneEccezione);
                }
            } else {
                idDominio = eccezioneIntegrazione.getDominioPorta();
                idModulo = eccezioneIntegrazione.getIdFunzione();
                tipoPdD = eccezioneIntegrazione.getTipoPorta();
                fruitore = eccezioneIntegrazione.getMittente();
                servizio = eccezioneIntegrazione.getServizio();
                servizioApplicativo = eccezioneIntegrazione.getServizioApplicativo();
                codiceEccezione = this.traduttore.toCodiceErroreIntegrazioneAsString(eccezioneIntegrazione.getErroreIntegrazione(), eccezioneIntegrazione.getProprieta().getFaultPrefixCode(), eccezioneIntegrazione.getProprieta().isFaultAsGenericCode());
                codiceEccezioneOpenSPCoop = eccezioneIntegrazione.getErroreIntegrazione().getCodiceErrore().getCodice();
                descrizioneEccezione = eccezioneIntegrazione.getProprieta().transformFaultMsg(eccezioneIntegrazione.getErroreIntegrazione(), this.protocolFactory);
                tipoEccezione = TipoEccezione.INTEGRATION;
                oraRegistrazione = eccezioneIntegrazione.getOraRegistrazione();
                messageType = eccezioneIntegrazione.getMessageType();
                if (!ignoreIntegrationFunctionErroreDirective) {
                    functionError = eccezioneIntegrazione.getFunctionError();
                    if (eccezioneIntegrazione.getReturnConfig() != null) {
                        genericDetails = eccezioneIntegrazione.getReturnConfig().isGenericDetails();
                        govwayCode = eccezioneIntegrazione.getReturnConfig().getGovwayReturnCode();
                    }
                    codeDetailsErrorWrapper.setPrefixCode("integration:");
                    codeDetailsErrorWrapper.setCode(codiceEccezione);
                    codeDetailsErrorWrapper.setDetails(descrizioneEccezione);
                }
            }
            if (!ignoreIntegrationFunctionErroreDirective) {
                if (!genericDetails && erroriProperties.isForceGenericDetails(functionError).booleanValue()) {
                    genericDetails = true;
                }
                if (Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                    genericDetails = false;
                }
            }
            TipoPdD idFunzione = null;
            if (org.openspcoop2.core.constants.TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                idFunzione = TipoPdD.OUTBOUND_PROXY;
            } else if (org.openspcoop2.core.constants.TipoPdD.APPLICATIVA.equals((Object)tipoPdD)) {
                idFunzione = TipoPdD.INBOUND_PROXY;
            } else if (org.openspcoop2.core.constants.TipoPdD.INTEGRATION_MANAGER.equals((Object)tipoPdD)) {
                idFunzione = TipoPdD.INTEGRATION_MANAGER;
            } else if (org.openspcoop2.core.constants.TipoPdD.ROUTER.equals((Object)tipoPdD)) {
                idFunzione = TipoPdD.ROUTER;
            }
            Dominio dominio = new Dominio();
            DominioSoggetto dominioSoggetto = new DominioSoggetto();
            dominioSoggetto.setType(idDominio.getTipo());
            dominioSoggetto.setBase(idDominio.getNome());
            dominio.setOrganization(dominioSoggetto);
            dominio.setId(idDominio.getCodicePorta());
            dominio.setRole(idFunzione);
            dominio.setModule(idModulo);
            erroreApplicativo.setDomain(dominio);
            if (oraRegistrazione == null) {
                oraRegistrazione = DateManager.getDate();
            }
            erroreApplicativo.setTimestamp(oraRegistrazione);
            if (fruitore != null || servizio != null || servizioApplicativo != null) {
                DatiCooperazione datiCooperazione = new DatiCooperazione();
                if (fruitore != null) {
                    Soggetto fruitoreErroreApplicativo = new Soggetto();
                    SoggettoIdentificativo fruitoreIdentificativoErroreApplicativo = new SoggettoIdentificativo();
                    fruitoreIdentificativoErroreApplicativo.setType(fruitore.getTipo());
                    fruitoreIdentificativoErroreApplicativo.setBase(fruitore.getNome());
                    fruitoreErroreApplicativo.setId(fruitoreIdentificativoErroreApplicativo);
                    fruitoreErroreApplicativo.setDomainId(fruitore.getCodicePorta());
                    datiCooperazione.setSender(fruitoreErroreApplicativo);
                }
                if (servizio != null && servizio.getSoggettoErogatore() != null) {
                    IDSoggetto erogatore = servizio.getSoggettoErogatore();
                    Soggetto erogatoreErroreApplicativo = new Soggetto();
                    SoggettoIdentificativo erogatoreIdentificativoErroreApplicativo = new SoggettoIdentificativo();
                    erogatoreIdentificativoErroreApplicativo.setType(erogatore.getTipo());
                    erogatoreIdentificativoErroreApplicativo.setBase(erogatore.getNome());
                    erogatoreErroreApplicativo.setId(erogatoreIdentificativoErroreApplicativo);
                    erogatoreErroreApplicativo.setDomainId(erogatore.getCodicePorta());
                    datiCooperazione.setProvider(erogatoreErroreApplicativo);
                }
                if (servizio != null && servizio.getTipo() != null && servizio.getNome() != null && servizio.getVersione() != null) {
                    Servizio servizioErroreApplicativo = new Servizio();
                    servizioErroreApplicativo.setBase(servizio.getNome());
                    servizioErroreApplicativo.setType(servizio.getTipo());
                    servizioErroreApplicativo.setVersion(servizio.getVersione());
                    datiCooperazione.setService(servizioErroreApplicativo);
                }
                if (servizio != null && servizio.getAzione() != null) {
                    datiCooperazione.setAction(servizio.getAzione());
                }
                datiCooperazione.setApplication(servizioApplicativo);
                erroreApplicativo.setService(datiCooperazione);
            }
            Eccezione eccezione = new Eccezione();
            CodiceEccezione codice = new CodiceEccezione();
            if (ignoreIntegrationFunctionErroreDirective || Costanti.isTRANSACTION_ERROR_STATUS_ABILITATO()) {
                codice.setBase(codiceEccezione);
                codice.setType(codiceEccezioneOpenSPCoop);
                if (subCodiceEccezioneOpenSPCoop != null) {
                    codice.setSubtype(subCodiceEccezioneOpenSPCoop);
                }
            } else {
                String govwayType = erroriProperties.getErrorType(functionError);
                codice.setBase(govwayType);
                codice.setType(Integer.valueOf(govwayCode));
            }
            eccezione.setCode(codice);
            if (ignoreIntegrationFunctionErroreDirective || !genericDetails) {
                eccezione.setDescription(descrizioneEccezione);
            } else {
                eccezione.setDescription(erroriProperties.getGenericDetails(functionError));
            }
            eccezione.setType(tipoEccezione);
            erroreApplicativo.setException(eccezione);
            return erroreApplicativo;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("buildErroreApplicativoElement failed: " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private OpenSPCoop2Message _buildErroreApplicativo_OpenSPCoop2Message(EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AbstractEccezioneBuilderParameter _parseErroreApplicativo(ErroreApplicativo erroreApplicativo, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        try {
            String descrizione;
            Enum codice;
            AbstractEccezioneBuilderParameter eccezione = null;
            if (TipoEccezione.PROTOCOL.equals((Object)erroreApplicativo.getException().getType())) {
                eccezione = new EccezioneProtocolloBuilderParameters();
                codice = CodiceErroreCooperazione.toCodiceErroreCooperazione(erroreApplicativo.getException().getCode().getType());
                descrizione = erroreApplicativo.getException().getCode().getBase();
                ErroreCooperazione erroreCooperazione = new ErroreCooperazione(descrizione, (CodiceErroreCooperazione)codice);
                org.openspcoop2.protocol.sdk.Eccezione eccezioneProtocollo = new org.openspcoop2.protocol.sdk.Eccezione(erroreCooperazione, true, erroreApplicativo.getDomain().getRole().getValue(), this.protocolFactory);
                if (erroreApplicativo.getException().getCode().getSubtype() != null) {
                    SubCodiceErrore sub = new SubCodiceErrore();
                    sub.setSubCodice(erroreApplicativo.getException().getCode().getSubtype());
                    eccezioneProtocollo.setSubCodiceEccezione(sub);
                }
                ((EccezioneProtocolloBuilderParameters)eccezione).setEccezioneProtocollo(eccezioneProtocollo);
            } else {
                eccezione = new EccezioneIntegrazioneBuilderParameters();
                codice = CodiceErroreIntegrazione.toCodiceErroreIntegrazione(erroreApplicativo.getException().getCode().getType());
                descrizione = erroreApplicativo.getException().getCode().getBase();
                ErroreIntegrazione erroreIntegrazione = new ErroreIntegrazione(descrizione, (CodiceErroreIntegrazione)codice, new KeyValueObject[0]);
                ((EccezioneIntegrazioneBuilderParameters)eccezione).setErroreIntegrazione(erroreIntegrazione);
            }
            eccezione.setDominioPorta(new IDSoggetto(erroreApplicativo.getDomain().getOrganization().getType(), erroreApplicativo.getDomain().getOrganization().getBase(), erroreApplicativo.getDomain().getId()));
            eccezione.setIdFunzione(erroreApplicativo.getDomain().getModule());
            if (TipoPdD.OUTBOUND_PROXY.equals((Object)erroreApplicativo.getDomain().getRole())) {
                eccezione.setTipoPorta(org.openspcoop2.core.constants.TipoPdD.DELEGATA);
            } else if (TipoPdD.INBOUND_PROXY.equals((Object)erroreApplicativo.getDomain().getRole())) {
                eccezione.setTipoPorta(org.openspcoop2.core.constants.TipoPdD.APPLICATIVA);
            } else if (TipoPdD.INTEGRATION_MANAGER.equals((Object)erroreApplicativo.getDomain().getRole())) {
                eccezione.setTipoPorta(org.openspcoop2.core.constants.TipoPdD.INTEGRATION_MANAGER);
            } else if (TipoPdD.ROUTER.equals((Object)erroreApplicativo.getDomain().getRole())) {
                eccezione.setTipoPorta(org.openspcoop2.core.constants.TipoPdD.ROUTER);
            }
            eccezione.setOraRegistrazione(erroreApplicativo.getTimestamp());
            if (erroreApplicativo.getService() != null) {
                DatiCooperazione datiCooperazione = erroreApplicativo.getService();
                if (datiCooperazione.getSender() != null) {
                    eccezione.setMittente(new IDSoggetto(datiCooperazione.getSender().getId().getType(), datiCooperazione.getSender().getId().getBase(), datiCooperazione.getSender().getDomainId()));
                }
                IDServizio idServizio = null;
                IDSoggetto idSoggettoErogatore = null;
                if (datiCooperazione.getProvider() != null) {
                    idSoggettoErogatore = new IDSoggetto(datiCooperazione.getProvider().getId().getType(), datiCooperazione.getProvider().getId().getBase(), datiCooperazione.getProvider().getDomainId());
                }
                if (datiCooperazione.getService() != null) {
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(datiCooperazione.getService().getType(), datiCooperazione.getService().getBase(), idSoggettoErogatore, datiCooperazione.getService().getVersion().intValue());
                }
                if (idServizio != null) {
                    idServizio.setAzione(datiCooperazione.getAction());
                    eccezione.setServizio(idServizio);
                }
                eccezione.setServizioApplicativo(datiCooperazione.getApplication());
            }
            return eccezione;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

