/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.diagnostica;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.openspcoop2.core.diagnostica.MessaggioDiagnostico;
import org.openspcoop2.core.diagnostica.utils.XMLUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticXMLRootElement;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.w3c.dom.Element;

public class DiagnosticSerializer
extends BasicComponentFactory
implements IDiagnosticSerializer {
    protected MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
    private boolean prettyDocument = false;
    private boolean omitXmlDeclaration = false;

    public DiagnosticSerializer(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
    }

    @Override
    public void setPrettyDocument(boolean v) {
        this.prettyDocument = v;
    }

    @Override
    public boolean isPrettyDocument() {
        return this.prettyDocument;
    }

    @Override
    public void setOmitXmlDeclaration(boolean v) {
        this.omitXmlDeclaration = v;
    }

    @Override
    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        Element el = null;
        String tmpId = null;
        try {
            if (msgDiag.sizeProperties() > 0) {
                tmpId = msgDiag.removeProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@");
            }
            byte[] xmlDiagnostico = XMLUtils.generateMessaggioDiagnostico((MessaggioDiagnostico)msgDiag.getMessaggioDiagnostico());
            el = this.xmlUtils.newElement(xmlDiagnostico);
        }
        catch (Exception e) {
            this.logAndThrowError(e, "DiagnosticSerializer.toElement error");
        }
        finally {
            if (tmpId != null && msgDiag != null) {
                msgDiag.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", tmpId);
            }
        }
        return el;
    }

    private void logAndThrowError(Exception e, String msg) throws ProtocolException {
        String er = msg + ": " + e.getMessage();
        this.log.error(er, (Throwable)e);
        throw new ProtocolException(er, e);
    }

    @Override
    public String toString(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.toByteArrayOutputStream(msgDiag, tipoSerializzazione).toString();
    }

    @Override
    public byte[] toByteArray(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.toByteArrayOutputStream(msgDiag, tipoSerializzazione).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream toByteArrayOutputStream(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        ByteArrayOutputStream ret = null;
        String tmpId = null;
        try {
            if (msgDiag.sizeProperties() > 0) {
                tmpId = msgDiag.removeProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@");
            }
            switch (tipoSerializzazione) {
                case XML: 
                case DEFAULT: {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    XMLUtils.generateMessaggioDiagnostico((MessaggioDiagnostico)msgDiag.getMessaggioDiagnostico(), (OutputStream)bout, (boolean)this.prettyDocument, (boolean)this.omitXmlDeclaration);
                    bout.flush();
                    bout.close();
                    ret = bout;
                    break;
                }
                case JSON: {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    String s = XMLUtils.generateMessaggioDiagnosticoAsJson((MessaggioDiagnostico)msgDiag.getMessaggioDiagnostico(), (boolean)this.prettyDocument);
                    bout.write(s.getBytes());
                    bout.flush();
                    bout.close();
                    ret = bout;
                }
            }
            if (ret == null) {
                throw new ProtocolException("Tipo [" + tipoSerializzazione + "] Non gestito");
            }
        }
        catch (Exception e) {
            this.logAndThrowError(e, "DiagnosticSerializer.toString error");
        }
        finally {
            if (tmpId != null && msgDiag != null) {
                msgDiag.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", tmpId);
            }
        }
        return ret;
    }

    @Override
    public XMLRootElement getXMLRootElement() throws ProtocolException {
        return new DiagnosticXMLRootElement();
    }
}

