/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.dump;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.IDumpMessaggioService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.PropertiesSerializator;
import org.openspcoop2.core.transazioni.utils.TransactionContentUtils;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.protocol.basic.BasicConnectionResult;
import org.openspcoop2.protocol.basic.BasicProducer;
import org.openspcoop2.protocol.basic.BasicProducerType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.dump.Attachment;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.transport.TransportUtils;

public class DumpProducer
extends BasicProducer
implements IDumpProducer {
    public DumpProducer(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory, BasicProducerType.DUMP);
    }

    @Override
    public void initializeAppender(OpenspcoopAppender appenderProperties) throws DumpException {
        try {
            this.initializeAppender(appenderProperties, true);
        }
        catch (Exception e) {
            throw new DumpException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    @Override
    @Deprecated
    public void dump(Connection conOpenSPCoopPdD, Messaggio messaggio) throws DumpException {
        this.dump(conOpenSPCoopPdD, messaggio, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void dump(Connection conOpenSPCoopPdD, Messaggio messaggio, boolean headersCompact) throws DumpException {
        if (messaggio == null) {
            throw new DumpException("Errore durante il dump: messaggio is null");
        }
        if (messaggio.getIdTransazione() == null) {
            throw new DumpException("Errore durante il dump: id transazione is null");
        }
        Date gdo = messaggio.getGdo();
        String protocollo = messaggio.getProtocollo();
        String idTransazione = messaggio.getIdTransazione();
        TipoMessaggio tipoMessaggio = messaggio.getTipoMessaggio();
        MessageType formatoMessaggio = messaggio.getFormatoMessaggio();
        String servizioApplicativoErogatore = messaggio.getServizioApplicativoErogatore();
        Date dataConsegnaErogatore = messaggio.getDataConsegna();
        String identificativoDump = "[" + idTransazione + "][" + tipoMessaggio + "]";
        if (servizioApplicativoErogatore != null) {
            identificativoDump = identificativoDump + "[" + servizioApplicativoErogatore + "]";
        }
        if (dataConsegnaErogatore != null) {
            identificativoDump = identificativoDump + "[" + DateUtils.getSimpleDateFormatMs().format(dataConsegnaErogatore) + "]";
        }
        if (this.debug) {
            this.log.debug("@@ log" + identificativoDump + " ....");
        }
        Connection con = null;
        BasicConnectionResult cr = null;
        try {
            PropertiesSerializator ps;
            List<String> values;
            ArrayList<Object> backupFailed;
            HashMap propertiesHdr;
            cr = this.getConnection(conOpenSPCoopPdD, "dump.log");
            con = cr.getConnection();
            if (this.debug) {
                this.log.debug("@@ log" + identificativoDump + " (getConnection finished) ....");
            }
            ServiceManagerProperties smProperties = new ServiceManagerProperties();
            smProperties.setDatabaseType(this.tipoDatabase);
            smProperties.setShowSql(this.debug);
            smProperties.setAutomaticTransactionManagement(con.getAutoCommit());
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, smProperties);
            IDumpMessaggioService dumpMessageService = jdbcServiceManager.getDumpMessaggioService();
            SimpleDateFormat dateformat = null;
            if (this.debug) {
                dateformat = DateUtils.getSimpleDateFormatMs();
            }
            File fDump = null;
            DumpMessaggio dumpMessaggio = new DumpMessaggio();
            dumpMessaggio.setProtocollo(protocollo);
            dumpMessaggio.setIdTransazione(idTransazione);
            dumpMessaggio.setServizioApplicativoErogatore(servizioApplicativoErogatore);
            dumpMessaggio.setDataConsegnaErogatore(dataConsegnaErogatore);
            dumpMessaggio.setTipoMessaggio(tipoMessaggio);
            if (this.debug) {
                this.log.debug("formato-messaggio: " + formatoMessaggio);
                this.log.debug("gdo: " + dateformat.format(gdo));
                this.log.debug("content-type[" + messaggio.getContentType() + "]");
                if (messaggio.getBody() == null) {
                    this.log.debug("body undefined");
                } else {
                    this.log.debug("body: " + Utilities.convertBytesToFormatString((long)messaggio.getBody().size()));
                }
            }
            if (formatoMessaggio != null) {
                dumpMessaggio.setFormatoMessaggio(formatoMessaggio.name());
            }
            dumpMessaggio.setDumpTimestamp(gdo);
            dumpMessaggio.setContentType(messaggio.getContentType());
            if (messaggio.getBody() != null && messaggio.getBody().size() > 0) {
                if (!messaggio.getBody().isSerializedOnFileSystem()) {
                    dumpMessaggio.setBody(messaggio.getBody().toByteArray());
                    dumpMessaggio.setContentLength(Long.valueOf(messaggio.getBody().size()));
                } else {
                    fDump = messaggio.getBody().getSerializedFile();
                    dumpMessaggio.setContentLength(Long.valueOf(fDump.length()));
                }
            }
            if (messaggio.getBodyMultipartInfo() != null) {
                if (this.debug) {
                    this.log.debug("multipart-body-content-id[" + messaggio.getBodyMultipartInfo().getContentId() + "]");
                    this.log.debug("multipart-body-content-location[" + messaggio.getBodyMultipartInfo().getContentLocation() + "]");
                    this.log.debug("multipart-body-content-type[" + messaggio.getBodyMultipartInfo().getContentType() + "]");
                }
                dumpMessaggio.setMultipartContentId(messaggio.getBodyMultipartInfo().getContentId());
                dumpMessaggio.setMultipartContentLocation(messaggio.getBodyMultipartInfo().getContentLocation());
                dumpMessaggio.setMultipartContentType(messaggio.getBodyMultipartInfo().getContentType());
                if (messaggio.getBodyMultipartInfo().getHeaders() != null && messaggio.getBodyMultipartInfo().getHeaders().size() > 0) {
                    if (this.debug) {
                        this.log.debug("Dump " + messaggio.getBodyMultipartInfo().getHeaders().size() + " multipart-body headers");
                    }
                    propertiesHdr = new HashMap();
                    backupFailed = new ArrayList();
                    for (String key : messaggio.getBodyMultipartInfo().getHeaders().keySet()) {
                        values = messaggio.getBodyMultipartInfo().getHeaders().get(key);
                        if (values == null || values.isEmpty()) continue;
                        for (String string : values) {
                            void var26_33;
                            if (string == null) {
                                String string2 = "";
                            }
                            if (this.debug) {
                                this.log.debug("\t\t" + key + "=" + (String)var26_33);
                            }
                            DumpMultipartHeader headerMultipart = new DumpMultipartHeader();
                            headerMultipart.setNome(key);
                            headerMultipart.setValore(var26_33.toString());
                            headerMultipart.setDumpTimestamp(gdo);
                            if (headersCompact) {
                                TransportUtils.addHeader(propertiesHdr, (String)key, (String)var26_33);
                                backupFailed.add(headerMultipart);
                                continue;
                            }
                            dumpMessaggio.addMultipartHeader(headerMultipart);
                        }
                    }
                    if (headersCompact) {
                        ps = new PropertiesSerializator(propertiesHdr);
                        try {
                            dumpMessaggio.setMultipartHeaderExt(ps.convertToDBColumnValue());
                            backupFailed.clear();
                            backupFailed = null;
                        }
                        catch (Throwable e) {
                            this.log.error("Errore durante la conversione degli header multipart: " + e.getMessage(), e);
                            for (DumpMultipartHeader dumpMultipartHeader : backupFailed) {
                                dumpMessaggio.addMultipartHeader(dumpMultipartHeader);
                            }
                        }
                    }
                }
            }
            dumpMessaggio.setPostProcessed(1);
            if (messaggio.getHeaders() != null && messaggio.getHeaders().size() > 0) {
                if (this.debug) {
                    this.log.debug("Dump " + messaggio.getHeaders().size() + " headers");
                }
                propertiesHdr = new HashMap();
                backupFailed = new ArrayList<Object>();
                for (String key : messaggio.getHeaders().keySet()) {
                    values = messaggio.getHeaders().get(key);
                    if (values == null || values.isEmpty()) continue;
                    for (String string : values) {
                        void var26_41;
                        if (string == null) {
                            String string3 = "";
                        }
                        if (this.debug) {
                            this.log.debug("\t\t" + key + "=" + (String)var26_41);
                        }
                        DumpHeaderTrasporto headerTrasporto = new DumpHeaderTrasporto();
                        headerTrasporto.setNome(key);
                        headerTrasporto.setValore(var26_41.toString());
                        headerTrasporto.setDumpTimestamp(gdo);
                        if (headersCompact) {
                            TransportUtils.addHeader(propertiesHdr, (String)key, (String)var26_41);
                            backupFailed.add(headerTrasporto);
                            continue;
                        }
                        dumpMessaggio.addHeaderTrasporto(headerTrasporto);
                    }
                }
                if (headersCompact) {
                    ps = new PropertiesSerializator(propertiesHdr);
                    try {
                        dumpMessaggio.setHeaderExt(ps.convertToDBColumnValue());
                        backupFailed.clear();
                        backupFailed = null;
                    }
                    catch (Throwable e) {
                        this.log.error("Errore durante la conversione degli header: " + e.getMessage(), e);
                        for (DumpHeaderTrasporto dumpHeaderTrasporto : backupFailed) {
                            dumpMessaggio.addHeaderTrasporto(dumpHeaderTrasporto);
                        }
                    }
                }
            }
            if (messaggio.getAttachments() != null && messaggio.getAttachments().size() > 0) {
                if (this.debug) {
                    this.log.debug("Dump " + messaggio.getAttachments().size() + " attachments");
                }
                for (Attachment attach : messaggio.getAttachments()) {
                    if (this.debug) {
                        this.log.debug("Attachment:");
                        this.log.debug("\t\tId[" + attach.getContentId() + "]");
                        this.log.debug("\t\tlocation[" + attach.getContentLocation() + "]");
                        this.log.debug("\t\ttype[" + attach.getContentType() + "]");
                        if (attach.getContent() == null) {
                            this.log.debug("\t\tcontent undefined");
                        } else {
                            this.log.debug("\t\tcontent: " + Utilities.convertBytesToFormatString((long)attach.getContent().length));
                        }
                    }
                    DumpAllegato dumpAllegato = new DumpAllegato();
                    dumpAllegato.setContentId(attach.getContentId());
                    dumpAllegato.setContentLocation(attach.getContentLocation());
                    dumpAllegato.setContentType(attach.getContentType());
                    dumpAllegato.setAllegato(attach.getContent());
                    dumpAllegato.setDumpTimestamp(gdo);
                    dumpMessaggio.addAllegato(dumpAllegato);
                    if (attach.getHeaders() == null || attach.getHeaders().size() <= 0) continue;
                    if (this.debug) {
                        this.log.debug("Dump " + attach.getHeaders().size() + " headers dell'allegato con id [" + attach.getContentId() + "]");
                    }
                    HashMap propertiesHdr2 = new HashMap();
                    ArrayList<DumpHeaderAllegato> backupFailed2 = new ArrayList<DumpHeaderAllegato>();
                    for (String string : attach.getHeaders().keySet()) {
                        List<String> values2 = attach.getHeaders().get(string);
                        if (values2 == null || values2.isEmpty()) continue;
                        for (String value : values2) {
                            if (value == null) {
                                value = "";
                            }
                            if (this.debug) {
                                this.log.debug("\t\t" + string + "=" + value);
                            }
                            DumpHeaderAllegato headerAllegato = new DumpHeaderAllegato();
                            headerAllegato.setNome(string);
                            headerAllegato.setValore(value.toString());
                            headerAllegato.setDumpTimestamp(gdo);
                            if (headersCompact) {
                                TransportUtils.addHeader(propertiesHdr2, (String)string, (String)value);
                                backupFailed2.add(headerAllegato);
                                continue;
                            }
                            dumpAllegato.addHeader(headerAllegato);
                        }
                    }
                    if (!headersCompact) continue;
                    PropertiesSerializator propertiesSerializator = new PropertiesSerializator(propertiesHdr2);
                    try {
                        dumpAllegato.setHeaderExt(propertiesSerializator.convertToDBColumnValue());
                        backupFailed2.clear();
                        backupFailed2 = null;
                    }
                    catch (Throwable e) {
                        this.log.error("Errore durante la conversione degli header dell'allegato '" + attach.getContentId() + "': " + e.getMessage(), e);
                        for (DumpHeaderAllegato dumpHeader : backupFailed2) {
                            dumpAllegato.addHeader(dumpHeader);
                        }
                    }
                }
            }
            if (messaggio.getContenuti() != null && messaggio.getContenuti().size() > 0) {
                if (this.debug) {
                    this.log.debug("Dump " + messaggio.getContenuti().size() + " contenuti");
                }
                for (String key : messaggio.getContenuti().keySet()) {
                    String value = messaggio.getContenuti().get(key);
                    if (value == null) {
                        value = "";
                    }
                    DumpContenuto contenuto = TransactionContentUtils.createDumpContenuto((String)key, (String)value, (Date)gdo);
                    if (this.debug) {
                        this.log.debug("\t\t" + key + "=" + value);
                    }
                    dumpMessaggio.addContenuto(contenuto);
                }
            }
            if (this.debug) {
                this.log.debug("@@ log" + identificativoDump + " registrazione in corso ...");
            }
            dumpMessageService.create((Object)dumpMessaggio);
            if (fDump != null) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
                sqlQueryObject.addUpdateTable("dump_messaggi");
                sqlQueryObject.addUpdateField("body", "?");
                sqlQueryObject.addWhereCondition("dump_messaggi.id=?");
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.tipoDatabase);
                String sqlQueryUpdate = sqlQueryObject.createSQLUpdate();
                Statement pstmt = null;
                try (FileInputStream fin = new FileInputStream(fDump);){
                    int index = 1;
                    pstmt = con.prepareStatement(sqlQueryUpdate);
                    jdbcAdapter.setBinaryData((PreparedStatement)pstmt, index++, (InputStream)fin, true);
                    pstmt.setLong(index++, dumpMessaggio.getId());
                    pstmt.execute();
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.debug) {
                this.log.debug("@@ log" + identificativoDump + " registrazione completata");
            }
        }
        catch (Exception e) {
            throw new DumpException("Errore durante il dump del messaggio idTransazione[" + idTransazione + "] tipoMessaggio[" + tipoMessaggio + "]: " + e.getMessage(), e);
        }
        finally {
            try {
                this.releaseConnection(cr, "dump.log");
            }
            catch (Exception exception) {}
        }
    }
}

