/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.registry;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.Search;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.ConfigurazioneMultitenant;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneCRUD;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReaderInUso;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPorteApplicative;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPorteDelegate;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServiziApplicativi;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class ConfigIntegrationReader
implements IConfigIntegrationReader {
    private IDriverConfigurazioneGet driverConfigurazioneGET;
    private IDriverConfigurazioneCRUD driverConfigurazioneCRUD;
    private IConfigIntegrationReaderInUso inUsoDriver = null;
    private Logger log;
    private static final String NOT_IMPLEMENTED = "Not Implemented";

    public ConfigIntegrationReader(IDriverConfigurazioneGet driverConfigurazione, Logger log) throws ProtocolException {
        this.driverConfigurazioneGET = driverConfigurazione;
        if (this.driverConfigurazioneGET instanceof IDriverConfigurazioneCRUD) {
            this.driverConfigurazioneCRUD = (IDriverConfigurazioneCRUD)this.driverConfigurazioneGET;
        }
        this.log = log;
        Loader loader = new Loader();
        try {
            this.inUsoDriver = (IConfigIntegrationReaderInUso)loader.newInstance("org.openspcoop2.protocol.engine.registry.ConfigIntegrationReaderInUso");
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        this.inUsoDriver.init(this.driverConfigurazioneGET, log);
    }

    @Override
    public boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) {
        try {
            if (this.driverConfigurazioneCRUD != null) {
                return this.driverConfigurazioneCRUD.existsServizioApplicativo(idServizioApplicativo);
            }
            return this.driverConfigurazioneGET.getServizioApplicativo(idServizioApplicativo) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiBasic(String username, String password, CryptConfig config) {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiBasic(username, password, config) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiBasic(String username, String password, CryptConfig config) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiBasic(username, password, config);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiSsl(String subject, String issuer) {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiSsl(subject, issuer) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String subject, String issuer) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiSsl(subject, issuer);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiSsl(String subject, String issuer, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) {
        try {
            return this.getServizioApplicativoByCredenzialiSsl(subject, issuer, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String subject, String issuer, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
                return ((DriverConfigurazioneDB)this.driverConfigurazioneGET).getServizioApplicativoByCredenzialiSsl(subject, issuer, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
            }
            throw new RegistryException("Unsupported");
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) {
        try {
            return this.getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
                return ((DriverConfigurazioneDB)this.driverConfigurazioneGET).getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier);
            }
            throw new RegistryException("Unsupported");
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiPrincipal(String principal) {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiPrincipal(principal) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiPrincipal(String principal) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiPrincipal(principal);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiToken(tokenPolicy, tokenClientId, tokenWithHttpsEnabled) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativoByCredenzialiToken(tokenPolicy, tokenClientId, tokenWithHttpsEnabled);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getServizioApplicativo(idServizioApplicativo);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDServizioApplicativo> findIdServiziApplicativi(ProtocolFiltroRicercaServiziApplicativi filtroRicerca) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getAllIdServiziApplicativi((FiltroRicercaServiziApplicativi)filtroRicerca);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDServizioApplicativo> findIdServiziApplicativiByPaAuth(PortaApplicativa pa, boolean authToken, boolean authTrasporto) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
                IDSoggetto idSoggetto = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
                String superuser = null;
                boolean returnAll = false;
                boolean bothSslAndToken = false;
                String tokenPolicy = null;
                boolean tokenPolicyOR = false;
                if (pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null) {
                    tokenPolicy = pa.getGestioneToken().getPolicy();
                }
                List<IDServizioApplicativo> ltrasporto = null;
                if (authTrasporto) {
                    TipoAutenticazione auth;
                    if (pa.getAutenticazione() != null && StringUtils.isNotEmpty((String)pa.getAutenticazione()) && ((auth = TipoAutenticazione.toEnumConstant((String)pa.getAutenticazione(), (boolean)false)) == null || TipoAutenticazione.DISABILITATO.equals((Object)auth))) {
                        returnAll = true;
                    }
                    if (returnAll) {
                        return this.findIdServiziApplicativiByAuthTrasporto(idSoggetto, returnAll, pa.getAutenticazione(), tokenPolicy, pa.getProprietaAutenticazione());
                    }
                    ltrasporto = this.findIdServiziApplicativiByAuthTrasporto(idSoggetto, returnAll, pa.getAutenticazione(), tokenPolicy, pa.getProprietaAutenticazione());
                }
                List ltoken = null;
                if (authToken && tokenPolicy != null) {
                    ltoken = ((DriverConfigurazioneDB)this.driverConfigurazioneGET).soggettiServizioApplicativoList(idSoggetto, superuser, CredenzialeTipo.TOKEN, Boolean.valueOf(false), "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
                }
                ArrayList<IDServizioApplicativo> lSA = new ArrayList<IDServizioApplicativo>();
                ArrayList<String> nomi = new ArrayList<String>();
                if (ltrasporto != null && !ltrasporto.isEmpty()) {
                    for (IDServizioApplicativo idSADB : ltrasporto) {
                        lSA.add(idSADB);
                        nomi.add(idSADB.getNome());
                    }
                }
                if (ltoken != null && !ltoken.isEmpty()) {
                    for (IDServizioApplicativo idSADB : ltoken) {
                        if (nomi.contains(idSADB.getNome())) continue;
                        lSA.add(idSADB);
                        nomi.add(idSADB.getNome());
                    }
                }
                if (lSA.isEmpty()) {
                    throw new RegistryNotFound("Servizi applicativi non trovati");
                }
                return lSA;
            }
            throw new RegistryException("Unsupported");
        }
        catch (RegistryNotFound notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDServizioApplicativo> findIdServiziApplicativiByPdAuth(PortaDelegata pd, boolean authToken, boolean authTrasporto) throws RegistryNotFound, RegistryException {
        try {
            if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
                IDSoggetto idSoggetto = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                String superuser = null;
                boolean returnAll = false;
                boolean bothSslAndToken = false;
                String tokenPolicy = null;
                boolean tokenPolicyOR = false;
                if (pd.getGestioneToken() != null && pd.getGestioneToken().getPolicy() != null) {
                    tokenPolicy = pd.getGestioneToken().getPolicy();
                }
                List<IDServizioApplicativo> ltrasporto = null;
                if (authTrasporto) {
                    TipoAutenticazione auth;
                    if (pd.getAutenticazione() != null && StringUtils.isNotEmpty((String)pd.getAutenticazione()) && ((auth = TipoAutenticazione.toEnumConstant((String)pd.getAutenticazione(), (boolean)false)) == null || TipoAutenticazione.DISABILITATO.equals((Object)auth))) {
                        returnAll = true;
                    }
                    if (returnAll) {
                        return this.findIdServiziApplicativiByAuthTrasporto(idSoggetto, returnAll, pd.getAutenticazione(), tokenPolicy, pd.getProprietaAutenticazione());
                    }
                    ltrasporto = this.findIdServiziApplicativiByAuthTrasporto(idSoggetto, returnAll, pd.getAutenticazione(), tokenPolicy, pd.getProprietaAutenticazione());
                }
                List ltoken = null;
                if (authToken && tokenPolicy != null) {
                    ltoken = ((DriverConfigurazioneDB)this.driverConfigurazioneGET).soggettiServizioApplicativoList(idSoggetto, superuser, CredenzialeTipo.TOKEN, Boolean.valueOf(false), "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
                }
                ArrayList<IDServizioApplicativo> lSA = new ArrayList<IDServizioApplicativo>();
                ArrayList<String> nomi = new ArrayList<String>();
                if (ltrasporto != null && !ltrasporto.isEmpty()) {
                    for (IDServizioApplicativo idSADB : ltrasporto) {
                        lSA.add(idSADB);
                        nomi.add(idSADB.getNome());
                    }
                }
                if (ltoken != null && !ltoken.isEmpty()) {
                    for (IDServizioApplicativo idSADB : ltoken) {
                        if (nomi.contains(idSADB.getNome())) continue;
                        lSA.add(idSADB);
                        nomi.add(idSADB.getNome());
                    }
                }
                if (lSA.isEmpty()) {
                    throw new RegistryNotFound("Servizi applicativi non trovati");
                }
                return lSA;
            }
            throw new RegistryException("Unsupported");
        }
        catch (RegistryNotFound notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    private List<IDServizioApplicativo> findIdServiziApplicativiByAuthTrasporto(IDSoggetto idSoggetto, boolean returnAll, String autenticazione, String tokenPolicy, List<Proprieta> listProprietaAutenticazione) throws RegistryNotFound, RegistryException, DriverConfigurazioneException {
        if (returnAll) {
            ProtocolFiltroRicercaServiziApplicativi f = new ProtocolFiltroRicercaServiziApplicativi();
            f.setTipoSoggetto(idSoggetto.getTipo());
            f.setNomeSoggetto(idSoggetto.getNome());
            f.setTipo("client");
            return this.findIdServiziApplicativi(f);
        }
        Boolean appId = null;
        CredenzialeTipo tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)autenticazione);
        if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione) && listProprietaAutenticazione != null && !listProprietaAutenticazione.isEmpty()) {
            for (Proprieta proprieta : listProprietaAutenticazione) {
                if (!"appId".equals(proprieta.getNome())) continue;
                appId = "true".equals(proprieta.getValore());
                break;
            }
        }
        boolean bothSslAndToken = false;
        boolean tokenPolicyOR = false;
        List ltrasporto = ((DriverConfigurazioneDB)this.driverConfigurazioneGET).soggettiServizioApplicativoList(idSoggetto, null, tipoAutenticazione, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
        ArrayList<IDServizioApplicativo> lSA = new ArrayList<IDServizioApplicativo>();
        for (IDServizioApplicativoDB idSADB : ltrasporto) {
            lSA.add((IDServizioApplicativo)idSADB);
        }
        return lSA;
    }

    @Override
    public boolean inUso(IDServizioApplicativo idServizioApplicativo, boolean verificaRuoli) throws RegistryException {
        return this.inUsoDriver.inUso(idServizioApplicativo, verificaRuoli);
    }

    @Override
    public String getDettagliInUso(IDServizioApplicativo idServizioApplicativo, boolean verificaRuoli) throws RegistryException {
        return this.inUsoDriver.getDettagliInUso(idServizioApplicativo, verificaRuoli);
    }

    @Override
    public IDPortaDelegata getIdPortaDelegata(String nome, IProtocolFactory<?> protocolFactory) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getIDPortaDelegata(nome);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsPortaDelegata(IDPortaDelegata idPortaDelegata) {
        try {
            if (this.driverConfigurazioneCRUD != null) {
                return this.driverConfigurazioneCRUD.existsPortaDelegata(idPortaDelegata);
            }
            return this.driverConfigurazioneGET.getPortaDelegata(idPortaDelegata) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public PortaDelegata getPortaDelegata(IDPortaDelegata idPortaDelegata) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getPortaDelegata(idPortaDelegata);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDPortaDelegata> findIdPorteDelegate(ProtocolFiltroRicercaPorteDelegate filtroRicerca) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getAllIdPorteDelegate((FiltroRicercaPorteDelegate)filtroRicerca);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<AttivazionePolicy> getRateLimitingPolicy(IDPortaDelegata idPortaDelegata) throws RegistryNotFound, RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getRateLimitingPolicy(portaDelegata)");
                Search search = new Search(true);
                List list = ControlloTrafficoDriverUtils.configurazioneControlloTrafficoAttivazionePolicyList((ISearch)search, (RuoloPolicy)RuoloPolicy.DELEGATA, (String)idPortaDelegata.getNome(), (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<Allarme> getAllarmi(IDPortaDelegata idPortaDelegata) throws RegistryNotFound, RegistryException {
        if (!CostantiDB.isAllarmiEnabled()) {
            return new ArrayList<Allarme>();
        }
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getAllarmi(portaDelegata)");
                Search search = new Search(true);
                List list = AllarmiDriverUtils.allarmiList((ISearch)search, (RuoloPorta)RuoloPorta.DELEGATA, (String)idPortaDelegata.getNome(), (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<MappingFruizionePortaDelegata> getMappingFruizionePortaDelegataList(IDSoggetto idFruitore, IDServizio idServizio) throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getMappingFruizionePortaDelegataList");
                List list = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)driver.getTipoDB(), (IDSoggetto)idFruitore, (IDServizio)idServizio, (boolean)false);
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public IDPortaApplicativa getIdPortaApplicativa(String nome, IProtocolFactory<?> protocolFactory) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getIDPortaApplicativa(nome);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean existsPortaApplicativa(IDPortaApplicativa idPortaApplicativa) {
        try {
            if (this.driverConfigurazioneCRUD != null) {
                return this.driverConfigurazioneCRUD.existsPortaApplicativa(idPortaApplicativa);
            }
            return this.driverConfigurazioneGET.getPortaApplicativa(idPortaApplicativa) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPortaApplicativa) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getPortaApplicativa(idPortaApplicativa);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<IDPortaApplicativa> findIdPorteApplicative(ProtocolFiltroRicercaPorteApplicative filtroRicerca) throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getAllIdPorteApplicative((FiltroRicercaPorteApplicative)filtroRicerca);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<AttivazionePolicy> getRateLimitingPolicy(IDPortaApplicativa idPortaApplicativa) throws RegistryNotFound, RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getRateLimitingPolicy(portaApplicativa)");
                Search search = new Search(true);
                List list = ControlloTrafficoDriverUtils.configurazioneControlloTrafficoAttivazionePolicyList((ISearch)search, (RuoloPolicy)RuoloPolicy.APPLICATIVA, (String)idPortaApplicativa.getNome(), (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<Allarme> getAllarmi(IDPortaApplicativa idPortaApplicativa) throws RegistryNotFound, RegistryException {
        if (!CostantiDB.isAllarmiEnabled()) {
            return new ArrayList<Allarme>();
        }
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getAllarmi(portaApplicativa)");
                Search search = new Search(true);
                List list = AllarmiDriverUtils.allarmiList((ISearch)search, (RuoloPorta)RuoloPorta.APPLICATIVA, (String)idPortaApplicativa.getNome(), (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<MappingErogazionePortaApplicativa> getMappingErogazionePortaApplicativaList(IDServizio idServizio) throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getMappingErogazionePortaApplicativaList");
                List list = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)driver.getTipoDB(), (IDServizio)idServizio, (boolean)false);
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public ConfigurazioneMultitenant getConfigurazioneMultitenant() throws RegistryNotFound, RegistryException {
        try {
            ConfigurazioneMultitenant conf = this.driverConfigurazioneGET.getConfigurazioneGenerale().getMultitenant();
            if (conf == null) {
                return new ConfigurazioneMultitenant();
            }
            return conf;
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public CanaliConfigurazione getCanaliConfigurazione() throws RegistryNotFound, RegistryException {
        try {
            return this.driverConfigurazioneGET.getCanaliConfigurazione();
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public List<AttivazionePolicy> getRateLimitingPolicyGlobali() throws RegistryNotFound, RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getRateLimitingPolicyGlobali");
                Search search = new Search(true);
                List list = ControlloTrafficoDriverUtils.configurazioneControlloTrafficoAttivazionePolicyList((ISearch)search, null, null, (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public String getNextPolicyInstanceSerialId(String policyId) throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getNextPolicyInstanceSerialId");
                String string = ControlloTrafficoDriverUtils.getNextPolicyInstanceSerialId((String)policyId, (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<Allarme> getAllarmiGlobali() throws RegistryNotFound, RegistryException {
        if (!CostantiDB.isAllarmiEnabled()) {
            return new ArrayList<Allarme>();
        }
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getAllarmiGlobali");
                Search search = new Search(true);
                List list = AllarmiDriverUtils.allarmiList((ISearch)search, null, null, (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return list;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public String getNextAlarmInstanceSerialId(String tipoPlugin) throws RegistryException {
        if (!CostantiDB.isAllarmiEnabled()) {
            throw new RegistryException("Alarm not supported");
        }
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection con = null;
            try {
                con = driver.getConnection("getNextAlarmInstanceSerialId");
                String string = AllarmiDriverUtils.getNextAlarmInstanceSerialId((String)tipoPlugin, (Connection)con, (Logger)this.log, (String)driver.getTipoDB());
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
            finally {
                try {
                    if (con != null) {
                        driver.releaseConnection(con);
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<GenericProperties> getTokenPolicyValidazione() throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            try {
                Search search = new Search(true);
                ArrayList<String> tipologiaList = new ArrayList<String>();
                tipologiaList.add("gestionePolicyToken");
                return driver.getGenericProperties(tipologiaList, Integer.valueOf(Liste.CONFIGURAZIONE_GESTIONE_POLICY_TOKEN), (ISearch)search, false);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public GenericProperties getTokenPolicyValidazione(String nome) throws RegistryNotFound, RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            try {
                GenericProperties gp = driver.getGenericProperties("gestionePolicyToken", nome);
                if (gp == null) {
                    throw new DriverConfigurazioneNotFound();
                }
                return gp;
            }
            catch (DriverConfigurazioneNotFound de) {
                throw new RegistryNotFound(de.getMessage(), de);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<GenericProperties> getTokenPolicyNegoziazione() throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            try {
                Search search = new Search(true);
                ArrayList<String> tipologiaList = new ArrayList<String>();
                tipologiaList.add("retrievePolicyToken");
                return driver.getGenericProperties(tipologiaList, Integer.valueOf(Liste.CONFIGURAZIONE_GESTIONE_POLICY_TOKEN), (ISearch)search, false);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public GenericProperties getTokenPolicyNegoziazione(String nome) throws RegistryNotFound, RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            try {
                GenericProperties gp = driver.getGenericProperties("retrievePolicyToken", nome);
                if (gp == null) {
                    throw new DriverConfigurazioneNotFound();
                }
                return gp;
            }
            catch (DriverConfigurazioneNotFound de) {
                throw new RegistryNotFound(de.getMessage(), de);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public List<GenericProperties> getAttributeAuthority() throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            try {
                Search search = new Search(true);
                ArrayList<String> tipologiaList = new ArrayList<String>();
                tipologiaList.add("attributeAuthority");
                return driver.getGenericProperties(tipologiaList, Integer.valueOf(Liste.CONFIGURAZIONE_GESTIONE_ATTRIBUTE_AUTHORITY), (ISearch)search, false);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }

    @Override
    public GenericProperties getAttributeAuthority(String nome) throws RegistryNotFound, RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            try {
                GenericProperties gp = driver.getGenericProperties("attributeAuthority", nome);
                if (gp == null) {
                    throw new DriverConfigurazioneNotFound();
                }
                return gp;
            }
            catch (DriverConfigurazioneNotFound de) {
                throw new RegistryNotFound(de.getMessage(), de);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), e);
            }
        }
        throw new RegistryException(NOT_IMPLEMENTED);
    }
}

