/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.tracciamento;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.BasicConnectionResult;
import org.openspcoop2.protocol.basic.BasicProducer;
import org.openspcoop2.protocol.basic.BasicProducerType;
import org.openspcoop2.protocol.sdk.Allegato;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCUtilities;

public class TracciaProducer
extends BasicProducer
implements ITracciaProducer {
    public TracciaProducer(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory, BasicProducerType.TRACCE);
    }

    @Override
    public void initializeAppender(OpenspcoopAppender appenderProperties) throws TracciamentoException {
        try {
            this.initializeAppender(appenderProperties, true);
        }
        catch (Exception e) {
            throw new TracciamentoException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    @Override
    public void log(Connection conOpenSPCoopPdD, Traccia traccia) throws TracciamentoException {
        if (traccia == null) {
            throw new TracciamentoException("Errore durante il tracciamento: traccia is null");
        }
        Busta busta = traccia.getBusta();
        if (busta == null) {
            throw new TracciamentoException("Errore durante il tracciamento di un busta: busta is null");
        }
        Date gdo = traccia.getGdo();
        IDSoggetto idSoggetto = traccia.getIdSoggetto();
        String tipoMessaggio = traccia.getTipoMessaggio().getTipo();
        String location = traccia.getLocation();
        String idCorrelazioneApplicativa = traccia.getCorrelazioneApplicativa();
        String idCorrelazioneApplicativaRisposta = traccia.getCorrelazioneApplicativaRisposta();
        if (this.debug) {
            this.log.debug("@@ log[" + busta.getID() + "] ....");
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        BasicConnectionResult cr = null;
        try {
            String[] propertiesNames;
            int index;
            int i;
            cr = this.getConnection(conOpenSPCoopPdD, "traccia.log");
            con = cr.getConnection();
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (getConnection finished) ....");
            }
            if (!TipiDatabase.isAMember((String)this.tipoDatabase)) {
                throw new TracciamentoException("Tipo database [" + this.tipoDatabase + "] non supportato");
            }
            TipiDatabase tipo = TipiDatabase.toEnumConstant((String)this.tipoDatabase);
            Timestamp gdoT = new Timestamp(gdo.getTime());
            Timestamp oraRegistrazioneT = null;
            Timestamp scadenzaT = null;
            if (busta.getOraRegistrazione() != null) {
                oraRegistrazioneT = new Timestamp(busta.getOraRegistrazione().getTime());
            }
            if (busta.getScadenza() != null) {
                scadenzaT = new Timestamp(busta.getScadenza().getTime());
            }
            int confermaRicezione = -1;
            confermaRicezione = busta.isConfermaRicezione() ? 1 : 0;
            String headerProtocollo = null;
            if (traccia.getBustaAsRawContent() != null) {
                try {
                    headerProtocollo = traccia.getBustaAsRawContent().toString(TipoSerializzazione.DEFAULT);
                }
                catch (Exception e) {
                    throw new Exception("Serializzazione RawContent non riuscita: " + e.getMessage(), e);
                }
            } else if (traccia.getBustaAsString() != null) {
                headerProtocollo = traccia.getBustaAsString();
            } else if (traccia.getBustaAsByteArray() != null) {
                headerProtocollo = new String(traccia.getBustaAsByteArray());
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (prima inserimento traccia) ....");
            }
            ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo", (Object)gdoT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo_int", (Object)gdoT.getTime(), InsertAndGeneratedKeyJDBCType.LONG));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_codice", (Object)idSoggetto.getCodicePorta(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_tipo_soggetto", (Object)idSoggetto.getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_nome_soggetto", (Object)idSoggetto.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_ruolo", (Object)traccia.getTipoPdD().getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_messaggio", (Object)tipoMessaggio, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("esito_elaborazione", (Object)traccia.getEsitoElaborazioneMessaggioTracciato().getEsito().toString(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("dettaglio_esito_elaborazione", (Object)traccia.getEsitoElaborazioneMessaggioTracciato().getDettaglio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idporta_mittente", (Object)busta.getIdentificativoPortaMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("mittente", (Object)busta.getMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_mittente", (Object)busta.getTipoMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("indirizzo_mittente", (Object)busta.getIndirizzoMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idporta_destinatario", (Object)busta.getIdentificativoPortaDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("destinatario", (Object)busta.getDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_destinatario", (Object)busta.getTipoDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("indirizzo_destinatario", (Object)busta.getIndirizzoDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("profilo_collaborazione", (Object)busta.getProfiloDiCollaborazioneValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("profilo_collaborazione_meta", (Object)(busta.getProfiloDiCollaborazione() == null ? null : busta.getProfiloDiCollaborazione().getEngineValue()), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("servizio_correlato", (Object)busta.getServizioCorrelato(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_servizio_correlato", (Object)busta.getTipoServizioCorrelato(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("collaborazione", (Object)busta.getCollaborazione(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("versione_servizio", (Object)busta.getVersioneServizio(), InsertAndGeneratedKeyJDBCType.INT));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("servizio", (Object)busta.getServizio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_servizio", (Object)busta.getTipoServizio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("azione", (Object)busta.getAzione(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_messaggio", (Object)busta.getID(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("ora_registrazione", (Object)oraRegistrazioneT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_ora_reg", (Object)busta.getTipoOraRegistrazioneValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_ora_reg_meta", (Object)(busta.getTipoOraRegistrazione() == null ? null : busta.getTipoOraRegistrazione().getEngineValue()), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("rif_messaggio", (Object)busta.getRiferimentoMessaggio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("scadenza", (Object)scadenzaT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("inoltro", (Object)busta.getInoltroValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("inoltro_meta", (Object)(busta.getInoltro() == null ? null : busta.getInoltro().getEngineValue()), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("conferma_ricezione", (Object)confermaRicezione, InsertAndGeneratedKeyJDBCType.INT));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("sequenza", (Object)busta.getSequenza(), InsertAndGeneratedKeyJDBCType.LONG));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("location", (Object)location, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("correlazione_applicativa", (Object)idCorrelazioneApplicativa, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("correlazione_risposta", (Object)idCorrelazioneApplicativaRisposta, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("sa_fruitore", (Object)busta.getServizioApplicativoFruitore(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("sa_erogatore", (Object)busta.getServizioApplicativoErogatore(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("protocollo", (Object)traccia.getProtocollo(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("digest", (Object)busta.getDigest(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_element", (Object)headerProtocollo, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_transazione", (Object)traccia.getIdTransazione(), InsertAndGeneratedKeyJDBCType.STRING));
            long idtraccia = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)tipo, (IKeyGeneratorObject)new CustomKeyGeneratorObject("tracce", "id", "seq_tracce", "tracce_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
            if (idtraccia <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto");
            }
            traccia.setId(idtraccia);
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (traccia inserita) ....");
            }
            Object sqlString = null;
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaRiscontri() + " riscontri) ....");
            }
            for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                Riscontro riscontro = busta.getRiscontro(i);
                sqlString = "INSERT INTO tracce_riscontri (idtraccia, riscontro, ricevuta, ora_registrazione, tipo_ora_reg, tipo_ora_reg_meta, gdo) VALUES (?, ?, ?, ?, ?, ?, ?)";
                stmt = con.prepareStatement((String)sqlString);
                index = 1;
                stmt.setLong(index++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)riscontro.getID());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)riscontro.getRicevuta());
                if (riscontro.getOraRegistrazione() != null) {
                    stmt.setTimestamp(index++, new Timestamp(riscontro.getOraRegistrazione().getTime()));
                } else {
                    stmt.setTimestamp(index++, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)riscontro.getTipoOraRegistrazioneValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)riscontro.getTipoOraRegistrazione().getEngineValue());
                stmt.setTimestamp(index++, gdoT);
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaRiscontri() + " riscontri effettuato) ....");
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaTrasmissioni() + " trasmissioni) ....");
            }
            for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                Trasmissione trasmissione = busta.getTrasmissione(i);
                sqlString = "INSERT INTO tracce_trasmissioni (idtraccia, origine, tipo_origine, indirizzo_origine, idporta_origine, destinazione, tipo_destinazione, indirizzo_destinazione, idporta_destinazione, ora_registrazione, tipo_ora_reg, tipo_ora_reg_meta, gdo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                stmt = con.prepareStatement((String)sqlString);
                index = 1;
                stmt.setLong(index++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getTipoOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getIndirizzoOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getIdentificativoPortaOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getDestinazione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getTipoDestinazione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getIndirizzoDestinazione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getIdentificativoPortaDestinazione());
                if (trasmissione.getOraRegistrazione() != null) {
                    stmt.setTimestamp(index++, new Timestamp(trasmissione.getOraRegistrazione().getTime()));
                } else {
                    stmt.setTimestamp(index++, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getTempoValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)trasmissione.getTempo().getEngineValue());
                stmt.setTimestamp(index++, gdoT);
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaTrasmissioni() + " trasmissioni effettuato) ....");
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaEccezioni() + " eccezioni) ....");
            }
            for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                Eccezione eccezione = busta.getEccezione(i);
                String subCodiceMeta = "";
                String subCodiceMetaInsert = "";
                if (eccezione.getSubCodiceEccezione() != null && eccezione.getSubCodiceEccezione().getSubCodice() != null) {
                    subCodiceMeta = "subcodice_eccezione_meta, ";
                    subCodiceMetaInsert = "?,";
                }
                sqlString = "INSERT INTO tracce_eccezioni (idtraccia, contesto_codifica, contesto_codifica_meta, codice_eccezione, codice_eccezione_meta, " + subCodiceMeta + "rilevanza, rilevanza_meta, posizione, gdo) VALUES (?, ?, ?, ?, ?, " + subCodiceMetaInsert + " ?, ? , ? , ?)";
                stmt = con.prepareStatement((String)sqlString);
                int index2 = 1;
                stmt.setLong(index2++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index2++, (String)eccezione.getContestoCodificaValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index2++, (String)eccezione.getContestoCodifica().getEngineValue());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index2++, (String)eccezione.getCodiceEccezioneValue(this.protocolFactory));
                stmt.setInt(index2++, eccezione.getCodiceEccezione().getCodice());
                if (eccezione.getSubCodiceEccezione() != null && eccezione.getSubCodiceEccezione().getSubCodice() != null) {
                    stmt.setInt(index2++, eccezione.getSubCodiceEccezione().getSubCodice());
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index2++, (String)eccezione.getRilevanzaValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index2++, (String)eccezione.getRilevanza().getEngineValue());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index2++, (String)eccezione.getDescrizione(this.protocolFactory));
                stmt.setTimestamp(index2++, gdoT);
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaEccezioni() + " eccezioni effettuato) ....");
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + traccia.sizeListaAllegati() + " allegati) ....");
            }
            for (i = 0; i < traccia.sizeListaAllegati(); ++i) {
                Allegato allegato = traccia.getAllegato(i);
                sqlString = "INSERT INTO tracce_allegati (idtraccia, content_id, content_location, content_type, digest, gdo) VALUES (?, ?, ?, ?, ?, ?)";
                stmt = con.prepareStatement((String)sqlString);
                int index3 = 1;
                stmt.setLong(index3++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index3++, (String)allegato.getContentId());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index3++, (String)allegato.getContentLocation());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index3++, (String)allegato.getContentType());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index3++, (String)allegato.getDigest());
                stmt.setTimestamp(index3++, gdoT);
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + traccia.sizeListaAllegati() + " allegati effettuato) ....");
            }
            if ((propertiesNames = busta.getPropertiesNames()) != null) {
                if (this.debug) {
                    this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + propertiesNames.length + " ext-protocol-info) ....");
                }
                for (int i2 = 0; i2 < propertiesNames.length; ++i2) {
                    String v = busta.getProperty(propertiesNames[i2]);
                    int limit = 2800;
                    if (TipiDatabase.POSTGRESQL.equals(this.tipoDatabase)) {
                        int sum = 20;
                        if (propertiesNames[i2] != null) {
                            sum += propertiesNames[i2].length();
                        }
                        if (v != null) {
                            sum += v.length();
                        }
                        if (sum > 2711) {
                            limit = 2691 - propertiesNames[i2].length();
                        }
                    }
                    String columnExtV = "";
                    String valueExtV = "";
                    if (v != null && v.length() > limit) {
                        columnExtV = "ext_value, ";
                        valueExtV = ", ?";
                    }
                    sqlString = "INSERT INTO tracce_ext_protocol_info (idtraccia, name, value, " + columnExtV + "gdo) VALUES (?, ?, ?" + valueExtV + ", ?)";
                    stmt = con.prepareStatement((String)sqlString);
                    int index4 = 1;
                    stmt.setLong(index4++, idtraccia);
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index4++, (String)propertiesNames[i2]);
                    if (v != null && v.length() > limit) {
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index4++, (String)v.substring(0, limit));
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index4++, (String)v);
                    } else {
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index4++, (String)v);
                    }
                    stmt.setTimestamp(index4++, gdoT);
                    stmt.executeUpdate();
                    stmt.close();
                }
                if (this.debug) {
                    this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + propertiesNames.length + " effettuato) ....");
                }
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] completato");
            }
        }
        catch (Exception e) {
            throw new TracciamentoException("Errore durante il tracciamento di una busta: " + e.getMessage() + "\nL'id del messaggio della busta era: " + busta.getID(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.releaseConnection(cr, "traccia.log");
            }
            catch (Exception exception) {}
        }
    }
}

