/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.registry;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.byok.IDriverBYOKConfig;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Cache;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.uddi.DriverRegistroServiziUDDI;
import org.openspcoop2.core.registry.driver.utils.DriverRegistroServiziWSInitUtilities;
import org.openspcoop2.core.registry.driver.web.DriverRegistroServiziWEB;
import org.openspcoop2.core.registry.driver.xml.DriverRegistroServiziXML;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapperUtilities;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.protocol.registry._ASWrapperDati;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.slf4j.Logger;

public class RegistroServizi {
    private org.openspcoop2.utils.cache.Cache cache = null;
    private Map<String, IDriverRegistroServiziGet> driverRegistroServizi;
    private Map<String, String> mappingNomeRegistroToTipiDatabase = new HashMap<String, String>();
    private Map<String, Boolean> mappingNomeRegistroToUseConnectionPdD = new HashMap<String, Boolean>();
    private List<DriverRegistroServiziXML> registriXML;
    private Logger log = null;
    private boolean raggiungibilitaTotale = false;
    private boolean readObjectStatoBozza = false;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private static String notFoundClassName = DriverRegistroServiziNotFound.class.getName();
    private static String excClassName = DriverRegistroServiziException.class.getName();
    private static Semaphore semaphore_getObjectCache = new Semaphore("RegistroServizi_Object");
    private static Semaphore semaphore_getAccordoServizioSoapCache = new Semaphore("RegistroServizi_AccordoServizioSoap");
    private static Semaphore semaphore_getAccordoServizioRestCache = new Semaphore("RegistroServizi_AccordoServizioRest");
    private static Semaphore semaphore_getServiceBindingCache = new Semaphore("RegistroServizi_ServiceBinding");
    private static Semaphore semaphore_pushGenericObject = new Semaphore("RegistroServizi_GenericObject");

    public boolean isCacheAbilitata() {
        return this.cache != null;
    }

    public void resetCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String printStatsCache(String separator) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                return this.cache.printStats(separator);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public void abilitaCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            throw new DriverRegistroServiziException("Cache gia' abilitata");
        }
        try {
            this.cache = new org.openspcoop2.utils.cache.Cache(CacheType.JCS, "registroServizi");
            this.cache.build();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, CryptConfig cryptConfigSoggetti) throws DriverRegistroServiziException {
        if (this.cache != null) {
            throw new DriverRegistroServiziException("Cache gia' abilitata");
        }
        try {
            Cache configurazioneCache = new Cache();
            if (dimensioneCache != null) {
                configurazioneCache.setDimensione("" + dimensioneCache);
            }
            if (algoritmoCacheLRU != null) {
                if (algoritmoCacheLRU.booleanValue()) {
                    configurazioneCache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                } else {
                    configurazioneCache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                }
            }
            if (itemIdleTime != null) {
                configurazioneCache.setItemIdleTime("" + itemIdleTime);
            }
            if (itemLifeSecond != null) {
                configurazioneCache.setItemLifeSecond("" + itemLifeSecond);
            }
            this.initCacheRegistriServizi(CacheType.JCS, configurazioneCache, null, false, cryptConfigSoggetti);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void disabilitaCache() throws DriverRegistroServiziException {
        if (this.cache == null) {
            throw new DriverRegistroServiziException("Cache gia' disabilitata");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public String listKeysCache(String separator) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                return this.cache.printKeys(separator);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public List<String> keysCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                return this.cache.keys();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public String getObjectCache(String key) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public Object getRawObjectCache(String key) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    if (o instanceof CacheResponse) {
                        CacheResponse cR = (CacheResponse)o;
                        if (cR.getObject() != null) {
                            o = cR.getObject();
                        } else if (cR.getException() != null) {
                            o = cR.getException();
                        }
                    }
                    return o;
                }
                return null;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public void removeObjectCache(String key) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                this.cache.remove(key);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new DriverRegistroServiziException("Cache non abilitata");
        }
    }

    public RegistroServizi(AccessoRegistro accessoRegistro, Logger alog, Logger alogConsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza, String jndiNameDatasourcePdD, boolean useOp2UtilsDatasource, boolean bindJMX, boolean prefillCache, CryptConfig cryptConfigSoggetti, CacheType cacheType, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(RegistroServizi.class);
        if (this.log == null) {
            throw new UtilsRuntimeException("Logger unavailable");
        }
        try {
            this.driverRegistroServizi = new HashMap<String, IDriverRegistroServiziGet>();
            this.registriXML = new ArrayList<DriverRegistroServiziXML>();
            this.raggiungibilitaTotale = raggiungibilitaTotale;
            this.readObjectStatoBozza = readObjectStatoBozza;
            for (int i = 0; i < accessoRegistro.sizeRegistroList(); ++i) {
                DriverRegistroServiziXML driver = null;
                AccessoRegistroRegistro registro = accessoRegistro.getRegistro(i);
                Object nomeRegistro = registro.getNome();
                if (nomeRegistro == null) {
                    nomeRegistro = "Registro" + i + registro.getTipo();
                }
                String path = registro.getLocation();
                if (CostantiConfigurazione.REGISTRO_XML.equals((Object)registro.getTipo())) {
                    while (path.indexOf("${") != -1) {
                        int indexStart = path.indexOf("${");
                        int indexEnd = path.indexOf("}");
                        if (indexEnd == -1) {
                            this.log.error("errore durante l'interpretazione del path [" + path + "]: ${ utilizzato senza la rispettiva chiusura }");
                            continue;
                        }
                        String nameSystemProperty = path.substring(indexStart + "${".length(), indexEnd);
                        String valueSystemProperty = System.getProperty(nameSystemProperty);
                        if (valueSystemProperty == null) {
                            this.log.error("errore durante l'interpretazione del path [" + path + "]: variabile di sistema ${" + nameSystemProperty + "} non esistente");
                            continue;
                        }
                        path = path.replace("${" + nameSystemProperty + "}", valueSystemProperty);
                    }
                }
                String msg = "carico registro " + (String)nomeRegistro + " di tipo[" + registro.getTipo() + "]   location[" + path + "]";
                this.log.info(msg);
                if (alogConsole != null) {
                    alogConsole.info(msg);
                }
                if (CostantiConfigurazione.REGISTRO_XML.equals((Object)registro.getTipo())) {
                    driver = new DriverRegistroServiziXML(path, this.log);
                    if (driver.create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, (IDriverRegistroServiziGet)driver);
                        this.registriXML.add(driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_UDDI.equals((Object)registro.getTipo())) {
                    driver = registro.getUser() != null && registro.getPassword() != null ? new DriverRegistroServiziUDDI(path, registro.getUser(), registro.getPassword(), this.log) : new DriverRegistroServiziUDDI(registro.getLocation(), this.log);
                    if (((DriverRegistroServiziUDDI)driver).create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, (IDriverRegistroServiziGet)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_WEB.equals((Object)registro.getTipo())) {
                    driver = new DriverRegistroServiziWEB(path, this.log);
                    if (((DriverRegistroServiziWEB)driver).create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, (IDriverRegistroServiziGet)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_DB.equals((Object)registro.getTipo())) {
                    driver = new DriverRegistroServiziDB(path, null, this.log, registro.getTipoDatabase(), useOp2UtilsDatasource, bindJMX);
                    this.mappingNomeRegistroToTipiDatabase.put((String)nomeRegistro, registro.getTipoDatabase());
                    this.mappingNomeRegistroToUseConnectionPdD.put((String)nomeRegistro, path.equals(jndiNameDatasourcePdD));
                    if (((DriverRegistroServiziDB)driver).create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, (IDriverRegistroServiziGet)driver);
                    } else {
                        msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                        this.log.error(msg);
                        if (alogConsole != null) {
                            alogConsole.info(msg);
                        }
                    }
                    if (!(driver instanceof IDriverBYOKConfig)) continue;
                    IDriverBYOKConfig c = (IDriverBYOKConfig)driver;
                    c.initialize(driverBYOK, false, true);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_WS.equals((Object)registro.getTipo())) {
                    try {
                        driver = DriverRegistroServiziWSInitUtilities.newInstance((String)registro.getLocation(), (String)registro.getUser(), (String)registro.getPassword(), (Logger)this.log);
                        this.driverRegistroServizi.put((String)nomeRegistro, (IDriverRegistroServiziGet)driver);
                    }
                    catch (Throwable e) {
                        msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                        this.log.error(msg);
                        if (alogConsole == null) continue;
                        alogConsole.info(msg);
                    }
                    continue;
                }
                msg = "Riscontrato errore durante l'inizializzazione del registro di tipo sconosciuto " + registro.getTipo() + " con location: " + registro.getLocation();
                this.log.error(msg);
                if (alogConsole == null) continue;
                alogConsole.info(msg);
            }
            if (accessoRegistro.getCache() != null) {
                this.initCacheRegistriServizi(cacheType, accessoRegistro.getCache(), alogConsole, prefillCache, cryptConfigSoggetti);
            }
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage();
            this.log.error(msg);
            if (alogConsole != null) {
                alogConsole.info(msg);
            }
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage());
        }
        if (this.driverRegistroServizi.size() == 0) {
            throw new DriverRegistroServiziException("Non e' stato possibile inizializzare nessuna sorgente di lettura per un Registro dei Servizi");
        }
    }

    public RegistroServizi(IDriverRegistroServiziGet driverRegistroServiziGET, Logger alog, boolean readObjectStatoBozza, String tipoRegistro) throws DriverRegistroServiziException {
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(RegistroServizi.class);
        if (this.log == null) {
            throw new UtilsRuntimeException("Logger unavailable");
        }
        try {
            this.driverRegistroServizi = new HashMap<String, IDriverRegistroServiziGet>();
            this.registriXML = new ArrayList<DriverRegistroServiziXML>();
            this.raggiungibilitaTotale = true;
            this.readObjectStatoBozza = readObjectStatoBozza;
            IDriverRegistroServiziGet driver = driverRegistroServiziGET;
            String nomeRegistro = "Registro_" + tipoRegistro;
            this.mappingNomeRegistroToTipiDatabase.put(nomeRegistro, tipoRegistro);
            this.mappingNomeRegistroToUseConnectionPdD.put(nomeRegistro, false);
            this.driverRegistroServizi.put(nomeRegistro, driver);
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage();
            this.log.error(msg);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage());
        }
        if (this.driverRegistroServizi.size() == 0) {
            throw new DriverRegistroServiziException("Non e' stato possibile inizializzare nessuna sorgente di lettura per un Registro dei Servizi");
        }
    }

    private void initCacheRegistriServizi(CacheType cacheType, Cache configurazioneCache, Logger alogConsole, boolean prefillCache, CryptConfig cryptConfigSoggetti) throws Exception {
        block45: {
            String msg;
            this.cache = new org.openspcoop2.utils.cache.Cache(cacheType, "registroServizi");
            if (configurazioneCache.getDimensione() != null || configurazioneCache.getAlgoritmo() != null) {
                block43: {
                    try {
                        int dimensione;
                        if (configurazioneCache.getDimensione() != null) {
                            dimensione = -1;
                            dimensione = prefillCache ? Integer.MAX_VALUE : Integer.parseInt(configurazioneCache.getDimensione());
                            msg = "Dimensione della cache (RegistroServizi) impostata al valore: " + dimensione;
                            if (prefillCache) {
                                msg = "[Prefill Enabled] " + (String)msg;
                            }
                            if (prefillCache) {
                                this.log.warn(msg);
                            } else {
                                this.log.info(msg);
                            }
                            if (alogConsole != null) {
                                if (prefillCache) {
                                    alogConsole.warn(msg);
                                } else {
                                    alogConsole.info(msg);
                                }
                            }
                            this.cache.setCacheSize(dimensione);
                        } else if (prefillCache) {
                            dimensione = Integer.MAX_VALUE;
                            msg = "[Prefill Enabled] Dimensione della cache (RegistroServizi) impostata al valore: " + dimensione;
                            this.log.warn(msg);
                            if (alogConsole != null) {
                                alogConsole.warn(msg);
                            }
                            this.cache.setCacheSize(dimensione);
                        }
                    }
                    catch (Exception error) {
                        msg = "Parametro errato per la dimensione della cache (RegistroServizi): " + error.getMessage();
                        this.log.error(msg);
                        if (alogConsole == null) break block43;
                        alogConsole.info(msg);
                    }
                }
                if (configurazioneCache.getAlgoritmo() != null) {
                    String msg2 = "Algoritmo di cache (RegistroServizi) impostato al valore: " + configurazioneCache.getAlgoritmo();
                    this.log.info(msg2);
                    if (alogConsole != null) {
                        alogConsole.info(msg2);
                    }
                    if (CostantiConfigurazione.CACHE_MRU.equals((Object)configurazioneCache.getAlgoritmo())) {
                        this.cache.setCacheAlgoritm(CacheAlgorithm.MRU);
                    } else {
                        this.cache.setCacheAlgoritm(CacheAlgorithm.LRU);
                    }
                }
            }
            if (configurazioneCache.getItemIdleTime() != null || configurazioneCache.getItemLifeSecond() != null) {
                block44: {
                    try {
                        if (configurazioneCache.getItemIdleTime() != null) {
                            int itemIdleTime = -1;
                            itemIdleTime = prefillCache ? -1 : Integer.parseInt(configurazioneCache.getItemIdleTime());
                            msg = "Attributo 'IdleTime' (RegistroServizi) impostato al valore: " + itemIdleTime;
                            if (prefillCache) {
                                msg = "[Prefill Enabled] " + msg;
                            }
                            if (prefillCache) {
                                this.log.warn(msg);
                            } else {
                                this.log.info(msg);
                            }
                            if (alogConsole != null) {
                                if (prefillCache) {
                                    alogConsole.warn(msg);
                                } else {
                                    alogConsole.info(msg);
                                }
                            }
                            this.cache.setItemIdleTime((long)itemIdleTime);
                        } else if (prefillCache) {
                            int itemIdleTime = -1;
                            msg = "[Prefill Enabled] Attributo 'IdleTime' (RegistroServizi) impostato al valore: " + itemIdleTime;
                            this.log.warn(msg);
                            if (alogConsole != null) {
                                alogConsole.warn(msg);
                            }
                            this.cache.setItemIdleTime((long)itemIdleTime);
                        }
                    }
                    catch (Exception error) {
                        msg = "Parametro errato per l'attributo 'IdleTime' (RegistroServizi): " + error.getMessage();
                        this.log.error(msg);
                        if (alogConsole == null) break block44;
                        alogConsole.info(msg);
                    }
                }
                try {
                    if (configurazioneCache.getItemLifeSecond() != null) {
                        int itemLifeSecond = -1;
                        itemLifeSecond = prefillCache ? -1 : Integer.parseInt(configurazioneCache.getItemLifeSecond());
                        msg = "Attributo 'MaxLifeSecond' (RegistroServizi) impostato al valore: " + itemLifeSecond;
                        if (prefillCache) {
                            msg = "[Prefill Enabled] " + msg;
                        }
                        if (prefillCache) {
                            this.log.warn(msg);
                        } else {
                            this.log.info(msg);
                        }
                        if (alogConsole != null) {
                            if (prefillCache) {
                                alogConsole.warn(msg);
                            } else {
                                alogConsole.info(msg);
                            }
                        }
                        this.cache.setItemLifeTime((long)itemLifeSecond);
                    } else if (prefillCache) {
                        int itemLifeSecond = -1;
                        msg = "Attributo 'MaxLifeSecond' (RegistroServizi) impostato al valore: " + itemLifeSecond;
                        this.log.warn(msg);
                        if (alogConsole != null) {
                            alogConsole.warn(msg);
                        }
                        this.cache.setItemLifeTime((long)itemLifeSecond);
                    }
                }
                catch (Exception error) {
                    msg = "Parametro errato per l'attributo 'MaxLifeSecond' (RegistroServizi): " + error.getMessage();
                    this.log.error(msg);
                    if (alogConsole == null) break block45;
                    alogConsole.info(msg);
                }
            }
        }
        this.cache.build();
        if (prefillCache) {
            this.prefillCache(null, alogConsole, cryptConfigSoggetti);
        }
    }

    @Deprecated
    public void disableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        this.cache.disableSyncronizedGet();
    }

    @Deprecated
    public boolean isDisableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return this.cache.isDisableSyncronizedGet();
    }

    protected Map<String, IDriverRegistroServiziGet> getDriverRegistroServizi() {
        return this.driverRegistroServizi;
    }

    public void prefillCache(Connection connectionPdD, Logger alogConsole, CryptConfig cryptConfigSoggetti) {
        Object msg = "[Prefill] Inizializzazione cache (RegistroServizi) in corso ...";
        this.log.info((String)msg);
        if (alogConsole != null) {
            alogConsole.info((String)msg);
        }
        Set<String> registri = this.driverRegistroServizi.keySet();
        for (String nomeRegistro : registri) {
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "]";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero accordi di servizio parte comune ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaAccordi filtroAccordi = new FiltroRicercaAccordi();
            List listAccordi = null;
            try {
                listAccordi = this.driverRegistroServizi.get(nomeRegistro).getAllIdAccordiServizioParteComune(filtroAccordi);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listAccordi != null ? listAccordi.size() : 0) + " accordi di servizio parte comune";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listAccordi != null && listAccordi.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordi.size() + " accordi di servizio parte comune ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDAccordo idAccordo : listAccordi) {
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte comune [" + idAccordo + "] ...";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    try {
                        this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteComune(this.idAccordoFactory, idAccordo, null, null));
                        this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    AccordoServizioParteComune as = null;
                    try {
                        this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteComune(this.idAccordoFactory, idAccordo, true, true));
                        as = this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, true, true);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    boolean serviziCorrelati = false;
                    if (as != null) {
                        ProfiloCollaborazione profiloAS = as.getProfiloCollaborazione();
                        for (Azione az : as.getAzioneList()) {
                            ProfiloCollaborazione profiloAZ = profiloAS;
                            if ("ridefinito".equals(az.getProfAzione())) {
                                profiloAZ = az.getProfiloCollaborazione();
                            }
                            if (!ProfiloCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)profiloAZ) && !ProfiloCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)profiloAZ)) continue;
                            serviziCorrelati = true;
                            break;
                        }
                        if (!serviziCorrelati) {
                            for (PortType pt : as.getPortTypeList()) {
                                ProfiloCollaborazione profiloPT = profiloAS;
                                if ("ridefinito".equals(pt.getProfiloPT())) {
                                    profiloPT = pt.getProfiloCollaborazione();
                                }
                                for (Operation az : pt.getAzioneList()) {
                                    ProfiloCollaborazione profiloAZ = profiloPT;
                                    if ("ridefinito".equals(az.getProfAzione())) {
                                        profiloAZ = az.getProfiloCollaborazione();
                                    }
                                    if (!ProfiloCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)profiloAZ) && !ProfiloCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)profiloAZ)) continue;
                                    serviziCorrelati = true;
                                    break;
                                }
                                if (!serviziCorrelati) continue;
                                break;
                            }
                        }
                    }
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte comune [" + idAccordo + "] completato";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    if (!serviziCorrelati) continue;
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], (analisi profilo asincrono) recupero servizi che implementano l'accordo di servizio parte comune [" + idAccordo + "] ...";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    FiltroRicercaServizi filtroServizi = new FiltroRicercaServizi();
                    filtroServizi.setIdAccordoServizioParteComune(idAccordo);
                    List listServizi = null;
                    try {
                        listServizi = this.driverRegistroServizi.get(nomeRegistro).getAllIdServizi(filtroServizi);
                    }
                    catch (DriverRegistroServiziNotFound pt) {
                    }
                    catch (DriverRegistroServiziException e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], (analisi profilo asincrono) recuperati " + (listServizi != null ? listServizi.size() : 0) + " servizi che implementano l'accordo di servizio parte comune [" + idAccordo + "]";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    if (listServizi == null || listServizi.size() <= 0) continue;
                    for (IDServizio idServizio : listServizi) {
                        IDSoggetto idSoggetto = idServizio.getSoggettoErogatore();
                        if (org.openspcoop2.core.constants.TipologiaServizio.CORRELATO.equals((Object)idServizio.getTipologia())) {
                            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati asincroni per l'accordo di servizio parte comune [" + idAccordo + "] e soggetto [" + idSoggetto + "] ...";
                            this.log.debug((String)msg);
                            if (alogConsole != null) {
                                alogConsole.debug((String)msg);
                            }
                            try {
                                this.cache.remove(this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordo, null));
                                this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo);
                            }
                            catch (DriverRegistroServiziNotFound az) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            try {
                                this.cache.remove(this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordo, false));
                                this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo, false);
                            }
                            catch (DriverRegistroServiziNotFound e) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            try {
                                this.cache.remove(this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordo, true));
                                this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo, true);
                            }
                            catch (DriverRegistroServiziNotFound e) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati asincroni per l'accordo di servizio parte comune [" + idAccordo + "] e soggetto [" + idSoggetto + "] completato";
                            this.log.debug((String)msg);
                            if (alogConsole == null) continue;
                            alogConsole.debug((String)msg);
                            continue;
                        }
                        msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati asincroni per l'accordo di servizio parte comune [" + idAccordo + "] e soggetto [" + idSoggetto + "] non effettuata essendo il servizio non di tipologia correlata";
                        this.log.debug((String)msg);
                        if (alogConsole == null) continue;
                        alogConsole.debug((String)msg);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordi.size() + " accordi di servizio parte comune completato";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero porte di dominio ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicerca filtroPdd = new FiltroRicerca();
            List listPdd = null;
            try {
                listPdd = this.driverRegistroServizi.get(nomeRegistro).getAllIdPorteDominio(filtroPdd);
            }
            catch (DriverRegistroServiziNotFound as) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperate " + (listPdd != null ? listPdd.size() : 0) + " porte di dominio";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listPdd != null && listPdd.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listPdd.size() + " porte di dominio ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (String idPdd : listPdd) {
                    try {
                        this.cache.remove(RegistroServizi._getKey_getPortaDominio(idPdd));
                        this.getPortaDominio(connectionPdD, nomeRegistro, idPdd);
                    }
                    catch (DriverRegistroServiziNotFound filtroServizi) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listPdd.size() + " porte di dominio completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero ruoli ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            List listRuoli = null;
            try {
                listRuoli = this.driverRegistroServizi.get(nomeRegistro).getAllIdRuoli(filtroRuoli);
            }
            catch (DriverRegistroServiziNotFound e) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listRuoli != null ? listRuoli.size() : 0) + " ruoli";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listRuoli != null && listRuoli.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listRuoli.size() + " ruoli ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDRuolo idRuolo : listRuoli) {
                    try {
                        this.cache.remove(RegistroServizi._getKey_getRuolo(idRuolo.getNome()));
                        this.getRuolo(connectionPdD, nomeRegistro, idRuolo.getNome());
                    }
                    catch (DriverRegistroServiziNotFound e) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listRuoli.size() + " ruoli completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero scope ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaScope filtroScope = new FiltroRicercaScope();
            List listScope = null;
            try {
                listScope = this.driverRegistroServizi.get(nomeRegistro).getAllIdScope(filtroScope);
            }
            catch (DriverRegistroServiziNotFound e) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listScope != null ? listScope.size() : 0) + " scope";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listScope != null && listScope.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listScope.size() + " scope ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDScope idScope : listScope) {
                    try {
                        this.cache.remove(RegistroServizi._getKey_getScope(idScope.getNome()));
                        this.getScope(connectionPdD, nomeRegistro, idScope.getNome());
                    }
                    catch (DriverRegistroServiziNotFound idSoggetto) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listScope.size() + " scope completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero soggetti ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            List listSoggetti = null;
            try {
                listSoggetti = this.driverRegistroServizi.get(nomeRegistro).getAllIdSoggetti(filtroSoggetti);
            }
            catch (DriverRegistroServiziNotFound e) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listSoggetti != null ? listSoggetti.size() : 0) + " soggetti";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listSoggetti != null && listSoggetti.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listSoggetti.size() + " soggetti ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDSoggetto idSoggetto : listSoggetti) {
                    try {
                        this.cache.remove(RegistroServizi._getKey_getSoggetto(idSoggetto));
                        this.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
                    }
                    catch (DriverRegistroServiziNotFound profiloAZ) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    Soggetto soggetto = null;
                    try {
                        soggetto = this.driverRegistroServizi.get(nomeRegistro).getSoggetto(idSoggetto);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    }
                    catch (DriverRegistroServiziException e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    if (soggetto == null || soggetto.sizeCredenzialiList() <= 0) continue;
                    for (CredenzialiSoggetto credenziale : soggetto.getCredenzialiList()) {
                        if (credenziale == null || credenziale.getTipo() == null) continue;
                        if (CredenzialeTipo.BASIC.equals((Object)credenziale.getTipo())) {
                            try {
                                this.cache.remove(this._getKey_getSoggettoByCredenzialiBasic(credenziale.getUser(), credenziale.getPassword()));
                                this.getSoggettoByCredenzialiBasic(connectionPdD, nomeRegistro, credenziale.getUser(), credenziale.getPassword(), cryptConfigSoggetti);
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        if (CredenzialeTipo.APIKEY.equals((Object)credenziale.getTipo())) {
                            try {
                                this.cache.remove(this._getKey_getSoggettoByCredenzialiApiKey(credenziale.getUser(), credenziale.getPassword(), credenziale.isCertificateStrictVerification()));
                                this.getSoggettoByCredenzialiApiKey(connectionPdD, nomeRegistro, credenziale.getUser(), credenziale.getPassword(), credenziale.isCertificateStrictVerification(), cryptConfigSoggetti);
                            }
                            catch (DriverRegistroServiziNotFound e) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        if (CredenzialeTipo.SSL.equals((Object)credenziale.getTipo())) {
                            if (credenziale.getSubject() != null) {
                                try {
                                    this.cache.remove(this._getKey_getSoggettoByCredenzialiSsl(credenziale.getSubject(), credenziale.getIssuer()));
                                    this.getSoggettoByCredenzialiSsl(connectionPdD, nomeRegistro, credenziale.getSubject(), credenziale.getIssuer());
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (credenziale.getCertificate() == null) continue;
                            try {
                                CertificateInfo certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])credenziale.getCertificate(), (int)0, null).getCertificate();
                                this.cache.remove(this._getKey_getSoggettoByCredenzialiSsl(certificato, credenziale.isCertificateStrictVerification()));
                                this.getSoggettoByCredenzialiSsl(connectionPdD, nomeRegistro, certificato, credenziale.isCertificateStrictVerification());
                            }
                            catch (DriverRegistroServiziNotFound certificato) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        if (!CredenzialeTipo.PRINCIPAL.equals((Object)credenziale.getTipo())) continue;
                        try {
                            this.cache.remove(this._getKey_getSoggettoByCredenzialiPrincipal(credenziale.getUser()));
                            this.getSoggettoByCredenzialiPrincipal(connectionPdD, nomeRegistro, credenziale.getUser());
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listSoggetti.size() + " soggetti completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero servizi ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaServizi filtroServizi = new FiltroRicercaServizi();
            List listServizi = null;
            try {
                listServizi = this.driverRegistroServizi.get(nomeRegistro).getAllIdServizi(filtroServizi);
            }
            catch (DriverRegistroServiziNotFound soggetto) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listServizi != null ? listServizi.size() : 0) + " servizi";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listServizi != null && listServizi.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listServizi.size() + " servizi ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDServizio idServizio : listServizi) {
                    block180: {
                        msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte specifica [" + idServizio + "] ...";
                        this.log.debug((String)msg);
                        if (alogConsole != null) {
                            alogConsole.debug((String)msg);
                        }
                        try {
                            this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, null));
                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
                        }
                        catch (DriverRegistroServiziNotFound credenziale) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        try {
                            this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, false));
                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, false);
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        try {
                            this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, true));
                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, true);
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        AccordoServizioParteSpecifica asps = null;
                        try {
                            asps = this.driverRegistroServizi.get(nomeRegistro).getAccordoServizioParteSpecifica(idServizio);
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (DriverRegistroServiziException e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        try {
                            IDAccordo idAPC;
                            AccordoServizioParteComune apc;
                            if (asps == null || asps.getAccordoServizioParteComune() == null || (apc = this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAPC = this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()))) == null) break block180;
                            if (asps.getPortType() != null && !"".equals(asps.getPortType())) {
                                if (apc.sizePortTypeList() <= 0) break block180;
                                for (PortType pt : apc.getPortTypeList()) {
                                    if (!pt.getNome().equals(asps.getPortType()) || pt.sizeAzioneList() <= 0) continue;
                                    for (Operation azione : pt.getAzioneList()) {
                                        idServizio.setAzione(azione.getNome());
                                        try {
                                            this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, null));
                                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
                                        }
                                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                        }
                                        catch (Exception e) {
                                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                        }
                                        try {
                                            this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, false));
                                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, false);
                                        }
                                        catch (DriverRegistroServiziNotFound e) {
                                        }
                                        catch (Exception e) {
                                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                        }
                                        try {
                                            this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, true));
                                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, true);
                                        }
                                        catch (DriverRegistroServiziNotFound e) {
                                        }
                                        catch (Exception e) {
                                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                                break block180;
                            }
                            if (apc.sizeAzioneList() <= 0) break block180;
                            for (Azione azione : apc.getAzioneList()) {
                                idServizio.setAzione(azione.getNome());
                                try {
                                    this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, null));
                                    this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
                                }
                                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                                try {
                                    this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, false));
                                    this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, false);
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                                try {
                                    this.cache.remove(RegistroServizi._getKey_getAccordoServizioParteSpecifica(idServizio, true));
                                    this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, true);
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        catch (DriverRegistroServiziNotFound idAPC) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                    }
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte specifica [" + idServizio + "] completata";
                    this.log.debug((String)msg);
                    if (alogConsole == null) continue;
                    alogConsole.debug((String)msg);
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listServizi.size() + " servizi completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero accordi di cooperazione ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaAccordi filtroAccordiCooperazione = new FiltroRicercaAccordi();
            List listAccordiCooperazione = null;
            try {
                listAccordiCooperazione = this.driverRegistroServizi.get(nomeRegistro).getAllIdAccordiCooperazione(filtroAccordiCooperazione);
            }
            catch (DriverRegistroServiziNotFound asps) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listAccordiCooperazione != null ? listAccordiCooperazione.size() : 0) + " accordi di cooperazione";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listAccordiCooperazione == null || listAccordiCooperazione.size() <= 0) continue;
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordiCooperazione.size() + " accordi di cooperazione ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            for (IDAccordoCooperazione idAccordoCooperazione : listAccordiCooperazione) {
                try {
                    this.cache.remove(RegistroServizi._getKey_getAccordoCooperazione(this.idAccordoCooperazioneFactory, idAccordoCooperazione, null));
                    this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione);
                }
                catch (DriverRegistroServiziNotFound apc) {
                }
                catch (Exception e) {
                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                }
                try {
                    this.cache.remove(RegistroServizi._getKey_getAccordoCooperazione(this.idAccordoCooperazioneFactory, idAccordoCooperazione, false));
                    this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione, false);
                }
                catch (DriverRegistroServiziNotFound e) {
                }
                catch (Exception e) {
                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                }
                try {
                    this.cache.remove(RegistroServizi._getKey_getAccordoCooperazione(this.idAccordoCooperazioneFactory, idAccordoCooperazione, true));
                    this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione, true);
                }
                catch (DriverRegistroServiziNotFound e) {
                }
                catch (Exception e) {
                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordiCooperazione.size() + " accordi di cooperazione completata";
            this.log.debug((String)msg);
            if (alogConsole == null) continue;
            alogConsole.debug((String)msg);
        }
        msg = "[Prefill] Inizializzazione cache (RegistroServizi) completata";
        this.log.info((String)msg);
        if (alogConsole != null) {
            alogConsole.info((String)msg);
        }
    }

    public Object getObjectCache(String keyCache, String methodName, String nomeRegistro, Boolean readContenutoAllegati, Connection connectionPdD, Object ... instances) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Class[] classArgoments = null;
        Object[] values = null;
        if (instances != null && instances.length > 0) {
            classArgoments = new Class[instances.length];
            values = new Object[instances.length];
            for (int i = 0; i < instances.length; ++i) {
                classArgoments[i] = "getAccordoServizioParteComune".equals(methodName) && i == 1 ? Boolean.TYPE : instances[i].getClass();
                values[i] = instances[i];
            }
        }
        return this.getObjectCache(keyCache, methodName, nomeRegistro, readContenutoAllegati, connectionPdD, classArgoments, values);
    }

    public Object getObjectCache(String keyCache, String methodName, String nomeRegistro, Boolean readContenutoAllegati, Connection connectionPdD, Class<?>[] classArgoments, Object[] values) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SemaphoreLock lock = semaphore_getObjectCache.acquireThrowRuntime("getObjectCache");
        DriverRegistroServiziNotFound dNotFound = null;
        Object obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[" + methodName + "]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:" + methodName + ") nel registro[" + nomeRegistro + "] in cache.");
                    Serializable serializable = response.getObject();
                    return serializable;
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:" + methodName + ") nel registro[" + nomeRegistro + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug("oggetto con chiave [" + keyCache + "] (method:" + methodName + ") nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro...");
            try {
                obj = this.getObject(methodName, nomeRegistro, readContenutoAllegati, connectionPdD, classArgoments, values);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info("Aggiungo eccezione [" + keyCache + "] in cache");
                } else if (obj != null) {
                    this.log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                } else {
                    throw new Exception("Metodo (" + methodName + ") nel registro[" + nomeRegistro + "] ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (notFoundClassName.equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)((Object)e);
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        finally {
            semaphore_getObjectCache.release(lock, "getObjectCache");
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    public Object getObject(String methodName, String nomeRegistro, Boolean readContenutoAllegati, Connection connectionPdD, Object ... instances) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Class[] classArgoments = null;
        Object[] values = null;
        if (instances != null && instances.length > 0) {
            classArgoments = new Class[instances.length];
            values = new Object[instances.length];
            for (int i = 0; i < instances.length; ++i) {
                classArgoments[i] = "getAccordoServizioParteComune".equals(methodName) && i == 1 ? Boolean.TYPE : instances[i].getClass();
                values[i] = instances[i];
            }
        }
        return this.getObject(methodName, nomeRegistro, readContenutoAllegati, connectionPdD, classArgoments, values);
    }

    public Object getObject(String methodName, String nomeRegistro, Boolean readContenutoAllegati, Connection connectionPdD, Class<?>[] classArgoments, Object[] values) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Object obj = null;
        if (nomeRegistro != null) {
            this.log.debug("Cerco nel registro [" + nomeRegistro + "]");
            try {
                Method method;
                IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegistro);
                this.log.debug("invocazione metodo [" + methodName + "]...");
                if (classArgoments == null || classArgoments.length == 0) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, Boolean.TYPE);
                        obj = method.invoke((Object)driver, readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, new Class[0]);
                        obj = method.invoke((Object)driver, new Object[0]);
                    }
                } else if (classArgoments.length == 1) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], Boolean.TYPE);
                        obj = method.invoke((Object)driver, values[0], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, classArgoments[0]);
                        obj = method.invoke((Object)driver, values[0]);
                    }
                } else if (classArgoments.length == 2) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        if ("getAccordoServizioParteComune".equals(methodName)) {
                            method = driver.getClass().getMethod(methodName, classArgoments[0], Boolean.TYPE, classArgoments[1]);
                            obj = method.invoke((Object)driver, values[0], readContenutoAllegati, values[1]);
                        } else {
                            method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], Boolean.TYPE);
                            obj = method.invoke((Object)driver, values[0], values[1], readContenutoAllegati);
                        }
                    } else if ("getAccordoServizioParteComune".equals(methodName)) {
                        method = driver.getClass().getMethod(methodName, classArgoments[0]);
                        obj = method.invoke((Object)driver, values[0]);
                    } else {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1]);
                        obj = method.invoke((Object)driver, values[0], values[1]);
                    }
                } else if (classArgoments.length == 3) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], classArgoments[2], Boolean.TYPE);
                        obj = method.invoke((Object)driver, values[0], values[1], values[2], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], classArgoments[2]);
                        obj = method.invoke((Object)driver, values[0], values[1], values[2]);
                    }
                } else if (classArgoments.length == 4) {
                    Class<Object> cArg2 = classArgoments[2];
                    if ("getSoggettoByCredenzialiApiKey".equals(methodName)) {
                        cArg2 = Boolean.TYPE;
                    }
                    Method method2 = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method2 = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], cArg2, classArgoments[3], Boolean.TYPE);
                        obj = method2.invoke((Object)driver, values[0], values[1], values[2], values[3], readContenutoAllegati);
                    } else {
                        method2 = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], cArg2, classArgoments[3]);
                        obj = method2.invoke((Object)driver, values[0], values[1], values[2], values[3]);
                    }
                } else {
                    throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
                }
                if (!this.readObjectStatoBozza && driver instanceof DriverRegistroServiziDB) {
                    if (obj instanceof AccordoCooperazione) {
                        AccordoCooperazione ac = (AccordoCooperazione)obj;
                        if (StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteComune) {
                        AccordoServizioParteComune as = (AccordoServizioParteComune)obj;
                        if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteSpecifica) {
                        AccordoServizioParteSpecifica s = (AccordoServizioParteSpecifica)obj;
                        if (StatiAccordo.bozza.toString().equals(s.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                        ArrayList<Fruitore> fruitoriConStatoNonBozza = new ArrayList<Fruitore>();
                        while (s.sizeFruitoreList() > 0) {
                            Fruitore tmpF = s.removeFruitore(0);
                            if (StatiAccordo.bozza.toString().equals(tmpF.getStatoPackage())) continue;
                            fruitoriConStatoNonBozza.add(tmpF);
                        }
                        while (fruitoriConStatoNonBozza.size() > 0) {
                            s.addFruitore((Fruitore)fruitoriConStatoNonBozza.remove(0));
                        }
                    }
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug("Ricerca nel registro non riuscita (metodo [" + methodName + "]): " + e.getMessage());
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (notFoundClassName.equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage());
                        throw new DriverRegistroServiziNotFound(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    if (excClassName.equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage(), e.getTargetException());
                        throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage(), e.getTargetException());
                    throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                }
                this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita, " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            this.log.debug("invocazione metodo [" + methodName + "] completata.");
            return obj;
        }
        this.log.debug("Cerco nella mia gerarchia di registri");
        StringBuilder notFoundProblem = new StringBuilder();
        StringBuilder exceptionProblem = new StringBuilder();
        boolean find = false;
        for (String nomeRegInLista : this.driverRegistroServizi.keySet()) {
            this.log.debug("Cerco nel registro con nome[" + nomeRegInLista + "]");
            try {
                Method method;
                IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegInLista);
                this.log.debug("invocazione metodo [" + methodName + "] nel registro[" + nomeRegInLista + "]...");
                if (classArgoments == null || classArgoments.length == 0) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, Boolean.TYPE);
                        obj = method.invoke((Object)driver, readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, new Class[0]);
                        obj = method.invoke((Object)driver, new Object[0]);
                    }
                    find = true;
                } else if (classArgoments.length == 1) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], Boolean.TYPE);
                        obj = method.invoke((Object)driver, values[0], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, classArgoments[0]);
                        obj = method.invoke((Object)driver, values[0]);
                    }
                    find = true;
                } else if (classArgoments.length == 2) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        if ("getAccordoServizioParteComune".equals(methodName)) {
                            method = driver.getClass().getMethod(methodName, classArgoments[0], Boolean.TYPE, classArgoments[1]);
                            obj = method.invoke((Object)driver, values[0], readContenutoAllegati, values[1]);
                        } else {
                            method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], Boolean.TYPE);
                            obj = method.invoke((Object)driver, values[0], values[1], readContenutoAllegati);
                        }
                    } else if ("getAccordoServizioParteComune".equals(methodName)) {
                        method = driver.getClass().getMethod(methodName, classArgoments[0]);
                        obj = method.invoke((Object)driver, values[0]);
                    } else {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1]);
                        obj = method.invoke((Object)driver, values[0], values[1]);
                    }
                    find = true;
                } else if (classArgoments.length == 3) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], classArgoments[2], Boolean.TYPE);
                        obj = method.invoke((Object)driver, values[0], values[1], values[2], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], classArgoments[2]);
                        obj = method.invoke((Object)driver, values[0], values[1], values[2]);
                    }
                    find = true;
                } else if (classArgoments.length == 4) {
                    Class<Object> cArg2 = classArgoments[2];
                    if ("getSoggettoByCredenzialiApiKey".equals(methodName)) {
                        cArg2 = Boolean.TYPE;
                    }
                    Method method3 = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method3 = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], cArg2, classArgoments[3], Boolean.TYPE);
                        obj = method3.invoke((Object)driver, values[0], values[1], values[2], values[3], readContenutoAllegati);
                    } else {
                        method3 = driver.getClass().getMethod(methodName, classArgoments[0], classArgoments[1], cArg2, classArgoments[3]);
                        obj = method3.invoke((Object)driver, values[0], values[1], values[2], values[3]);
                    }
                    find = true;
                } else {
                    throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
                }
                if (!this.readObjectStatoBozza && driver instanceof DriverRegistroServiziDB) {
                    if (obj instanceof AccordoCooperazione) {
                        AccordoCooperazione ac = (AccordoCooperazione)obj;
                        if (StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteComune) {
                        AccordoServizioParteComune as = (AccordoServizioParteComune)obj;
                        if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteSpecifica) {
                        AccordoServizioParteSpecifica s = (AccordoServizioParteSpecifica)obj;
                        if (StatiAccordo.bozza.toString().equals(s.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                        ArrayList<Fruitore> fruitoriConStatoNonBozza = new ArrayList<Fruitore>();
                        while (s.sizeFruitoreList() > 0) {
                            Fruitore tmpF = s.removeFruitore(0);
                            if (StatiAccordo.bozza.toString().equals(tmpF.getStatoPackage())) continue;
                            fruitoriConStatoNonBozza.add(tmpF);
                        }
                        while (fruitoriConStatoNonBozza.size() > 0) {
                            s.addFruitore((Fruitore)fruitoriConStatoNonBozza.remove(0));
                        }
                    }
                }
            }
            catch (DriverRegistroServiziNotFound ed) {
                this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita (metodo [" + methodName + "]): " + ed.getMessage());
                notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + ed.getMessage());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (notFoundClassName.equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage());
                        notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + e.getTargetException().getMessage());
                    } else if (excClassName.equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage(), e.getTargetException());
                        if (this.raggiungibilitaTotale) {
                            throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                        }
                        exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getTargetException().getMessage());
                    } else {
                        this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage(), e.getTargetException());
                        if (this.raggiungibilitaTotale) {
                            throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                        }
                        exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getTargetException().getMessage());
                    }
                } else {
                    this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage(), (Throwable)e);
                    if (this.raggiungibilitaTotale) {
                        throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                    }
                    exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita, " + e.getMessage(), (Throwable)e);
                if (this.raggiungibilitaTotale) {
                    throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                }
                exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
            }
            if (!find) continue;
            break;
        }
        this.log.debug("invocazione metodo [" + methodName + "] completata.");
        if (find) {
            return obj;
        }
        if (exceptionProblem.length() > 0 && notFoundProblem.length() > 0) {
            throw new DriverRegistroServiziException("[" + methodName + "]:" + exceptionProblem.toString() + notFoundProblem.toString());
        }
        if (exceptionProblem.length() > 0) {
            throw new DriverRegistroServiziException("[" + methodName + "]:" + exceptionProblem.toString());
        }
        if (notFoundProblem.length() > 0) {
            throw new DriverRegistroServiziNotFound("[" + methodName + "]:" + notFoundProblem.toString());
        }
        throw new DriverRegistroServiziException("[" + methodName + "]: ricerca non riuscita in tutti i registri");
    }

    private IDriverRegistroServiziGet getDriver(Connection connectionPdD, String nomeRegistro) throws DriverRegistroServiziException {
        IDriverRegistroServiziGet driver = this.driverRegistroServizi.get(nomeRegistro);
        if (driver instanceof DriverRegistroServiziDB) {
            Boolean useConnectionPdD = this.mappingNomeRegistroToUseConnectionPdD.get(nomeRegistro);
            if (connectionPdD != null && useConnectionPdD.booleanValue()) {
                driver = new DriverRegistroServiziDB(connectionPdD, this.log, this.mappingNomeRegistroToTipiDatabase.get(nomeRegistro));
                if (!((DriverRegistroServiziDB)driver).create) {
                    throw new DriverRegistroServiziException("Inizializzazione DriverRegistroServizi(" + nomeRegistro + ") con connessione PdD non riuscita");
                }
            }
        }
        return driver;
    }

    protected static String _getKey_getAccordoServizioParteComune(IDAccordoFactory idAccordoFactory, IDAccordo idAccordo, Boolean readContenutiAllegati, Boolean readDatiRegistro) throws DriverRegistroServiziException {
        String uriAccordoServizio = idAccordoFactory.getUriFromIDAccordo(idAccordo);
        String key = "getAccordoServizio_" + uriAccordoServizio;
        if (readContenutiAllegati != null && readContenutiAllegati.booleanValue()) {
            key = key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        if (readDatiRegistro != null && readDatiRegistro.booleanValue()) {
            key = key + "_READ-DATI-REGISTRO(" + readDatiRegistro + ")";
        }
        return key;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(Connection connectionPdD, String nomeRegistro, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, null, null);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(Connection connectionPdD, String nomeRegistro, IDAccordo idAccordo, Boolean readContenutiAllegati, Boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune]: Parametro non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune]: Nome accordo di servizio non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getAccordoServizioParteComune(this.idAccordoFactory, idAccordo, readContenutiAllegati, readDatiRegistro))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoServizioParteComune)response.getObject();
        }
        AccordoServizioParteComune as = null;
        as = this.cache != null ? (readDatiRegistro != null ? (AccordoServizioParteComune)this.getObjectCache(key, "getAccordoServizioParteComune", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo, readDatiRegistro) : (AccordoServizioParteComune)this.getObjectCache(key, "getAccordoServizioParteComune", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo)) : (readDatiRegistro != null ? (AccordoServizioParteComune)this.getObject("getAccordoServizioParteComune", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo, readDatiRegistro) : (AccordoServizioParteComune)this.getObject("getAccordoServizioParteComune", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo));
        if (as != null) {
            return as;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio [" + idAccordo + "] non trovato");
    }

    protected static String _getKey_getPortaDominio(String nomePdD) throws DriverRegistroServiziException {
        return "getPortaDominio_" + nomePdD;
    }

    public PortaDominio getPortaDominio(Connection connectionPdD, String nomeRegistro, String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getPortaDominio(nomePdD))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (PortaDominio)response.getObject();
        }
        PortaDominio pd = null;
        pd = this.cache != null ? (PortaDominio)this.getObjectCache(key, "getPortaDominio", nomeRegistro, null, connectionPdD, nomePdD) : (PortaDominio)this.getObject("getPortaDominio", nomeRegistro, null, connectionPdD, nomePdD);
        if (pd != null) {
            return pd;
        }
        throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio [" + nomePdD + "] non Trovata");
    }

    protected static String _getKey_getGruppo(String nomeGruppo) throws DriverRegistroServiziException {
        return "getGruppo_" + nomeGruppo;
    }

    public Gruppo getGruppo(Connection connectionPdD, String nomeRegistro, String nomeGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomeGruppo == null) {
            throw new DriverRegistroServiziException("[getGruppo]: Parametro non definito");
        }
        IDGruppo idGruppo = new IDGruppo(nomeGruppo);
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getGruppo(nomeGruppo))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Gruppo)response.getObject();
        }
        Gruppo gruppo = null;
        gruppo = this.cache != null ? (Gruppo)this.getObjectCache(key, "getGruppo", nomeRegistro, null, connectionPdD, idGruppo) : (Gruppo)this.getObject("getGruppo", nomeRegistro, null, connectionPdD, idGruppo);
        if (gruppo != null) {
            return gruppo;
        }
        throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo [" + nomeGruppo + "] non trovato");
    }

    protected static String _getKey_getRuolo(String nomeRuolo) throws DriverRegistroServiziException {
        return "getRuolo_" + nomeRuolo;
    }

    public Ruolo getRuolo(Connection connectionPdD, String nomeRegistro, String nomeRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomeRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo]: Parametro non definito");
        }
        IDRuolo idRuolo = new IDRuolo(nomeRuolo);
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getRuolo(nomeRuolo))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Ruolo)response.getObject();
        }
        Ruolo ruolo = null;
        ruolo = this.cache != null ? (Ruolo)this.getObjectCache(key, "getRuolo", nomeRegistro, null, connectionPdD, idRuolo) : (Ruolo)this.getObject("getRuolo", nomeRegistro, null, connectionPdD, idRuolo);
        if (ruolo != null) {
            return ruolo;
        }
        throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo [" + nomeRuolo + "] non trovato");
    }

    protected static String _getKey_getScope(String nomeScope) throws DriverRegistroServiziException {
        return "getScope_" + nomeScope;
    }

    public Scope getScope(Connection connectionPdD, String nomeRegistro, String nomeScope) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomeScope == null) {
            throw new DriverRegistroServiziException("[getScope]: Parametro non definito");
        }
        IDScope idScope = new IDScope(nomeScope);
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getScope(nomeScope))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Scope)response.getObject();
        }
        Scope scope = null;
        scope = this.cache != null ? (Scope)this.getObjectCache(key, "getScope", nomeRegistro, null, connectionPdD, idScope) : (Scope)this.getObject("getScope", nomeRegistro, null, connectionPdD, idScope);
        if (scope != null) {
            return scope;
        }
        throw new DriverRegistroServiziNotFound("[getScope] Scope [" + nomeScope + "] non trovato");
    }

    protected static String _getKey_getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        return "getSoggetto_" + idSoggetto.getTipo() + "/" + idSoggetto.getNome();
    }

    public Soggetto getSoggetto(Connection connectionPdD, String nomeRegistro, IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipoSP = idSoggetto.getTipo();
        String codiceSP = idSoggetto.getNome();
        if (tipoSP == null || codiceSP == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getSoggetto(idSoggetto))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggetto", nomeRegistro, null, connectionPdD, idSoggetto) : (Soggetto)this.getObject("getSoggetto", nomeRegistro, null, connectionPdD, idSoggetto);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato");
    }

    protected static String _toKey_getSoggettoByCredenzialiBasicPrefix() {
        return "getSoggettoByCredenzialiBasic_";
    }

    private String _getKey_getSoggettoByCredenzialiBasic(String user, String password) throws DriverRegistroServiziException {
        return RegistroServizi._toKey_getSoggettoByCredenzialiBasicPrefix() + user + "_" + password;
    }

    public Soggetto getSoggettoByCredenzialiBasic(Connection connectionPdD, String nomeRegistro, String user, String password, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (user == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiBasic] Parametro user Non Valido");
        }
        if (password == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiBasic] Parametro password Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoByCredenzialiBasic(user, password))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoByCredenzialiBasic", nomeRegistro, null, connectionPdD, user, password, config) : (Soggetto)this.getObject("getSoggettoByCredenzialiBasic", nomeRegistro, null, connectionPdD, user, password, config);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoByCredenzialiBasic] Soggetto non Trovato");
    }

    protected static String _toKey_getSoggettoByCredenzialiApiKeyPrefix(boolean appId) {
        return appId ? "getSoggettoByCredenzialiMultipleApiKey_" : "getSoggettoByCredenzialiApiKey_";
    }

    private String _getKey_getSoggettoByCredenzialiApiKey(String user, String password, boolean appId) throws DriverRegistroServiziException {
        return RegistroServizi._toKey_getSoggettoByCredenzialiApiKeyPrefix(appId) + user + "_" + password;
    }

    public Soggetto getSoggettoByCredenzialiApiKey(Connection connectionPdD, String nomeRegistro, String user, String password, boolean appId, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (user == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiApiKey] Parametro user Non Valido");
        }
        if (password == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiApiKey] Parametro password Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoByCredenzialiApiKey(user, password, appId))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoByCredenzialiApiKey", nomeRegistro, null, connectionPdD, user, password, appId, config) : (Soggetto)this.getObject("getSoggettoByCredenzialiApiKey", nomeRegistro, null, connectionPdD, user, password, appId, config);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoByCredenzialiApiKey] Soggetto non Trovato");
    }

    protected static String _toKey_getSoggettoByCredenzialiSslPrefix(boolean separator) {
        return "getSoggettoByCredenzialiSsl" + (separator ? "_" : "");
    }

    private String _getKey_getSoggettoByCredenzialiSsl(String aSubject, String Issuer) {
        Object key = RegistroServizi._toKey_getSoggettoByCredenzialiSslPrefix(false);
        key = (String)key + "_subject:" + aSubject;
        key = Issuer != null ? (String)key + "_issuer:" + Issuer : (String)key + "_issuer:nonDefinito";
        return key;
    }

    public Soggetto getSoggettoByCredenzialiSsl(Connection connectionPdD, String nomeRegistro, String subject, String issuer) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (subject == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiSsl] Parametro subject Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoByCredenzialiSsl(subject, issuer))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Class[] classArguments = new Class[]{String.class, String.class};
        Object[] values = new Object[]{subject, issuer};
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoByCredenzialiSsl", nomeRegistro, (Boolean)null, connectionPdD, classArguments, values) : (Soggetto)this.getObject("getSoggettoByCredenzialiSsl", nomeRegistro, (Boolean)null, connectionPdD, classArguments, values);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoByCredenzialiSsl] Soggetto non Trovato");
    }

    protected static String _toKey_getSoggettoByCredenzialiSslCertPrefix(boolean separator) {
        return "getSoggettoByCredenzialiSslCert" + (separator ? "_" : "");
    }

    private String _getKey_getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException {
        try {
            Object key = RegistroServizi._toKey_getSoggettoByCredenzialiSslCertPrefix(false);
            key = (String)key + "_cert:" + certificate.digestBase64Encoded();
            key = (String)key + "_strictVerifier:" + strictVerifier;
            return key;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public Soggetto getSoggettoByCredenzialiSsl(Connection connectionPdD, String nomeRegistro, CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (certificate == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiSsl] Parametro certificate Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoByCredenzialiSsl(certificate, strictVerifier))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Class[] classArguments = new Class[]{CertificateInfo.class, Boolean.TYPE};
        Object[] values = new Object[]{certificate, strictVerifier};
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoByCredenzialiSsl", nomeRegistro, (Boolean)null, connectionPdD, classArguments, values) : (Soggetto)this.getObject("getSoggettoByCredenzialiSsl", nomeRegistro, (Boolean)null, connectionPdD, classArguments, values);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoByCredenzialiSsl] Soggetto non Trovato");
    }

    protected static String _toKey_getSoggettoByCredenzialiPrincipalPrefix() {
        return "getSoggettoByCredenzialiPrincipal_";
    }

    private String _getKey_getSoggettoByCredenzialiPrincipal(String principal) throws DriverRegistroServiziException {
        return RegistroServizi._toKey_getSoggettoByCredenzialiPrincipalPrefix() + principal;
    }

    public Soggetto getSoggettoByCredenzialiPrincipal(Connection connectionPdD, String nomeRegistro, String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (principal == null) {
            throw new DriverRegistroServiziException("[getSoggettoByCredenzialiPrincipal] Parametro principal Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoByCredenzialiPrincipal(principal))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoByCredenzialiPrincipal", nomeRegistro, null, connectionPdD, principal) : (Soggetto)this.getObject("getSoggettoByCredenzialiPrincipal", nomeRegistro, null, connectionPdD, principal);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoByCredenzialiPrincipal] Soggetto non Trovato");
    }

    protected static String _toKey_getAccordoServizioParteSpecificaPrefix(IDServizio idService) throws DriverRegistroServiziException {
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        String key = "getServizio_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio + "/" + versioneServizio;
        return key;
    }

    protected static String _getKey_getAccordoServizioParteSpecifica(IDServizio idService, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        Object key = RegistroServizi._toKey_getAccordoServizioParteSpecificaPrefix(idService);
        String azione = idService.getAzione();
        if (azione != null) {
            key = (String)key + "_" + azione;
        }
        if (readContenutiAllegati != null) {
            key = (String)key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Connection connectionPdD, String nomeRegistro, IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Connection connectionPdD, String nomeRegistro, IDServizio idService, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getAccordoServizioParteSpecifica(idService, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoServizioParteSpecifica)response.getObject();
        }
        AccordoServizioParteSpecifica serv = null;
        serv = this.cache != null ? (AccordoServizioParteSpecifica)this.getObjectCache(key, "getAccordoServizioParteSpecifica", nomeRegistro, readContenutiAllegati, connectionPdD, idService) : (AccordoServizioParteSpecifica)this.getObject("getAccordoServizioParteSpecifica", nomeRegistro, readContenutiAllegati, connectionPdD, idService);
        if (serv != null) {
            return serv;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Servizio non trovato");
    }

    protected static String _toKey_getAccordoServizioParteSpecifica_ServizioCorrelato_prefix() throws DriverRegistroServiziException {
        return "getServizioCorrelato(RicercaPerAccordo)_";
    }

    protected static String _toKey_getAccordoServizioParteSpecifica_ServizioCorrelato(IDAccordoFactory idAccordoFactory, IDAccordo idAccordo) throws DriverRegistroServiziException {
        return "_" + idAccordoFactory.getUriFromIDAccordo(idAccordo) + "_";
    }

    private String _getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        String key = RegistroServizi._toKey_getAccordoServizioParteSpecifica_ServizioCorrelato_prefix() + idSoggetto.getTipo() + "/" + idSoggetto.getNome();
        key = key + RegistroServizi._toKey_getAccordoServizioParteSpecifica_ServizioCorrelato(this.idAccordoFactory, idAccordo);
        if (readContenutiAllegati != null) {
            key = key + "READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(Connection connectionPdD, String nomeRegistro, IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(Connection connectionPdD, String nomeRegistro, IDSoggetto idSoggetto, IDAccordo idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        String nome = idSoggetto.getNome();
        String tipo = idSoggetto.getTipo();
        if (tipo == null || nome == null || idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametri Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordo, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoServizioParteSpecifica)response.getObject();
        }
        AccordoServizioParteSpecifica servCorrelato = null;
        servCorrelato = this.cache != null ? (AccordoServizioParteSpecifica)this.getObjectCache(key, "getAccordoServizioParteSpecifica_ServizioCorrelato", nomeRegistro, readContenutiAllegati, connectionPdD, idSoggetto, idAccordo) : (AccordoServizioParteSpecifica)this.getObject("getAccordoServizioParteSpecifica_ServizioCorrelato", nomeRegistro, readContenutiAllegati, connectionPdD, idSoggetto, idAccordo);
        if (servCorrelato != null) {
            return servCorrelato;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] ServizioCorrelato non trovato");
    }

    protected static String _getKey_getAccordoCooperazione(IDAccordoCooperazioneFactory idAccordoCooperazioneFactory, IDAccordoCooperazione idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        String uriAccordoCooperazione = idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordo);
        String key = "getAccordoCooperazione_" + uriAccordoCooperazione;
        if (readContenutiAllegati != null) {
            key = key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoCooperazione getAccordoCooperazione(Connection connectionPdD, String nomeRegistro, IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordo, null);
    }

    public AccordoCooperazione getAccordoCooperazione(Connection connectionPdD, String nomeRegistro, IDAccordoCooperazione idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione]: Parametro non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione]: Nome accordo di servizio non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getAccordoCooperazione(this.idAccordoCooperazioneFactory, idAccordo, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoCooperazione)response.getObject();
        }
        AccordoCooperazione ac = null;
        ac = this.cache != null ? (AccordoCooperazione)this.getObjectCache(key, "getAccordoCooperazione", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo) : (AccordoCooperazione)this.getObject("getAccordoCooperazione", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo);
        if (ac != null) {
            return ac;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo non trovato");
    }

    protected static String _toKey_getAllIdPorteDominio_method() {
        return "getAllIdPorteDominio";
    }

    public List<String> getAllIdPorteDominio(Connection connectionPdD, String nomeRegistro, FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdPorteDominio_method());
    }

    protected static String _toKey_getAllIdGruppi_method() {
        return "getAllIdGruppi";
    }

    public List<IDGruppo> getAllIdGruppi(Connection connectionPdD, String nomeRegistro, FiltroRicercaGruppi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdGruppi_method());
    }

    protected static String _toKey_getAllIdRuoli_method() {
        return "getAllIdRuoli";
    }

    public List<IDRuolo> getAllIdRuoli(Connection connectionPdD, String nomeRegistro, FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdRuoli_method());
    }

    protected static String _toKey_getAllIdScope_method() {
        return "getAllIdScope";
    }

    public List<IDScope> getAllIdScope(Connection connectionPdD, String nomeRegistro, FiltroRicercaScope filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdScope_method());
    }

    protected static String _toKey_getAllIdSoggetti_method() {
        return "getAllIdSoggetti";
    }

    public List<IDSoggetto> getAllIdSoggetti(Connection connectionPdD, String nomeRegistro, FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdSoggetti_method());
    }

    protected static String _toKey_getAllIdAccordiCooperazione_method() {
        return "getAllIdAccordiCooperazione";
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(Connection connectionPdD, String nomeRegistro, FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdAccordiCooperazione_method());
    }

    protected static String _toKey_getAllIdAccordiServizioParteComune_method() {
        return "getAllIdAccordiServizioParteComune";
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(Connection connectionPdD, String nomeRegistro, FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdAccordiServizioParteComune_method());
    }

    protected static String _toKey_getAllIdPortType_method() {
        return "getAllIdPortType";
    }

    public List<IDPortType> getAllIdPortType(Connection connectionPdD, String nomeRegistro, FiltroRicercaPortTypes filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdPortType_method());
    }

    protected static String _toKey_getAllIdAzionePortType_method() {
        return "getAllIdAzionePortType";
    }

    public List<IDPortTypeAzione> getAllIdAzionePortType(Connection connectionPdD, String nomeRegistro, FiltroRicercaOperations filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdAzionePortType_method());
    }

    protected static String _toKey_getAllIdAzione_method() {
        return "getAllIdAzioneAccordo";
    }

    public List<IDAccordoAzione> getAllIdAzioneAccordo(Connection connectionPdD, String nomeRegistro, FiltroRicercaAzioni filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdAzione_method());
    }

    protected static String _toKey_getAllIdResource_method() {
        return "getAllIdResource";
    }

    public List<IDResource> getAllIdResource(Connection connectionPdD, String nomeRegistro, FiltroRicercaResources filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdResource_method());
    }

    protected static String _toKey_getAllIdServizi_method() {
        return "getAllIdServizi";
    }

    public List<IDServizio> getAllIdServizi(Connection connectionPdD, String nomeRegistro, FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdServizi_method());
    }

    protected static String _toKey_getAllIdFruizioniServizio_method() {
        return "getAllIdFruizioniServizio";
    }

    public List<IDFruizione> getAllIdFruizioniServizio(Connection connectionPdD, String nomeRegistro, FiltroRicercaFruizioniServizio filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, RegistroServizi._toKey_getAllIdFruizioniServizio_method());
    }

    private List<?> _getAllIdEngine(Connection connectionPdD, String nomeRegistro, Object filtroRicerca, String nomeMetodo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (filtroRicerca == null) {
            throw new DriverRegistroServiziException("[" + nomeMetodo + "]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = nomeMetodo + "_" + filtroRicerca.toString())) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (List)((Object)response.getObject());
        }
        List list = null;
        list = this.cache != null ? (List)this.getObjectCache(key, nomeMetodo, nomeRegistro, null, connectionPdD, filtroRicerca) : (List)this.getObject(nomeMetodo, nomeRegistro, null, connectionPdD, filtroRicerca);
        if (list != null) {
            return list;
        }
        throw new DriverRegistroServiziNotFound("[" + nomeMetodo + "] Elementi non trovati");
    }

    protected static String _toKey_prefixGetAllegatoAccordoServizioParteComune(IDAccordo idAccordo) {
        return "getAllegatoAccordoServizioParteComune_" + idAccordo.toString() + "_";
    }

    protected static String getKeyGetAllegatoAccordoServizioParteComune(IDAccordo idAccordo, RuoliDocumento ruolo, Object tipo, String nome) {
        StringBuilder key = new StringBuilder(RegistroServizi._toKey_prefixGetAllegatoAccordoServizioParteComune(idAccordo));
        key.append(ruolo.toString());
        if (tipo != null) {
            key.append("_").append(tipo.toString());
        }
        key.append("_").append(nome);
        return key.toString();
    }

    protected Documento getAllegato(Connection connectionPdD, String nomeRegistro, IDAccordo idAccordo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllegatoAccordoServizioParteComune(connectionPdD, nomeRegistro, "getAllegato", idAccordo, RuoliDocumento.allegato, null, nome, requestInfo);
    }

    protected Documento getSpecificaSemiformale(Connection connectionPdD, String nomeRegistro, IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllegatoAccordoServizioParteComune(connectionPdD, nomeRegistro, "getSpecificaSemiformale", idAccordo, RuoliDocumento.specificaSemiformale, (Object)tipo, nome, requestInfo);
    }

    private Documento _getAllegatoAccordoServizioParteComune(Connection connectionPdD, String nomeRegistro, String nomeMetodo, IDAccordo idAccordo, RuoliDocumento ruolo, Object tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Documento doc;
        boolean useRequestInfo;
        String key = RegistroServizi.getKeyGetAllegatoAccordoServizioParteComune(idAccordo, ruolo, tipo, nome);
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null;
        if (useRequestInfo && (doc = requestInfo.getRequestConfig().getAllegatoApi(key)) != null) {
            return doc;
        }
        doc = this._getAllegatoAccordoServizioParteComune(connectionPdD, nomeRegistro, nomeMetodo, idAccordo, ruolo, tipo, nome, key);
        if (useRequestInfo && requestInfo != null) {
            requestInfo.getRequestConfig().addAllegatoApi(key, doc, requestInfo.getIdTransazione());
        }
        return doc;
    }

    private Documento _getAllegatoAccordoServizioParteComune(Connection connectionPdD, String nomeRegistro, String nomeMetodo, IDAccordo idAccordo, RuoliDocumento ruolo, Object tipo, String nome, String key) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idAccordo == null || ruolo == null || nome == null) {
            throw new DriverRegistroServiziException("[" + nomeMetodo + "]: Parametri non definito");
        }
        if (!RuoliDocumento.allegato.equals((Object)ruolo) && tipo == null) {
            throw new DriverRegistroServiziException("[" + nomeMetodo + "]: Tipo documento definito");
        }
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key)) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Documento)response.getObject();
        }
        Documento documento = null;
        documento = RuoliDocumento.allegato.equals((Object)ruolo) ? (this.cache != null ? (Documento)this.getObjectCache(key, nomeMetodo, nomeRegistro, null, connectionPdD, idAccordo, nome) : (Documento)this.getObject(nomeMetodo, nomeRegistro, null, connectionPdD, idAccordo, nome)) : (this.cache != null ? (Documento)this.getObjectCache(key, nomeMetodo, nomeRegistro, null, connectionPdD, idAccordo, tipo, nome) : (Documento)this.getObject(nomeMetodo, nomeRegistro, null, connectionPdD, idAccordo, tipo, nome));
        if (documento != null) {
            return documento;
        }
        throw new DriverRegistroServiziNotFound("[" + nomeMetodo + "] Documento non trovato");
    }

    protected static String _toKey_prefixGetAllegatoAccordoServizioParteSpecifica(IDServizio idServizio) {
        return "getAllegatoAccordoServizioParteSpecifica_" + idServizio.toString(false) + "_";
    }

    protected static String getKeyGetAllegatoAccordoServizioParteSpecifica(IDServizio idServizio, RuoliDocumento ruolo, Object tipo, String nome) {
        StringBuilder key = new StringBuilder(RegistroServizi._toKey_prefixGetAllegatoAccordoServizioParteSpecifica(idServizio));
        key.append(ruolo.toString());
        if (tipo != null) {
            key.append("_").append(tipo.toString());
        }
        key.append("_").append(nome);
        return key.toString();
    }

    protected Documento getAllegato(Connection connectionPdD, String nomeRegistro, IDServizio idServizio, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllegatoAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, "getAllegato", idServizio, RuoliDocumento.allegato, null, nome, requestInfo);
    }

    protected Documento getSpecificaSemiformale(Connection connectionPdD, String nomeRegistro, IDServizio idServizio, TipiDocumentoSemiformale tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllegatoAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, "getSpecificaSemiformale", idServizio, RuoliDocumento.specificaSemiformale, (Object)tipo, nome, requestInfo);
    }

    protected Documento getSpecificaSicurezza(Connection connectionPdD, String nomeRegistro, IDServizio idServizio, TipiDocumentoSicurezza tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllegatoAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, "getSpecificaSicurezza", idServizio, RuoliDocumento.specificaSicurezza, (Object)tipo, nome, requestInfo);
    }

    protected Documento getSpecificaLivelloServizio(Connection connectionPdD, String nomeRegistro, IDServizio idServizio, TipiDocumentoLivelloServizio tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllegatoAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, "getSpecificaLivelloServizio", idServizio, RuoliDocumento.specificaSicurezza, (Object)tipo, nome, requestInfo);
    }

    private Documento _getAllegatoAccordoServizioParteSpecifica(Connection connectionPdD, String nomeRegistro, String nomeMetodo, IDServizio idServizio, RuoliDocumento ruolo, Object tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Documento doc;
        boolean useRequestInfo;
        String key = RegistroServizi.getKeyGetAllegatoAccordoServizioParteSpecifica(idServizio, ruolo, tipo, nome);
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null;
        if (useRequestInfo && (doc = requestInfo.getRequestConfig().getAllegatoServizio(key)) != null) {
            return doc;
        }
        doc = this._getAllegatoAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, nomeMetodo, idServizio, ruolo, tipo, nome, key);
        if (useRequestInfo && requestInfo != null) {
            requestInfo.getRequestConfig().addAllegatoServizio(key, doc, requestInfo.getIdTransazione());
        }
        return doc;
    }

    private Documento _getAllegatoAccordoServizioParteSpecifica(Connection connectionPdD, String nomeRegistro, String nomeMetodo, IDServizio idServizio, RuoliDocumento ruolo, Object tipo, String nome, String key) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idServizio == null || ruolo == null || nome == null) {
            throw new DriverRegistroServiziException("[" + nomeMetodo + "]: Parametri non definito");
        }
        if (!RuoliDocumento.allegato.equals((Object)ruolo) && tipo == null) {
            throw new DriverRegistroServiziException("[" + nomeMetodo + "]: Tipo documento definito");
        }
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key)) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (Documento)response.getObject();
        }
        Documento documento = null;
        documento = RuoliDocumento.allegato.equals((Object)ruolo) ? (this.cache != null ? (Documento)this.getObjectCache(key, nomeMetodo, nomeRegistro, null, connectionPdD, idServizio, nome) : (Documento)this.getObject(nomeMetodo, nomeRegistro, null, connectionPdD, idServizio, nome)) : (this.cache != null ? (Documento)this.getObjectCache(key, nomeMetodo, nomeRegistro, null, connectionPdD, idServizio, tipo, nome) : (Documento)this.getObject(nomeMetodo, nomeRegistro, null, connectionPdD, idServizio, tipo, nome));
        if (documento != null) {
            return documento;
        }
        throw new DriverRegistroServiziNotFound("[" + nomeMetodo + "] Documento non trovato");
    }

    public org.openspcoop2.core.registry.RegistroServizi[] getRegistriServiziXML() {
        if (this.registriXML.size() > 0) {
            org.openspcoop2.core.registry.RegistroServizi[] r = new org.openspcoop2.core.registry.RegistroServizi[this.registriXML.size()];
            for (int i = 0; i < this.registriXML.size(); ++i) {
                r[i] = this.registriXML.get(i).getRegistroXML();
            }
            return r;
        }
        return null;
    }

    protected static String _toKey_getWsdlAccordoServizioPrefix() {
        return "getWsdlAccordoServizio_";
    }

    protected static String _toKey_getWsdlAccordoServizioService(IDServizio idService) {
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        return "_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio + "/" + versioneServizio + "_";
    }

    public org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper getWsdlAccordoServizio(Connection connectionPdD, String nomeRegistro, IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchemaXSD, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametro Non Valido");
        }
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._toKey_getWsdlAccordoServizioPrefix() + infoWsdlSource.name() + RegistroServizi._toKey_getWsdlAccordoServizioService(idService) + "schema_" + buildSchemaXSD + "readDatiRegistro_" + readDatiRegistro)) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper)response.getObject();
        }
        org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper wsdlAS = null;
        wsdlAS = this.cache != null ? this.getAccordoServizioSoapCache(key, idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD, readDatiRegistro) : this.getAccordoServizioSoapEngine(idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD, readDatiRegistro);
        if (wsdlAS != null) {
            return wsdlAS;
        }
        throw new DriverRegistroServiziNotFound("[getWsdlAccordoServizio] WSDLAccordoServizio non trovato");
    }

    private org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper getAccordoServizioSoapCache(String keyCache, IDServizio idService, InformationApiSource infoWsdlSource, String nomeRegistro, Connection connectionPdD, boolean buildSchemaXSD, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SemaphoreLock lock = semaphore_getAccordoServizioSoapCache.acquireThrowRuntime("getAccordoServizioSoapCache");
        DriverRegistroServiziNotFound dNotFound = null;
        org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[getWSDLAccordoServizio]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getWSDLAccordoServizio) nel registro[" + nomeRegistro + "] in cache.");
                    org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper accordoServizioWrapper = (org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper)response.getObject();
                    return accordoServizioWrapper;
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getWSDLAccordoServizio) nel registro[" + nomeRegistro + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug("oggetto con chiave [" + keyCache + "] (method:WSDLAccordoServizio) nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro...");
            try {
                obj = this.getAccordoServizioSoapEngine(idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD, readDatiRegistro);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (obj != null) {
                    this.log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                } else {
                    this.log.info("Aggiungo eccezione [" + keyCache + "] in cache");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (notFoundClassName.equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)((Object)e);
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        finally {
            semaphore_getAccordoServizioSoapCache.release(lock, "getAccordoServizioSoapCache");
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    private org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper getAccordoServizioSoapEngine(IDServizio idService, InformationApiSource infoWsdlSource, String nomeRegistro, Connection connectionPdD, boolean buildSchemaXSD, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper accordoServizioWrapper;
        block17: {
            _ASWrapperDati asWrapper = this.buildASWrapperDati(nomeRegistro, idService, connectionPdD, readDatiRegistro);
            AccordoServizioParteSpecifica servizio = asWrapper.servizio;
            AccordoServizioParteComune as = asWrapper.as;
            boolean registroServiziDB = asWrapper.registroServiziDB;
            accordoServizioWrapper = new org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper();
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(as);
            accordoServizioWrapper.setIdAccordoServizio(idAccordo);
            accordoServizioWrapper.setNomePortType(servizio.getPortType());
            accordoServizioWrapper.setTipologiaServizio(servizio.getTipologiaServizio());
            accordoServizioWrapper.setAccordoServizio(as);
            accordoServizioWrapper.setLocationWsdlImplementativoErogatore(servizio.getWsdlImplementativoErogatore());
            accordoServizioWrapper.setLocationWsdlImplementativoFruitore(servizio.getWsdlImplementativoFruitore());
            accordoServizioWrapper.setBytesWsdlImplementativoErogatore(servizio.getByteWsdlImplementativoErogatore());
            accordoServizioWrapper.setBytesWsdlImplementativoFruitore(servizio.getByteWsdlImplementativoFruitore());
            OpenSPCoop2MessageFactory defaultMessageFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            AccordoServizioWrapperUtilities wsdlWrapperUtilities = new AccordoServizioWrapperUtilities(defaultMessageFactory, this.log);
            wsdlWrapperUtilities.setAccordoServizio(accordoServizioWrapper);
            if (buildSchemaXSD) {
                try {
                    boolean buildFromBytes = registroServiziDB;
                    wsdlWrapperUtilities.buildSchema(buildFromBytes);
                }
                catch (DriverRegistroServiziException e) {
                    throw new DriverRegistroServiziException("[SchemaXSD] " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper accordoServizioWrapperStep2;
                block21: {
                    block20: {
                        if (InformationApiSource.SPECIFIC.equals((Object)infoWsdlSource)) {
                            this.log.debug("Costruisco WSDLAccordoServizio from WSDL...");
                            this._loadFromWsdl(servizio, registroServiziDB, wsdlWrapperUtilities);
                            break block17;
                        }
                        if (InformationApiSource.REGISTRY.equals((Object)infoWsdlSource)) {
                            this.log.debug("Costruisco WSDLAccordoServizio from AccordoServizio...");
                            wsdlWrapperUtilities.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
                            break block17;
                        }
                        if (InformationApiSource.SPECIFIC_REGISTRY.equals((Object)infoWsdlSource) || InformationApiSource.SAFE_SPECIFIC_REGISTRY.equals((Object)infoWsdlSource)) {
                            org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper accordoServizioWrapperStep22;
                            block19: {
                                block18: {
                                    this.log.debug("Costruisco WSDLAccordoServizio from WSDL (Step1)...");
                                    try {
                                        this._loadFromWsdl(servizio, registroServiziDB, wsdlWrapperUtilities);
                                    }
                                    catch (DriverRegistroServiziException e) {
                                        if (!InformationApiSource.SPECIFIC_REGISTRY.equals((Object)infoWsdlSource)) break block18;
                                        throw e;
                                    }
                                }
                                this.log.debug("Costruisco WSDLAccordoServizio from AccordoServizio (Step2)...");
                                AccordoServizioWrapperUtilities wsdlWrapperUtilitiesStep2 = new AccordoServizioWrapperUtilities(defaultMessageFactory, this.log);
                                accordoServizioWrapperStep22 = accordoServizioWrapper.clone(false);
                                wsdlWrapperUtilitiesStep2.setAccordoServizio(accordoServizioWrapperStep22);
                                try {
                                    wsdlWrapperUtilitiesStep2.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
                                }
                                catch (DriverRegistroServiziException e) {
                                    if (!InformationApiSource.SPECIFIC_REGISTRY.equals((Object)infoWsdlSource)) break block19;
                                    throw e;
                                }
                            }
                            this.log.debug("Costruisco WSDLAccordoServizio merge WSDL e AccordoServizio (Step3)...");
                            this._merge(accordoServizioWrapper, accordoServizioWrapperStep22);
                            break block17;
                        }
                        if (!InformationApiSource.REGISTRY_SPECIFIC.equals((Object)infoWsdlSource) && !InformationApiSource.SAFE_REGISTRY_SPECIFIC.equals((Object)infoWsdlSource)) break block17;
                        this.log.debug("Costruisco WSDLAccordoServizio from AccordoServizio (Step1)...");
                        try {
                            wsdlWrapperUtilities.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
                        }
                        catch (DriverRegistroServiziException e) {
                            if (!InformationApiSource.REGISTRY_SPECIFIC.equals((Object)infoWsdlSource)) break block20;
                            throw e;
                        }
                    }
                    this.log.debug("Costruisco WSDLAccordoServizio from WSDL (Step2)...");
                    AccordoServizioWrapperUtilities wsdlWrapperUtilitiesStep2 = new AccordoServizioWrapperUtilities(defaultMessageFactory, this.log);
                    accordoServizioWrapperStep2 = accordoServizioWrapper.clone(false);
                    wsdlWrapperUtilitiesStep2.setAccordoServizio(accordoServizioWrapperStep2);
                    try {
                        this._loadFromWsdl(servizio, registroServiziDB, wsdlWrapperUtilitiesStep2);
                    }
                    catch (DriverRegistroServiziException e) {
                        if (!InformationApiSource.REGISTRY_SPECIFIC.equals((Object)infoWsdlSource)) break block21;
                        throw e;
                    }
                }
                this.log.debug("Costruisco WSDLAccordoServizio merge  AccordoServizio e WSDL (Step3)...");
                this._merge(accordoServizioWrapper, accordoServizioWrapperStep2);
            }
            catch (DriverRegistroServiziException e) {
                if (TipologiaServizio.CORRELATO.equals((Object)servizio.getTipologiaServizio())) {
                    throw new DriverRegistroServiziException("[WSDL-FRUITORE] " + e.getMessage(), (Throwable)e);
                }
                throw new DriverRegistroServiziException("[WSDL-EROGATORE] " + e.getMessage(), (Throwable)e);
            }
        }
        this.log.debug("invocazione metodo getWSDLAccordoServizio completata.");
        return accordoServizioWrapper;
    }

    private void _loadFromWsdl(AccordoServizioParteSpecifica servizio, boolean registroServiziDB, AccordoServizioWrapperUtilities wsdlWrapperUtilities) throws DriverRegistroServiziException {
        if (TipologiaServizio.CORRELATO.equals((Object)servizio.getTipologiaServizio())) {
            Definition wsdlFruitore = null;
            wsdlFruitore = registroServiziDB ? wsdlWrapperUtilities.buildWsdlFruitoreFromBytes() : wsdlWrapperUtilities.buildWsdlFruitore();
            boolean readParteImplementativa = servizio.getWsdlImplementativoFruitore() != null && !"".equals(servizio.getWsdlImplementativoFruitore()) || servizio.getByteWsdlImplementativoFruitore() != null || wsdlFruitore.getAllBindings() != null && wsdlFruitore.getAllBindings().size() > 0;
            wsdlWrapperUtilities.buildAccordoServizioWrapperFromWsdl(wsdlFruitore, readParteImplementativa);
        } else {
            Definition wsdlErogatore = null;
            wsdlErogatore = registroServiziDB ? wsdlWrapperUtilities.buildWsdlErogatoreFromBytes() : wsdlWrapperUtilities.buildWsdlErogatore();
            boolean readParteImplementativa = servizio.getWsdlImplementativoErogatore() != null && !"".equals(servizio.getWsdlImplementativoErogatore()) || servizio.getByteWsdlImplementativoErogatore() != null || wsdlErogatore.getAllBindings() != null && wsdlErogatore.getAllBindings().size() > 0;
            wsdlWrapperUtilities.buildAccordoServizioWrapperFromWsdl(wsdlErogatore, readParteImplementativa);
        }
    }

    private void _merge(org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper ptA, org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper ptB) {
        for (int i = 0; i < ptB.sizePortTypeList(); ++i) {
            PortType portTypeB = ptB.getPortType(i);
            boolean exists = false;
            for (int j = 0; j < ptA.sizePortTypeList(); ++j) {
                PortType portTypeA = ptA.getPortType(j);
                if (!portTypeB.getNome().equals(portTypeA.getNome())) continue;
                for (Operation opB : portTypeB.getAzioneList()) {
                    boolean existsOperation = false;
                    for (Operation opA : portTypeA.getAzioneList()) {
                        if (!opB.getNome().equals(opA.getNome())) continue;
                        existsOperation = true;
                        break;
                    }
                    if (existsOperation) continue;
                    portTypeA.addAzione(opB);
                }
                exists = true;
                break;
            }
            if (exists) continue;
            ptA.addPortType(portTypeB);
        }
    }

    protected static String _toKey_getRestAccordoServizioPrefix() {
        return "getRestAccordoServizio_";
    }

    protected static String _toKey_getRestAccordoServizioService(IDServizio idService) {
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        return "_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio + "/" + versioneServizio + "_";
    }

    public AccordoServizioWrapper getRestAccordoServizio(Connection connectionPdD, String nomeRegistro, IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchemaXSD, boolean processIncludeForOpenApi, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getRestAccordoServizio] Parametro Non Valido");
        }
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverRegistroServiziException("[getRestAccordoServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getRestAccordoServizio] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._toKey_getRestAccordoServizioPrefix() + infoWsdlSource.name() + RegistroServizi._toKey_getRestAccordoServizioService(idService) + "schema_" + buildSchemaXSD + "_processInclude_" + processIncludeForOpenApi + "_readDatiRegistro_" + readDatiRegistro)) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (AccordoServizioWrapper)response.getObject();
        }
        AccordoServizioWrapper restAS = null;
        restAS = this.cache != null ? this.getAccordoServizioRestCache(key, idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro) : this.getAccordoServizioRestEngine(idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro);
        if (restAS != null) {
            return restAS;
        }
        throw new DriverRegistroServiziNotFound("[getRestAccordoServizio] API non trovata");
    }

    private AccordoServizioWrapper getAccordoServizioRestCache(String keyCache, IDServizio idService, InformationApiSource infoWsdlSource, String nomeRegistro, Connection connectionPdD, boolean buildSchemaXSD, boolean processIncludeForOpenApi, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SemaphoreLock lock = semaphore_getAccordoServizioRestCache.acquireThrowRuntime("getAccordoServizioRestCache");
        DriverRegistroServiziNotFound dNotFound = null;
        AccordoServizioWrapper obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[getRestAccordoServizio]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getRestAccordoServizio) nel registro[" + nomeRegistro + "] in cache.");
                    AccordoServizioWrapper accordoServizioWrapper = (AccordoServizioWrapper)response.getObject();
                    return accordoServizioWrapper;
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getRestAccordoServizio) nel registro[" + nomeRegistro + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug("oggetto con chiave [" + keyCache + "] (method:getRestAccordoServizio) nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro...");
            try {
                obj = this.getAccordoServizioRestEngine(idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (obj != null) {
                    this.log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                } else {
                    this.log.info("Aggiungo eccezione [" + keyCache + "] in cache");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (notFoundClassName.equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)((Object)e);
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        finally {
            semaphore_getAccordoServizioRestCache.release(lock, "getAccordoServizioRestCache");
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    private AccordoServizioWrapper getAccordoServizioRestEngine(IDServizio idService, InformationApiSource infoWsdlSource, String nomeRegistro, Connection connectionPdD, boolean buildSchemi, boolean processIncludeForOpenApi, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioWrapper accordoServizioWrapper;
        block24: {
            _ASWrapperDati asWrapper = this.buildASWrapperDati(nomeRegistro, idService, connectionPdD, readDatiRegistro);
            AccordoServizioParteSpecifica servizio = asWrapper.servizio;
            AccordoServizioParteComune as = asWrapper.as;
            if (as == null) {
                throw new DriverRegistroServiziException("AS undefined");
            }
            boolean registroServiziDB = asWrapper.registroServiziDB;
            accordoServizioWrapper = new AccordoServizioWrapper();
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(as);
            accordoServizioWrapper.setIdAccordoServizio(idAccordo);
            accordoServizioWrapper.setAccordoServizio(as);
            boolean processInclude = buildSchemi;
            if (buildSchemi && as != null && FormatoSpecifica.OPEN_API_3.equals((Object)as.getFormatoSpecifica())) {
                processInclude = processIncludeForOpenApi;
            }
            accordoServizioWrapper.setLocationSpecifica(as.getWsdlConcettuale());
            accordoServizioWrapper.setBytesSpecifica(as.getByteWsdlConcettuale());
            accordoServizioWrapper.setRegistroServiziDB(asWrapper.registroServiziDB);
            OpenSPCoop2MessageFactory defaultMessageFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            org.openspcoop2.core.registry.rest.AccordoServizioWrapperUtilities wsdlWrapperUtilities = new org.openspcoop2.core.registry.rest.AccordoServizioWrapperUtilities(defaultMessageFactory, this.log, accordoServizioWrapper);
            try {
                if (InformationApiSource.SPECIFIC.equals((Object)infoWsdlSource)) {
                    this.log.debug("Costruisco API tramite la specifica...");
                    wsdlWrapperUtilities.buildApiFromSpecific(registroServiziDB, buildSchemi, processInclude);
                    break block24;
                }
                if (InformationApiSource.REGISTRY.equals((Object)infoWsdlSource)) {
                    this.log.debug("Costruisco API tramite il registro...");
                    wsdlWrapperUtilities.buildApiFromRegistry(registroServiziDB, buildSchemi);
                    break block24;
                }
                if (InformationApiSource.SPECIFIC_REGISTRY.equals((Object)infoWsdlSource) || InformationApiSource.SAFE_SPECIFIC_REGISTRY.equals((Object)infoWsdlSource)) {
                    this.log.debug("Costruisco API tramite la specifica (Step1)...");
                    try {
                        wsdlWrapperUtilities.buildApiFromSpecific(registroServiziDB, buildSchemi, processInclude);
                    }
                    catch (DriverRegistroServiziException e) {
                        if (InformationApiSource.SPECIFIC_REGISTRY.equals((Object)infoWsdlSource)) {
                            throw e;
                        }
                        String errorMsg = "Costruisco API tramite il registro (Step1) error: " + e.getMessage();
                        if ("L'API non contiene una specifica".equals(e.getMessage())) {
                            this.log.warn(errorMsg, (Throwable)e);
                        }
                        this.log.error(errorMsg, (Throwable)e);
                    }
                    this.log.debug("Costruisco API tramite il registro (Step2)...");
                    AccordoServizioWrapper accordoServizioWrapperStep2 = accordoServizioWrapper.clone();
                    org.openspcoop2.core.registry.rest.AccordoServizioWrapperUtilities wsdlWrapperUtilitiesStep2 = new org.openspcoop2.core.registry.rest.AccordoServizioWrapperUtilities(defaultMessageFactory, this.log, accordoServizioWrapperStep2);
                    try {
                        wsdlWrapperUtilitiesStep2.buildApiFromRegistry(registroServiziDB, buildSchemi);
                    }
                    catch (DriverRegistroServiziException e) {
                        if (InformationApiSource.SPECIFIC_REGISTRY.equals((Object)infoWsdlSource)) {
                            throw e;
                        }
                        String errorMsg = "Costruisco API tramite il registro (Step2) error: " + e.getMessage();
                        if ("L'API non contiene una specifica".equals(e.getMessage())) {
                            this.log.warn(errorMsg, (Throwable)e);
                        }
                        this.log.error(errorMsg, (Throwable)e);
                    }
                    this.log.debug("Costruisco API merge specifica e registro (Step3)...");
                    this._merge(accordoServizioWrapper, accordoServizioWrapperStep2);
                    break block24;
                }
                if (!InformationApiSource.REGISTRY_SPECIFIC.equals((Object)infoWsdlSource) && !InformationApiSource.SAFE_REGISTRY_SPECIFIC.equals((Object)infoWsdlSource)) break block24;
                this.log.debug("Costruisco API tramite il registro (Step1)...");
                try {
                    wsdlWrapperUtilities.buildApiFromRegistry(registroServiziDB, buildSchemi);
                }
                catch (DriverRegistroServiziException e) {
                    if (InformationApiSource.REGISTRY_SPECIFIC.equals((Object)infoWsdlSource)) {
                        throw e;
                    }
                    String errorMsg = "Costruisco API tramite il registro (Step1) error: " + e.getMessage();
                    if ("L'API non contiene una specifica".equals(e.getMessage())) {
                        this.log.warn(errorMsg, (Throwable)e);
                    }
                    this.log.error(errorMsg, (Throwable)e);
                }
                this.log.debug("Costruisco API tramite la specifica (Step2)...");
                AccordoServizioWrapper accordoServizioWrapperStep2 = accordoServizioWrapper.clone();
                org.openspcoop2.core.registry.rest.AccordoServizioWrapperUtilities wsdlWrapperUtilitiesStep2 = new org.openspcoop2.core.registry.rest.AccordoServizioWrapperUtilities(defaultMessageFactory, this.log, accordoServizioWrapperStep2);
                try {
                    wsdlWrapperUtilitiesStep2.buildApiFromSpecific(registroServiziDB, buildSchemi, processInclude);
                }
                catch (DriverRegistroServiziException e) {
                    if (InformationApiSource.REGISTRY_SPECIFIC.equals((Object)infoWsdlSource)) {
                        throw e;
                    }
                    String errorMsg = "Costruisco API tramite il registro (Step2) error: " + e.getMessage();
                    if ("L'API non contiene una specifica".equals(e.getMessage())) {
                        this.log.warn(errorMsg, (Throwable)e);
                    }
                    this.log.error(errorMsg, (Throwable)e);
                }
                this.log.debug("Costruisco WSDLAccordoServizio merge  AccordoServizio e WSDL (Step3)...");
                this._merge(accordoServizioWrapper, accordoServizioWrapperStep2);
            }
            catch (DriverRegistroServiziException e) {
                if (TipologiaServizio.CORRELATO.equals((Object)servizio.getTipologiaServizio())) {
                    throw new DriverRegistroServiziException("[CORRELATO] " + e.getMessage(), (Throwable)e);
                }
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        this.log.debug("invocazione metodo getWSDLAccordoServizio completata.");
        return accordoServizioWrapper;
    }

    private void _merge(AccordoServizioWrapper asAwrapper, AccordoServizioWrapper asBwrapper) {
        int j;
        boolean exists;
        int i;
        AccordoServizioParteComune asA = asAwrapper.getAccordoServizio();
        AccordoServizioParteComune asB = asBwrapper.getAccordoServizio();
        for (i = 0; i < asB.sizeResourceList(); ++i) {
            Resource resourceB = asB.getResource(i);
            exists = false;
            for (j = 0; j < asA.sizeResourceList(); ++j) {
                Resource resourceA = asA.getResource(j);
                if (!resourceB.getNome().equals(resourceA.getNome())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            asA.addResource(resourceB);
        }
        if (asAwrapper.getApi() == null) {
            asAwrapper.setApi(asBwrapper.getApi());
        } else if (asBwrapper.getApi() != null) {
            for (i = 0; i < asBwrapper.getApi().sizeOperations(); ++i) {
                ApiOperation apiOpB = asBwrapper.getApi().getOperation(i);
                exists = false;
                for (j = 0; j < asAwrapper.getApi().sizeOperations(); ++j) {
                    ApiOperation apiOpA = asAwrapper.getApi().getOperation(j);
                    if ((apiOpA.getPath() != null ? !apiOpA.getPath().equals(apiOpB.getPath()) : apiOpB.getPath() != null) || (apiOpA.getHttpMethod() == null ? apiOpB.getHttpMethod() != null : apiOpB.getHttpMethod() == null || !apiOpA.getHttpMethod().equals((Object)apiOpB.getHttpMethod()))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                asAwrapper.getApi().addOperation(apiOpB);
            }
        }
    }

    protected static String _getKey_getServiceBinding(IDServizio idService) {
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        return "getServiceBinding_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio + "/" + versioneServizio;
    }

    public ServiceBinding getServiceBinding(Connection connectionPdD, String nomeRegistro, IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServiceBinding] Parametro Non Valido");
        }
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverRegistroServiziException("[getServiceBinding] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServiceBinding] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = RegistroServizi._getKey_getServiceBinding(idService))) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return (ServiceBinding)response.getObject();
        }
        ServiceBinding sb = null;
        sb = this.cache != null ? this.getServiceBindingCache(key, idService, nomeRegistro, connectionPdD) : this.getServiceBindingEngine(idService, nomeRegistro, connectionPdD);
        if (sb != null) {
            return sb;
        }
        throw new DriverRegistroServiziNotFound("[getServiceBinding] API non trovata");
    }

    private ServiceBinding getServiceBindingCache(String keyCache, IDServizio idService, String nomeRegistro, Connection connectionPdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SemaphoreLock lock = semaphore_getServiceBindingCache.acquireThrowRuntime("getServiceBindingCache");
        DriverRegistroServiziNotFound dNotFound = null;
        ServiceBinding obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[getServiceBinding]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getServiceBinding) nel registro[" + nomeRegistro + "] in cache.");
                    ServiceBinding serviceBinding = (ServiceBinding)response.getObject();
                    return serviceBinding;
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getServiceBinding) nel registro[" + nomeRegistro + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug("oggetto con chiave [" + keyCache + "] (method:getServiceBinding) nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro...");
            try {
                obj = this.getServiceBindingEngine(idService, nomeRegistro, connectionPdD);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info("Aggiungo eccezione [" + keyCache + "] in cache");
                } else if (obj != null) {
                    this.log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                } else {
                    throw new Exception("Metodo (getServiceBinding) nel registro[" + nomeRegistro + "] ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (notFoundClassName.equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)((Object)e);
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        finally {
            semaphore_getServiceBindingCache.release(lock, "getServiceBindingCache");
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    private ServiceBinding getServiceBindingEngine(IDServizio idService, String nomeRegistro, Connection connectionPdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        _ASWrapperDati asWrapper = this.buildASWrapperDati(nomeRegistro, idService, connectionPdD, false);
        return asWrapper.as.getServiceBinding();
    }

    private _ASWrapperDati buildASWrapperDati(String nomeRegistro, IDServizio idService, Connection connectionPdD, boolean readDatiRegistro) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        _ASWrapperDati asWrapper = new _ASWrapperDati();
        if (nomeRegistro != null) {
            this.log.debug("Cerco wsdl nel registro [" + nomeRegistro + "]");
            try {
                String uriServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idService);
                IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegistro);
                this.log.debug("invocazione metodo getWSDLAccordoServizio (search servizio)...");
                try {
                    asWrapper.servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteSpecifica(idService, true) : driver.getAccordoServizioParteSpecifica(idService);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (asWrapper.servizio == null) {
                    throw new DriverRegistroServiziNotFound("Servizio [" + uriServizio + "] non definito");
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(asWrapper.servizio.getAccordoServizioParteComune());
                this.log.debug("invocazione metodo getWSDLAccordoServizio (search accordo)...");
                asWrapper.as = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteComune(idAccordo, true, readDatiRegistro) : driver.getAccordoServizioParteComune(idAccordo);
                if (asWrapper.as == null) {
                    throw new DriverRegistroServiziNotFound("Accordo di servizio [" + idAccordo + "] associato al servizio [" + uriServizio + "] non presente nel registro");
                }
                if (asWrapper.servizio.getPortType() != null && !"".equals(asWrapper.servizio.getPortType())) {
                    boolean findPortType = false;
                    for (int l = 0; l < asWrapper.as.sizePortTypeList(); ++l) {
                        if (!asWrapper.servizio.getPortType().equals(asWrapper.as.getPortType(l).getNome())) continue;
                        findPortType = true;
                        break;
                    }
                    if (!findPortType) {
                        throw new DriverRegistroServiziNotFound("PortType[" + asWrapper.servizio.getPortType() + "] associato al servizio [" + uriServizio + "] non presente nell'Accordo di servizio [" + idAccordo + "]");
                    }
                }
                asWrapper.registroServiziDB = driver instanceof DriverRegistroServiziDB;
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug("Ricerca nel registro non riuscita (metodo getWSDLAccordoServizio): " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita, " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        this.log.debug("Cerco nella mia gerarchia di registri");
        StringBuilder notFoundProblem = new StringBuilder();
        StringBuilder exceptionProblem = new StringBuilder();
        boolean find = false;
        for (String nomeRegInLista : this.driverRegistroServizi.keySet()) {
            this.log.debug("Cerco nel registro con nome[" + nomeRegInLista + "]");
            try {
                String uriServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idService);
                IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegInLista);
                this.log.debug("invocazione metodo getWSDLAccordoServizio (search servizio) nel registro[" + nomeRegInLista + "]...");
                try {
                    asWrapper.servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteSpecifica(idService, true) : driver.getAccordoServizioParteSpecifica(idService);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (asWrapper.servizio == null) {
                    throw new DriverRegistroServiziNotFound("Servizio [" + uriServizio + "] non definito");
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(asWrapper.servizio.getAccordoServizioParteComune());
                this.log.debug("invocazione metodo getWSDLAccordoServizio (search accordo) nel registro[" + nomeRegInLista + "]...");
                asWrapper.as = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteComune(idAccordo, true, readDatiRegistro) : driver.getAccordoServizioParteComune(idAccordo);
                if (asWrapper.as == null) {
                    throw new DriverRegistroServiziNotFound("Accordo di servizio [" + idAccordo + "] associato al servizio [" + uriServizio + "] non presente nel registro");
                }
                if (asWrapper.servizio.getPortType() != null && !"".equals(asWrapper.servizio.getPortType())) {
                    boolean findPortType = false;
                    for (int l = 0; l < asWrapper.as.sizePortTypeList(); ++l) {
                        if (!asWrapper.servizio.getPortType().equals(asWrapper.as.getPortType(l).getNome())) continue;
                        findPortType = true;
                        break;
                    }
                    if (!findPortType) {
                        throw new DriverRegistroServiziNotFound("PortType[" + asWrapper.servizio.getPortType() + "] associato al servizio [" + uriServizio + "] non presente nell'Accordo di servizio [" + idAccordo + "]");
                    }
                }
                asWrapper.registroServiziDB = driver instanceof DriverRegistroServiziDB;
                find = true;
            }
            catch (DriverRegistroServiziNotFound ed) {
                this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita (metodo getWSDLAccordoServizio): " + ed.getMessage());
                notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + ed.getMessage());
            }
            catch (Exception e) {
                this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita, " + e.getMessage(), (Throwable)e);
                if (this.raggiungibilitaTotale) {
                    throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                }
                exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
            }
            if (!find) continue;
            break;
        }
        this.log.debug("invocazione metodo getWSDLAccordoServizio completata.");
        if (!find) {
            if (exceptionProblem.length() > 0 && notFoundProblem.length() > 0) {
                throw new DriverRegistroServiziException("getWSDLAccordoServizio:" + exceptionProblem.toString() + notFoundProblem.toString());
            }
            if (exceptionProblem.length() > 0) {
                throw new DriverRegistroServiziException("getWSDLAccordoServizio:" + exceptionProblem.toString());
            }
            if (notFoundProblem.length() > 0) {
                throw new DriverRegistroServiziNotFound("getWSDLAccordoServizio:" + notFoundProblem.toString());
            }
            throw new DriverRegistroServiziException("getWSDLAccordoServizio: ricerca non riuscita in tutti i registri");
        }
        return asWrapper;
    }

    public Serializable pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (this.cache != null) {
            return this._pushGenericObject(keyObject, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable _pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SemaphoreLock lock = semaphore_pushGenericObject.acquireThrowRuntime("_pushGenericObject");
        try {
            if (keyObject == null) {
                throw new DriverRegistroServiziException("[getGenericObject]: Parametro non definito");
            }
            String key = null;
            key = "getGenericObject_" + keyObject;
            CacheResponse response = (CacheResponse)this.cache.get(key);
            if (response != null) {
                if (response.getException() != null) {
                    if (notFoundClassName.equals(response.getException().getClass().getName())) {
                        throw (DriverRegistroServiziNotFound)((Object)response.getException());
                    }
                    throw (DriverRegistroServiziException)((Object)response.getException());
                }
                Serializable serializable = response.getObject();
                return serializable;
            }
            try {
                CacheResponse responseCache = new CacheResponse();
                responseCache.setObject(object);
                this.cache.put(key, responseCache);
            }
            catch (UtilsException e) {
                this.log.error("Errore durante l'inserimento in cache [" + key + "]: " + e.getMessage());
            }
            Serializable serializable = object;
            return serializable;
        }
        finally {
            semaphore_pushGenericObject.release(lock, "_pushGenericObject");
        }
    }

    public Serializable getGenericObject(String keyObject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (keyObject == null) {
            throw new DriverRegistroServiziException("[getGenericObject]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getGenericObject_" + keyObject)) != null) {
            if (response.getException() != null) {
                if (notFoundClassName.equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)((Object)response.getException());
                }
                throw (DriverRegistroServiziException)((Object)response.getException());
            }
            return response.getObject();
        }
        throw new DriverRegistroServiziNotFound("GenericObject with key [" + keyObject + "] not found");
    }
}

