/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.slf4j.Logger;

public abstract class AbstractModIPDNDConfig {
    protected Logger log;
    protected String version1JsonPathMatch;
    protected String version2JsonPathMatch;
    protected String overridePrefixJsonPath = "";
    protected boolean ovveridePatternAsConstant = false;
    protected String details;
    private static final int DEFAULT_VERSION = 1;
    private static final String NOT_PREFIX = "NOT ";

    public void clone(AbstractModIPDNDConfig base) {
        base.version1JsonPathMatch = this.version1JsonPathMatch;
        base.version2JsonPathMatch = this.version2JsonPathMatch;
        base.overridePrefixJsonPath = this.overridePrefixJsonPath;
        base.ovveridePatternAsConstant = this.ovveridePatternAsConstant;
        base.details = this.details;
    }

    protected AbstractModIPDNDConfig(Logger log) {
        this.log = log;
    }

    protected AbstractModIPDNDConfig(String details, Logger log) {
        this(log);
        this.details = details;
    }

    public int getVersion(String json) {
        if (this.match(this.normalizePattern(this.version2JsonPathMatch), json)) {
            return 2;
        }
        if (this.match(this.normalizePattern(this.version1JsonPathMatch), json)) {
            return 1;
        }
        return 1;
    }

    private boolean match(String pattern, String json) {
        if (pattern == null || StringUtils.isEmpty((CharSequence)pattern)) {
            return false;
        }
        boolean not = false;
        String searchPattern = pattern;
        if (pattern.toLowerCase().startsWith(NOT_PREFIX.toLowerCase())) {
            not = true;
            searchPattern = pattern.substring(NOT_PREFIX.length());
        }
        String v = null;
        try {
            v = JsonPathExpressionEngine.extractAndConvertResultAsString((String)json, (String)searchPattern, (Logger)this.log);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return not ? v == null || StringUtils.isEmpty((CharSequence)v) : v != null && StringUtils.isNotEmpty((CharSequence)v);
    }

    public String getVersion1JsonPathMatch() {
        return this.version1JsonPathMatch;
    }

    public void setVersion1JsonPathMatch(String version1JsonPathMatch) {
        this.version1JsonPathMatch = version1JsonPathMatch;
    }

    public String getVersion2JsonPathMatch() {
        return this.version2JsonPathMatch;
    }

    public void setVersion2JsonPathMatch(String version2JsonPathMatch) {
        this.version2JsonPathMatch = version2JsonPathMatch;
    }

    protected void checkDetails() throws ProtocolException {
        if (this.details == null) {
            throw new ProtocolException("Details undefined");
        }
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    protected String getValueEngine(Map<String, String> jsonPath) {
        int version = this.getVersion(this.details);
        return this.getValueEngine(jsonPath, version);
    }

    protected String getValueEngine(Map<String, String> jsonPath, int version) {
        String pattern = jsonPath.get("" + version);
        if (pattern == null || StringUtils.isEmpty((CharSequence)pattern)) {
            return null;
        }
        try {
            return JsonPathExpressionEngine.extractAndConvertResultAsString((String)this.details, (String)this.normalizePattern(pattern), (Logger)this.log);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getPatternEngine(Map<String, String> jsonPath) {
        int version = this.getVersion(this.details);
        return this.getPatternEngine(jsonPath, version);
    }

    protected String getPatternEngine(Map<String, String> jsonPath, int version) {
        String pattern = jsonPath.get("" + version);
        if (pattern == null || StringUtils.isEmpty((CharSequence)pattern)) {
            return null;
        }
        return pattern;
    }

    private String normalizePattern(String pattern) {
        if (pattern == null) {
            return pattern;
        }
        String prefix = null;
        if (((String)pattern).startsWith("$..")) {
            prefix = "$..";
        } else if (((String)pattern).startsWith("$.")) {
            prefix = "$.";
        }
        if (this.ovveridePatternAsConstant) {
            String base = null;
            if (prefix != null) {
                base = ((String)pattern).replace(prefix, "");
            }
            pattern = prefix + "['" + base + "']";
        }
        if (this.overridePrefixJsonPath == null || StringUtils.isEmpty((CharSequence)this.overridePrefixJsonPath)) {
            return pattern;
        }
        if (((String)pattern).startsWith(this.overridePrefixJsonPath)) {
            return pattern;
        }
        if (prefix != null) {
            return ((String)pattern).replace(prefix, this.overridePrefixJsonPath);
        }
        return pattern;
    }

    public String getOverridePrefixJsonPath() {
        return this.overridePrefixJsonPath;
    }

    public void setOverridePrefixJsonPath(String prefixJsonPath) {
        this.overridePrefixJsonPath = prefixJsonPath;
    }

    public boolean isOvveridePatternAsConstant() {
        return this.ovveridePatternAsConstant;
    }

    public void setOvveridePatternAsConstant(boolean ovveridePatternAsConstant) {
        this.ovveridePatternAsConstant = ovveridePatternAsConstant;
    }

    protected Map<String, String> newMap(Map<String, String> src) {
        HashMap<String, String> dest = null;
        if (src != null && !src.isEmpty()) {
            dest = new HashMap<String, String>();
            dest.putAll(src);
        }
        return dest;
    }
}

