/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public abstract class AbstractArchiveGenericProperties
implements IArchiveObject {
    protected String tipologiaPolicy;
    protected String idPolicy;
    protected GenericProperties policy;
    protected ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String object, String tipologiaPolicy, String nomePolicy) throws ProtocolException {
        if (tipologiaPolicy == null) {
            throw new ProtocolException("tipologiaPolicy non fornito");
        }
        if (nomePolicy == null) {
            throw new ProtocolException("nomePolicy non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append(object);
        bf.append("_");
        bf.append(tipologiaPolicy);
        bf.append("_");
        bf.append(nomePolicy);
        return bf.toString();
    }

    public AbstractArchiveGenericProperties(GenericProperties policy, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (policy == null) {
            throw new ProtocolException("Policy non fornito");
        }
        if (policy.getTipologia() == null) {
            throw new ProtocolException("Policy.tipologia non definito");
        }
        if (policy.getNome() == null) {
            throw new ProtocolException("Policy.nome non definito");
        }
        this.tipologiaPolicy = policy.getTipologia();
        this.idPolicy = policy.getNome();
        this.policy = policy;
        this.idCorrelazione = idCorrelazione;
    }

    public String getTipologiaPolicy() {
        return this.tipologiaPolicy;
    }

    public String getNomePolicy() {
        return this.idPolicy;
    }

    public GenericProperties getPolicy() {
        return this.policy;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

