/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveAllarme
implements IArchiveObject {
    private RuoloPorta ruoloPorta;
    private String nomePorta;
    private String alias;
    private Allarme allarme;
    private boolean allarmeGlobale;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(RuoloPorta ruoloPorta, String nomePorta, String alias) throws ProtocolException {
        if (alias == null) {
            throw new ProtocolException("alias non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("Allarme_");
        bf.append(alias);
        if (ruoloPorta != null && nomePorta != null) {
            bf.append("#");
            bf.append(ruoloPorta.toString());
            bf.append("_");
            bf.append(nomePorta);
        }
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveAllarme.buildKey(this.ruoloPorta, this.nomePorta, this.alias);
    }

    public ArchiveAllarme(Allarme allarme, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (allarme == null) {
            throw new ProtocolException("Allarme non fornito");
        }
        if (allarme.getAlias() == null) {
            throw new ProtocolException("Allarme.alias non definito");
        }
        this.alias = allarme.getAlias();
        if (allarme != null && allarme.getFiltro() != null) {
            this.ruoloPorta = allarme.getFiltro().getRuoloPorta();
            this.nomePorta = allarme.getFiltro().getNomePorta();
        }
        this.allarme = allarme;
        this.allarmeGlobale = allarme.getFiltro() == null || allarme.getFiltro().getNomePorta() == null || "".equals(allarme.getFiltro().getNomePorta());
        this.idCorrelazione = idCorrelazione;
    }

    public String getAlias() {
        return this.alias;
    }

    public RuoloPorta getRuoloPorta() {
        return this.ruoloPorta;
    }

    public String getNomePorta() {
        return this.nomePorta;
    }

    public Allarme getAllarme() {
        return this.allarme;
    }

    public boolean isAllarmeGlobale() {
        return this.allarmeGlobale;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

