/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchivePdd
implements IArchiveObject {
    private String nomePdd;
    private PortaDominio portaDominio;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String nomePdd) throws ProtocolException {
        if (nomePdd == null) {
            throw new ProtocolException("nomePdd non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("PortaDominio_");
        bf.append(nomePdd);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchivePdd.buildKey(this.nomePdd);
    }

    public ArchivePdd(PortaDominio portaDominio, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (portaDominio == null) {
            throw new ProtocolException("PortaDominio non fornito");
        }
        if (portaDominio.getNome() == null) {
            throw new ProtocolException("PortaDominio.nome non definito");
        }
        this.nomePdd = portaDominio.getNome();
        this.portaDominio = portaDominio;
        this.idCorrelazione = idCorrelazione;
    }

    public String getNomePdd() {
        return this.nomePdd;
    }

    public PortaDominio getPortaDominio() {
        return this.portaDominio;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

