/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IPositionArchiveObject;

public class ArchiveUrlInvocazioneRegola
implements IPositionArchiveObject {
    private String nome;
    private int posizione;
    private ConfigurazioneUrlInvocazioneRegola regola;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String nome) throws ProtocolException {
        if (nome == null) {
            throw new ProtocolException("nome non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("UrlInvocazioneRegola_");
        bf.append(nome);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveUrlInvocazioneRegola.buildKey(this.nome);
    }

    @Override
    public int position() throws ProtocolException {
        return this.posizione;
    }

    public ArchiveUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (regola == null) {
            throw new ProtocolException("Regola per url di invocazione non fornita");
        }
        if (regola.getNome() == null) {
            throw new ProtocolException("Nome della regola per l'url di invocazione non definita");
        }
        this.nome = regola.getNome();
        this.posizione = regola.getPosizione();
        this.regola = regola;
        this.idCorrelazione = idCorrelazione;
    }

    public String getNome() {
        return this.nome;
    }

    public ConfigurazioneUrlInvocazioneRegola getRegola() {
        return this.regola;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

