/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.constants;

import java.io.Serializable;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;

public enum EsitoTransazioneName implements Serializable
{
    OK,
    OK_PRESENZA_ANOMALIE,
    MESSAGGI_NON_PRESENTI,
    CONTROLLO_TRAFFICO_POLICY_VIOLATA_WARNING_ONLY,
    CONTROLLO_TRAFFICO_MAX_THREADS_WARNING_ONLY,
    HTTP_3xx,
    CONSEGNA_MULTIPLA,
    CONSEGNA_MULTIPLA_IN_CORSO,
    CONSEGNA_MULTIPLA_COMPLETATA,
    ERRORE_APPLICATIVO,
    ERRORE_PROTOCOLLO,
    ERRORE_CONNESSIONE_CLIENT_NON_DISPONIBILE,
    ERRORE_PROCESSAMENTO_PDD_4XX,
    ERRORE_PROCESSAMENTO_PDD_5XX,
    AUTENTICAZIONE_FALLITA,
    AUTORIZZAZIONE_FALLITA,
    MESSAGGIO_NON_TROVATO,
    ERRORE_INVOCAZIONE,
    ERRORE_SERVER,
    CONTENUTO_RICHIESTA_NON_RICONOSCIUTO,
    CONTENUTO_RISPOSTA_NON_RICONOSCIUTO,
    TOKEN_NON_PRESENTE,
    ERRORE_AUTENTICAZIONE_TOKEN,
    ERRORE_TOKEN,
    ERRORE_AUTENTICAZIONE,
    ERRORE_AUTORIZZAZIONE,
    CONTROLLO_TRAFFICO_POLICY_VIOLATA,
    CONTROLLO_TRAFFICO_MAX_THREADS,
    ERRORE_SICUREZZA_MESSAGGIO_RICHIESTA,
    ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA,
    ERRORE_ALLEGATI_MESSAGGIO_RICHIESTA,
    ERRORE_ALLEGATI_MESSAGGIO_RISPOSTA,
    ERRORE_CORRELAZIONE_APPLICATIVA_RICHIESTA,
    ERRORE_CORRELAZIONE_APPLICATIVA_RISPOSTA,
    HTTP_4xx,
    HTTP_5xx,
    ERRORE_VALIDAZIONE_RICHIESTA,
    ERRORE_VALIDAZIONE_RISPOSTA,
    ERRORE_SOSPENSIONE,
    CORS_PREFLIGHT_REQUEST_VIA_GATEWAY,
    CORS_PREFLIGHT_REQUEST_TRASPARENTE,
    ERRORE_TRASFORMAZIONE_RICHIESTA,
    ERRORE_TRASFORMAZIONE_RISPOSTA,
    CONSEGNA_MULTIPLA_FALLITA,
    API_NON_INDIVIDUATA,
    OPERAZIONE_NON_INDIVIDUATA,
    RICHIESTA_DUPLICATA,
    RISPOSTA_DUPLICATA,
    MESSAGE_BOX,
    ERRORE_RESPONSE_TIMEOUT,
    ERRORE_REQUEST_TIMEOUT,
    ERRORE_CONNECTION_TIMEOUT,
    ERRORE_NEGOZIAZIONE_TOKEN,
    ERRORE_TRACCIAMENTO,
    CUSTOM;

    private MapKey<String> mapKey = Map.newMapKey((String)("EsitoTransazioneName." + this.name()));

    public MapKey<String> getMapKey() {
        return this.mapKey;
    }

    public static boolean isPddSpecific(EsitoTransazioneName esitoTransactionName) {
        return !OK.equals(esitoTransactionName) && !EsitoTransazioneName.isIntegrationManagerSpecific(esitoTransactionName);
    }

    public static boolean isIntegrationManagerSpecific(EsitoTransazioneName esitoTransactionName) {
        return MESSAGGI_NON_PRESENTI.equals(esitoTransactionName) || MESSAGGIO_NON_TROVATO.equals(esitoTransactionName) || AUTENTICAZIONE_FALLITA.equals(esitoTransactionName) || AUTORIZZAZIONE_FALLITA.equals(esitoTransactionName);
    }

    public static boolean isStatiConsegnaMultipla(EsitoTransazioneName esitoTransactionName) {
        return CONSEGNA_MULTIPLA_IN_CORSO.equals(esitoTransactionName) || CONSEGNA_MULTIPLA_COMPLETATA.equals(esitoTransactionName) || CONSEGNA_MULTIPLA_FALLITA.equals(esitoTransactionName);
    }

    public static boolean isConsegnaMultipla(EsitoTransazioneName esitoTransactionName) {
        return CONSEGNA_MULTIPLA.equals(esitoTransactionName) || CONSEGNA_MULTIPLA_IN_CORSO.equals(esitoTransactionName) || CONSEGNA_MULTIPLA_COMPLETATA.equals(esitoTransactionName) || CONSEGNA_MULTIPLA_FALLITA.equals(esitoTransactionName);
    }

    public static boolean isErroreRisposta(EsitoTransazioneName esitoTransactionName) {
        return CONTENUTO_RISPOSTA_NON_RICONOSCIUTO.equals(esitoTransactionName) || ERRORE_ALLEGATI_MESSAGGIO_RISPOSTA.equals(esitoTransactionName) || ERRORE_CORRELAZIONE_APPLICATIVA_RISPOSTA.equals(esitoTransactionName) || ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA.equals(esitoTransactionName) || ERRORE_VALIDAZIONE_RISPOSTA.equals(esitoTransactionName) || ERRORE_TRASFORMAZIONE_RISPOSTA.equals(esitoTransactionName) || RISPOSTA_DUPLICATA.equals(esitoTransactionName);
    }

    public static boolean isSavedInMessageBox(EsitoTransazioneName esitoTransactionName) {
        return MESSAGE_BOX.equals(esitoTransactionName);
    }

    public static EsitoTransazioneName convertoTo(String name) {
        EsitoTransazioneName esitoTransactionName = null;
        try {
            esitoTransactionName = EsitoTransazioneName.valueOf(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (esitoTransactionName == null) {
            esitoTransactionName = CUSTOM;
        }
        return esitoTransactionName;
    }

    public static String[] toEnumNameArray() {
        String[] res = new String[EsitoTransazioneName.values().length];
        int i = 0;
        for (EsitoTransazioneName tmp : EsitoTransazioneName.values()) {
            res[i] = tmp.name();
            ++i;
        }
        return res;
    }

    public String toString() {
        return this.name();
    }
}

