/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.state;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IDService;

public class FunctionContextCustom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String context;
    private IDService idService;
    private HashMap<String, IDService> subcontext;

    public FunctionContextCustom(String context, IDService idService) throws ProtocolException {
        this(context, idService, null);
    }

    public FunctionContextCustom(String context, HashMap<String, IDService> subcontext) throws ProtocolException {
        this(context, null, subcontext);
    }

    private FunctionContextCustom(String context, IDService idServiceParam, HashMap<String, IDService> subcontextMap) throws ProtocolException {
        if (context == null) {
            throw new ProtocolException("Context undefined");
        }
        if (!StringUtils.isAlphanumeric((String)(context = context.trim()))) {
            throw new ProtocolException("Context '" + context + "' unsupported: only alphanumeric character permitted");
        }
        this.context = context;
        if (idServiceParam == null && (subcontextMap == null || subcontextMap.size() <= 0)) {
            throw new ProtocolException("IDService and Subcontext not found");
        }
        if (idServiceParam != null) {
            FunctionContextCustom.checkIDService(idServiceParam);
            this.idService = idServiceParam;
        }
        if (subcontextMap != null && subcontextMap.size() > 0) {
            for (String subcontext : subcontextMap.keySet()) {
                IDService idService = subcontextMap.get(subcontext);
                int count = 0;
                for (String subcontextRegistered : subcontextMap.keySet()) {
                    if (subcontextRegistered.equals(subcontext)) {
                        ++count;
                        continue;
                    }
                    if (subcontext.length() < subcontextRegistered.length() || !subcontext.startsWith(subcontextRegistered)) continue;
                    throw new ProtocolException("Subcontext '" + subcontext + "' not valid: exists another subcontext '" + subcontextRegistered + "' with same prefix");
                }
                if (count > 1) {
                    throw new ProtocolException("Subcontext '" + subcontext + "' registered more than one (founded:" + count + ")");
                }
                String tmp = new String(subcontext);
                while (tmp.contains("/")) {
                    tmp = tmp.replace("/", "");
                }
                if (!StringUtils.isAlphanumeric((String)tmp)) {
                    throw new ProtocolException("Subcontext '" + subcontext + "' unsupported: only alphanumeric character or '/' permitted");
                }
                if (subcontext.startsWith("/")) {
                    throw new ProtocolException("Subcontext '" + subcontext + "' unsupported: cannot start with '/' character");
                }
                if (subcontext.endsWith("/")) {
                    throw new ProtocolException("Subcontext '" + subcontext + "' unsupported: cannot ends with '/' character");
                }
                FunctionContextCustom.checkIDService(idService);
            }
            this.subcontext = subcontextMap;
        }
    }

    private static void checkIDService(IDService idService) throws ProtocolException {
        if (!(IDService.PORTA_DELEGATA.equals(idService) || IDService.PORTA_DELEGATA_NIO.equals(idService) || IDService.PORTA_DELEGATA_XML_TO_SOAP.equals(idService) || IDService.PORTA_DELEGATA_XML_TO_SOAP_NIO.equals(idService) || IDService.PORTA_APPLICATIVA.equals(idService) || IDService.PORTA_APPLICATIVA_NIO.equals(idService) || IDService.INTEGRATION_MANAGER_SOAP.equals(idService))) {
            throw new ProtocolException("IDService '" + idService + "' unsupported");
        }
    }

    public boolean isMatch(String contextParam, String subContextParam) {
        return this.getServiceMatch(contextParam, subContextParam) != null;
    }

    public IDService getServiceMatch(String contextParam, String subContextParam) {
        if (this.context.equals(contextParam)) {
            if (subContextParam != null && !"".equals(subContextParam) && this.subcontext != null && this.subcontext.size() > 0) {
                for (String subcontext : this.subcontext.keySet()) {
                    if (!subContextParam.startsWith(subcontext)) continue;
                    IDService idService = this.subcontext.get(subcontext);
                    return idService;
                }
            }
            if (this.idService != null) {
                return this.idService;
            }
        }
        return null;
    }

    public String getFunctionMatch(String contextParam, String subContextParam) {
        if (this.context.equals(contextParam)) {
            if (subContextParam != null && !"".equals(subContextParam) && this.subcontext != null && this.subcontext.size() > 0) {
                for (String subcontext : this.subcontext.keySet()) {
                    if (!subContextParam.startsWith(subcontext)) continue;
                    return this.context + "/" + subcontext;
                }
            }
            if (this.idService != null) {
                return this.context;
            }
        }
        return null;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public IDService getIdService() {
        return this.idService;
    }

    public void setIdService(IDService idService) {
        this.idService = idService;
    }

    public HashMap<String, IDService> getSubcontext() {
        return this.subcontext;
    }
}

