/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.List;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.utils.RegistroServiziUtils;

public class ModISecurityUtils {
    private ModISecurityUtils() {
    }

    public static List<String> getProfiloSicurezzaMessaggio(AccordoServizioParteComune api, String portType) {
        return ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageProfile", api, portType, false);
    }

    public static List<String> getProfiloSicurezzaMessaggioConSorgenteToken(AccordoServizioParteComune api, String portType) {
        return ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageProfile", "modipaSecurityMessageSorgenteToken", api, portType, false);
    }

    public static boolean isProfiloSicurezzaMessaggioConIntegrita(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getProfiloSicurezzaMessaggio(api, portType);
        if (tmp != null && !tmp.isEmpty()) {
            for (String profiloSicurezzaMessaggio : tmp) {
                if (!"idam0301".equals(profiloSicurezzaMessaggio) && !"idam0302".equals(profiloSicurezzaMessaggio) && !"idam0401".equals(profiloSicurezzaMessaggio) && !"idam0402".equals(profiloSicurezzaMessaggio)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProfiloSicurezzaMessaggioCorniceSicurezza(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageCorniceSicurezza", api, portType, true);
        if (tmp != null && !tmp.isEmpty()) {
            for (String v : tmp) {
                if (v == null || !"true".equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getProfiloSicurezzaMessaggioCorniceSicurezzaPattern(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageCorniceSicurezzaPattern", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            return tmp.get(0);
        }
        return null;
    }

    public static String getProfiloSicurezzaMessaggioCorniceSicurezzaSchema(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageCorniceSicurezzaSchema", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            return tmp.get(0);
        }
        return null;
    }

    public static boolean isProfiloSicurezzaMessaggioConHeaderDuplicati(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageHeaderName", "modipaSecurityMessageSorgenteToken", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String headerSorgenteToken : tmp) {
                List splitValues = RegistroServiziUtils.splitPropertyProtocolloResult((String)headerSorgenteToken);
                String header = (String)splitValues.get(0);
                String sorgenteToken = (String)splitValues.get(1);
                if (!"autonlyreq_modipa".equals(header) && !"authorization_modipa".equals(header) && !"autonlyreq_custom".equals(header) && !"authorization_custom".equals(header) || !ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProfiloSicurezzaMessaggioConSorgenteTokenNonLocale(AccordoServizioParteComune api, String portType, boolean rest) {
        if (rest) {
            return ModISecurityUtils.isProfiloSicurezzaMessaggioRestConSorgenteTokenNonLocale(api, portType);
        }
        return ModISecurityUtils.isProfiloSicurezzaMessaggioSoapConSorgenteTokenNonLocale(api, portType);
    }

    public static boolean isProfiloSicurezzaMessaggioRestConSorgenteTokenNonLocale(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageHeaderName", "modipaSecurityMessageSorgenteToken", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String headerSorgenteToken : tmp) {
                List splitValues = RegistroServiziUtils.splitPropertyProtocolloResult((String)headerSorgenteToken);
                String sorgenteToken = (String)splitValues.get(1);
                if (ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProfiloSicurezzaMessaggioSoapConSorgenteTokenNonLocale(AccordoServizioParteComune api, String portType) {
        String sorgenteToken;
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageSorgenteToken", api, portType, false);
        return tmp != null && !tmp.isEmpty() && !ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken = tmp.get(0));
    }

    private static List<String> getPropertySicurezzaMessaggioEngine(String propertyName, AccordoServizioParteComune api, String portType, boolean booleanValue) {
        return RegistroServiziUtils.fillPropertyProtocollo((String)propertyName, (AccordoServizioParteComune)api, (String)portType, (boolean)booleanValue);
    }

    private static List<String> getPropertySicurezzaMessaggioEngine(String propertyName, String propertyName2, AccordoServizioParteComune api, String portType, boolean booleanValue) {
        return RegistroServiziUtils.fillPropertyProtocollo((String)propertyName, (String)propertyName2, (AccordoServizioParteComune)api, (String)portType, (boolean)booleanValue);
    }

    public static boolean isSicurezzaMessaggioRequired(AccordoServizioParteComune api, String portType) {
        List<String> apiValues = ModISecurityUtils.getProfiloSicurezzaMessaggioConSorgenteToken(api, portType);
        if (apiValues != null && !apiValues.isEmpty()) {
            for (String sicurezzaMessaggioSorgenteToken : apiValues) {
                List splitValues = RegistroServiziUtils.splitPropertyProtocolloResult((String)sicurezzaMessaggioSorgenteToken);
                String sicurezzaMessaggio = (String)splitValues.get(0);
                String sorgenteToken = (String)splitValues.get(1);
                if (!("idam01".equals(sicurezzaMessaggio) || "idam02".equals(sicurezzaMessaggio) ? ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken) : "idam0301".equals(sicurezzaMessaggio) || "idam0302".equals(sicurezzaMessaggio) || "idam0401".equals(sicurezzaMessaggio) || "idam0402".equals(sicurezzaMessaggio))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSicurezzaMessaggioRiferimentoX509Required(AccordoServizioParteComune api, String portType) {
        List<String> apiValues = ModISecurityUtils.getProfiloSicurezzaMessaggioConSorgenteToken(api, portType);
        if (apiValues != null && !apiValues.isEmpty()) {
            for (String sicurezzaMessaggioSorgenteToken : apiValues) {
                List splitValues = RegistroServiziUtils.splitPropertyProtocolloResult((String)sicurezzaMessaggioSorgenteToken);
                String sicurezzaMessaggio = (String)splitValues.get(0);
                String sorgenteToken = (String)splitValues.get(1);
                boolean x509 = false;
                if ("idam01".equals(sicurezzaMessaggio) || "idam02".equals(sicurezzaMessaggio)) {
                    x509 = ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken);
                } else if ("idam0301".equals(sicurezzaMessaggio) || "idam0302".equals(sicurezzaMessaggio)) {
                    x509 = true;
                } else if ("idam0401".equals(sicurezzaMessaggio) || "idam0402".equals(sicurezzaMessaggio)) {
                    x509 = ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken);
                }
                if (!x509) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSicurezzaMessaggioKidModeSupported(AccordoServizioParteComune api, String portType) {
        List<String> apiValues = ModISecurityUtils.getProfiloSicurezzaMessaggioConSorgenteToken(api, portType);
        if (apiValues != null && !apiValues.isEmpty()) {
            for (String sicurezzaMessaggioSorgenteToken : apiValues) {
                List splitValues = RegistroServiziUtils.splitPropertyProtocolloResult((String)sicurezzaMessaggioSorgenteToken);
                String sicurezzaMessaggio = (String)splitValues.get(0);
                String sorgenteToken = (String)splitValues.get(1);
                if (!("idam01".equals(sicurezzaMessaggio) || "idam02".equals(sicurezzaMessaggio) ? !ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(sorgenteToken) : "idam0401".equals(sicurezzaMessaggio) || "idam0402".equals(sicurezzaMessaggio))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean existsAlmostOneProfiloSicurezzaMessaggioGenerazioneTokenIdAuthRemoto(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageSorgenteToken", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String sorgenteToken : tmp) {
                if (!"pdnd".equals(sorgenteToken) && !"oauth".equals(sorgenteToken)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean existsAlmostOneProfiloSicurezzaMessaggioGenerazioneTokenIdAuthLocale(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageSorgenteToken", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String sorgenteToken : tmp) {
                if ("pdnd".equals(sorgenteToken) || "oauth".equals(sorgenteToken)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSicurezzaMessaggioGenerazioneTokenIdAuthLocale(String sorgenteToken) {
        return !"pdnd".equals(sorgenteToken) && !"oauth".equals(sorgenteToken);
    }

    public static boolean isSicurezzaMessaggioGenerazioneTokenIdAuthPDND(AccordoServizioParteComune api, String portType) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageSorgenteToken", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String sorgenteToken : tmp) {
                if (!ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthPDND(sorgenteToken)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSicurezzaMessaggioGenerazioneTokenIdAuthPDND(String sorgenteToken) {
        return "pdnd".equals(sorgenteToken);
    }

    public static boolean isProfiloSicurezzaMessaggioApplicabileRichiesta(AccordoServizioParteComune api, String portType, boolean sicurezzaRequired) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageConfig", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String applicabilita : tmp) {
                if (ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabile(applicabilita, true)) {
                    return true;
                }
                if (!"custom".equals(applicabilita) || !ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRichiestaCustom(api, portType)) continue;
                return true;
            }
            return false;
        }
        return sicurezzaRequired;
    }

    public static boolean isProfiloSicurezzaMessaggioApplicabileRisposta(AccordoServizioParteComune api, String portType, boolean sicurezzaRequired) {
        List<String> tmp = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityMessageConfig", api, portType, false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String applicabilita : tmp) {
                if (ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabile(applicabilita, false)) {
                    return true;
                }
                if (!"custom".equals(applicabilita) || !ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRispostaCustom(api, portType)) continue;
                return true;
            }
            return false;
        }
        return sicurezzaRequired;
    }

    private static boolean isProfiloSicurezzaMessaggioApplicabile(String applicabilita, boolean richiesta) {
        if (richiesta) {
            return "entrambi".equals(applicabilita) || "richiesta".equals(applicabilita) || "entrambi_attachments".equals(applicabilita) || "richiesta_attachments".equals(applicabilita);
        }
        return "entrambi".equals(applicabilita) || "risposta".equals(applicabilita) || "entrambi_attachments".equals(applicabilita) || "risposta_attachments".equals(applicabilita);
    }

    private static boolean isProfiloSicurezzaMessaggioApplicabileRichiestaCustom(AccordoServizioParteComune api, String portType) {
        List<String> tmpCustom = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityRequest", api, portType, false);
        if (tmpCustom != null && !tmpCustom.isEmpty()) {
            for (String profiloSicurezzaMessaggioCustom : tmpCustom) {
                if (!"true".equals(profiloSicurezzaMessaggioCustom) && !"custom".equals(profiloSicurezzaMessaggioCustom)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isProfiloSicurezzaMessaggioApplicabileRispostaCustom(AccordoServizioParteComune api, String portType) {
        List<String> tmpCustom = ModISecurityUtils.getPropertySicurezzaMessaggioEngine("modipaSecurityResponse", api, portType, false);
        if (tmpCustom != null && !tmpCustom.isEmpty()) {
            for (String profiloSicurezzaMessaggioCustom : tmpCustom) {
                if (!"true".equals(profiloSicurezzaMessaggioCustom) && !"custom".equals(profiloSicurezzaMessaggioCustom)) continue;
                return true;
            }
        }
        return false;
    }
}

