/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public class JMSConnectionInfo {
    private final String connectionID;
    private final String clientAddress;
    private final long creationTime;
    private final String clientID;
    private final String username;

    public static JMSConnectionInfo[] from(String jsonString) throws Exception {
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JMSConnectionInfo[] infos = new JMSConnectionInfo[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JMSConnectionInfo info;
            JsonObject obj = array.getJsonObject(i);
            String cid = obj.containsKey((Object)"clientID") ? obj.getString("clientID") : null;
            String uname = obj.containsKey((Object)"principal") ? obj.getString("principal") : null;
            infos[i] = info = new JMSConnectionInfo(obj.getString("connectionID"), obj.getString("clientAddress"), obj.getJsonNumber("creationTime").longValue(), cid, uname);
        }
        return infos;
    }

    private JMSConnectionInfo(String connectionID, String clientAddress, long creationTime, String clientID, String username) {
        this.connectionID = connectionID;
        this.clientAddress = clientAddress;
        this.creationTime = creationTime;
        this.clientID = clientID;
        this.username = username;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getUsername() {
        return this.username;
    }
}

