/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.dynamic.components;

import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.exceptions.ParameterException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.dynamic.components.BaseComponent;

public class CheckBox
extends BaseComponent<Boolean> {
    public CheckBox(Parameter<Boolean> parameter, IDynamicLoader loader) {
        super(parameter, loader);
    }

    @Override
    public DataElement toDataElement() throws ParameterException {
        DataElement de = new DataElement();
        de.setName(this.getId());
        de.setLabel(this.getRendering().getLabel());
        de.setLabelRight(this.getRendering().getLabelRight());
        de.setPostBack_viaPOST(this.getRefreshParamIds().size() > 0);
        de.setRequired(this.getRendering().isRequired());
        de.setNote(this.getRendering().getSuggestion());
        de.setType(DataElementType.CHECKBOX);
        de.setValue((Boolean)this.getValue() != false ? "yes" : "no");
        de.setSelected((Boolean)this.getValue() != false ? "yes" : "no");
        return de;
    }

    @Override
    public void setValueFromRequest(String parameterValue) throws ParameterException {
        if (parameterValue == null) {
            if (((Boolean)this.getRendering().getDefaultValue()).booleanValue()) {
                this.setValue((Boolean)this.getRendering().getDefaultValue());
            } else {
                this.setValue(null);
            }
        } else {
            this.setValue(ServletUtils.isCheckBoxEnabled(parameterValue));
        }
    }
}

