/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.login;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.lib.mvc.login.LoginAttempt;
import org.slf4j.Logger;

public class FailedAttempts {
    private ConcurrentMap<String, LoginAttempt> failedAttemptsMap = new ConcurrentHashMap<String, LoginAttempt>();
    private List<Duration> failedDelays;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FailedAttempts getInstance() {
        Class<FailedAttempts> clazz = FailedAttempts.class;
        synchronized (FailedAttempts.class) {
            if (Holder.instance == null) {
                throw new IllegalStateException("Instance not initialized. Call createInstance() first.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Holder.instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createInstance(String loginRetryDelays) throws UtilsException {
        Class<FailedAttempts> clazz = FailedAttempts.class;
        synchronized (FailedAttempts.class) {
            if (Holder.instance != null) {
                throw new UtilsException("Instance already created");
            }
            Holder.instance = new FailedAttempts(loginRetryDelays);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private FailedAttempts(String loginRetryDelays) throws UtilsException {
        List<Duration> loginRertyDelays = this.getFailedAttemptDelay(loginRetryDelays);
        this.failedDelays = new ArrayList<Duration>(loginRertyDelays);
    }

    public LoginAttempt get(String username) {
        return (LoginAttempt)this.failedAttemptsMap.get(username);
    }

    public boolean bloccaUtente(Logger log, String username) {
        LoginAttempt attempt = this.get(username);
        if (attempt != null && attempt.getExpiring().isAfter(Instant.now())) {
            log.error("Accesso fallito utente: {} utente bloccato causa troppi tentativi fino a: {}", (Object)username, (Object)attempt.getExpiring());
            return true;
        }
        return false;
    }

    public List<Duration> getFailedAttemptDelay(String loginRetryDelays) throws UtilsException {
        List<String> prop = List.of(loginRetryDelays.split(","));
        ArrayList<Duration> parsedProp = new ArrayList<Duration>();
        Integer prev = 0;
        for (String p : prop) {
            Integer curr = Integer.parseInt(p.trim());
            if (prev > curr) {
                throw new UtilsException("I tempi di attesa nel caso di credenziali errate devono essere incrementali");
            }
            parsedProp.add(Duration.ofSeconds(curr.intValue()));
        }
        return parsedProp;
    }

    public void aggiungiTentativoFallitoUtente(Logger log, String username) {
        this.failedAttemptsMap.compute(username, (key, value) -> {
            int retries = (value == null ? 0 : value.getRetries()) + 1;
            Instant expires = Instant.now().plus(this.computeUserLockAmount(retries));
            log.error("utente {} password errata, tentativo: {}, utente sbloccato dopo: {}", new Object[]{username, retries, expires});
            return new LoginAttempt(expires, retries);
        });
    }

    private TemporalAmount computeUserLockAmount(int retries) {
        return this.failedDelays.get(Math.min(retries - 1, this.failedDelays.size() - 1));
    }

    public void resetTentativiUtente(Logger log, String username) {
        log.debug("utente {} password corrretta", (Object)username);
        this.failedAttemptsMap.remove(username);
    }

    private static class Holder {
        private static FailedAttempts instance;

        private Holder() {
        }
    }
}

