/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.properties.beans;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.Property;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.web.lib.mvc.byok.LockUtilities;
import org.openspcoop2.web.lib.mvc.properties.beans.BaseItemBean;
import org.openspcoop2.web.lib.mvc.properties.exception.ConditionException;
import org.openspcoop2.web.lib.mvc.properties.exception.UserInputValidationException;
import org.openspcoop2.web.lib.mvc.properties.exception.ValidationException;
import org.openspcoop2.web.lib.mvc.properties.utils.ConditionsEngine;

public class ConfigBean {
    private String id = null;
    private List<String> listaNomiProperties = new ArrayList<String>();
    private List<String> listaKeysItem = new ArrayList<String>();
    private Map<String, BaseItemBean<?>> mapItem = new HashMap();
    private Map<String, List<BaseItemBean<?>>> mapPropertyItem = new HashMap();
    private IProvider provider;

    public ConfigBean(IProvider provider) {
        this.provider = provider;
    }

    public void clear() {
        this.listaNomiProperties.clear();
        this.listaKeysItem.clear();
        this.mapItem.clear();
        this.mapPropertyItem.clear();
    }

    public void addItem(BaseItemBean<?> item) throws ValidationException {
        if (this.mapItem.containsKey(item.getName())) {
            throw new ValidationException("Item [" + item.getName() + "] viola il vincolo di univocita' degli elementi: rinominare uno dei due item.");
        }
        this.listaKeysItem.add(item.getName());
        this.mapItem.put(item.getName(), item);
        if (item.getSaveProperty() != null) {
            List<BaseItemBean<?>> lstItems = null;
            lstItems = this.mapPropertyItem.containsKey(item.getSaveProperty().getName()) ? this.mapPropertyItem.remove(item.getSaveProperty().getName()) : new ArrayList();
            lstItems.add(item);
            this.mapPropertyItem.put(item.getSaveProperty().getName(), lstItems);
        }
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public BaseItemBean<?> getItem(String name) {
        return this.mapItem.get(name);
    }

    public List<String> getListakeys() {
        return this.listaKeysItem;
    }

    public List<BaseItemBean<?>> getListaItem() {
        ArrayList lista = new ArrayList();
        for (String key : this.listaKeysItem) {
            lista.add(this.mapItem.get(key));
        }
        return lista;
    }

    public List<?> getListaItemSDK() {
        List<BaseItemBean<?>> list = this.getListaItem();
        if (list != null && !list.isEmpty()) {
            ArrayList l = new ArrayList();
            for (BaseItemBean<?> base : list) {
                l.add(base.getItem());
            }
            return l;
        }
        return null;
    }

    public Map<String, Properties> getPropertiesMap() {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        List<BaseItemBean<?>> listaItem = this.getListaItem();
        for (BaseItemBean<?> item : listaItem) {
            Property saveProperty = item.getSaveProperty();
            String itemValue = item.getPropertyValue();
            boolean save = saveProperty != null && (saveProperty.isForce() || StringUtils.isNotEmpty((String)itemValue) && item.isVisible());
            if (!save) continue;
            String propertyName = saveProperty.getName();
            String propertiesName = saveProperty.getProperties() != null ? saveProperty.getProperties() : "___defaultMap";
            Properties p = null;
            p = map.containsKey(propertiesName) ? (Properties)map.remove(propertiesName) : new Properties();
            map.put(propertiesName, p);
            if (!saveProperty.isAppend()) {
                p.setProperty(propertyName, itemValue);
                continue;
            }
            String appendPropertyKey = "___" + propertyName;
            Object appendKeyPropertyValue = null;
            if (p.containsKey(appendPropertyKey)) {
                appendKeyPropertyValue = p.getProperty(appendPropertyKey);
                p.remove(appendPropertyKey);
                appendKeyPropertyValue = (String)appendKeyPropertyValue + "_@@_";
                appendKeyPropertyValue = (String)appendKeyPropertyValue + item.getName();
            } else {
                appendKeyPropertyValue = item.getName();
            }
            p.setProperty(appendPropertyKey, (String)appendKeyPropertyValue);
            Object apValue = null;
            if (p.containsKey(propertyName)) {
                apValue = p.getProperty(propertyName);
                p.remove(propertyName);
                apValue = (String)apValue + saveProperty.getAppendSeparator();
                apValue = (String)apValue + itemValue;
            } else {
                apValue = itemValue;
            }
            p.setProperty(propertyName, (String)apValue);
        }
        return map;
    }

    public void setValueFromRequest(String name, String parameterValue, ExternalResources externalResources, LockUtilities lockUtilities) throws ProviderException {
        this.getItem(name).setValueFromRequest(parameterValue, externalResources, lockUtilities);
    }

    public void updateConfigurazione(Config config) throws ConditionException {
        List<BaseItemBean<?>> listaItem = this.getListaItem();
        for (BaseItemBean<?> item : listaItem) {
            boolean resolve = ConditionsEngine.resolve(item.getConditions(), this);
            item.setVisible(resolve);
        }
        ConditionsEngine.controllaSezioniDaNascondere(config, this);
    }

    public void validazioneInputUtente(String nome, String descrizione, Config config, ExternalResources externalResources) throws UserInputValidationException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ProviderException, ProviderValidationException {
        List<BaseItemBean<?>> listaItem = this.getListaItem();
        for (BaseItemBean<?> item : listaItem) {
            item.validate(externalResources);
        }
        IProvider provider = null;
        if (StringUtils.isNotEmpty((String)config.getProvider())) {
            try {
                provider = (IProvider)ClassLoaderUtilities.newInstance((String)config.getProvider());
            }
            catch (Exception e) {
                throw new ProviderException("Errore durante l'istanziazione del provider [" + config.getProvider() + "]: " + e.getMessage(), (Throwable)e);
            }
            provider.validateId(nome);
            provider.validateDescription(descrizione);
            provider.validate(this.getPropertiesMap());
        }
    }

    public List<String> getListaNomiProperties() {
        return this.listaNomiProperties;
    }

    public Map<String, List<BaseItemBean<?>>> getMapPropertyItem() {
        return this.mapPropertyItem;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

