/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.properties.utils;

import java.util.List;
import org.openspcoop2.core.mvc.properties.Condition;
import org.openspcoop2.core.mvc.properties.Conditions;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.Defined;
import org.openspcoop2.core.mvc.properties.Equals;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.Section;
import org.openspcoop2.core.mvc.properties.Selected;
import org.openspcoop2.core.mvc.properties.Subsection;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.properties.beans.BaseItemBean;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.openspcoop2.web.lib.mvc.properties.exception.ConditionException;
import org.openspcoop2.web.lib.mvc.properties.utils.EqualsType;

public class ConditionsEngine {
    public static boolean resolve(Conditions conditions, ConfigBean configBean) throws ConditionException {
        try {
            if (conditions == null) {
                return true;
            }
            boolean isAnd = conditions.getAnd();
            boolean isNot = conditions.getNot();
            boolean esito = isAnd;
            for (Condition condition : conditions.getConditionList()) {
                boolean resCondition = ConditionsEngine.resolve(condition, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            return isNot ? !esito : esito;
        }
        catch (Exception e) {
            throw new ConditionException("Errore durante la risoluzione delle Conditions: " + conditions.toString(), e);
        }
    }

    public static boolean resolve(Condition condition, ConfigBean configBean) throws ConditionException {
        try {
            boolean resCondition;
            boolean isAnd = condition.getAnd();
            boolean isNot = condition.getNot();
            boolean esito = isAnd;
            for (Defined defined : condition.getDefinedList()) {
                resCondition = ConditionsEngine.resolveDefined(defined, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getEqualsList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.EQUALS, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getLessThenList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.LESS_THEN, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getLessEqualsList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.LESS_EQUALS, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getGreaterThenList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.GREATER_THEN, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getGreaterEqualsList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.GREATER_EQUALS, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getStartsWithList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.STARTS_WITH, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Equals equals : condition.getEndsWithList()) {
                resCondition = ConditionsEngine.resolveEquals(EqualsType.ENDS_WITH, equals, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            for (Selected selected : condition.getSelectedList()) {
                resCondition = ConditionsEngine.resolveSelected(selected, configBean);
                esito = isAnd ? esito && resCondition : esito || resCondition;
            }
            return isNot ? !esito : esito;
        }
        catch (Exception e) {
            throw new ConditionException("Errore durante la risoluzione della Condition: " + condition.toString(), e);
        }
    }

    public static boolean resolveSelected(Selected selected, ConfigBean configBean) throws ConditionException {
        try {
            boolean esito;
            String elementName = selected.getName();
            boolean isNot = selected.getNot();
            BaseItemBean<?> item = configBean.getItem(elementName);
            boolean bl = esito = item.isVisible() && ServletUtils.isCheckBoxEnabled(item.getValue());
            return isNot ? !esito : esito;
        }
        catch (Exception e) {
            throw new ConditionException("Errore durante la risoluzione della condizione Selected: " + selected.toString(), e);
        }
    }

    public static boolean resolveEquals(EqualsType equalsType, Equals equals, ConfigBean configBean) throws ConditionException {
        try {
            boolean esito;
            String elementName = equals.getName();
            boolean isNot = equals.getNot();
            String value = equals.getValue();
            BaseItemBean<?> item = configBean.getItem(elementName);
            boolean opValue = false;
            if (item.isVisible()) {
                switch (equalsType) {
                    case EQUALS: {
                        opValue = value.equals(item.getValue());
                        break;
                    }
                    case LESS_THEN: {
                        opValue = item.getValue() != null && value.compareTo(item.getValue()) < 0;
                        break;
                    }
                    case LESS_EQUALS: {
                        opValue = value.equals(item.getValue()) || item.getValue() != null && value.compareTo(item.getValue()) < 0;
                        break;
                    }
                    case GREATER_THEN: {
                        opValue = item.getValue() != null && value.compareTo(item.getValue()) > 0;
                        break;
                    }
                    case GREATER_EQUALS: {
                        opValue = value.equals(item.getValue()) || item.getValue() != null && value.compareTo(item.getValue()) > 0;
                        break;
                    }
                    case STARTS_WITH: {
                        opValue = item.getValue() != null && value != null && item.getValue().startsWith(value);
                        break;
                    }
                    case ENDS_WITH: {
                        opValue = item.getValue() != null && value != null && item.getValue().endsWith(value);
                    }
                }
            }
            boolean bl = esito = item.isVisible() && opValue;
            return isNot ? !esito : esito;
        }
        catch (Exception e) {
            throw new ConditionException("Errore durante la risoluzione della condizione Equals: " + equals.toString(), e);
        }
    }

    public static boolean resolveDefined(Defined defined, ConfigBean configBean) throws ConditionException {
        try {
            boolean esito;
            String elementName = defined.getName();
            boolean isNot = defined.getNot();
            BaseItemBean<?> item = configBean.getItem(elementName);
            boolean bl = esito = item.isVisible() && item.getValue() != null;
            return isNot ? !esito : esito;
        }
        catch (Exception e) {
            throw new ConditionException("Errore durante la risoluzione della condizione Defined: " + defined.toString(), e);
        }
    }

    public static boolean controllaSezioniDaNascondere(Config config, ConfigBean cbTmp) throws ConditionException {
        List sectionList = config.getSectionList();
        boolean show = true;
        for (int i = 0; i < sectionList.size(); ++i) {
            Section section = (Section)sectionList.get(i);
            show = ConditionsEngine.showSection(section, "s" + i, cbTmp);
        }
        return show;
    }

    private static boolean showSection(Section section, String sectionIdx, ConfigBean cbTmp) throws ConditionException {
        BaseItemBean<?> itemSection = cbTmp.getItem(sectionIdx);
        boolean show = itemSection.isVisible();
        if (!show) {
            if (section.getItemList() != null) {
                for (Item item : section.getItemList()) {
                    BaseItemBean<?> item3 = cbTmp.getItem(item.getName());
                    item3.setVisible(show);
                }
            }
            if (section.getSubsectionList() != null) {
                for (int i = 0; i < section.getSubsectionList().size(); ++i) {
                    Subsection subSection = (Subsection)section.getSubsectionList().get(i);
                    ConditionsEngine.showSubsection(subSection, sectionIdx + "_ss" + i, cbTmp, show);
                }
            }
        } else {
            boolean allItemHidden = true;
            boolean allSubSectionHidden = true;
            if (section.getItemList() != null) {
                for (Item item : section.getItemList()) {
                    BaseItemBean<?> item3 = cbTmp.getItem(item.getName());
                    if (!item3.isVisible()) continue;
                    allItemHidden = false;
                    break;
                }
            }
            if (section.getSubsectionList() != null) {
                for (int i = 0; i < section.getSubsectionList().size(); ++i) {
                    Subsection subSection = (Subsection)section.getSubsectionList().get(i);
                    if (!ConditionsEngine.showSubsection(subSection, sectionIdx + "_ss" + i, cbTmp, show)) continue;
                    if (allSubSectionHidden) {
                        // empty if block
                    }
                    allSubSectionHidden = false;
                }
            }
            show = !allItemHidden || !allSubSectionHidden;
        }
        itemSection.setVisible(show);
        return show;
    }

    private static boolean showSubsection(Subsection subSection, String subsectionIdx, ConfigBean cbTmp, boolean showParent) throws ConditionException {
        boolean show;
        BaseItemBean<?> itemSubSection = cbTmp.getItem(subsectionIdx);
        boolean bl = show = !showParent ? false : itemSubSection.isVisible();
        if (!show) {
            for (Item item : subSection.getItemList()) {
                BaseItemBean<?> item3 = cbTmp.getItem(item.getName());
                item3.setVisible(show);
            }
        } else {
            boolean allHidden = true;
            for (Item item : subSection.getItemList()) {
                BaseItemBean<?> item3 = cbTmp.getItem(item.getName());
                if (!item3.isVisible()) continue;
                allHidden = false;
                break;
            }
            show = !allHidden;
        }
        itemSubSection.setVisible(show);
        return show;
    }
}

