/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.authorization;

import java.util.List;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autorizzazione.pd.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazionePortaDelegata;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.utils.SignalHubUtils;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;

public class AutorizzazioneSignalHubPush
extends AbstractAutorizzazioneBase {
    private static final String GENERIC_ERROR = "Errore di processamento dell'autorizzazione signal hub";
    private static final String ROLE_SERVICE_UNRECOGNIZED = "L'applicativo autenticato non \u00e8 configurato come pubblicatore del servizio indicato, n\u00e9 tramite assegnazione diretta n\u00e9 mediante ruolo associato";

    public boolean saveAuthorizationResultInCache() {
        return false;
    }

    public EsitoAutorizzazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) {
        try {
            ModIProperties modiProperties = ModIProperties.getInstance();
            if (!modiProperties.isSignalHubEnabled()) {
                throw new ProtocolException("La funzionalit\u00e0 SignalHub non \u00e8 attiva");
            }
            return this.processEngine(datiInvocazione);
        }
        catch (ProtocolException e) {
            return this.buildConfigurazioneNonDisponibile(null, (Exception)((Object)e));
        }
    }

    private EsitoAutorizzazionePortaDelegata buildConfigurazioneNonDisponibile(String descrizioneErrore, Exception e) {
        EsitoAutorizzazionePortaDelegata esito = new EsitoAutorizzazionePortaDelegata();
        esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, descrizioneErrore != null ? ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(descrizioneErrore, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE) : ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
        esito.setAutorizzato(false);
        esito.setDetails(GENERIC_ERROR);
        esito.setEccezioneProcessamento(e);
        return esito;
    }

    public EsitoAutorizzazionePortaDelegata processEngine(DatiInvocazionePortaDelegata datiInvocazione) throws ProtocolException {
        EsitoAutorizzazionePortaDelegata esito = new EsitoAutorizzazionePortaDelegata();
        PdDContext context = datiInvocazione.getPddContext();
        List<ProtocolProperty> eServiceProperties = SignalHubUtils.obtainSignalHubProtocolProperty((Context)context);
        String allowedService = null;
        try {
            allowedService = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(eServiceProperties, (String)"modipaInfoGenSignalHubPulisherSA");
        }
        catch (Exception e) {
            if (this.getProtocolFactory().getLogger() != null) {
                this.getProtocolFactory().getLogger().error("Configurazione SignalHub non fornita per il servizio indicato: " + e.getMessage(), (Throwable)e);
            }
            return this.buildConfigurazioneNonDisponibile("Configurazione SignalHub non fornita per il servizio indicato", e);
        }
        String allowedRole = null;
        try {
            allowedRole = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(eServiceProperties, (String)"modipaInfoGenSignalHubPulisherRole");
        }
        catch (Exception e) {
            if (this.getProtocolFactory().getLogger() != null) {
                this.getProtocolFactory().getLogger().error("Configurazione SignalHub non fornita per il servizio indicato: " + e.getMessage(), (Throwable)e);
            }
            return this.buildConfigurazioneNonDisponibile("Configurazione SignalHub non fornita per il servizio indicato", e);
        }
        List roles = List.of();
        if (datiInvocazione.getServizioApplicativo() != null && datiInvocazione.getServizioApplicativo().getInvocazionePorta() != null && datiInvocazione.getServizioApplicativo().getInvocazionePorta().getRuoli() != null) {
            roles = datiInvocazione.getServizioApplicativo().getInvocazionePorta().getRuoli().getRuoloList();
        }
        for (Ruolo role : roles) {
            if (!role.getNome().equals(allowedRole)) continue;
            esito.setAutorizzato(true);
            return esito;
        }
        if (datiInvocazione.getIdServizioApplicativo() == null) {
            esito.setAutorizzato(false);
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriIntegrazione.ERRORE_410_AUTENTICAZIONE_RICHIESTA.getErroreIntegrazione());
        } else if (!allowedService.equals(datiInvocazione.getIdServizioApplicativo().getNome())) {
            esito.setAutorizzato(false);
            esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(datiInvocazione.getIdServizioApplicativo().getNome()));
            esito.setDetails(ROLE_SERVICE_UNRECOGNIZED);
        } else {
            esito.setAutorizzato(true);
        }
        return esito;
    }
}

