/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.config;

import java.util.Map;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.config.BasicManager;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.FaultIntegrationGenericInfoMode;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class ModIProtocolManager
extends BasicManager {
    protected ModIProperties modipaProperties = null;
    protected Logger logger = this.getProtocolFactory().getLogger();

    public ModIProtocolManager(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
        this.modipaProperties = ModIProperties.getInstance();
    }

    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        return true;
    }

    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneValidazione() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultProtocolValidazione();
    }

    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
    }

    public boolean isGenerazioneDetailsFaultProtocolloConStackTrace() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
    }

    public boolean isGenerazioneDetailsFaultProtocolloConInformazioniGeneriche() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
    }

    public boolean isGenerazioneDetailsFaultIntegratione_erroreServer() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultIntegrationServerError();
    }

    public boolean isGenerazioneDetailsFaultIntegratione_erroreClient() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultIntegrationClientError();
    }

    public boolean isGenerazioneDetailsFaultIntegrationeConStackTrace() {
        return this.modipaProperties.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
    }

    public FaultIntegrationGenericInfoMode getModalitaGenerazioneInformazioniGeneriche_DetailsFaultIntegrazione() {
        Boolean value = this.modipaProperties.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
        if (value == null) {
            return FaultIntegrationGenericInfoMode.SERVIZIO_APPLICATIVO;
        }
        if (value.booleanValue()) {
            return FaultIntegrationGenericInfoMode.ABILITATO;
        }
        return FaultIntegrationGenericInfoMode.DISABILITATO;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultApplicativo() {
        return this.modipaProperties.isAggiungiDetailErroreApplicativoSoapFaultApplicativo();
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultPdD() {
        return this.modipaProperties.isAggiungiDetailErroreApplicativoSoapFaultPdD();
    }

    public Map<String, String> buildIntegrationProperties(Busta busta, boolean isRichiesta, TipoIntegrazione tipoIntegrazione) throws ProtocolException {
        return null;
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext, IRegistryReader registryReader, boolean integration) throws ProtocolException {
        if (integration) {
            try {
                String asyncInteractionRole;
                String asyncInteractionType;
                boolean createCorrelationIdIfNotExists = false;
                if (msg != null) {
                    createCorrelationIdIfNotExists = ServiceBinding.REST.equals((Object)msg.getServiceBinding()) ? this.modipaProperties.isRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists() : this.modipaProperties.isSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists();
                }
                if (busta != null && createCorrelationIdIfNotExists && "PUSH".equals(asyncInteractionType = busta.getProperty("ProfiloInterazioneAsincrona-Tipo")) && "Richiesta".equals(asyncInteractionRole = busta.getProperty("ProfiloInterazioneAsincrona-Ruolo")) && ServiceBinding.REST.equals((Object)msg.getServiceBinding())) {
                    String headerCorrelationId = this.modipaProperties.getRestCorrelationIdHeader();
                    String correlationIdFound = msg.getTransportResponseContext().getHeaderFirstValue(headerCorrelationId);
                    if (correlationIdFound == null || "".equals(correlationIdFound)) {
                        TransportUtils.addHeader((Map)msg.getTransportResponseContext().getHeaders(), (String)headerCorrelationId, (String)"__@@SkipValidation##__");
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return super.updateOpenSPCoop2MessageResponse(msg, busta, notifierInputStreamParams, transportRequestContext, transportResponseContext, registryReader, integration);
    }

    public boolean isSuccessfulHttpRedirectStatusCode(ServiceBinding serviceBinding) throws ProtocolException {
        return ServiceBinding.REST.equals((Object)serviceBinding);
    }
}

