/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.util.List;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.utils.ModIKeystoreUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreParams;

public class ModIKeystoreConfig
extends ModIKeystoreUtils {
    private static ModIProperties modIProperties = null;

    public static boolean isKeystoreDefinitoInFruizione(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        String mode = ModIKeystoreConfig.getKeystoreDefinitoIn(soggettoFruitore, asps);
        return mode != null && "fruizione".equals(mode);
    }

    public static boolean isKeystoreDefinitoInTokenPolicy(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        String mode = ModIKeystoreConfig.getKeystoreDefinitoIn(soggettoFruitore, asps);
        return mode != null && "token".equals(mode);
    }

    private static String getKeystoreDefinitoIn(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        boolean fruizione = true;
        List<ProtocolProperty> listProtocolProperties = ModIPropertiesUtils.getProtocolProperties(fruizione, soggettoFruitore, asps);
        return ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)"modipaKeystoreFruizioneMode");
    }

    public ModIKeystoreConfig(ServizioApplicativo sa, String securityMessageProfile) throws ProtocolException, UtilsException {
        super(sa, securityMessageProfile);
    }

    public ModIKeystoreConfig(boolean fruizione, IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, String securityMessageProfile) throws ProtocolException, UtilsException {
        super(fruizione, soggettoFruitore, asps, securityMessageProfile, ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStoreTipo(), ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStorePath(), ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStorePassword(), ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyAlias(), ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyPassword());
    }

    public ModIKeystoreConfig(KeystoreParams kp) throws ProtocolException, UtilsException {
        super(kp);
    }

    private static synchronized void initModiProperties() throws ProtocolException {
        if (modIProperties == null) {
            modIProperties = ModIProperties.getInstance();
        }
    }

    private static ModIProperties getModiProperties() throws ProtocolException {
        if (modIProperties == null) {
            ModIKeystoreConfig.initModiProperties();
        }
        return modIProperties;
    }

    private static String getSicurezzaMessaggioCertificatiKeyStoreTipo() throws ProtocolException {
        try {
            return ModIKeystoreConfig.getModiProperties().getSicurezzaMessaggioCertificatiKeyStoreTipo();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getSicurezzaMessaggioCertificatiKeyStorePath() throws ProtocolException {
        try {
            if (ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStoreTipo() != null) {
                return ModIKeystoreConfig.getModiProperties().getSicurezzaMessaggioCertificatiKeyStorePath();
            }
            return null;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getSicurezzaMessaggioCertificatiKeyStorePassword() throws ProtocolException {
        try {
            if (ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStoreTipo() != null) {
                return ModIKeystoreConfig.getModiProperties().getSicurezzaMessaggioCertificatiKeyStorePassword();
            }
            return null;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getSicurezzaMessaggioCertificatiKeyAlias() throws ProtocolException {
        try {
            if (ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStoreTipo() != null) {
                return ModIKeystoreConfig.getModiProperties().getSicurezzaMessaggioCertificatiKeyAlias();
            }
            return null;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getSicurezzaMessaggioCertificatiKeyPassword() throws ProtocolException {
        try {
            if (ModIKeystoreConfig.getSicurezzaMessaggioCertificatiKeyStoreTipo() != null) {
                return ModIKeystoreConfig.getModiProperties().getSicurezzaMessaggioCertificatiKeyPassword();
            }
            return null;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

