/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.autorizzazione.canali.CanaliUtils;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.utils.ModIKeystoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.utils.SOAPHeader;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.message.constants.SignatureDigestAlgorithm;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.properties.PropertiesUtilities;

public class ModISecurityConfig {
    private String algorithm;
    private String apiSoapAlgorithmUsedOnlyForAudit;
    private String digestAlgorithm;
    private DigestEncoding digestEncoding;
    private List<DigestEncoding> digestEncodingAccepted;
    private String c14nAlgorithm;
    private boolean kid;
    private boolean x5c;
    private boolean x5t;
    private boolean x5u;
    private String x5url;
    private String keyIdentifierMode;
    private boolean useSingleCertificate;
    private boolean includeSignatureToken;
    private int ttl;
    private Long checkTtlIatMs;
    private String audience;
    private boolean checkAudience;
    private String clientId;
    private String issuer;
    private String subject;
    private List<String> httpHeaders;
    private List<SOAPHeader> soapHeaders;
    private boolean multipleHeaderUseSameJti;
    private boolean multipleHeaderUseJtiAuthorizationAsIdMessaggio;
    private Boolean multipleHeaderAuthorizationConfig;
    private Properties claims;
    private Properties multipleHeaderClaims;
    private List<String> corniceSicurezzaCodiceEnteRule;
    private List<String> corniceSicurezzaUserRule;
    private List<String> corniceSicurezzaIpUserRule;
    private ModIAuditConfig corniceSicurezzaSchemaConfig;
    private String corniceSicurezzaAudience;
    private boolean fruizione;
    private List<ProtocolProperty> listProtocolPropertiesInternal;
    private String tokenKid;
    private String tokenClientId;
    private static final String AUDIENCE_UNDEFINED = "Audience undefined";
    private static final String CONFIGURAZIONE_SICUREZZA_INCOMPLETA = "Configurazione della sicurezza incompleta";
    private static final String RSA = "RSA";
    private static final String ECDSA = "ECDSA";

    public ModISecurityConfig(OpenSPCoop2Message msg, Context context, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo, IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica aspsParam, ServizioApplicativo sa, boolean rest, boolean fruizione, boolean request, String patternCorniceSicurezza, String schemaCorniceSicurezza, Busta busta, Busta bustaRichiesta, Boolean multipleHeaderAuthorizationConfig, boolean keystoreDefinitoInFruizione, boolean keystoreDefinitoInTokenPolicy, String tokenPolicyKid, String tokenPolicyClientId, boolean kidMode, boolean addSecurity, boolean addAudit) throws ProtocolException {
        this.algorithm = null;
        this.apiSoapAlgorithmUsedOnlyForAudit = null;
        this.digestAlgorithm = null;
        this.digestEncoding = null;
        this.digestEncodingAccepted = null;
        this.c14nAlgorithm = null;
        this.kid = false;
        this.x5c = false;
        this.x5t = false;
        this.x5u = false;
        this.x5url = null;
        this.keyIdentifierMode = null;
        this.useSingleCertificate = true;
        this.includeSignatureToken = false;
        this.httpHeaders = new ArrayList<String>();
        this.soapHeaders = new ArrayList<SOAPHeader>();
        this.multipleHeaderUseSameJti = true;
        this.multipleHeaderUseJtiAuthorizationAsIdMessaggio = true;
        this.multipleHeaderAuthorizationConfig = null;
        this.corniceSicurezzaCodiceEnteRule = null;
        this.corniceSicurezzaUserRule = null;
        this.corniceSicurezzaIpUserRule = null;
        this.corniceSicurezzaSchemaConfig = null;
        this.listProtocolPropertiesInternal = null;
        if (msg == null || busta != null) {
            // empty if block
        }
        this.kid = kidMode;
        this.fruizione = fruizione;
        this.multipleHeaderAuthorizationConfig = multipleHeaderAuthorizationConfig;
        ModIProperties modiProperties = ModIProperties.getInstance();
        IDServizio idServizio = null;
        try {
            idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(aspsParam);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        Fruitore fruitore = null;
        if (fruizione) {
            if (soggettoFruitore == null) {
                throw new ProtocolException("Fruitore non fornito");
            }
            boolean find = false;
            for (Fruitore fruitoreCheck : aspsParam.getFruitoreList()) {
                if (!fruitoreCheck.getTipo().equals(soggettoFruitore.getTipo()) || !fruitoreCheck.getNome().equals(soggettoFruitore.getNome())) continue;
                fruitore = fruitoreCheck;
                this.listProtocolPropertiesInternal = fruitoreCheck.getProtocolPropertyList();
                find = true;
                break;
            }
            if (!find) {
                throw new ProtocolException("Fruitore '" + soggettoFruitore + "' non registrato come fruitore dell'accordo parte specifica");
            }
        } else {
            this.listProtocolPropertiesInternal = aspsParam.getProtocolPropertyList();
        }
        if (this.listProtocolPropertiesInternal == null || this.listProtocolPropertiesInternal.isEmpty()) {
            throw new ProtocolException(CONFIGURAZIONE_SICUREZZA_INCOMPLETA);
        }
        if (addAudit && !addSecurity) {
            this.apiSoapAlgorithmUsedOnlyForAudit = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRestRequestAlg");
        }
        if (rest) {
            String idPropertyClaims;
            String claimsPropRegistry;
            String idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio;
            String multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry;
            String idPropertyMultipleHeaderUseSameJti;
            String multipleHeaderUseSameJtiPropRegistry;
            this.initSharedRest(modiProperties, this.listProtocolPropertiesInternal, sa, fruizione, request, keystoreDefinitoInFruizione, keystoreDefinitoInTokenPolicy);
            String httpHeadersPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageHttpHeaders");
            if (httpHeadersPropRegistry != null && httpHeadersPropRegistry.length() > 0) {
                this.httpHeaders = Arrays.asList(httpHeadersPropRegistry.split(","));
            }
            if ((multipleHeaderUseSameJtiPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)(idPropertyMultipleHeaderUseSameJti = fruizione ? "modipaSecurityMessageRequestJti" : "modipaSecurityMessageResponseJti"))) != null) {
                this.multipleHeaderUseSameJti = "same".equals(multipleHeaderUseSameJtiPropRegistry);
            }
            if ((multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)(idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio = fruizione ? "modipaSecurityMessageRequestJtiIdMsg" : "modipaSecurityMessageResponseJtiIdMsg"))) != null) {
                this.multipleHeaderUseJtiAuthorizationAsIdMessaggio = "auth".equals(multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry);
            }
            if ((claimsPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)(idPropertyClaims = fruizione ? "modipaSecurityMessageRequestClaims" : "modipaSecurityMessageResponseClaims"))) != null && claimsPropRegistry.length() > 0) {
                this.claims = PropertiesUtilities.convertTextToProperties((String)claimsPropRegistry);
            }
            if (this.multipleHeaderAuthorizationConfig != null) {
                String idPropertyMultipleHeaderClaims = null;
                idPropertyMultipleHeaderClaims = this.multipleHeaderAuthorizationConfig != false ? (this.fruizione ? "modipaSecurityMessageRequestClaimsAuth" : "modipaSecurityMessageResponseClaimsAuth") : (this.fruizione ? "modipaSecurityMessageRequestClaimsModi" : "modipaSecurityMessageResponseClaimsModi");
                String multipleHeaderClaimsAuthorization = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)idPropertyMultipleHeaderClaims);
                if (multipleHeaderClaimsAuthorization != null && multipleHeaderClaimsAuthorization.length() > 0) {
                    this.multipleHeaderClaims = PropertiesUtilities.convertTextToProperties((String)multipleHeaderClaimsAuthorization);
                }
            }
        } else {
            this.initSharedSoap(this.listProtocolPropertiesInternal, fruizione, request);
            String soapHeadersPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageSoapHeaders");
            if (soapHeadersPropRegistry != null && soapHeadersPropRegistry.length() > 0) {
                this.soapHeaders = SOAPHeader.parse(soapHeadersPropRegistry);
            }
        }
        if (fruizione) {
            if (request) {
                boolean greatherThanZero = true;
                this.ttl = ProtocolPropertiesUtils.getRequiredNumberValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestExp", (boolean)greatherThanZero).intValue();
            }
        } else if (!request) {
            boolean greatherThanZero = true;
            this.ttl = ProtocolPropertiesUtils.getRequiredNumberValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseExp", (boolean)greatherThanZero).intValue();
        }
        if (fruizione && request) {
            String modalita;
            if (this.multipleHeaderAuthorizationConfig != null && !this.multipleHeaderAuthorizationConfig.booleanValue() && "different".equals(modalita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestIntegrityAudMode"))) {
                this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestIntegrityAud");
            }
            if (this.audience == null) {
                this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestAud");
            }
            if (this.audience == null && fruitore.getConnettore() != null && fruitore.getConnettore().sizePropertyList() > 0) {
                for (Property p : fruitore.getConnettore().getPropertyList()) {
                    if (!"location".equals(p.getNome())) continue;
                    this.audience = p.getValore();
                }
            }
            if (this.audience == null) {
                throw new ProtocolException(AUDIENCE_UNDEFINED);
            }
            if (rest) {
                if (this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "client_id")) {
                    this.clientId = ModIUtilities.get(this.multipleHeaderClaims, "client_id", true);
                    if (this.clientId != null && !"${notGenerate}".equalsIgnoreCase(this.clientId)) {
                        this.clientId = null;
                    }
                }
                if (this.clientId == null && ModIUtilities.exists(this.claims, "client_id")) {
                    this.clientId = ModIUtilities.get(this.claims, "client_id", true);
                    if (this.clientId != null && !"${notGenerate}".equalsIgnoreCase(this.clientId)) {
                        this.clientId = null;
                    }
                }
            }
            if (this.clientId == null) {
                if (keystoreDefinitoInFruizione || keystoreDefinitoInTokenPolicy) {
                    try {
                        this.clientId = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((IDServizio)idServizio).replace(" ", "/");
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                if (sa != null) {
                    this.clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityMessageResponseAud");
                    if (this.clientId == null) {
                        try {
                            this.clientId = NamingUtils.getLabelSoggetto((IDSoggetto)new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario())) + "/" + sa.getNome();
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            if (this.tokenClientId == null) {
                if (keystoreDefinitoInFruizione) {
                    this.tokenClientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityOauthId");
                } else if (keystoreDefinitoInTokenPolicy) {
                    this.tokenClientId = tokenPolicyClientId;
                } else if (sa != null) {
                    this.tokenClientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityTokenClientId");
                }
            }
            if (this.tokenKid == null) {
                if (keystoreDefinitoInFruizione) {
                    this.tokenKid = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityOauthKid");
                } else if (keystoreDefinitoInTokenPolicy) {
                    this.tokenKid = tokenPolicyKid;
                } else if (sa != null) {
                    this.tokenKid = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityTokenKID");
                }
            }
            try {
                if (this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "iss")) {
                    this.issuer = ModIUtilities.get(this.multipleHeaderClaims, "iss", false);
                } else if (ModIUtilities.exists(this.claims, "iss")) {
                    this.issuer = ModIUtilities.get(this.claims, "iss", false);
                } else if (modiProperties.isRestSecurityTokenClaimsIssuerEnabled()) {
                    String valore = modiProperties.getRestSecurityTokenClaimsIssuerHeaderValue();
                    if (valore != null && !"".equals(valore)) {
                        this.issuer = valore;
                    } else if (keystoreDefinitoInFruizione || keystoreDefinitoInTokenPolicy) {
                        this.issuer = NamingUtils.getLabelSoggetto((IDSoggetto)soggettoFruitore);
                    } else if (sa != null) {
                        this.issuer = NamingUtils.getLabelSoggetto((IDSoggetto)new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "sub")) {
                    this.subject = ModIUtilities.get(this.multipleHeaderClaims, "sub", false);
                } else if (ModIUtilities.exists(this.claims, "sub")) {
                    this.subject = ModIUtilities.get(this.claims, "sub", false);
                } else if (modiProperties.isRestSecurityTokenClaimsSubjectEnabled()) {
                    String valore = modiProperties.getRestSecurityTokenClaimsSubjectHeaderValue();
                    if (valore != null && !"".equals(valore)) {
                        this.subject = valore;
                    } else if (keystoreDefinitoInFruizione || keystoreDefinitoInTokenPolicy) {
                        this.subject = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((IDServizio)idServizio).replace(" ", "/");
                    } else if (sa != null) {
                        this.subject = sa.getNome();
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (patternCorniceSicurezza != null) {
                if ("old".equals(patternCorniceSicurezza)) {
                    this.readCorniceSicurezzaCodiceEnteLegacy(modiProperties);
                    this.readCorniceSicurezzaUserLegacy(modiProperties);
                    this.readCorniceSicurezzaIpUserLegacy(modiProperties);
                } else {
                    IConfigIntegrationReader configReader = protocolFactory.getCachedConfigIntegrationReader(state, requestInfo);
                    PortaDelegata pd = null;
                    if (msg != null) {
                        Object nomePortaInvocataObject = msg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA);
                        String nomePorta = null;
                        if (nomePortaInvocataObject instanceof String) {
                            nomePorta = (String)nomePortaInvocataObject;
                        }
                        if (nomePorta == null && context != null && context.containsKey(CostantiPdD.NOME_PORTA_INVOCATA)) {
                            nomePorta = (String)context.getObject(CostantiPdD.NOME_PORTA_INVOCATA);
                        }
                        if (nomePorta == null && requestInfo != null && requestInfo.getProtocolContext() != null) {
                            nomePorta = requestInfo.getProtocolContext().getInterfaceName();
                        }
                        if (nomePorta != null) {
                            pd = ModISecurityConfig.getPortaDelegata(nomePorta, configReader);
                        }
                    }
                    this.readCorniceSicurezzaSchema(modiProperties, schemaCorniceSicurezza, pd);
                }
            }
        } else if (!fruizione && !request) {
            if (this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "aud")) {
                this.audience = ModIUtilities.get(this.multipleHeaderClaims, "aud", true);
            } else if (ModIUtilities.exists(this.claims, "aud")) {
                this.audience = ModIUtilities.get(this.claims, "aud", true);
            }
            if (this.audience == null && sa != null) {
                this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityMessageResponseAud");
            }
            if (this.audience == null && kidMode) {
                boolean sicurezzaToken;
                boolean bl = sicurezzaToken = context != null && context.containsKey(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
                if (sicurezzaToken) {
                    InformazioniToken informazioniTokenNormalizzate = null;
                    Object oInformazioniTokenNormalizzate = context.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
                    if (oInformazioniTokenNormalizzate != null) {
                        informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
                    }
                    if (informazioniTokenNormalizzate != null) {
                        if (informazioniTokenNormalizzate.getClientId() != null && StringUtils.isNotEmpty((String)informazioniTokenNormalizzate.getClientId())) {
                            this.audience = informazioniTokenNormalizzate.getClientId();
                        } else if (informazioniTokenNormalizzate.getSub() != null && StringUtils.isNotEmpty((String)informazioniTokenNormalizzate.getSub())) {
                            this.audience = informazioniTokenNormalizzate.getSub();
                        }
                    }
                }
            }
            if (this.audience == null && bustaRichiesta != null) {
                this.audience = bustaRichiesta.getProperty(rest ? "ProfiloSicurezzaMessaggio-ClientId" : "ProfiloSicurezzaMessaggio-WSA-From");
            }
            if (this.audience == null && bustaRichiesta != null) {
                this.audience = bustaRichiesta.getProperty("ProfiloSicurezzaMessaggio-Subject");
            }
            if (this.audience == null && sa != null) {
                try {
                    this.audience = NamingUtils.getLabelSoggetto((IDSoggetto)new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario())) + "/" + sa.getNome();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (this.audience == null) {
                String soggettoMittente = null;
                if (soggettoFruitore != null && soggettoFruitore.getNome() != null) {
                    try {
                        this.audience = NamingUtils.getLabelSoggetto((IDSoggetto)soggettoFruitore);
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                this.audience = rest ? modiProperties.getRestResponseSecurityTokenAudienceDefault(soggettoMittente) : modiProperties.getSoapResponseSecurityTokenAudienceDefault(soggettoMittente);
            }
            try {
                this.clientId = this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "client_id") ? ModIUtilities.get(this.multipleHeaderClaims, "client_id", true) : (ModIUtilities.exists(this.claims, "client_id") ? ModIUtilities.get(this.claims, "client_id", true) : NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((IDServizio)idServizio).replace(" ", "/"));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "iss")) {
                    this.issuer = ModIUtilities.get(this.multipleHeaderClaims, "iss", true);
                } else if (ModIUtilities.exists(this.claims, "iss")) {
                    this.issuer = ModIUtilities.get(this.claims, "iss", true);
                } else if (modiProperties.isRestSecurityTokenClaimsIssuerEnabled()) {
                    String valore = modiProperties.getRestSecurityTokenClaimsIssuerHeaderValue();
                    this.issuer = valore != null && !"".equals(valore) ? valore : NamingUtils.getLabelSoggetto((IDSoggetto)new IDSoggetto(aspsParam.getTipoSoggettoErogatore(), aspsParam.getNomeSoggettoErogatore()));
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, "sub")) {
                    this.subject = ModIUtilities.get(this.multipleHeaderClaims, "sub", true);
                } else if (ModIUtilities.exists(this.claims, "sub")) {
                    this.subject = ModIUtilities.get(this.claims, "sub", true);
                } else if (modiProperties.isRestSecurityTokenClaimsSubjectEnabled()) {
                    String valore = modiProperties.getRestSecurityTokenClaimsSubjectHeaderValue();
                    this.subject = valore != null && !"".equals(valore) ? valore : NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((IDServizio)idServizio).replace(" ", "/");
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (rest) {
                String idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio = "modipaSecurityMessageResponseDuplicateJti";
                String multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio);
                if (multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry != null) {
                    this.multipleHeaderUseJtiAuthorizationAsIdMessaggio = "auth".equals(multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry);
                }
                String keystoreMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaKeystoreCertMode");
                boolean keystoreRidefinito = "ridefinisci".equals(keystoreMode);
                if (this.tokenClientId == null) {
                    this.tokenClientId = keystoreRidefinito ? ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityOauthId") : modiProperties.getSicurezzaMessaggioCertificatiKeyClientId();
                }
                if (this.tokenKid == null) {
                    this.tokenKid = keystoreRidefinito ? ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityOauthKid") : modiProperties.getSicurezzaMessaggioCertificatiKeyKid();
                }
            }
        } else {
            throw new ProtocolException("Use unsupported");
        }
        if (rest) {
            if (this.multipleHeaderAuthorizationConfig != null) {
                ModIUtilities.remove(this.multipleHeaderClaims, "aud");
                ModIUtilities.remove(this.multipleHeaderClaims, "client_id");
                ModIUtilities.remove(this.multipleHeaderClaims, "iss");
                ModIUtilities.remove(this.multipleHeaderClaims, "sub");
            }
            ModIUtilities.remove(this.claims, "aud");
            ModIUtilities.remove(this.claims, "client_id");
            ModIUtilities.remove(this.claims, "iss");
            ModIUtilities.remove(this.claims, "sub");
        }
    }

    private void readCorniceSicurezzaSchemaAudience(String schemaCorniceSicurezza) throws ProtocolException {
        if (schemaCorniceSicurezza != null && StringUtils.isNotEmpty((String)schemaCorniceSicurezza)) {
            String modalita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestAuditAudMode");
            if ("different".equals(modalita)) {
                this.corniceSicurezzaAudience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestAuditAud");
            }
            if (this.corniceSicurezzaAudience == null) {
                this.corniceSicurezzaAudience = this.audience;
            }
            if (this.corniceSicurezzaAudience == null) {
                throw new ProtocolException("Audit Audience undefined");
            }
        }
    }

    private void readCorniceSicurezzaSchema(ModIProperties modiProperties, String schemaCorniceSicurezza, PortaDelegata pd) throws ProtocolException {
        try {
            if (schemaCorniceSicurezza != null && StringUtils.isNotEmpty((String)schemaCorniceSicurezza)) {
                this.readCorniceSicurezzaSchemaAudience(schemaCorniceSicurezza);
                this.readCorniceSicurezzaSchemaClaims(modiProperties, schemaCorniceSicurezza, pd);
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private void readCorniceSicurezzaSchemaClaimsReadPAProperties(ModIProperties modiProperties, String schemaCorniceSicurezza, PortaApplicativa pa) throws ProtocolException {
        if (modiProperties.getAuditConfig() != null && !modiProperties.getAuditConfig().isEmpty()) {
            for (ModIAuditConfig modIAuditConfig : modiProperties.getAuditConfig()) {
                if (!modIAuditConfig.getNome().equals(schemaCorniceSicurezza)) continue;
                this.corniceSicurezzaSchemaConfig = modIAuditConfig.copyNewInstance();
                this.readCorniceSicurezzaSchemaClaimsRuleReadPAProperties(this.corniceSicurezzaSchemaConfig.getClaims(), pa);
                break;
            }
        }
    }

    private void readCorniceSicurezzaSchemaClaimsRuleReadPAProperties(List<ModIAuditClaimConfig> list, PortaApplicativa pa) {
        if (list != null && !list.isEmpty()) {
            for (ModIAuditClaimConfig modIAuditClaimConfig : list) {
                this.readCorniceSicurezzaSchemaClaimRuleReadPAProperties(modIAuditClaimConfig, pa);
            }
        }
    }

    private void readCorniceSicurezzaSchemaClaimRuleReadPAProperties(ModIAuditClaimConfig claimConfig, PortaApplicativa pa) {
        boolean forwardEnabled;
        boolean traceEnabled = claimConfig.isTrace();
        if (pa != null) {
            traceEnabled = CostantiProprieta.isModIAuditTraceEnabled((List)pa.getProprietaList(), (String)claimConfig.getNome(), (boolean)traceEnabled);
        }
        claimConfig.setTrace(traceEnabled);
        boolean bl = forwardEnabled = claimConfig.getForwardBackend() != null && StringUtils.isNotEmpty((String)claimConfig.getForwardBackend());
        if (pa != null) {
            forwardEnabled = CostantiProprieta.isModIAuditForwardBackendEnabled((List)pa.getProprietaList(), (String)claimConfig.getNome(), (boolean)forwardEnabled);
        }
        if (forwardEnabled) {
            String header = claimConfig.getForwardBackend();
            if (pa != null) {
                header = CostantiProprieta.getModIAuditForwardBackend((List)pa.getProprietaList(), (String)claimConfig.getNome(), (String)header);
            }
            claimConfig.setForwardBackend(header);
        } else {
            claimConfig.setForwardBackend(null);
        }
    }

    private void readCorniceSicurezzaSchemaClaims(ModIProperties modiProperties, String schemaCorniceSicurezza, PortaDelegata pd) throws ProtocolException {
        if (modiProperties.getAuditConfig() != null && !modiProperties.getAuditConfig().isEmpty()) {
            for (ModIAuditConfig modIAuditConfig : modiProperties.getAuditConfig()) {
                if (!modIAuditConfig.getNome().equals(schemaCorniceSicurezza)) continue;
                this.corniceSicurezzaSchemaConfig = modIAuditConfig.copyNewInstance();
                this.readCorniceSicurezzaSchemaClaimsRule(this.corniceSicurezzaSchemaConfig.getClaims(), pd);
                break;
            }
        }
    }

    private void readCorniceSicurezzaSchemaClaimsRule(List<ModIAuditClaimConfig> list, PortaDelegata pd) throws ProtocolException {
        if (list != null && !list.isEmpty()) {
            for (ModIAuditClaimConfig modIAuditClaimConfig : list) {
                boolean traceEnabled = modIAuditClaimConfig.isTrace();
                if (pd != null) {
                    traceEnabled = CostantiProprieta.isModIAuditTraceEnabled((List)pd.getProprietaList(), (String)modIAuditClaimConfig.getNome(), (boolean)traceEnabled);
                }
                modIAuditClaimConfig.setTrace(traceEnabled);
                this.readCorniceSicurezzaSchemaClaimRule(modIAuditClaimConfig);
            }
        }
    }

    private void readCorniceSicurezzaSchemaClaimRule(ModIAuditClaimConfig claimConfig) throws ProtocolException {
        try {
            String claimName = claimConfig.getNome();
            String claimMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)("modipaSecurityMessageCorniceSicurezzaSchemaMode" + claimName));
            List<String> rules = null;
            if ("ridefinisci".equals(claimMode)) {
                String claimValue = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)("modipaSecurityMessageCorniceSicurezzaSchemaValue" + claimName));
                rules = ModISecurityConfig.convertToList(claimValue);
                ModIUtilities.remove(this.claims, claimName);
            } else {
                rules = claimConfig.getRules();
            }
            claimConfig.setRules(rules);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private void readCorniceSicurezzaCodiceEnteLegacy(ModIProperties modiProperties) throws ProtocolException {
        try {
            String codiceEnteMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnteMode");
            String claimNameCodiceEnte = modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestCodiceEnte();
            if ("ridefinisci".equals(codiceEnteMode)) {
                this.corniceSicurezzaCodiceEnteRule = ModISecurityConfig.convertToList(ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnte"));
                if (this.multipleHeaderAuthorizationConfig != null) {
                    ModIUtilities.remove(this.multipleHeaderClaims, claimNameCodiceEnte);
                }
                ModIUtilities.remove(this.claims, claimNameCodiceEnte);
            } else {
                this.corniceSicurezzaCodiceEnteRule = this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, claimNameCodiceEnte) ? ModISecurityConfig.convertToList(ModIUtilities.get(this.multipleHeaderClaims, claimNameCodiceEnte, true)) : (ModIUtilities.exists(this.claims, claimNameCodiceEnte) ? ModISecurityConfig.convertToList(ModIUtilities.get(this.claims, claimNameCodiceEnte, true)) : modiProperties.getSicurezzaMessaggioCorniceSicurezzaDynamicCodiceEnte());
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private void readCorniceSicurezzaUserLegacy(ModIProperties modiProperties) throws ProtocolException {
        try {
            String userMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageCorniceSicurezzaUserMode");
            String claimNameUser = modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestUser();
            if ("ridefinisci".equals(userMode)) {
                this.corniceSicurezzaUserRule = ModISecurityConfig.convertToList(ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageCorniceSicurezzaUser"));
                if (this.multipleHeaderAuthorizationConfig != null) {
                    ModIUtilities.remove(this.multipleHeaderClaims, claimNameUser);
                }
                ModIUtilities.remove(this.claims, claimNameUser);
            } else {
                this.corniceSicurezzaUserRule = this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, claimNameUser) ? ModISecurityConfig.convertToList(ModIUtilities.get(this.multipleHeaderClaims, claimNameUser, true)) : (ModIUtilities.exists(this.claims, claimNameUser) ? ModISecurityConfig.convertToList(ModIUtilities.get(this.claims, claimNameUser, true)) : modiProperties.getSicurezzaMessaggioCorniceSicurezzaDynamicUser());
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private void readCorniceSicurezzaIpUserLegacy(ModIProperties modiProperties) throws ProtocolException {
        try {
            String ipUserMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageCorniceSicurezzaIPUserMode");
            String claimNameIpUser = modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestIpuser();
            if ("ridefinisci".equals(ipUserMode)) {
                this.corniceSicurezzaIpUserRule = ModISecurityConfig.convertToList(ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageCorniceSicurezzaIPUser"));
                if (this.multipleHeaderAuthorizationConfig != null) {
                    ModIUtilities.remove(this.multipleHeaderClaims, claimNameIpUser);
                }
                ModIUtilities.remove(this.claims, claimNameIpUser);
            } else {
                this.corniceSicurezzaIpUserRule = this.multipleHeaderAuthorizationConfig != null && ModIUtilities.exists(this.multipleHeaderClaims, claimNameIpUser) ? ModISecurityConfig.convertToList(ModIUtilities.get(this.multipleHeaderClaims, claimNameIpUser, true)) : (ModIUtilities.exists(this.claims, claimNameIpUser) ? ModISecurityConfig.convertToList(ModIUtilities.get(this.claims, claimNameIpUser, true)) : modiProperties.getSicurezzaMessaggioCorniceSicurezzaDynamicIpuser());
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public ModISecurityConfig(OpenSPCoop2Message msg, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo, boolean fruizione, boolean request, PortaApplicativa paDefault) throws ProtocolException {
        this.algorithm = null;
        this.apiSoapAlgorithmUsedOnlyForAudit = null;
        this.digestAlgorithm = null;
        this.digestEncoding = null;
        this.digestEncodingAccepted = null;
        this.c14nAlgorithm = null;
        this.kid = false;
        this.x5c = false;
        this.x5t = false;
        this.x5u = false;
        this.x5url = null;
        this.keyIdentifierMode = null;
        this.useSingleCertificate = true;
        this.includeSignatureToken = false;
        this.httpHeaders = new ArrayList<String>();
        this.soapHeaders = new ArrayList<SOAPHeader>();
        this.multipleHeaderUseSameJti = true;
        this.multipleHeaderUseJtiAuthorizationAsIdMessaggio = true;
        this.multipleHeaderAuthorizationConfig = null;
        this.corniceSicurezzaCodiceEnteRule = null;
        this.corniceSicurezzaUserRule = null;
        this.corniceSicurezzaIpUserRule = null;
        this.corniceSicurezzaSchemaConfig = null;
        this.listProtocolPropertiesInternal = null;
        try {
            if (!fruizione && request) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(paDefault.getServizio().getTipo(), paDefault.getServizio().getNome(), paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario(), paDefault.getServizio().getVersione().intValue());
                IRegistryReader registryReader = protocolFactory.getCachedRegistryReader(state, requestInfo);
                AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio);
                this.listProtocolPropertiesInternal = ModIPropertiesUtils.getProtocolProperties(false, null, asps);
                if (this.listProtocolPropertiesInternal == null || this.listProtocolPropertiesInternal.isEmpty()) {
                    throw new ProtocolException(CONFIGURAZIONE_SICUREZZA_INCOMPLETA);
                }
                this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestAud");
                if (this.audience == null) {
                    IConfigIntegrationReader configReader = protocolFactory.getCachedConfigIntegrationReader(state, requestInfo);
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                    AccordoServizioParteComune aspc = registryReader.getAccordoServizioParteComune(idAccordo);
                    boolean rest = org.openspcoop2.core.registry.constants.ServiceBinding.REST.equals((Object)aspc.getServiceBinding());
                    this.audience = this.buildDefaultAudience(msg, protocolFactory, aspc, asps, configReader, rest, requestInfo, paDefault);
                }
                if (this.audience == null) {
                    throw new ProtocolException(AUDIENCE_UNDEFINED);
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    private String buildDefaultAudience(OpenSPCoop2Message msg, IProtocolFactory<?> protocolFactory, AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, IConfigIntegrationReader configReader, boolean rest, RequestInfo requestInfo, PortaApplicativa paDefault) throws ProtocolException {
        try {
            ArrayList<String> tags = new ArrayList<String>();
            if (aspc != null && aspc.getGruppi() != null && aspc.getGruppi().sizeGruppoList() > 0) {
                for (int i = 0; i < aspc.getGruppi().sizeGruppoList(); ++i) {
                    tags.add(aspc.getGruppi().getGruppo(i).getNome());
                }
            }
            CanaliConfigurazione canaliConfigurazione = configReader.getCanaliConfigurazione();
            String canaleApi = null;
            if (aspc != null) {
                canaleApi = aspc.getCanale();
            }
            String canalePorta = paDefault != null ? paDefault.getCanale() : null;
            String canale = CanaliUtils.getCanale((CanaliConfigurazione)canaliConfigurazione, (String)canaleApi, (String)canalePorta);
            String nomePorta = null;
            nomePorta = paDefault != null ? paDefault.getNome() : (msg != null ? msg.getTransportRequestContext().getInterfaceName() : null);
            UrlInvocazioneAPI urlInvocazioneApi = ConfigurazionePdDManager.getInstance().getConfigurazioneUrlInvocazione(protocolFactory, RuoloContesto.PORTA_APPLICATIVA, rest ? ServiceBinding.REST : ServiceBinding.SOAP, nomePorta, new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), tags, canale, requestInfo);
            String prefixGatewayUrl = urlInvocazioneApi.getBaseUrl();
            String contesto = urlInvocazioneApi.getContext();
            return Utilities.buildUrl((String)prefixGatewayUrl, (String)contesto);
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    public ModISecurityConfig(OpenSPCoop2Message msg, Context context, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo, IDSoggetto soggettoFruitore, AccordoServizioParteComune aspc, AccordoServizioParteSpecifica aspsParam, ServizioApplicativo sa, boolean rest, boolean fruizione, boolean request, Boolean multipleHeaderAuthorizationConfig, boolean kidMode, String patternCorniceSicurezza, String schemaCorniceSicurezza) throws ProtocolException {
        block35: {
            this.algorithm = null;
            this.apiSoapAlgorithmUsedOnlyForAudit = null;
            this.digestAlgorithm = null;
            this.digestEncoding = null;
            this.digestEncodingAccepted = null;
            this.c14nAlgorithm = null;
            this.kid = false;
            this.x5c = false;
            this.x5t = false;
            this.x5u = false;
            this.x5url = null;
            this.keyIdentifierMode = null;
            this.useSingleCertificate = true;
            this.includeSignatureToken = false;
            this.httpHeaders = new ArrayList<String>();
            this.soapHeaders = new ArrayList<SOAPHeader>();
            this.multipleHeaderUseSameJti = true;
            this.multipleHeaderUseJtiAuthorizationAsIdMessaggio = true;
            this.multipleHeaderAuthorizationConfig = null;
            this.corniceSicurezzaCodiceEnteRule = null;
            this.corniceSicurezzaUserRule = null;
            this.corniceSicurezzaIpUserRule = null;
            this.corniceSicurezzaSchemaConfig = null;
            this.listProtocolPropertiesInternal = null;
            ModIProperties modiProperties = ModIProperties.getInstance();
            this.kid = kidMode;
            this.fruizione = fruizione;
            boolean keystoreDefinitoInFruizione = false;
            if (this.fruizione) {
                try {
                    keystoreDefinitoInFruizione = ModIKeystoreConfig.isKeystoreDefinitoInFruizione(soggettoFruitore, aspsParam);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            this.multipleHeaderAuthorizationConfig = multipleHeaderAuthorizationConfig;
            this.listProtocolPropertiesInternal = ModIPropertiesUtils.getProtocolProperties(fruizione, soggettoFruitore, aspsParam);
            if (this.listProtocolPropertiesInternal == null || this.listProtocolPropertiesInternal.isEmpty()) {
                throw new ProtocolException(CONFIGURAZIONE_SICUREZZA_INCOMPLETA);
            }
            if (rest) {
                this.initSharedRest(modiProperties, this.listProtocolPropertiesInternal, null, fruizione, request, false, false);
            } else {
                this.initSharedSoap(this.listProtocolPropertiesInternal, fruizione, request);
            }
            try {
                String idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio;
                String multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry;
                Long l;
                String mode;
                boolean greatherThanZero;
                if (fruizione) {
                    if (!request) {
                        greatherThanZero = true;
                        mode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseIatMode");
                        if ("ridefinisci".equals(mode) && (l = ProtocolPropertiesUtils.getRequiredNumberValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseIatTtl", (boolean)greatherThanZero)) != null && l > 0L) {
                            this.checkTtlIatMs = l * 1000L;
                        }
                    }
                } else if (request) {
                    greatherThanZero = true;
                    mode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestIatMode");
                    if ("ridefinisci".equals(mode) && (l = ProtocolPropertiesUtils.getRequiredNumberValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestIatTtl", (boolean)greatherThanZero)) != null && l > 0L) {
                        this.checkTtlIatMs = l * 1000L;
                    }
                }
                if (rest && this.multipleHeaderAuthorizationConfig != null && (multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)(idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio = fruizione ? "modipaSecurityMessageResponseDuplicateJti" : "modipaSecurityMessageRequestDuplicateJti"))) != null) {
                    this.multipleHeaderUseJtiAuthorizationAsIdMessaggio = "auth".equals(multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry);
                }
                if (!fruizione && request) {
                    String modalita;
                    String nomePorta;
                    IConfigIntegrationReader configReader = protocolFactory.getCachedConfigIntegrationReader(state, requestInfo);
                    PortaApplicativa paDefault = null;
                    if (msg != null) {
                        Object nomePortaInvocataObject = msg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA);
                        nomePorta = null;
                        if (nomePortaInvocataObject instanceof String) {
                            nomePorta = (String)nomePortaInvocataObject;
                        }
                        if (nomePorta == null && context != null && context.containsKey(CostantiPdD.NOME_PORTA_INVOCATA)) {
                            nomePorta = (String)context.getObject(CostantiPdD.NOME_PORTA_INVOCATA);
                        }
                        if (nomePorta == null && requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
                            nomePorta = requestInfo.getProtocolContext().getInterfaceName();
                        }
                        if (nomePorta != null) {
                            paDefault = ModISecurityConfig.getPortaApplicativa(nomePorta, configReader);
                        }
                    }
                    this.checkAudience = true;
                    if (this.multipleHeaderAuthorizationConfig != null && !this.multipleHeaderAuthorizationConfig.booleanValue() && "different".equals(modalita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestIntegrityAudMode"))) {
                        this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestIntegrityAud");
                    }
                    if (this.audience == null) {
                        this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageRequestAud");
                    }
                    if (this.audience == null) {
                        this.audience = this.buildDefaultAudience(msg, protocolFactory, aspc, aspsParam, configReader, rest, requestInfo, paDefault);
                    }
                    if (this.audience == null) {
                        throw new ProtocolException(AUDIENCE_UNDEFINED);
                    }
                    PortaApplicativa paInvocata = null;
                    if (requestInfo != null && requestInfo.getProtocolContext() != null && (nomePorta = requestInfo.getProtocolContext().getInterfaceName()) != null) {
                        paInvocata = ModISecurityConfig.getPortaApplicativa(nomePorta, configReader);
                    }
                    if (patternCorniceSicurezza != null && !"old".equals(patternCorniceSicurezza) && schemaCorniceSicurezza != null) {
                        this.readCorniceSicurezzaSchemaAudience(schemaCorniceSicurezza);
                        this.readCorniceSicurezzaSchemaClaimsReadPAProperties(modiProperties, schemaCorniceSicurezza, paInvocata);
                    }
                    break block35;
                }
                if (fruizione && !request) {
                    String modalita;
                    if (this.multipleHeaderAuthorizationConfig != null && !this.multipleHeaderAuthorizationConfig.booleanValue() && "different".equals(modalita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseIntegrityAudMode"))) {
                        this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseIntegrityAud");
                    }
                    if (this.audience == null) {
                        this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseAudExpected");
                    }
                    if (this.audience == null && sa != null) {
                        this.audience = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityMessageResponseAud");
                        if (this.audience == null) {
                            this.audience = NamingUtils.getLabelSoggetto((IDSoggetto)new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario())) + "/" + sa.getNome();
                        }
                    }
                    this.checkAudience = ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(this.listProtocolPropertiesInternal, (String)"modipaSecurityMessageResponseAud", (boolean)false);
                    if (this.checkAudience && this.audience == null) {
                        if (keystoreDefinitoInFruizione) {
                            throw new ProtocolException("Configurazione errata; Audience della risposta non definito nonostante sia richiesta una verifica");
                        }
                        throw new ProtocolException("Configurazione errata; Audience non definito sull'applicativo e verifica abilitata sulla fruizione");
                    }
                    if (this.tokenClientId == null && sa != null) {
                        this.tokenClientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityTokenClientId");
                    }
                    break block35;
                }
                throw new ProtocolException("Use unsupported");
            }
            catch (Exception e) {
                throw new ProtocolException((Throwable)e);
            }
        }
    }

    private static PortaApplicativa getPortaApplicativa(String nomePorta, IConfigIntegrationReader configReader) {
        try {
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(nomePorta);
            return configReader.getPortaApplicativa(idPA);
        }
        catch (Exception t) {
            return null;
        }
    }

    private static PortaDelegata getPortaDelegata(String nomePorta, IConfigIntegrationReader configReader) {
        try {
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setNome(nomePorta);
            return configReader.getPortaDelegata(idPD);
        }
        catch (Exception t) {
            return null;
        }
    }

    private void initSharedRest(ModIProperties modiProperties, List<ProtocolProperty> listProtocolProperties, ServizioApplicativo sa, boolean fruizione, boolean request, boolean keystoreDefinitoInFruizione, boolean keystoreDefinitoInTokenPolicy) throws ProtocolException {
        if (fruizione) {
            if (request) {
                this.algorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestRequestAlg");
                try {
                    this.useSingleCertificate = !ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestRequestX509CertUseCertificateChain", (boolean)true);
                }
                catch (ProtocolException protocolException) {}
            }
        } else if (!request) {
            this.algorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestResponseAlg");
            try {
                this.useSingleCertificate = !ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestResponseX509CertUseCertificateChain", (boolean)true);
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        if (this.algorithm != null) {
            if (this.algorithm.contains("256")) {
                this.digestAlgorithm = "SHA-256";
            } else if (this.algorithm.contains("384")) {
                this.digestAlgorithm = "SHA-384";
            } else if (this.algorithm.contains("512")) {
                this.digestAlgorithm = "SHA-512";
            } else {
                throw new ProtocolException("Digest algorithm compatible with signature '" + this.algorithm + "' not found");
            }
            if (this.digestAlgorithm != null) {
                boolean creazioneDigest;
                boolean bl = creazioneDigest = fruizione && request || !fruizione && !request;
                if (creazioneDigest) {
                    try {
                        this.digestEncoding = modiProperties.getRestSecurityTokenDigestDefaultEncoding();
                        String digestEncodingPropRegistry = null;
                        digestEncodingPropRegistry = request ? ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestRequestDigestEncoding") : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestResponseDigestEncoding");
                        if (digestEncodingPropRegistry != null) {
                            this.digestEncoding = DigestEncoding.valueOf((String)digestEncodingPropRegistry.trim().toUpperCase());
                        }
                    }
                    catch (Exception e) {
                        throw new ProtocolException("Digest encoding; configuration error: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (fruizione && !request || !fruizione && request) {
            try {
                this.digestEncodingAccepted = modiProperties.getRestSecurityTokenDigestEncodingAccepted();
            }
            catch (Exception e) {
                throw new ProtocolException("Digest algorithm accepted; configuration error: " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.kid) {
            String profiloSicurezzaMessaggioRifX509AsRequestItemValue;
            String x509 = null;
            x509 = request ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestRequestX509Cert") : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestRequestX509Cert");
            if (!request && "false".equals(profiloSicurezzaMessaggioRifX509AsRequestItemValue = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestResponseX509CertAsReq"))) {
                x509 = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestResponseX509Cert");
            }
            if (x509 == null || StringUtils.isEmpty((String)x509)) {
                if (request) {
                    throw new ProtocolException("Property [modipaSecurityMessageRestRequestX509Cert] undefined");
                }
                throw new ProtocolException("Non essendo previsto un token di sicurezza per la richiesta, la configurazione 'Riferimento X.509]' deve essere ridefinita");
            }
            List vX509 = ProtocolPropertiesUtils.getListFromMultiSelectValue((String)x509);
            if (vX509.contains("x5u")) {
                this.x5u = true;
                if (fruizione && request) {
                    if (keystoreDefinitoInFruizione || keystoreDefinitoInTokenPolicy) {
                        try {
                            this.x5url = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestRequestX509Url");
                        }
                        catch (Exception e) {
                            ProtocolException pe = new ProtocolException("Nella configurazione di sicurezza (x5u) associata alla fruizione non \u00e8 stata definita una URL che riferisce un certificato (o certificate chain) X.509 corrispondente alla chiave firmataria del security token");
                            pe.setInteroperabilityError(true);
                            throw pe;
                        }
                    } else {
                        try {
                            this.x5url = ProtocolPropertiesUtils.getRequiredStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaSecurityMessageRestRequestX509Url");
                        }
                        catch (Exception e) {
                            ProtocolException pe = new ProtocolException("Applicativo '" + sa.getNome() + "' non utilizzabile con la configurazione di sicurezza (x5u) associata alla fruizione richiesta, poich\u00e8 non contiene la definizione di una URL che riferisce un certificato (o certificate chain) X.509 corrispondente alla chiave firmataria del security token");
                            pe.setInteroperabilityError(true);
                            throw pe;
                        }
                    }
                } else if (!fruizione && !request) {
                    this.x5url = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageRestResponseX509Url");
                }
            }
            if (vX509.contains("x5c")) {
                this.x5c = true;
            }
            if (vX509.contains("x5t")) {
                this.x5t = true;
            }
        }
    }

    private void initSharedSoap(List<ProtocolProperty> listProtocolProperties, boolean fruizione, boolean request) throws ProtocolException {
        if (fruizione) {
            if (request) {
                boolean auditConfig = false;
                try {
                    this.algorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapRequestAlg");
                }
                catch (Exception e) {
                    if (this.apiSoapAlgorithmUsedOnlyForAudit != null && StringUtils.isNotEmpty((String)this.apiSoapAlgorithmUsedOnlyForAudit)) {
                        auditConfig = true;
                    }
                    throw e;
                }
                if (!auditConfig) {
                    this.c14nAlgorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapRequestCanonicalizationAlg");
                    this.keyIdentifierMode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapRequestX509Cert");
                    try {
                        this.useSingleCertificate = !ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapRequestX509CertUseCertificateChain", (boolean)true);
                    }
                    catch (ProtocolException protocolException) {
                        // empty catch block
                    }
                    try {
                        this.includeSignatureToken = ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapRequestX509CertIncludeSignatureToken", (boolean)true);
                    }
                    catch (ProtocolException protocolException) {}
                }
            }
        } else if (!request) {
            this.algorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapResponseAlg");
            this.c14nAlgorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapResponseCanonicalizationAlg");
            this.keyIdentifierMode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapResponseX509Cert");
            try {
                this.useSingleCertificate = !ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapResponseX509CertUseCertificateChain", (boolean)true);
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
            try {
                this.includeSignatureToken = ProtocolPropertiesUtils.getBooleanValuePropertyRegistry(listProtocolProperties, (String)"modipaSecurityMessageSoapResponseX509CertIncludeSignatureToken", (boolean)true);
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        if (this.algorithm != null) {
            if (this.algorithm.contains("224")) {
                this.digestAlgorithm = SignatureDigestAlgorithm.SHA224.getUri();
            } else if (this.algorithm.contains("256")) {
                this.digestAlgorithm = SignatureDigestAlgorithm.SHA256.getUri();
            } else if (this.algorithm.contains("384")) {
                this.digestAlgorithm = SignatureDigestAlgorithm.SHA384.getUri();
            } else if (this.algorithm.contains("512")) {
                this.digestAlgorithm = SignatureDigestAlgorithm.SHA512.getUri();
            } else {
                throw new ProtocolException("Digest algorithm compatible with signature '" + this.algorithm + "' not found");
            }
        }
    }

    public static List<String> convertToList(String value) throws ProtocolException {
        String nonDefinita = "non definita";
        ArrayList<String> l = null;
        if (value != null) {
            if ("".equals(value = value.trim())) {
                throw new ProtocolException(nonDefinita);
            }
            l = new ArrayList<String>();
            if (value.contains(",")) {
                ModISecurityConfig.converToList(value, nonDefinita, l);
            } else {
                l.add(value);
            }
        } else {
            throw new ProtocolException(nonDefinita);
        }
        return l;
    }

    private static void converToList(String value, String nonDefinita, List<String> l) throws ProtocolException {
        String[] tmp = value.split(",");
        if (tmp == null || tmp.length <= 0) {
            throw new ProtocolException(nonDefinita);
        }
        for (String s : tmp) {
            if (s == null || "".equals(s = s.trim())) continue;
            l.add(s);
        }
        if (l.isEmpty()) {
            throw new ProtocolException(nonDefinita);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmConvertForREST() throws ProtocolException {
        String algo;
        if (this.algorithm != null && (algo = this.convertAlgorithmForREST()) != null) {
            return algo;
        }
        if (this.apiSoapAlgorithmUsedOnlyForAudit != null && StringUtils.isNotEmpty((String)this.apiSoapAlgorithmUsedOnlyForAudit)) {
            return this.apiSoapAlgorithmUsedOnlyForAudit;
        }
        throw new ProtocolException("Convert signature algorithm '" + this.algorithm + "' for audit token failed");
    }

    private String convertAlgorithmForREST() {
        String algoLowerCase = this.algorithm.toLowerCase();
        String size256 = "256";
        String size384 = "384";
        String size512 = "512";
        if (algoLowerCase.contains(RSA.toLowerCase())) {
            if (this.algorithm.contains(size256)) {
                return ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256;
            }
            if (this.algorithm.contains(size384)) {
                return ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS384;
            }
            if (this.algorithm.contains(size512)) {
                return ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS512;
            }
        } else if (algoLowerCase.contains(ECDSA.toLowerCase())) {
            if (this.algorithm.contains(size256)) {
                return ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES256;
            }
            if (this.algorithm.contains(size384)) {
                return ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES384;
            }
            if (this.algorithm.contains(size512)) {
                return ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES512;
            }
        }
        return null;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public DigestEncoding getDigestEncoding() {
        return this.digestEncoding;
    }

    public List<DigestEncoding> getDigestEncodingAccepted() {
        return this.digestEncodingAccepted;
    }

    public String getC14nAlgorithm() {
        return this.c14nAlgorithm;
    }

    public boolean isKid() {
        return this.kid;
    }

    public boolean isX5c() {
        return this.x5c;
    }

    public boolean isX5t() {
        return this.x5t;
    }

    public boolean isX5u() {
        return this.x5u;
    }

    public String getX5url() {
        return this.x5url;
    }

    public String getKeyIdentifierMode() {
        return this.keyIdentifierMode;
    }

    public boolean isUseSingleCertificate() {
        return this.useSingleCertificate;
    }

    public boolean isIncludeSignatureToken() {
        return this.includeSignatureToken;
    }

    public int getTtlSeconds() {
        return this.ttl;
    }

    public Long getCheckTtlIatMilliseconds() {
        return this.checkTtlIatMs;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public boolean isMultipleHeaderUseSameJti() {
        return this.multipleHeaderUseSameJti;
    }

    public boolean isMultipleHeaderUseJtiAuthorizationAsIdMessaggio() {
        return this.multipleHeaderUseJtiAuthorizationAsIdMessaggio;
    }

    public List<SOAPHeader> getSoapHeaders() {
        return this.soapHeaders;
    }

    public List<String> getCorniceSicurezzaUserRule() {
        return this.corniceSicurezzaUserRule;
    }

    public List<String> getCorniceSicurezzaIpUserRule() {
        return this.corniceSicurezzaIpUserRule;
    }

    public List<String> getCorniceSicurezzaCodiceEnteRule() {
        return this.corniceSicurezzaCodiceEnteRule;
    }

    public ModIAuditConfig getCorniceSicurezzaSchemaConfig() {
        return this.corniceSicurezzaSchemaConfig;
    }

    public String getCorniceSicurezzaAudience() {
        return this.corniceSicurezzaAudience;
    }

    public boolean isCheckAudience() {
        return this.checkAudience;
    }

    public Properties getClaims() {
        return this.claims;
    }

    public Properties getMultipleHeaderClaims() {
        return this.multipleHeaderClaims;
    }

    public String getTokenKid() {
        return this.tokenKid;
    }

    public String getTokenClientId() {
        return this.tokenClientId;
    }
}

