/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.lang.StringUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingHeader;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingUtilities;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.modipa.builder.ModIImbustamentoSoap;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModITruststoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.utils.SOAPInfo;
import org.openspcoop2.protocol.modipa.validator.AbstractModIValidazioneSintatticaCommons;
import org.openspcoop2.protocol.modipa.validator.ModISOAPSecurity;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.SoapMessageSecurityToken;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.ValidazioneUtils;
import org.openspcoop2.security.keystore.KeystoreConstants;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.constants.SignatureDigestAlgorithm;
import org.openspcoop2.security.message.engine.MessageSecurityContext_impl;
import org.openspcoop2.security.message.wss4j.MessageSecurityReceiver_wss4j;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModIValidazioneSintatticaSoap
extends AbstractModIValidazioneSintatticaCommons {
    public ModIValidazioneSintatticaSoap(Logger log, IState state, Context context, IProtocolFactory<?> factory, RequestInfo requestInfo, ModIProperties modiProperties, ValidazioneUtils validazioneUtils) {
        super(log, state, context, factory, requestInfo, modiProperties, validazioneUtils);
    }

    private void logError(String msg) {
        this.log.error(msg);
    }

    private void logError(String msg, Exception e) {
        this.log.error(msg, (Throwable)e);
    }

    private String getErrorHeaderSoapNonPresente(String hdr) {
        return "Header SOAP '" + hdr + "' non presente";
    }

    public void validateAsyncInteractionProfile(OpenSPCoop2Message msg, boolean request, String asyncInteractionType, String asyncInteractionRole, Busta busta, List<Eccezione> erroriValidazione, String replyTo) throws ProtocolException {
        boolean bufferMessageReadOnly = this.modiProperties.isValidazioneBufferEnabled();
        String idTransazione = null;
        if (this.context != null) {
            idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        OpenSPCoop2SoapMessage soapMessage = null;
        try {
            soapMessage = msg.castAsSoap();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        String correlationIdName = this.modiProperties.getSoapCorrelationIdName();
        String correlationId = ModIUtilities.getSOAPHeaderCorrelationIdValue(soapMessage, bufferMessageReadOnly, idTransazione);
        String replyToName = this.modiProperties.getSoapReplyToName();
        String replyToAddress = ModIUtilities.getSOAPHeaderReplyToValue(soapMessage, bufferMessageReadOnly, idTransazione);
        if (replyToAddress != null) {
            busta.addProperty("ProfiloInterazioneAsincrona-ReplyTo", replyToAddress);
        }
        if (correlationId != null) {
            busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", correlationId);
            if (correlationId.length() <= 255) {
                busta.setCollaborazione(correlationId);
            }
        }
        if (asyncInteractionType != null) {
            if ("PUSH".equals(asyncInteractionType)) {
                if ("Richiesta".equals(asyncInteractionRole)) {
                    if (request) {
                        if (replyToAddress == null || "".equals(replyToAddress)) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_PRESENTE, this.getErrorHeaderSoapNonPresente(replyToName)));
                        }
                        if (this.modiProperties.isSoapSecurityTokenPushReplyToUpdateInErogazione()) {
                            ModIUtilities.addSOAPHeaderReplyTo(soapMessage, bufferMessageReadOnly, idTransazione, replyTo);
                        }
                    } else if (correlationId == null || "".equals(correlationId)) {
                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, this.getErrorHeaderSoapNonPresente(correlationIdName)));
                    }
                } else if (request && (correlationId == null || "".equals(correlationId))) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, this.getErrorHeaderSoapNonPresente(correlationIdName)));
                }
            } else if (request) {
                if (("RichiestaStato".equals(asyncInteractionRole) || "Risposta".equals(asyncInteractionRole)) && (correlationId == null || "".equals(correlationId))) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, this.getErrorHeaderSoapNonPresente(correlationIdName)));
                }
            } else if ("Richiesta".equals(asyncInteractionRole) && (correlationId == null || "".equals(correlationId))) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, this.getErrorHeaderSoapNonPresente(correlationIdName)));
            }
        }
    }

    public SOAPEnvelope validateSecurityProfile(OpenSPCoop2Message msg, boolean request, String securityMessageProfile, boolean corniceSicurezza, boolean includiRequestDigest, boolean signAttachments, Busta busta, List<Eccezione> erroriValidazione, ModITruststoreConfig trustStoreCertificati, ModISecurityConfig securityConfig, boolean buildSecurityTokenInRequest, Map<String, Object> dynamicMapParameter, Busta datiRichiesta, RequestInfo requestInfo, MsgDiagnostico msgDiag) throws ProtocolException {
        boolean integrita;
        if (msg == null) {
            throw new ProtocolException("Param msg is null");
        }
        MessageSecurityContextParameters messageSecurityContextParameters = new MessageSecurityContextParameters();
        messageSecurityContextParameters.setFunctionAsClient(false);
        messageSecurityContextParameters.setPrefixWsuId(OpenSPCoop2Properties.getInstance().getPrefixWsuId());
        MessageSecurityContext_impl messageSecurityContext = new MessageSecurityContext_impl(messageSecurityContextParameters);
        boolean attesoSecurityHeader = true;
        if (!request) {
            try {
                if (msg.isFault()) {
                    attesoSecurityHeader = false;
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        boolean bufferMessageReadOnly = this.modiProperties.isValidazioneBufferEnabled();
        String idTransazione = null;
        if (this.context != null) {
            idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        if (!messageSecurityContext.existsSecurityHeader(msg, this.modiProperties.getSoapSecurityTokenActor(), bufferMessageReadOnly, idTransazione)) {
            if (attesoSecurityHeader) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_PRESENTE, "Header Message Security non riscontrato nella SOAPEnvelope ricevuta"));
            }
            return null;
        }
        OpenSPCoop2SoapMessage soapMessage = null;
        try {
            soapMessage = msg.castAsSoap();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        SOAPInfo soapInfo = new SOAPInfo();
        boolean useSoapReader = false;
        try {
            soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, true, true, false);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        boolean filtroDuplicati = "idam02".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
        boolean integritaX5c = false;
        if ("idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile)) {
            integritaX5c = true;
        }
        boolean integritaKid = false;
        if ("idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile)) {
            integritaKid = true;
        }
        boolean bl = integrita = integritaX5c || integritaKid;
        if (integritaKid) {
            String labelPattern = "idam0401".equals(securityMessageProfile) ? "INTEGRITY_REST_02 con ID_AUTH_REST_01" : "INTEGRITY_REST_02 con ID_AUTH_REST_02";
            throw new ProtocolException("Sicurezza Messaggio con pattern '" + labelPattern + "' non utilizzabile su API SOAP");
        }
        SOAPHeaderElement requestDigestHeader = null;
        if (integrita && !request && includiRequestDigest) {
            requestDigestHeader = ModIUtilities.getSOAPHeaderRequestDigest(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione);
        }
        X509Certificate x509 = null;
        List elementsToClean = null;
        SOAPHeaderElement securityHeader = null;
        Timestamp timestamp = null;
        WSDataRef timestamptRef = null;
        WSDataRef wsaToRef = null;
        WSDataRef wsaMessageIdRef = null;
        WSDataRef bodyRef = null;
        WSDataRef requestDigestRef = null;
        ArrayList<WSDataRef> attachmentsRef = new ArrayList<WSDataRef>();
        MessageSecurityReceiver_wss4j wss4jSignature = null;
        try {
            Long futureTimeToLive;
            wss4jSignature = new MessageSecurityReceiver_wss4j();
            HashMap<String, Object> secProperties = new HashMap<String, Object>();
            secProperties.put("securityEngine", "wss4j");
            if (this.modiProperties.getSoapSecurityTokenActor() != null && !"".equals(this.modiProperties.getSoapSecurityTokenActor())) {
                secProperties.put("actor", this.modiProperties.getSoapSecurityTokenActor());
            }
            secProperties.put("mustUnderstand", "" + this.modiProperties.isSoapSecurityTokenMustUnderstand());
            if (!request) {
                corniceSicurezza = false;
            }
            if (corniceSicurezza) {
                this.addValidationCorniceSicurezza(secProperties);
            }
            StringBuilder bfAction = new StringBuilder();
            bfAction.append("Timestamp").append(" ").append("Signature");
            if (corniceSicurezza) {
                bfAction.append(" ").append("SAMLTokenUnsigned");
            }
            secProperties.put("action", bfAction.toString());
            Properties pTruststore = new Properties();
            pTruststore.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
            pTruststore.put("org.apache.ws.security.crypto.merlin.truststore.type", trustStoreCertificati.getSecurityMessageTruststoreType());
            if (trustStoreCertificati.getSecurityMessageTruststorePassword() != null) {
                pTruststore.put("org.apache.ws.security.crypto.merlin.truststore.password", trustStoreCertificati.getSecurityMessageTruststorePassword());
            }
            pTruststore.put("org.apache.ws.security.crypto.merlin.truststore.file", trustStoreCertificati.getSecurityMessageTruststorePath());
            pTruststore.put("requestInfo", requestInfo);
            if (trustStoreCertificati.getSecurityMessageTruststoreCRLs() != null) {
                pTruststore.put("org.apache.ws.security.crypto.merlin.x509crl.file", trustStoreCertificati.getSecurityMessageTruststoreCRLs());
                secProperties.put("enableRevocation", "true");
            }
            if (trustStoreCertificati.getSecurityMessageTruststoreOCSPPolicy() != null) {
                secProperties.put("signatureOCSP", trustStoreCertificati.getSecurityMessageTruststoreOCSPPolicy());
                if (trustStoreCertificati.getSecurityMessageTruststoreCRLs() != null) {
                    secProperties.put("signatureCRL", trustStoreCertificati.getSecurityMessageTruststoreCRLs());
                }
            }
            secProperties.put("signatureVerificationPropRefId", pTruststore);
            if (corniceSicurezza) {
                secProperties.put("signaturePropRefId", pTruststore);
            }
            secProperties.put("isBSPCompliant", "true");
            Long timeToLive = this.modiProperties.getSoapSecurityTokenTimestampCreatedTimeCheckMilliseconds();
            if (securityConfig.getCheckTtlIatMilliseconds() != null) {
                timeToLive = securityConfig.getCheckTtlIatMilliseconds();
            }
            boolean setTimeToLive = false;
            if (timeToLive != null && msg != null) {
                msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_IAT_TTL_CHECK, (Object)timeToLive);
            }
            if (!setTimeToLive) {
                secProperties.put("timeToLive", "315360000");
            }
            if ((futureTimeToLive = this.modiProperties.getSoapSecurityTokenTimestampCreatedTimeCheckFutureToleranceMilliseconds()) != null) {
                // empty if block
            }
            secProperties.put("timestampStrict", "false");
            messageSecurityContext.setIncomingProperties(secProperties, false);
            if (signAttachments) {
                messageSecurityContext.setManualAttachmentsSignaturePart("{}cid:Attachments");
            }
            elementsToClean = wss4jSignature.getDirtyElements((MessageSecurityContext)messageSecurityContext, soapMessage);
            ArrayList listaErroriRiscontrati = new ArrayList();
            wss4jSignature.checkEncryptSignatureParts((MessageSecurityContext)messageSecurityContext, elementsToClean, soapMessage, listaErroriRiscontrati);
            if (!listaErroriRiscontrati.isEmpty()) {
                StringBuilder bf = new StringBuilder();
                for (SubErrorCodeSecurity subCodiceErroreSicurezza : listaErroriRiscontrati) {
                    if (bf.length() > 0) {
                        bf.append(" ; ");
                    }
                    bf.append(subCodiceErroreSicurezza.getMsgErrore());
                }
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_PRESENTE, bf.toString()));
                return null;
            }
            wss4jSignature.process((MessageSecurityContext)messageSecurityContext, (OpenSPCoop2Message)soapMessage, busta, bufferMessageReadOnly, idTransazione, (org.openspcoop2.utils.Map)this.context);
            x509 = wss4jSignature.getX509Certificate();
            securityHeader = messageSecurityContext.getSecurityHeader(msg, this.modiProperties.getSoapSecurityTokenActor(), bufferMessageReadOnly, idTransazione);
            timestamp = wss4jSignature.getTimestamp();
            List signatureRefs = wss4jSignature.getSignatureRefs();
            if (signatureRefs != null && !signatureRefs.isEmpty()) {
                for (WSDataRef wsDataRef : signatureRefs) {
                    if (wsDataRef.getName() != null && wsDataRef.getName().getLocalPart() != null && wsDataRef.getName().getNamespaceURI() != null) {
                        busta.addProperty("ProfiloSicurezzaMessaggioSignedSoap-" + wsDataRef.getName().getLocalPart(), wsDataRef.getName().getNamespaceURI());
                    }
                    if (wsDataRef.getName() != null && "Timestamp".equals(wsDataRef.getName().getLocalPart()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(wsDataRef.getName().getNamespaceURI())) {
                        timestamptRef = wsDataRef;
                        continue;
                    }
                    if (wsDataRef.getName() != null && "To".equals(wsDataRef.getName().getLocalPart()) && "http://www.w3.org/2005/08/addressing".equals(wsDataRef.getName().getNamespaceURI())) {
                        wsaToRef = wsDataRef;
                        continue;
                    }
                    if (wsDataRef.getName() != null && "MessageID".equals(wsDataRef.getName().getLocalPart()) && "http://www.w3.org/2005/08/addressing".equals(wsDataRef.getName().getNamespaceURI())) {
                        wsaMessageIdRef = wsDataRef;
                        continue;
                    }
                    if (wsDataRef.getName() != null && "Body".equals(wsDataRef.getName().getLocalPart()) && soapInfo.getEnvelopeNamespace().equals(wsDataRef.getName().getNamespaceURI())) {
                        bodyRef = wsDataRef;
                        continue;
                    }
                    if (requestDigestHeader != null && wsDataRef.getName() != null && requestDigestHeader.getLocalName().equals(wsDataRef.getName().getLocalPart()) && requestDigestHeader.getNamespaceURI().equals(wsDataRef.getName().getNamespaceURI())) {
                        requestDigestRef = wsDataRef;
                        continue;
                    }
                    if (wsDataRef.getName() == null || !"attachment".equals(wsDataRef.getName().getLocalPart()) || !"http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1".equals(wsDataRef.getName().getNamespaceURI())) continue;
                    attachmentsRef.add(wsDataRef);
                }
            }
        }
        catch (Exception e) {
            this.logError("Errore durante la validazione del token di sicurezza: " + e.getMessage(), e);
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, e.getMessage(), (Throwable)e));
            return null;
        }
        if (x509 == null || x509.getSubjectX500Principal() == null) {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE, "Certificato X509 mittente non presente"));
        } else {
            busta.addProperty("ProfiloSicurezzaMessaggio-X509-Subject", x509.getSubjectX500Principal().toString());
            if (x509.getIssuerX500Principal() != null) {
                busta.addProperty("ProfiloSicurezzaMessaggio-X509-Issuer", x509.getIssuerX500Principal().toString());
            }
            if (request) {
                boolean autenticazioneToken;
                if (msg == null || msg.getTransportRequestContext() == null || msg.getTransportRequestContext().getInterfaceName() == null) {
                    throw new ProtocolException("ID Porta non presente");
                }
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setNome(msg.getTransportRequestContext().getInterfaceName());
                PortaApplicativa pa = null;
                try {
                    pa = this.factory.getCachedConfigIntegrationReader(this.state, this.requestInfo).getPortaApplicativa(idPA);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                boolean bl2 = autenticazioneToken = pa != null && pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null && StringUtils.isNotEmpty((String)pa.getGestioneToken().getPolicy());
                if (!autenticazioneToken) {
                    this.identificazioneApplicativoMittente(x509, msg, busta, msgDiag);
                }
            }
        }
        SoapMessageSecurityToken soapSecurityToken = null;
        if (request && this.context != null) {
            SecurityToken securityTokenForContext = ModIUtilities.newSecurityToken(this.context);
            soapSecurityToken = new SoapMessageSecurityToken();
            soapSecurityToken.setCertificate(new CertificateInfo(x509, "soapEnvelope"));
            securityTokenForContext.setEnvelope(soapSecurityToken);
        }
        Map dynamicMap = null;
        Map<String, Object> dynamicMapRequest = null;
        if (!request) {
            dynamicMapRequest = ModIUtilities.removeDynamicMapRequest(this.context);
        }
        try {
            if (dynamicMapRequest != null) {
                dynamicMap = DynamicUtils.buildDynamicMapResponse((OpenSPCoop2Message)msg, (Context)this.context, null, (Logger)this.log, (boolean)bufferMessageReadOnly, dynamicMapRequest);
            } else {
                dynamicMap = DynamicUtils.buildDynamicMap((OpenSPCoop2Message)msg, (Context)this.context, (Busta)datiRichiesta, (Logger)this.log, (boolean)bufferMessageReadOnly);
                ModIUtilities.saveDynamicMapRequest(this.context, dynamicMap);
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (dynamicMapParameter != null && dynamicMap != null) {
            dynamicMapParameter.putAll(dynamicMap);
        }
        if (timestamp == null) {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_PRESENTE, "Header WSSecurity Timestamp"));
        } else if (timestamptRef == null || timestamptRef.getDigestValue() == null || timestamptRef.getDigestAlgorithm() == null) {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_VALIDA, "Header WSSecurity Timestamp non firmato"));
        } else {
            Date d;
            if (timestamp.getCreated() != null) {
                long ms = timestamp.getCreated().toEpochMilli();
                d = new Date(ms);
                busta.addProperty("ProfiloSicurezzaMessaggio-IssuedAt", DateUtils.getSimpleDateFormatMs().format(d));
            } else {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_PRESENTE, "Header WSSecurity Timestamp; elemento 'Created'"));
            }
            if (timestamp.getExpires() != null) {
                long ms = timestamp.getExpires().toEpochMilli();
                d = new Date(ms);
                busta.addProperty("ProfiloSicurezzaMessaggio-Expiration", DateUtils.getSimpleDateFormatMs().format(d));
            } else {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SCADENZA_NON_PRESENTE, "Header WSSecurity Timestamp; elemento 'Expires'"));
            }
        }
        if (integrita) {
            if (bodyRef == null || bodyRef.getDigestValue() == null || bodyRef.getDigestAlgorithm() == null) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_NON_VALIDO, "Header WSSecurity Signature; SOAP Body non firmato"));
            } else {
                SignatureDigestAlgorithm s = SignatureDigestAlgorithm.toEnumConstant((String)bodyRef.getDigestAlgorithm());
                Object digestValue = s != null ? s.name() + "=" : "";
                digestValue = (String)digestValue + Base64Utilities.encodeAsString((byte[])bodyRef.getDigestValue());
                busta.addProperty("ProfiloSicurezzaMessaggio-Digest", (String)digestValue);
                if (request && includiRequestDigest && this.context != null && securityHeader != null) {
                    String digestNamespace = "http://www.w3.org/2000/09/xmldsig#";
                    String digestReferencePattern = "//{" + digestNamespace + "}:Reference";
                    OpenSPCoop2MessageFactory messageFactory = msg != null ? msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
                    DynamicNamespaceContext dnc = MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)messageFactory).getNamespaceContext((Node)securityHeader);
                    XPathExpressionEngine xpathEngine = new XPathExpressionEngine(messageFactory);
                    Object res = null;
                    try {
                        res = xpathEngine.getMatchPattern((SOAPElement)securityHeader, dnc, digestReferencePattern, XPathReturnType.NODESET);
                    }
                    catch (XPathNotFoundException xPathNotFoundException) {
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                    if (res != null) {
                        if (res instanceof NodeList) {
                            NodeList nodeList = (NodeList)res;
                            this.context.addObject(ModICostanti.MODIPA_CONTEXT_REQUEST_DIGEST, (Object)nodeList);
                        } else {
                            this.logError("Tipo non gestito ritornato dal xpath engine durante la raccolta delle signature references [" + res.getClass().getName() + "]");
                        }
                    }
                }
            }
            if (!request && includiRequestDigest) {
                if (requestDigestHeader == null) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_NON_VALIDO, "Header Request Digest non presente"));
                }
                if (requestDigestRef == null || requestDigestRef.getDigestValue() == null || requestDigestRef.getDigestAlgorithm() == null) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_NON_VALIDO, "Header WSSecurity Signature; Header Request Digest non firmato"));
                }
            }
            if (signAttachments) {
                ArrayList<String> cidAttachments = new ArrayList<String>();
                try {
                    if (msg.castAsSoap().hasAttachments()) {
                        Iterator itAttach = msg.castAsSoap().getAttachments();
                        while (itAttach.hasNext()) {
                            AttachmentPart ap = (AttachmentPart)itAttach.next();
                            String contentId = this.normalizeContentID(ap.getContentId());
                            cidAttachments.add(contentId);
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (attachmentsRef.isEmpty()) {
                    if (requestDigestRef == null || requestDigestRef.getDigestValue() == null || requestDigestRef.getDigestAlgorithm() == null) {
                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE, "Header WSSecurity Signature; Allegati non firmati"));
                    }
                } else {
                    for (WSDataRef wsDateRef : attachmentsRef) {
                        String cid = null;
                        Object idLog = "";
                        if (wsDateRef != null) {
                            cid = this.normalizeContentID(wsDateRef.getWsuId());
                            Object object = idLog = wsDateRef.getWsuId() != null ? " '" + cid + "'" : "";
                        }
                        if (wsDateRef == null || wsDateRef.getDigestValue() == null || wsDateRef.getDigestAlgorithm() == null) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA, "Header WSSecurity Signature; Allegato" + (String)idLog + " non firmato (digest non presente)"));
                        }
                        if (cid == null) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA, "Header WSSecurity Signature; Allegato" + (String)idLog + " non firmato (cid non presente)"));
                        }
                        if (!cidAttachments.contains(cid)) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA, "Header WSSecurity Signature; Allegato con id" + (String)idLog + ", riferito nella firma, non esiste"));
                            continue;
                        }
                        cidAttachments.remove(cid);
                    }
                }
                if (!cidAttachments.isEmpty()) {
                    for (String cid : cidAttachments) {
                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA, "Header WSSecurity Signature; Allegato" + cid + " non firmato"));
                    }
                }
            }
        }
        WSAddressingHeader wsAddressingHeader = null;
        try {
            WSAddressingUtilities wsaddressingUtilities = new WSAddressingUtilities(this.log);
            wsAddressingHeader = wsaddressingUtilities.read(soapMessage, soapInfo.getHeader(), this.modiProperties.getSoapWSAddressingActor(), this.modiProperties.isSoapWSAddressingSchemaValidation());
            if (wsAddressingHeader == null) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_PRESENTE, "Header WSAddressing non presenti"));
            }
        }
        catch (Exception e) {
            this.logError("Errore durante la letttura degli header WSAddressing: " + e.getMessage(), e);
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_PRESENTE, "Header WSAddressing; process failed: " + e.getMessage(), (Throwable)e));
        }
        if (wsAddressingHeader != null) {
            if (wsAddressingHeader.getTo() == null || wsAddressingHeader.getToValue() == null) {
                if (request || buildSecurityTokenInRequest) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE, "Header WSAddressing 'To' non presente"));
                }
            } else {
                busta.addProperty("ProfiloSicurezzaMessaggio-WSA-To", wsAddressingHeader.getToValue());
                if (wsaToRef == null || wsaToRef.getDigestValue() == null || wsaToRef.getDigestAlgorithm() == null) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO, "Header WSAddressing 'To' non firmato"));
                }
            }
            if (wsAddressingHeader.getFrom() != null && wsAddressingHeader.getFromValue() != null) {
                busta.addProperty("ProfiloSicurezzaMessaggio-WSA-From", wsAddressingHeader.getFromValue());
            }
            if (wsAddressingHeader.getId() == null || wsAddressingHeader.getIdValue() == null) {
                if (filtroDuplicati) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, "Header WSAddressing 'MessageID' non presente"));
                }
            } else {
                String id = wsAddressingHeader.getIdValue();
                busta.addProperty("ProfiloSicurezzaMessaggio-MessageId", id);
                if (id.length() <= 255) {
                    busta.setID(id);
                }
                if (filtroDuplicati && (wsaMessageIdRef == null || wsaMessageIdRef.getDigestValue() == null || wsaMessageIdRef.getDigestAlgorithm() == null)) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALIDO, "Header WSAddressing 'MessageID' non firmato"));
                }
            }
            if (wsAddressingHeader.getRelatesTo() != null && wsAddressingHeader.getRelatesToValue() != null) {
                String relatesTo = wsAddressingHeader.getRelatesToValue();
                busta.addProperty("ProfiloSicurezzaMessaggio-RelatesTo", relatesTo);
                if (relatesTo.length() <= 255) {
                    busta.setRiferimentoMessaggio(relatesTo);
                }
            }
        }
        if (wsAddressingHeader == null) {
            return null;
        }
        if (corniceSicurezza) {
            DynamicNamespaceContext dnc = MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)msg.getFactory()).getNamespaceContext((Node)securityHeader);
            XPathExpressionEngine engine = new XPathExpressionEngine(msg.getFactory());
            String xpathSaml2CodiceEnte = "//{" + "urn:oasis:names:tc:SAML:2.0:assertion" + "}NameID/text()";
            try {
                String codiceEnte = engine.getStringMatchPattern((SOAPElement)securityHeader, dnc, xpathSaml2CodiceEnte);
                if (codiceEnte == null || "".equals(codiceEnte)) {
                    throw new XPathNotFoundException("non trovato");
                }
                busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-Ente", codiceEnte);
            }
            catch (XPathNotFoundException notFound) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, "Informazioni Audit; elemento 'Subject/NameID'"));
            }
            catch (Exception e) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALIDO, "Informazioni Audit; elemento 'Subject/NameID'"));
            }
            String attributeNameUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaSoapUser();
            String xpathSaml2User = "//{" + "urn:oasis:names:tc:SAML:2.0:assertion" + "}Attribute[@Name='" + attributeNameUser + "']//{" + "urn:oasis:names:tc:SAML:2.0:assertion" + "}AttributeValue/text()";
            try {
                String user = engine.getStringMatchPattern((SOAPElement)securityHeader, dnc, xpathSaml2User);
                if (user == null || "".equals(user)) {
                    throw new XPathNotFoundException("non trovato");
                }
                busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-User", user);
            }
            catch (XPathNotFoundException notFound) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, "Informazioni Audit; elemento 'Attribute/" + attributeNameUser + "'"));
            }
            catch (Exception e) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALIDO, "Informazioni Audit; elemento 'Attribute/" + attributeNameUser + "'"));
            }
            String attributeNameIpUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaSoapIpuser();
            String xpathSaml2IpUser = "//{" + "urn:oasis:names:tc:SAML:2.0:assertion" + "}Attribute[@Name='" + attributeNameIpUser + "']//{" + "urn:oasis:names:tc:SAML:2.0:assertion" + "}AttributeValue/text()";
            try {
                String ipUser = engine.getStringMatchPattern((SOAPElement)securityHeader, dnc, xpathSaml2IpUser);
                if (ipUser == null || "".equals(ipUser)) {
                    throw new XPathNotFoundException("non trovato");
                }
                busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-UserIP", ipUser);
            }
            catch (XPathNotFoundException notFound) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, "Informazioni Audit; elemento 'Attribute/" + attributeNameIpUser + "'"));
            }
            catch (Exception e) {
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALIDO, "Informazioni Audit; elemento 'Attribute/" + attributeNameIpUser + "'"));
            }
        }
        ModISOAPSecurity soapSecurity = new ModISOAPSecurity();
        soapSecurity.setSecurityHeader(securityHeader);
        soapSecurity.setWsAddressingHeader(wsAddressingHeader);
        soapSecurity.setRequestDigestHeader(requestDigestHeader);
        if (bodyRef != null) {
            soapSecurity.setWsuIdBodyRef(bodyRef.getWsuId());
        }
        soapSecurity.setElementsToClean(elementsToClean);
        soapSecurity.setMessageSecurityContext((MessageSecurityContext)messageSecurityContext);
        soapSecurity.setWss4jSignature(wss4jSignature);
        msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_SBUSTAMENTO_SOAP, (Object)soapSecurity);
        try {
            SOAPEnvelope soapEnvelope = soapSecurity.buildTraccia(msg.getMessageType());
            if (soapSecurityToken != null) {
                soapSecurityToken.setToken(soapEnvelope);
            }
            return soapEnvelope;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private String normalizeContentID(String contentId) {
        if (contentId == null) {
            return null;
        }
        contentId = contentId.replace("&lt;", "<");
        if ((contentId = contentId.replace("&gt;", ">")).startsWith("cid:") && contentId.length() > 4) {
            contentId = contentId.substring(4);
        }
        if (contentId.startsWith("<") && contentId.length() > 1) {
            contentId = contentId.substring(1);
        }
        if (contentId.endsWith(">") && contentId.length() > 1) {
            contentId = contentId.substring(0, contentId.length() - 1);
        }
        return contentId;
    }

    private void addValidationCorniceSicurezza(Map<String, Object> secProperties) {
        secProperties.put("openspcoop2.saml.version", "2.0");
        secProperties.put("signatureActionChoice", "true");
        if (ModIImbustamentoSoap.isSenderVouche()) {
            secProperties.put("validateSamlSubjectConfirmation", "true");
            secProperties.put("validateSamlSubjectConfirmationType", "sender-vouches");
        } else {
            secProperties.put("validateSamlSubjectConfirmation", "false");
        }
    }
}

