/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.commons.search.dao.ISoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCSoggettoServiceSearch;
import org.openspcoop2.core.statistiche.StatistichePdndTracing;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IDBStatistichePdndTracingServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaInfoServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatistichePdndTracingServiceSearch;
import org.openspcoop2.core.statistiche.model.StatistichePdndTracingModel;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.dao.IServiceSearchWithoutId;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoInfo;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoSoggetto;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoUtils;
import org.openspcoop2.monitor.engine.statistic.StatisticsInfoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsService;
import org.openspcoop2.web.monitor.core.dao.IDynamicUtilsService;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingSearchForm;
import org.openspcoop2.web.monitor.statistiche.constants.ModalitaRicercaStatistichePdnd;
import org.openspcoop2.web.monitor.statistiche.dao.IStatistichePdndTracingService;
import org.slf4j.Logger;

public class StatistichePdndTracingService
implements IStatistichePdndTracingService {
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private transient IDynamicUtilsService dynamicService = null;
    private StatistichePdndTracingSearchForm search;
    private org.openspcoop2.core.statistiche.dao.IServiceManager statisticheServiceManager;
    private IStatistichePdndTracingServiceSearch statistichePdndTracingServiceSearchDAO;
    private IServiceManager utilsServiceManager;
    private ISoggettoServiceSearch soggettiServiceSearchDAO;
    private PddMonitorProperties govwayMonitorProperties;
    private boolean timeoutEvent = false;
    private Integer timeoutRicerche = null;

    private static void logError(String msg, Throwable e) {
        if (log != null) {
            log.error(msg, e);
        }
    }

    public StatistichePdndTracingService() {
        try {
            this.statisticheServiceManager = (org.openspcoop2.core.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            this.statistichePdndTracingServiceSearchDAO = this.statisticheServiceManager.getStatistichePdndTracingServiceSearch();
            this.utilsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            this.soggettiServiceSearchDAO = this.utilsServiceManager.getSoggettoServiceSearch();
            this.govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.timeoutRicerche = this.govwayMonitorProperties.getIntervalloTimeoutRicercaStatistiche();
            this.dynamicService = new DynamicUtilsService();
        }
        catch (DAOFactoryException | NotImplementedException | ServiceException | UtilsException e) {
            StatistichePdndTracingService.logError(e.getMessage(), e);
        }
    }

    public StatistichePdndTracingService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public StatistichePdndTracingService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public StatistichePdndTracingService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public StatistichePdndTracingService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.statisticheServiceManager = (org.openspcoop2.core.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.statistichePdndTracingServiceSearchDAO = this.statisticheServiceManager.getStatistichePdndTracingServiceSearch();
            this.govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)StatistichePdndTracingService.log);
            this.timeoutRicerche = this.govwayMonitorProperties.getIntervalloTimeoutRicercaStatistiche();
            this.dynamicService = new DynamicUtilsService(con, autoCommit, serviceManagerProperties, log);
        }
        catch (DAOFactoryException | NotImplementedException | ServiceException | UtilsException e) {
            StatistichePdndTracingService.logError(e.getMessage(), e);
        }
    }

    public void setSearch(StatistichePdndTracingSearchForm search) {
        this.search = search;
    }

    public StatistichePdndTracingSearchForm getSearch() {
        return this.search;
    }

    public List<StatistichePdndTracingBean> findAll(int start, int limit) {
        return this.findAllEngine(start, limit);
    }

    public int totalCount() {
        if (this.search == null) {
            return 0;
        }
        try {
            IExpression expr = this.createQuery(true, (IServiceSearchWithoutId<?>)this.statistichePdndTracingServiceSearchDAO, StatistichePdndTracing.model());
            NonNegativeNumber nnn = this.statistichePdndTracingServiceSearchDAO.count(expr);
            return nnn != null ? (int)nnn.longValue() : 0;
        }
        catch (NotImplementedException | ServiceException e) {
            StatistichePdndTracingService.logError("Errore durante il calcolo del numero dei record: " + e.getMessage(), e);
            return 0;
        }
    }

    public void store(StatistichePdndTracingBean obj) throws Exception {
    }

    public void deleteById(Long key) {
    }

    public void delete(StatistichePdndTracingBean obj) throws Exception {
    }

    public void deleteAll() throws Exception {
    }

    public void updateFields(StatistichePdndTracingBean bean, UpdateField field) throws ServiceException, NotFoundException, NotImplementedException {
        this.statisticheServiceManager.getStatistichePdndTracingService().updateFields((Object)bean, new UpdateField[]{field});
    }

    public void forcePublish() throws Exception {
        IExpression expr = this.createQuery(false, (IServiceSearchWithoutId<?>)this.statistichePdndTracingServiceSearchDAO, StatistichePdndTracing.model());
        this.statisticheServiceManager.getStatistichePdndTracingService().forcePublish(expr);
    }

    public void forcePublish(List<Long> ids) throws Exception {
        this.statisticheServiceManager.getStatistichePdndTracingService().forcePublish(ids);
    }

    public boolean isForcePublishEnabled(StatistichePdndTracingBean tracing) {
        if (tracing.getFailed() && !tracing.isForcePublish()) {
            try {
                Date date = StatisticsInfoUtils.readDataUltimaGenerazioneStatistiche((IStatisticaInfoServiceSearch)this.statisticheServiceManager.getStatisticaInfoServiceSearch(), (TipoIntervalloStatistico)TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO, (Logger)log);
                return date.after(tracing.getDataPubblicazione());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void forcePublish(StatistichePdndTracingBean tracing) throws Exception {
        if (!this.isForcePublishEnabled(tracing)) {
            throw new ServiceException("Il tracciato non risulta essere in uno stato in cui pu\u00f2 essere abilitata la pubblicazione forzata: non ha ancora superato il numero massimo di tentativi o non \u00e8 nello stato FAILED");
        }
        this.forcePublish(List.of(tracing.getId()));
    }

    public StatistichePdndTracingBean findById(Long key) {
        IDBStatistichePdndTracingServiceSearch idSearch = (IDBStatistichePdndTracingServiceSearch)this.statistichePdndTracingServiceSearchDAO;
        try {
            StatistichePdndTracing statistichePdndTracing = (StatistichePdndTracing)idSearch.get(key.longValue());
            if (statistichePdndTracing != null) {
                StatistichePdndTracingBean bean = new StatistichePdndTracingBean(statistichePdndTracing);
                List list = this.dynamicService.findElencoSoggetti("modipa", statistichePdndTracing.getPddCodice());
                if (list != null && !list.isEmpty()) {
                    Soggetto soggetto = (Soggetto)list.get(0);
                    bean.setSoggettoReadable(NamingUtils.getLabelSoggetto((String)"modipa", (String)soggetto.getTipoSoggetto(), (String)soggetto.getNomeSoggetto()));
                }
                return bean;
            }
        }
        catch (MultipleResultException | NotFoundException | NotImplementedException | ServiceException | ProtocolException e) {
            StatistichePdndTracingService.logError("Errore durante la ricerca dei Tracing PDND con id:" + key, e);
        }
        return null;
    }

    public List<StatistichePdndTracingBean> findAll() {
        return this.findAllEngine(null, null);
    }

    private List<StatistichePdndTracingBean> findAllEngine(Integer start, Integer limit) {
        if (this.search == null) {
            return new ArrayList<StatistichePdndTracingBean>();
        }
        try {
            IExpression expr = this.createQuery(false, (IServiceSearchWithoutId<?>)this.statistichePdndTracingServiceSearchDAO, StatistichePdndTracing.model());
            IPaginatedExpression pagExpr = this.statistichePdndTracingServiceSearchDAO.toPaginatedExpression(expr).offset(start.intValue()).limit(limit.intValue());
            this.timeoutEvent = false;
            List findAll = null;
            if (this.timeoutRicerche == null) {
                findAll = this.statistichePdndTracingServiceSearchDAO.findAll(pagExpr);
            } else {
                try {
                    findAll = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.statistichePdndTracingServiceSearchDAO.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    StatistichePdndTracingService.logError(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    StatistichePdndTracingService.logError(e.getMessage(), e);
                }
                catch (TimeoutException e) {
                    List<StatistichePdndTracingBean> lNull = null;
                    this.timeoutEvent = true;
                    StatistichePdndTracingService.logError(e.getMessage(), e);
                    return lNull;
                }
            }
            if (findAll != null && !findAll.isEmpty()) {
                ArrayList<StatistichePdndTracingBean> toRet = new ArrayList<StatistichePdndTracingBean>();
                for (StatistichePdndTracing statistichePdndTracing : findAll) {
                    StatistichePdndTracingBean bean = new StatistichePdndTracingBean(statistichePdndTracing);
                    String nomeSoggettoPrincipale = null;
                    List list = this.dynamicService.findElencoSoggetti("modipa", statistichePdndTracing.getPddCodice());
                    if (list != null && !list.isEmpty()) {
                        Soggetto soggetto = (Soggetto)list.get(0);
                        nomeSoggettoPrincipale = soggetto.getNomeSoggetto();
                        bean.setSoggettoReadable(NamingUtils.getLabelSoggetto((String)"modipa", (String)soggetto.getTipoSoggetto(), (String)nomeSoggettoPrincipale));
                    }
                    if (this.search != null && this.search.getSoggettoLocale() != null && !this.search.getSoggettoLocale().equals(nomeSoggettoPrincipale)) {
                        bean.setSoggettoReadable(bean.getSoggettoReadable() + " (aggregatore per " + this.search.getSoggettoLocale() + ")");
                    }
                    toRet.add(bean);
                }
                return toRet;
            }
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException | ProtocolException e) {
            StatistichePdndTracingService.logError("Errore durante la ricerca dei Tracing PDND: " + e.getMessage(), e);
        }
        return new ArrayList<StatistichePdndTracingBean>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IExpression createQuery(boolean isCount, IServiceSearchWithoutId<?> dao, StatistichePdndTracingModel model) throws ServiceException {
        IExpression expr = null;
        try {
            expr = dao.newExpression();
            ModalitaRicercaStatistichePdnd ricerca = ModalitaRicercaStatistichePdnd.getFromString(this.search.getModalitaRicerca());
            if (ricerca.equals((Object)ModalitaRicercaStatistichePdnd.ANDAMENTO_TEMPORALE)) {
                expr.between(model.DATA_TRACCIAMENTO, (Object)this.search.getDataInizio(), (Object)this.search.getDataFine());
                if (this.search.getPermessiUtenteOperatore() != null) {
                    IExpression permessi = this.search.getPermessiUtenteOperatore().toExpressionStatistichePdndTracing(dao, model.PDD_CODICE);
                    expr.and(new IExpression[]{permessi});
                }
                if (Utility.isFiltroDominioAbilitato() && this.search.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.search.getSoggettoLocale()) && !"--".equals(this.search.getSoggettoLocale())) {
                    String tipoSoggettoLocale = this.search.getTipoSoggettoLocale();
                    String nomeSoggettoLocale = this.search.getSoggettoLocale();
                    nomeSoggettoLocale = this.traduciSoggettoAggregato(nomeSoggettoLocale);
                    String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                    expr.and().equals(model.PDD_CODICE, (Object)idPorta);
                }
                if (this.search.getStato() != null && StringUtils.isNotEmpty((String)this.search.getStato()) && !"--".equals(this.search.getStato())) {
                    if ("IN_ATTESA".equals(this.search.getStato())) {
                        expr.isNull(model.STATO);
                    } else {
                        expr.equals(model.STATO, (Object)this.search.getStato());
                    }
                }
                if (this.search.getStatoPdnd() != null && StringUtils.isNotEmpty((String)this.search.getStatoPdnd()) && !"--".equals(this.search.getStatoPdnd())) {
                    expr.equals(model.STATO_PDND, (Object)this.search.getStatoPdnd());
                }
                if (this.search.getTentativiPubblicazione() != null) {
                    expr.equals(model.TENTATIVI_PUBBLICAZIONE, (Object)this.search.getTentativiPubblicazione());
                }
            } else {
                if (!ricerca.equals((Object)ModalitaRicercaStatistichePdnd.TRACING_ID)) throw new ServiceException("Modalit\u00e0 di ricerca non supportata: " + this.search.getModalitaRicerca());
                if (this.search.getTracingId() == null || !StringUtils.isNotEmpty((String)this.search.getTracingId())) throw new ServiceException("Tracing ID non fornito.");
                expr.equals(model.TRACING_ID, (Object)this.search.getTracingId());
            }
            expr.equals(model.HISTORY, (Object)0);
            expr.isNotNull(model.CSV);
            if (isCount) return expr;
            expr.addOrder(model.DATA_TRACCIAMENTO, SortOrder.DESC);
            expr.addOrder(model.PDD_CODICE, SortOrder.DESC);
            return expr;
        }
        catch (CoreException | ExpressionException | ExpressionNotImplementedException | NotImplementedException | UserInvalidException e) {
            StatistichePdndTracingService.logError("Errore durante la creazione dell'espressione: " + e.getMessage(), e);
            throw new ServiceException(e);
        }
        catch (ServiceException e) {
            StatistichePdndTracingService.logError("Errore durante la creazione dell'espressione: " + e.getMessage(), e);
            throw e;
        }
    }

    private String traduciSoggettoAggregato(String nomeSoggettoLocale) {
        try {
            PdndTracciamentoInfo info = PdndTracciamentoUtils.getInfoTracciamento((JDBCSoggettoServiceSearch)((JDBCSoggettoServiceSearch)this.soggettiServiceSearchDAO), (Logger)log);
            PdndTracciamentoSoggetto s = info.getInfoByNomeSoggetto(nomeSoggettoLocale, false, true);
            if (s != null) {
                return s.getIdSoggetto().getNome();
            }
        }
        catch (Exception e) {
            log.error("Raccolta info soggetti per tracing fallita: " + e.getMessage(), (Throwable)e);
        }
        return nomeSoggettoLocale;
    }

    @Override
    public boolean isTimeoutEvent() {
        return this.timeoutEvent;
    }
}

