/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGenerale;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGeneralePK;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioniGeneraliSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IConfigurazioniGeneraliService;
import org.openspcoop2.web.monitor.statistiche.export.ConfigurazioniCsvExporter;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ConfigurazioniExporter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    private static void logError(String msg, Exception e) {
        if (log != null) {
            if (e != null) {
                log.error(msg, (Throwable)e);
            } else {
                log.error(msg);
            }
        }
    }

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            boolean exportConsentito;
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Param context is null");
            }
            IConfigurazioniGeneraliService service = (IConfigurazioniGeneraliService)context.getBean("configurazioniGeneraliService");
            ConfigurazioniGeneraliSearchForm sfInSession = (ConfigurazioniGeneraliSearchForm)context.getBean("configurazioniGeneraliSearchForm");
            ConfigurazioniGeneraliSearchForm searchForm = (ConfigurazioniGeneraliSearchForm)sfInSession.clone();
            User utente = null;
            String modalita = null;
            LoginBean lbInSession = (LoginBean)context.getBean("loginBean");
            if (lbInSession != null && lbInSession.isLoggedIn()) {
                utente = lbInSession.getUtente();
                modalita = lbInSession.getModalita();
            }
            searchForm.setUser(utente);
            searchForm.setModalita(modalita);
            searchForm.saveProtocollo();
            service.setSearch((AbstractCoreSearchForm)searchForm);
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idtransazioni = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idtransazioni, (String)",");
            String ruoloS = req.getParameter("ruolo");
            String formato = req.getParameter("formatoConfigurazione");
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idTransazioniFromSession = (String)sessione.getAttribute("idsOriginali");
            String ruoloSFromSession = (String)sessione.getAttribute("ruoloOriginale");
            String formatoFromSession = (String)sessione.getAttribute("fExOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idsOriginali");
            sessione.removeAttribute("ruoloOriginale");
            sessione.removeAttribute("fExOriginali");
            String[] idsFromSession = StringUtils.split((String)idTransazioniFromSession, (String)",");
            PddRuolo ruolo = PddRuolo.toEnumConstant((String)ruoloS);
            boolean bl = exportConsentito = ConfigurazioniExporter.checkParametri(isAll, isAllFromSession, ids, idsFromSession, ruoloS, ruoloSFromSession) && ConfigurazioniExporter.checkFormatoExport(formato, formatoFromSession);
            if (!exportConsentito) {
                String msgErrore = "L'utente non dispone dei permessi necessari per effettuare l'export delle configurazioni.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msgErrore;
                response.sendRedirect(redirectUrl);
                return;
            }
            ConfigurazioniExporter.export(req, response, isAllFromSession, service, idsFromSession, ruolo, formato);
        }
        catch (Exception e) {
            ConfigurazioniExporter.logError(e.getMessage(), e);
        }
    }

    public static void export(HttpServletRequest req, HttpServletResponse response, Boolean isAll, IConfigurazioniGeneraliService service, String[] ids, PddRuolo ruolo, String formato) throws ServletException, IOException {
        try {
            ArrayList<ConfigurazioneGenerale> lst = new ArrayList<ConfigurazioneGenerale>();
            if (isAll != null && isAll.booleanValue()) {
                int offset = 0;
                int letti = 0;
                int limit = 25;
                List<ConfigurazioneGenerale> lstTmp = null;
                do {
                    if ((letti = (lstTmp = service.findAllDettagli(offset, limit)).size()) <= 0) continue;
                    lst.addAll(lstTmp);
                    for (ConfigurazioneGenerale configurazioneGenerale : lstTmp) {
                        if (!configurazioneGenerale.isDatiPortaPrincipale()) continue;
                        ++offset;
                    }
                } while (letti > 0);
            } else {
                for (String idString : ids) {
                    ConfigurazioneGeneralePK key = new ConfigurazioneGeneralePK(idString);
                    ConfigurazioneGenerale findById = (ConfigurazioneGenerale)service.findById(key);
                    lst.add(findById);
                    List<ConfigurazioneGenerale> findConfigurazioniFiglie = service.findConfigurazioniFiglie(findById.getNome(), findById.getRuolo());
                    if (findConfigurazioniFiglie == null || findConfigurazioniFiglie.size() <= 0) continue;
                    lst.addAll(findConfigurazioniFiglie);
                }
            }
            if (!lst.isEmpty()) {
                String mimeType = MimeTypes.getInstance().getMimeType(formato);
                String ext = MimeTypeUtils.fileExtensionForMIMEType((String)mimeType);
                String fileName = "ConfigurazioneServizi." + ext;
                HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
                response.setStatus(200);
                response.flushBuffer();
                ConfigurazioniCsvExporter exporter = new ConfigurazioniCsvExporter(log, ruolo, formato);
                exporter.exportConfigurazioni(lst, (OutputStream)response.getOutputStream());
            } else {
                String fileName = "Errors.txt";
                HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
                response.setStatus(200);
                response.flushBuffer();
                String msgErrore = "La configurazione di export selezionata non ha prodotto nessun csv valido";
                response.getWriter().write(msgErrore);
            }
        }
        catch (Exception e) {
            ConfigurazioniExporter.logError(e.getMessage(), e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean checkParametri(Boolean isAll, Boolean isAllFromSession, String[] ids, String[] idsFromSession, String ruoloS, String ruoloSFromSession) {
        if (isAll == null || isAllFromSession == null || isAll.booleanValue() != isAllFromSession.booleanValue()) {
            return false;
        }
        if (!(ids != null && ids.length != 0 && idsFromSession != null && idsFromSession.length != 0 || isAll.booleanValue())) {
            return false;
        }
        if (ids != null && idsFromSession != null && ids.length != idsFromSession.length) {
            return false;
        }
        if (ids != null) {
            for (String id : ids) {
                boolean found = false;
                for (String idFromSession : idsFromSession) {
                    if (!id.equals(idFromSession)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        if (StringUtils.isEmpty((String)ruoloS) || StringUtils.isEmpty((String)ruoloSFromSession)) {
            return false;
        }
        return ruoloS.equals(ruoloSFromSession);
    }

    public static boolean checkFormatoExport(String formato, String formatoFromSession) {
        if (formato == null || formatoFromSession == null) {
            return false;
        }
        return formato.equals(formatoFromSession);
    }
}

