/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.console.resource;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import net.sf.json.JSONSerializer;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.jminix.console.resource.EncoderBean;
import org.jminix.server.ServerConnectionProvider;
import org.jminix.type.HtmlContent;
import org.jminix.type.InputStreamContent;
import org.restlet.data.CacheDirective;
import org.restlet.data.CharacterSet;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.ext.velocity.TemplateRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateResource
extends ServerResource {
    public String a;
    private static final String VELOCITY_ENGINE_CONTEX_KEY = "template.resource.velocity.engine";
    protected final EncoderBean encoder = new EncoderBean();

    protected void doInit() throws ResourceException {
        super.doInit();
        VelocityEngine ve = (VelocityEngine)this.getContext().getAttributes().get(VELOCITY_ENGINE_CONTEX_KEY);
        if (ve == null) {
            ve = new VelocityEngine();
            Properties p = new Properties();
            p.setProperty("resource.loader", "class");
            p.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
            p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("runtime.log.logsystem.log4j.logger", "common.jmx.velocity");
            try {
                ve.init(p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.getContext().getAttributes().put(VELOCITY_ENGINE_CONTEX_KEY, ve);
        }
    }

    protected abstract String getTemplateName();

    @Get(value="html|txt|json")
    public abstract Map<String, Object> getModel();

    public Representation toRepresentation(Object source, Variant variant) {
        TemplateRepresentation representation;
        if (source instanceof Representation) {
            return (Representation)source;
        }
        if (source == null) {
            return new EmptyRepresentation();
        }
        Map model = (Map)source;
        this.getResponseCacheDirectives().add(CacheDirective.noCache());
        this.getResponseCacheDirectives().add(CacheDirective.mustRevalidate());
        this.getResponseCacheDirectives().add(CacheDirective.noStore());
        if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
            String desc;
            Template template;
            HashMap<String, Object> enrichedModel = new HashMap<String, Object>(model);
            String templateName = this.getTemplateName();
            Object resultObject = enrichedModel.get("value");
            if (resultObject instanceof InputStreamContent) {
                return new InputRepresentation((InputStream)((InputStreamContent)resultObject), MediaType.APPLICATION_OCTET_STREAM);
            }
            if (resultObject instanceof HtmlContent) {
                templateName = "html-attribute";
            }
            try {
                VelocityEngine ve = (VelocityEngine)this.getContext().getAttributes().get(VELOCITY_ENGINE_CONTEX_KEY);
                template = ve.getTemplate("jminix/templates/" + templateName + ".vm");
                template.setEncoding("UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String skin = this.getRequest().getResourceRef().getQueryAsForm().getValues("skin");
            if (skin == null) {
                skin = "default";
            }
            if ((desc = this.getRequest().getResourceRef().getQueryAsForm().getValues("desc")) == null) {
                desc = "on";
            }
            enrichedModel.put("query", this.getQueryString());
            enrichedModel.put("ok", "1".equals(this.getRequest().getResourceRef().getQueryAsForm().getValues("ok")));
            enrichedModel.put("margin", "embedded".equals(skin) ? 0 : 5);
            enrichedModel.put("skin", skin);
            enrichedModel.put("desc", desc);
            enrichedModel.put("encoder", new EncoderBean());
            enrichedModel.put("request", this.getRequest());
            representation = new TemplateRepresentation(template, enrichedModel, MediaType.TEXT_HTML);
        } else if (MediaType.TEXT_PLAIN.equals((Object)variant.getMediaType())) {
            Template template;
            HashMap<String, EncoderBean> enrichedModel = new HashMap<String, EncoderBean>(model);
            try {
                VelocityEngine ve = (VelocityEngine)this.getContext().getAttributes().get(VELOCITY_ENGINE_CONTEX_KEY);
                template = ve.getTemplate("jminix/templates/" + this.getTemplateName() + "-plain.vm");
                template.setEncoding("UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            enrichedModel.put("encoder", this.encoder);
            enrichedModel.put("request", (EncoderBean)this.getRequest());
            representation = new TemplateRepresentation(template, enrichedModel, MediaType.TEXT_PLAIN);
        } else if (MediaType.APPLICATION_JSON.equals((Object)variant.getMediaType())) {
            boolean leaf;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("label", this.unescape(this.getRequest().getOriginalRef().getLastSegment(true)));
            String beforeLast = this.getRequest().getOriginalRef().getSegments().size() > 2 ? (String)this.getRequest().getResourceRef().getSegments().get(this.getRequest().getOriginalRef().getSegments().size() - 3) : null;
            boolean bl = leaf = "attributes".equals(beforeLast) || "operations".equals(beforeLast);
            if (model.containsKey("items") && !leaf) {
                Object items = model.get("items");
                List<Object> itemCollection = null;
                itemCollection = items instanceof Collection ? (List<Object>)items : Arrays.asList(items);
                ArrayList children = new ArrayList();
                for (Object e : itemCollection) {
                    HashMap<String, String> ref = new HashMap<String, String>();
                    if (e instanceof MBeanAttributeInfo) {
                        ref.put("$ref", this.encoder.encode(this.escape(((MBeanAttributeInfo)e).getName())) + "/");
                    } else if (e instanceof Map && ((Map)e).containsKey("declaration")) {
                        ref.put("$ref", ((Map)e).get("declaration").toString());
                    } else {
                        ref.put("$ref", this.encoder.encode(this.escape(e.toString())) + "/");
                    }
                    children.add(ref);
                }
                result.put("children", children);
            } else if (model.containsKey("value")) {
                if (model.get("value") instanceof HtmlContent) {
                    result.put("value", "...");
                } else {
                    result.put("value", model.get("value").toString());
                }
            } else if (model.containsKey("items")) {
                Object items = model.get("items");
                String value = null;
                value = items.getClass().isArray() ? Arrays.deepToString(Arrays.asList(items).toArray()) : items.toString();
                result.put("value", value);
            } else if (model.containsKey("attributes") && model.get("attributes") instanceof CompositeData) {
                CompositeData items = (CompositeData)model.get("attributes");
                result.put("value", items.values());
            }
            representation = "servers".equals(this.getRequest().getOriginalRef().getLastSegment(true)) ? new StringRepresentation((CharSequence)JSONSerializer.toJSON((Object)new Object[]{result}).toString(), MediaType.APPLICATION_JSON, Language.ALL, CharacterSet.UTF_8) : new StringRepresentation((CharSequence)JSONSerializer.toJSON(result).toString(), MediaType.APPLICATION_JSON, Language.ALL, CharacterSet.UTF_8);
        } else {
            return null;
        }
        representation.setExpirationDate(new Date(0L));
        return representation;
    }

    protected ServerConnectionProvider getServerProvider() {
        return (ServerConnectionProvider)this.getContext().getAttributes().get("serverProvider");
    }

    protected MBeanServerConnection getServer() {
        return this.getServerProvider().getConnection(this.getDecodedAttribute("server"));
    }

    protected String getQueryString() {
        String query = this.getRequest().getResourceRef().getQuery();
        return query != null ? "?" + query : "";
    }

    protected String getDecodedAttribute(String value) {
        return this.encoder.decode(this.getAttribute(value));
    }

    public String escape(String value) {
        return value.replaceAll("/", "\u00c2\u00a6");
    }

    public String unescape(String value) {
        return value.replaceAll("\u00c2\u00a6", "/");
    }
}

