/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.console.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.sf.json.JSONSerializer;
import org.jminix.console.resource.AbstractTemplateResource;
import org.jminix.console.resource.ValueParser;
import org.jminix.type.HtmlContent;
import org.jminix.type.InputStreamContent;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationResource
extends AbstractTemplateResource {
    private String templateName = "operation";

    @Override
    public Map<String, Object> getModel() {
        String domain = this.unescape(this.getDecodedAttribute("domain"));
        String mbean = this.unescape(this.getDecodedAttribute("mbean"));
        String declaration = this.getDecodedAttribute("operation");
        String operation = declaration.split("\\(")[0];
        String signature = declaration.split("\\(").length > 1 ? (declaration.split("\\(")[1].split("\\)").length > 0 ? declaration.split("\\(")[1].split("\\)")[0] : "") : "";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("operation", this.getOperation(this.getServer(), domain, mbean, operation, signature));
        return model;
    }

    @Post(value="*:txt|html|json")
    public Representation execute(Representation entity) throws ResourceException {
        String[] stringParams = new Form(entity).getValuesArray("param");
        String domain = this.unescape(this.getDecodedAttribute("domain"));
        String mbean = this.unescape(this.getDecodedAttribute("mbean"));
        String declaration = this.getDecodedAttribute("operation");
        String operation = declaration.split("\\(")[0];
        String[] signature = declaration.split("\\(").length > 1 ? (declaration.split("\\(")[1].split("\\)").length > 0 ? declaration.split("\\(")[1].split("\\)")[0].split(",") : new String[]{}) : new String[]{};
        MBeanServerConnection server = this.getServer();
        try {
            Object[] params = new Object[signature.length];
            ValueParser parser = new ValueParser();
            for (int i = 0; i < stringParams.length; ++i) {
                params[i] = parser.parse(stringParams[i], signature[i]);
            }
            Object result = server.invoke(new ObjectName(domain + ":" + mbean), operation, params, signature);
            if (result != null) {
                Variant variant = this.getPreferredVariant(this.getVariants());
                if (MediaType.APPLICATION_JSON == variant.getMediaType()) {
                    return new StringRepresentation((CharSequence)JSONSerializer.toJSON((Object)result).toString(), MediaType.APPLICATION_JSON, Language.ALL, CharacterSet.UTF_8);
                }
                if (result instanceof InputStreamContent) {
                    return new InputRepresentation((InputStream)((InputStreamContent)result), MediaType.APPLICATION_OCTET_STREAM);
                }
                return new StringRepresentation((CharSequence)result.toString(), result instanceof HtmlContent ? MediaType.TEXT_HTML : MediaType.TEXT_PLAIN, Language.ALL, CharacterSet.UTF_8);
            }
            String queryString = this.getQueryString();
            if (!queryString.contains("ok=1")) {
                queryString = queryString == null || "".equals(queryString) ? "?" : queryString + "&";
                queryString = queryString + "ok=1";
            }
            this.redirectPermanent(this.encoder.encode(declaration) + queryString);
            return null;
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getTemplateName() {
        return this.templateName;
    }

    private MBeanOperationInfo getOperation(MBeanServerConnection server, String domain, String mbean, String operationName, String signature) {
        try {
            for (MBeanOperationInfo i : server.getMBeanInfo(new ObjectName(domain + ":" + mbean)).getOperations()) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (MBeanParameterInfo p : i.getSignature()) {
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    sb.append(p.getType());
                }
                if (!i.getName().equals(operationName) || !sb.toString().equals(signature)) continue;
                return i;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}

