/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.loader.config.LoaderInstanceProperties;
import org.slf4j.Logger;

public class LoaderProperties {
    private Logger log = null;
    private LoaderInstanceProperties reader;
    private static LoaderProperties loaderProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoaderProperties(String confDir, Logger log) throws UtilsException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(LoaderProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = LoaderProperties.class.getResourceAsStream("/loader.properties");
            if (properties == null) {
                throw new UtilsException("File '/loader.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.doError(e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new LoaderInstanceProperties(propertiesReader, this.log, confDir);
    }

    private void doError(Exception e) throws UtilsException {
        String msg = "Riscontrato errore durante la lettura del file 'loader.properties': " + e.getMessage();
        this.log.error(msg, (Throwable)e);
        throw new UtilsException("ConsoleProperties initialize error: " + e.getMessage(), (Throwable)e);
    }

    public static boolean initialize(String confDir, Logger log) {
        try {
            loaderProperties = new LoaderProperties(confDir, log);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static LoaderProperties getInstance() throws OpenSPCoop2ConfigurationException {
        if (loaderProperties == null) {
            Class<LoaderProperties> clazz = LoaderProperties.class;
            synchronized (LoaderProperties.class) {
                throw new OpenSPCoop2ConfigurationException("LoaderProperties non inizializzato");
            }
        }
        return loaderProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        LoaderProperties.loaderProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    private Boolean readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (true/value expected)");
        }
        return Boolean.parseBoolean(tmp);
    }

    public String getProtocolloDefault() throws UtilsException {
        return this.readProperty(false, "protocolloDefault");
    }

    public Boolean isAutenticazioneUtentiUtilizzaDabaseRegistro() throws UtilsException {
        return this.readBooleanProperty(false, "user.searchDatabaseRegistro");
    }

    public String getConsoleUtenzePassword() throws UtilsException {
        return this.readProperty(true, "user.password");
    }

    public String getNomePddOperativaConsoleSinglePdDMode() throws UtilsException {
        return this.readProperty(false, "nomePddOperativa_CtrlstatSinglePdD");
    }

    public String getTipoPortaDiDominio() throws UtilsException {
        return this.readProperty(false, "tipoPdD");
    }

    public Boolean isGestioneSoggetti() throws UtilsException {
        return this.readBooleanProperty(true, "gestioneSoggetti");
    }

    public Boolean isMantieniFruitoriServiziEsistenti() throws UtilsException {
        return this.readBooleanProperty(true, "mantieniFruitoriServiziEsistenti");
    }

    public StatiAccordo getStatoAccordi() throws UtilsException {
        String tmp = this.readProperty(true, "statoAccordi");
        if (!(StatiAccordo.bozza.toString().equals(tmp) || StatiAccordo.operativo.toString().equals(tmp) || StatiAccordo.finale.toString().equals(tmp))) {
            String errorMsg = "Opzione 'statoAccordi' non valida (" + tmp + "), valori possibili sono: " + StatiAccordo.bozza.toString() + "," + StatiAccordo.operativo.toString() + "," + StatiAccordo.finale.toString();
            throw new UtilsException(errorMsg);
        }
        return StatiAccordo.valueOf((String)tmp);
    }

    public String getConsoleNomeSintesi() throws UtilsException {
        return this.readProperty(true, "loader.nome.sintesi");
    }

    public String getConsoleNomeEsteso() throws UtilsException {
        return this.readProperty(true, "loader.nome.esteso");
    }

    public String getConsoleCSS() throws UtilsException {
        return this.readProperty(true, "loader.css");
    }

    public String getConsoleLanguage() throws UtilsException {
        return this.readProperty(true, "loader.language");
    }

    public int getConsoleLunghezzaLabel() throws UtilsException {
        String lunghezzaS = this.readProperty(true, "loader.lunghezzaLabel");
        return Integer.parseInt(lunghezzaS);
    }

    public String getLogoHeaderImage() throws UtilsException {
        return this.readProperty(false, "console.header.logo.image");
    }

    public String getLogoHeaderTitolo() throws UtilsException {
        return this.readProperty(false, "console.header.logo.titolo");
    }

    public String getLogoHeaderLink() throws UtilsException {
        return this.readProperty(false, "console.header.logo.link");
    }

    public boolean isVisualizzaLinkHomeHeader() throws UtilsException {
        return this.readBooleanProperty(true, "console.header.home.link.enabled");
    }
}

