/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.IVersionInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.VersionUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.DriverUsersDB;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.loader.config.DatasourceProperties;
import org.openspcoop2.web.loader.config.LoaderProperties;
import org.openspcoop2.web.loader.core.Costanti;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class LoaderCore {
    public static Logger log = null;
    private String loaderNomeSintesi = null;
    private String loaderNomeEsteso = null;
    private String loaderNomeEstesoSuffix = null;
    private String loaderCSS = null;
    private String loaderLanguage = null;
    private int consoleLunghezzaLabel = 50;
    private String logoHeaderImage = null;
    private String logoHeaderTitolo = null;
    private String logoHeaderLink = null;
    private boolean visualizzaLinkHomeHeader = false;
    private String nomePdDOperativaCtrlstatSinglePdD = null;
    private boolean searchUserIntoRegistro = true;
    private boolean gestioneSoggetti = true;
    private boolean mantieniFruitoriServizi = true;
    private StatiAccordo statoAccordo = null;
    private String tipoPdD = null;
    private String protocolloDefault;
    private String dataSourceRegistroServizi = null;
    private Properties ctxDatasourceRegistroServizi = null;
    private String tipoDatabaseRegistroServizi = null;
    private String dataSourceConfigurazionePdD = null;
    private Properties ctxDatasourceConfigurazionePdD = null;
    private String tipoDatabaseConfigurazionePdD = null;
    private AbstractXMLUtils xmlUtils = null;
    private static final String VERSION_INFO_READ = "VERSION_INFO_READ";
    private static final String VERSION_INFO = "VERSION_INFO";
    private IVersionInfo versionInfo = null;
    private Boolean versionInfoRead = null;

    private String getTitleSuffix(HttpServletRequest request, HttpSession session) {
        IVersionInfo versionInfo = null;
        try {
            versionInfo = this.getInfoVersion(request, session);
        }
        catch (Exception e) {
            log.error("Errore durante la lettura delle informazioni sulla versione: " + e.getMessage(), (Throwable)e);
        }
        String consoleNomeEstesoSuffix = null;
        if (versionInfo != null) {
            if (!StringUtils.isEmpty((String)versionInfo.getErrorTitleSuffix(new Object[0]))) {
                consoleNomeEstesoSuffix = versionInfo.getErrorTitleSuffix(new Object[0]);
            } else if (!StringUtils.isEmpty((String)versionInfo.getWarningTitleSuffix(new Object[0]))) {
                consoleNomeEstesoSuffix = versionInfo.getWarningTitleSuffix(new Object[0]);
            }
        }
        return consoleNomeEstesoSuffix;
    }

    public String getLoaderNomeSintesi() {
        return this.loaderNomeSintesi;
    }

    public String getLoaderNomeEsteso(HttpServletRequest request, HttpSession session) {
        Object titleSuffix = this.getTitleSuffix(request, session);
        if (!StringUtils.isEmpty((String)titleSuffix)) {
            if (!((String)titleSuffix).startsWith(" ")) {
                titleSuffix = " " + (String)titleSuffix;
            }
            return this.loaderNomeEsteso + (String)titleSuffix;
        }
        return this.loaderNomeEsteso;
    }

    public String getProductVersion() {
        Object pVersion = null;
        pVersion = "GovWay 3.3.18";
        try {
            String version = VersionUtilities.readVersion();
            if (version != null && !StringUtils.isEmpty((String)version)) {
                pVersion = version;
            }
        }
        catch (Exception version) {
            // empty catch block
        }
        String buildVersion = null;
        try {
            buildVersion = VersionUtilities.readBuildVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buildVersion != null) {
            pVersion = (String)pVersion + " (build " + buildVersion + ")";
        }
        return pVersion;
    }

    public String getLoaderCSS() {
        return this.loaderCSS;
    }

    public String getLoaderLanguage() {
        return this.loaderLanguage;
    }

    public int getConsoleLunghezzaLabel() {
        return this.consoleLunghezzaLabel;
    }

    public String getLogoHeaderImage() {
        return this.logoHeaderImage;
    }

    public String getLogoHeaderTitolo() {
        return this.logoHeaderTitolo;
    }

    public String getLogoHeaderLink() {
        return this.logoHeaderLink;
    }

    public boolean isVisualizzaLinkHomeHeader() {
        return this.visualizzaLinkHomeHeader;
    }

    public LoaderCore() throws Exception {
        log = LoggerWrapperFactory.getLogger((String)"govway.loader");
        this.initCore();
    }

    public boolean isSearchUserIntoRegistro() {
        return this.searchUserIntoRegistro;
    }

    private void initCore() throws Exception {
        DatasourceProperties datasourceProperties = null;
        try {
            datasourceProperties = DatasourceProperties.getInstance();
            this.dataSourceRegistroServizi = datasourceProperties.getRegistroServiziDataSource();
            this.tipoDatabaseRegistroServizi = datasourceProperties.getRegistroServiziTipoDatabase();
            this.ctxDatasourceRegistroServizi = datasourceProperties.getRegistroServiziDataSourceContext();
            this.dataSourceConfigurazionePdD = datasourceProperties.getConfigurazioneDataSource();
            this.tipoDatabaseConfigurazionePdD = datasourceProperties.getConfigurazioneTipoDatabase();
            this.ctxDatasourceConfigurazionePdD = datasourceProperties.getConfigurazioneDataSourceContext();
        }
        catch (Exception e) {
            log.error("[OpenSPCoopLoader::initCore] Impossibile leggere i dati dal file loader.datasource.properties:" + e.toString());
            throw new Exception("[OpenSPCoopLoader::initCore] Impossibile leggere i dati dal file loader.datasource.properties:" + e.toString());
        }
        LoaderProperties loaderProperties = null;
        try {
            loaderProperties = LoaderProperties.getInstance();
            this.nomePdDOperativaCtrlstatSinglePdD = loaderProperties.getNomePddOperativaConsoleSinglePdDMode();
            if (this.nomePdDOperativaCtrlstatSinglePdD == null) {
                this.nomePdDOperativaCtrlstatSinglePdD = this.getNomePddOperativa();
            }
            this.gestioneSoggetti = loaderProperties.isGestioneSoggetti();
            this.mantieniFruitoriServizi = loaderProperties.isMantieniFruitoriServiziEsistenti();
            this.searchUserIntoRegistro = loaderProperties.isAutenticazioneUtentiUtilizzaDabaseRegistro();
            this.statoAccordo = loaderProperties.getStatoAccordi();
            this.tipoPdD = loaderProperties.getTipoPortaDiDominio();
            if (this.tipoPdD == null) {
                this.tipoPdD = Costanti.PDD_TIPOLOGIA_ESTERNA;
            }
            this.protocolloDefault = loaderProperties.getProtocolloDefault();
            this.loaderNomeSintesi = loaderProperties.getConsoleNomeSintesi();
            this.loaderNomeEsteso = loaderProperties.getConsoleNomeEsteso();
            this.loaderCSS = loaderProperties.getConsoleCSS();
            this.loaderLanguage = loaderProperties.getConsoleLanguage();
            this.consoleLunghezzaLabel = loaderProperties.getConsoleLunghezzaLabel();
            this.logoHeaderImage = loaderProperties.getLogoHeaderImage();
            this.logoHeaderLink = loaderProperties.getLogoHeaderLink();
            this.logoHeaderTitolo = loaderProperties.getLogoHeaderTitolo();
            this.visualizzaLinkHomeHeader = loaderProperties.isVisualizzaLinkHomeHeader();
        }
        catch (Exception e) {
            log.error("[OpenSPCoopLoader::initCore] Impossibile leggere i dati dal file loader.properties:" + e.toString());
            throw new Exception("[OpenSPCoopLoader::initCore] Impossibile leggere i dati dal file loader.properties:" + e.toString());
        }
        this.xmlUtils = MessageXMLUtils.DEFAULT;
    }

    public LoaderCore(LoaderCore core) throws Exception {
        this.dataSourceRegistroServizi = core.dataSourceRegistroServizi;
        this.tipoDatabaseRegistroServizi = core.tipoDatabaseRegistroServizi;
        this.ctxDatasourceRegistroServizi = core.ctxDatasourceRegistroServizi;
        this.dataSourceConfigurazionePdD = core.dataSourceConfigurazionePdD;
        this.tipoDatabaseConfigurazionePdD = core.tipoDatabaseConfigurazionePdD;
        this.ctxDatasourceConfigurazionePdD = core.ctxDatasourceConfigurazionePdD;
        this.nomePdDOperativaCtrlstatSinglePdD = core.nomePdDOperativaCtrlstatSinglePdD;
        if (this.nomePdDOperativaCtrlstatSinglePdD == null) {
            this.nomePdDOperativaCtrlstatSinglePdD = this.getNomePddOperativa();
        }
        this.gestioneSoggetti = core.gestioneSoggetti;
        this.mantieniFruitoriServizi = core.mantieniFruitoriServizi;
        this.searchUserIntoRegistro = core.searchUserIntoRegistro;
        this.statoAccordo = core.statoAccordo;
        this.tipoPdD = core.tipoPdD;
        if (this.tipoPdD == null) {
            this.tipoPdD = Costanti.PDD_TIPOLOGIA_ESTERNA;
        }
        this.protocolloDefault = core.protocolloDefault;
        this.loaderNomeSintesi = core.loaderNomeSintesi;
        this.loaderNomeEsteso = core.loaderNomeEsteso;
        this.loaderNomeEstesoSuffix = core.loaderNomeEstesoSuffix;
        this.loaderCSS = core.loaderCSS;
        this.loaderLanguage = core.loaderLanguage;
        this.consoleLunghezzaLabel = core.consoleLunghezzaLabel;
        this.logoHeaderImage = core.logoHeaderImage;
        this.logoHeaderLink = core.logoHeaderLink;
        this.logoHeaderTitolo = core.logoHeaderTitolo;
        this.visualizzaLinkHomeHeader = core.visualizzaLinkHomeHeader;
        this.xmlUtils = MessageXMLUtils.DEFAULT;
    }

    public static Logger getLog() {
        return log;
    }

    public String getDataSourceRegistroServizi() {
        return this.dataSourceRegistroServizi;
    }

    public Properties getCtxDatasourceRegistroServizi() {
        return this.ctxDatasourceRegistroServizi;
    }

    public String getTipoDatabaseRegistroServizi() {
        return this.tipoDatabaseRegistroServizi;
    }

    public String getDataSourceConfigurazionePdD() {
        return this.dataSourceConfigurazionePdD;
    }

    public Properties getCtxDatasourceConfigurazionePdD() {
        return this.ctxDatasourceConfigurazionePdD;
    }

    public String getTipoDatabaseConfigurazionePdD() {
        return this.tipoDatabaseConfigurazionePdD;
    }

    public String getNomePdDOperativaCtrlstatSinglePdD() {
        return this.nomePdDOperativaCtrlstatSinglePdD;
    }

    public boolean isGestioneSoggetti() {
        return this.gestioneSoggetti;
    }

    public boolean isMantieniFruitoriServizi() {
        return this.mantieniFruitoriServizi;
    }

    public StatiAccordo getStatoAccordo() {
        return this.statoAccordo;
    }

    public String getTipoPdD() {
        return this.tipoPdD;
    }

    public String getProtocolloDefault() {
        return this.protocolloDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IVersionInfo initInfoVersion(HttpServletRequest request, HttpSession session, String tipoDB) throws UtilsException {
        block19: {
            if (this.versionInfoRead == null) {
                try {
                    Boolean versionInfoReadFromSession = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, Boolean.class, (String)VERSION_INFO_READ);
                    if (versionInfoReadFromSession != null) {
                        this.versionInfoRead = versionInfoReadFromSession;
                        this.versionInfo = (IVersionInfo)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, IVersionInfo.class, (String)VERSION_INFO);
                        break block19;
                    }
                    IVersionInfo vInfo = VersionUtilities.readInfoVersion();
                    if (vInfo != null) {
                        Connection con = null;
                        try {
                            GestoreJNDI jndi = new GestoreJNDI(this.ctxDatasourceRegistroServizi);
                            DataSource ds = (DataSource)jndi.lookup(this.dataSourceRegistroServizi);
                            con = ds.getConnection();
                            vInfo.init(log, new Object[]{con, tipoDB});
                            this.versionInfo = vInfo;
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            try {
                                if (con != null) {
                                    con.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)true, (String)VERSION_INFO_READ);
                    if (vInfo != null) {
                        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)vInfo, (String)VERSION_INFO);
                    }
                }
                finally {
                    this.versionInfoRead = true;
                }
            }
        }
        return this.versionInfo;
    }

    public IVersionInfo getInfoVersion(HttpServletRequest request, HttpSession session) throws UtilsException {
        if (this.versionInfoRead == null) {
            this.initInfoVersion(request, session, this.tipoDatabaseRegistroServizi);
        }
        return this.versionInfo;
    }

    public boolean existsUserRegistro(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "existsUserRegistro";
        try {
            GestoreJNDI jndi = new GestoreJNDI(this.ctxDatasourceRegistroServizi);
            DataSource ds = (DataSource)jndi.lookup(this.dataSourceRegistroServizi);
            con = ds.getConnection();
            DriverUsersDB driver = new DriverUsersDB(con, this.tipoDatabaseRegistroServizi, log);
            boolean bl = driver.existsUser(login);
            return bl;
        }
        catch (Exception e) {
            log.error("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
            throw new DriverUsersDBException("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsUserConfig(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "existsUserConfig";
        try {
            GestoreJNDI jndi = new GestoreJNDI(this.ctxDatasourceConfigurazionePdD);
            DataSource ds = (DataSource)jndi.lookup(this.dataSourceConfigurazionePdD);
            con = ds.getConnection();
            DriverUsersDB driver = new DriverUsersDB(con, this.tipoDatabaseConfigurazionePdD, log);
            boolean bl = driver.existsUser(login);
            return bl;
        }
        catch (Exception e) {
            log.error("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
            throw new DriverUsersDBException("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public User getUserRegistro(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getUserRegistro";
        try {
            GestoreJNDI jndi = new GestoreJNDI(this.ctxDatasourceRegistroServizi);
            DataSource ds = (DataSource)jndi.lookup(this.dataSourceRegistroServizi);
            con = ds.getConnection();
            DriverUsersDB driver = new DriverUsersDB(con, this.tipoDatabaseRegistroServizi, log);
            User user = driver.getUser(login);
            return user;
        }
        catch (Exception e) {
            log.error("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
            throw new DriverUsersDBException("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public User getUserConfig(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getUserConfig";
        try {
            GestoreJNDI jndi = new GestoreJNDI(this.ctxDatasourceConfigurazionePdD);
            DataSource ds = (DataSource)jndi.lookup(this.dataSourceConfigurazionePdD);
            con = ds.getConnection();
            DriverUsersDB driver = new DriverUsersDB(con, this.tipoDatabaseConfigurazionePdD, log);
            User user = driver.getUser(login);
            return user;
        }
        catch (Exception e) {
            log.error("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
            throw new DriverUsersDBException("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getNomePddOperativa() throws Exception {
        Connection con = null;
        String nomeMetodo = "getNomePddOperativa";
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            GestoreJNDI jndi = new GestoreJNDI(this.ctxDatasourceRegistroServizi);
            DataSource ds = (DataSource)jndi.lookup(this.dataSourceRegistroServizi);
            con = ds.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabaseRegistroServizi);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addWhereCondition("tipo=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, Costanti.PDD_TIPOLOGIA_OPERATIVA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                String nomePdd = risultato.getString("nome");
                if (risultato.next()) {
                    throw new Exception("Esiste piu' di una pdd con tipologia '" + Costanti.PDD_TIPOLOGIA_OPERATIVA + "'");
                }
                String string = nomePdd;
                return string;
            }
            try {
                throw new Exception("Non esiste una pdd con tipologia '" + Costanti.PDD_TIPOLOGIA_OPERATIVA + "'");
            }
            catch (Exception e) {
                log.error("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
                throw new Exception("[LoaderCore::" + nomeMetodo + "] Error :" + e.getMessage(), e);
            }
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public byte[] readBytes(FormFile ff) throws Exception {
        byte[] data = ff.getFileData();
        Document d = this.xmlUtils.newDocument(data);
        String xml = this.xmlUtils.toString(d, true);
        xml = Utilities.eraserXmlAttribute((String)xml, (String)"xml:base=");
        data = xml.getBytes();
        return data;
    }
}

