/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.core;

import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementParameter;
import org.openspcoop2.web.loader.config.DatasourceProperties;
import org.openspcoop2.web.loader.config.LoaderProperties;
import org.openspcoop2.web.loader.core.LoaderLogger;
import org.slf4j.Logger;

public class LoaderStartup
implements ServletContextListener {
    private static Logger log = null;
    private static boolean initialized = false;

    public static boolean isInitialized() {
        return initialized;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log == null) {
            log = LoggerWrapperFactory.getLogger((String)"govway.loader");
        }
        log.info("Undeploy loader in corso...");
        initialized = false;
        log.info("Undeploy loader effettuato.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        String confDir = null;
        boolean appendActualConfiguration = false;
        try {
            InputStream is = LoaderStartup.class.getResourceAsStream("/loader.properties");
            try {
                if (is != null) {
                    String tmpAppendActualConfiguration;
                    Properties p = new Properties();
                    p.load(is);
                    confDir = p.getProperty("confDirectory");
                    if (confDir != null) {
                        confDir = confDir.trim();
                    }
                    if ((tmpAppendActualConfiguration = p.getProperty("appendLog4j")) != null) {
                        appendActualConfiguration = "true".equalsIgnoreCase(tmpAppendActualConfiguration.trim());
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception p) {}
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        try {
            LoaderLogger.initialize(log, confDir, null, appendActualConfiguration);
            log = LoggerWrapperFactory.getLogger((String)"govway.loader");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        log.info("Inizializzazione loader in corso...");
        LoaderProperties.initialize(confDir, log);
        DatasourceProperties.initialize(confDir, log);
        log.info("Inizializzazione loader effettuata con successo.");
        log.info("Inizializzazione ExtendedInfoManager in corso...");
        try {
            ExtendedInfoManager.initialize((Loader)new Loader(), null, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        log.info("Inizializzazione ExtendedInfoManager effettuata con successo");
        log.info("Inizializzazione DataElement in corso...");
        try {
            LoaderProperties loaderProperties = LoaderProperties.getInstance();
            int consoleLunghezzaLabel = loaderProperties.getConsoleLunghezzaLabel();
            DataElementParameter dep = new DataElementParameter();
            dep.setSize(Integer.valueOf(consoleLunghezzaLabel));
            DataElement.initialize((DataElementParameter)dep);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        log.info("Inizializzazione DataElement effettuata con successo");
    }

    public static void setInitialized(boolean initialized) {
        LoaderStartup.initialized = initialized;
    }
}

