/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.servlet;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.GeneralLink;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.loader.config.LoaderProperties;
import org.openspcoop2.web.loader.core.LoaderCore;
import org.slf4j.Logger;

public class GeneralHelper {
    HttpSession session;
    public Logger log;
    private LoaderCore loaderCore;
    protected int size = 50;

    public GeneralHelper(HttpSession session) {
        this.session = session;
        try {
            this.loaderCore = new LoaderCore();
            this.size = LoaderProperties.getInstance().getConsoleLunghezzaLabel();
        }
        catch (Exception e) {
            this.log = LoggerWrapperFactory.getLogger((String)"govway.loader");
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
        this.log = LoggerWrapperFactory.getLogger((String)"govway.loader");
    }

    public GeneralData initGeneralData(HttpServletRequest request) {
        String baseUrl = request.getRequestURI();
        return this.initGeneralData_engine(request, baseUrl);
    }

    public GeneralData initGeneralData(HttpServletRequest request, String servletName) {
        Object baseUrl = request.getContextPath();
        baseUrl = servletName.startsWith("/") ? (String)baseUrl + servletName : (String)baseUrl + "/" + servletName;
        return this.initGeneralData_engine(request, (String)baseUrl);
    }

    private GeneralData initGeneralData_engine(HttpServletRequest request, String baseUrl) {
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
        String css = this.loaderCore.getLoaderCSS();
        boolean displayUtente = false;
        boolean displayLogin = true;
        boolean displayLogout = true;
        if (baseUrl.indexOf("/login.do") != -1 && userLogin == null || baseUrl.indexOf("/logout.do") != -1) {
            displayLogin = false;
            displayLogout = false;
        }
        if (userLogin != null) {
            displayLogin = false;
            displayUtente = true;
        }
        GeneralData gd = new GeneralData("https://link.it");
        gd.setProduct(this.loaderCore.getLoaderNomeSintesi());
        gd.setLanguage(this.loaderCore.getLoaderLanguage());
        gd.setTitle(StringEscapeUtils.escapeHtml((String)this.loaderCore.getLoaderNomeEsteso(request, this.session)));
        gd.setUrl(baseUrl);
        gd.setCss(css);
        gd.setLogoHeaderImage(this.loaderCore.getLogoHeaderImage());
        gd.setLogoHeaderLink(this.loaderCore.getLogoHeaderLink());
        gd.setLogoHeaderTitolo(this.loaderCore.getLogoHeaderTitolo());
        gd.setVisualizzaLinkHome(this.loaderCore.isVisualizzaLinkHomeHeader());
        if (displayLogin || displayLogout) {
            ArrayList<GeneralLink> link = new ArrayList<GeneralLink>();
            if (displayUtente) {
                GeneralLink glUtente = new GeneralLink();
                glUtente.setLabel(userLogin);
                glUtente.setUrl("");
                link.add(glUtente);
            }
            GeneralLink glO = new GeneralLink();
            glO.setLabel("Informazioni");
            glO.setUrl("about.do");
            link.add(glO);
            if (displayLogin) {
                GeneralLink gl1 = new GeneralLink();
                gl1.setLabel("Login");
                gl1.setUrl("login.do");
                link.add(gl1);
            }
            if (displayLogout) {
                GeneralLink gl2 = new GeneralLink();
                gl2.setLabel("Logout");
                gl2.setUrl("logout.do");
                link.add(gl2);
            }
            GeneralLink gl4 = new GeneralLink();
            gl4.setLabel("");
            link.add(gl4);
            gd.setHeaderLinks(link);
        }
        return gd;
    }

    public PageData initPageData() {
        return this.initPageData(null);
    }

    public PageData initPageData(String breadcrumb) {
        PageData pd = new PageData();
        if (breadcrumb != null) {
            ArrayList<GeneralLink> titlelist = new ArrayList<GeneralLink>();
            GeneralLink tl1 = new GeneralLink();
            tl1.setLabel(breadcrumb);
            titlelist.add(tl1);
            pd.setTitleList(titlelist);
        }
        DataElement titoloSezione = new DataElement();
        titoloSezione.setLabel("Login");
        titoloSezione.setType(DataElementType.TITLE);
        titoloSezione.setName("");
        ArrayList<DataElement> dati = new ArrayList<DataElement>();
        DataElement login = new DataElement();
        login.setLabel("Login");
        login.setType(DataElementType.TEXT_EDIT);
        login.setName("login");
        login.setStyleClass("inputLink");
        DataElement pwd = new DataElement();
        pwd.setLabel("Password");
        pwd.setType(DataElementType.CRYPT);
        pwd.setName("password");
        pwd.setStyleClass("inputLink");
        dati.add(titoloSezione);
        dati.add(login);
        dati.add(pwd);
        pd.setDati(dati);
        return pd;
    }

    public int getSize() {
        return this.size;
    }
}

