/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.servlet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.MenuEntry;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.loader.config.LoaderProperties;
import org.openspcoop2.web.loader.core.LoaderCore;
import org.openspcoop2.web.loader.servlet.about.AboutCore;
import org.openspcoop2.web.loader.servlet.archivi.ImportaXML;
import org.slf4j.Logger;

public class LoaderHelper {
    protected HttpServletRequest request;
    protected PageData pd;
    protected HttpSession session;
    protected LoaderCore core;
    protected AboutCore aboutCore;
    protected ICrypt passwordManager;
    protected ICrypt passwordManagerBackwardCompatibility;
    private Logger log = null;

    public ICrypt getPasswordManager() {
        return this.passwordManager;
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isEditModeInProgress() throws Exception {
        String editMode = this.request.getParameter("edit-mode");
        return ServletUtils.isEditModeInProgress((String)editMode);
    }

    public boolean isEditModeFinished() throws Exception {
        String editMode = this.request.getParameter("edit-mode");
        return ServletUtils.isEditModeFinished((String)editMode);
    }

    public String getPostBackElementName() throws Exception {
        return this.request.getParameter("postBackElementName");
    }

    public LoaderHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        this.request = request;
        this.pd = pd;
        this.session = session;
        this.log = LoggerWrapperFactory.getLogger((String)"govway.loader");
        try {
            this.core = new LoaderCore();
            this.aboutCore = new AboutCore(this.core);
            LoaderProperties consoleProperties = LoaderProperties.getInstance();
            CryptConfig config = new CryptConfig(consoleProperties.getConsoleUtenzePassword());
            this.passwordManager = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
            if (config.isBackwardCompatibility()) {
                this.passwordManagerBackwardCompatibility = CryptFactory.getOldMD5Crypt((Logger)this.log);
            }
        }
        catch (Exception e) {
            this.log.error("Exception LoaderHelper: " + e.getMessage(), (Throwable)e);
        }
    }

    public int getSize() {
        return 50;
    }

    public void makeMenu() {
        ArrayList<MenuEntry> menu = new ArrayList<MenuEntry>();
        MenuEntry me1 = new MenuEntry();
        me1.setTitle("Strumenti");
        String[][] entries1 = new String[2][2];
        entries1[0][0] = "Importa";
        entries1[0][1] = "importaXml.do";
        entries1[1][0] = "Elimina";
        entries1[1][1] = "eliminazioneXml.do";
        me1.setEntries(entries1);
        menu.add(me1);
        this.pd.setMenu(menu);
    }

    public boolean loginCheckData(boolean verificaPassword) throws DriverUsersDBException {
        String pwcrypt;
        String login = this.request.getParameter("login");
        String password = this.request.getParameter("password");
        if (login.equals("")) {
            this.pd.setMessage("Dati incompleti. E' necessario indicare un utente", MessageType.ERROR_SINTETICO);
            return false;
        }
        if (verificaPassword && password.equals("")) {
            this.pd.setMessage("Dati incompleti. E' necessario indicare una Password", MessageType.ERROR_SINTETICO);
            return false;
        }
        boolean trovato = false;
        trovato = this.core.isSearchUserIntoRegistro() ? this.core.existsUserRegistro(login) : this.core.existsUserConfig(login);
        User u = null;
        if (trovato) {
            u = this.core.isSearchUserIntoRegistro() ? this.core.getUserRegistro(login) : this.core.getUserConfig(login);
        }
        if (trovato && verificaPassword && (pwcrypt = u.getPassword()) != null && !pwcrypt.equals("") && !(trovato = this.passwordManager.check(password, pwcrypt)) && this.passwordManagerBackwardCompatibility != null) {
            trovato = this.passwordManagerBackwardCompatibility.check(password, pwcrypt);
        }
        if (!trovato) {
            if (!verificaPassword) {
                this.pd.setMessage("L'utente fornito non esiste", MessageType.ERROR_SINTETICO);
            } else {
                this.pd.setMessage("Le credenziali fornite non sono corrette", MessageType.ERROR_SINTETICO);
            }
            return false;
        }
        if (!u.getPermessi().isServizi()) {
            this.pd.setMessage("L'utente non possiede i diritti per creare configurazioni", MessageType.ERROR_SINTETICO);
            return false;
        }
        ServletUtils.setUserIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (User)u);
        return true;
    }

    public void addImportaXMLtoDati(List<DataElement> dati, String tipoxml) {
        DataElement de = new DataElement();
        de.setLabel("Importa");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipologia");
        de.setType(DataElementType.SELECT);
        String[] stati = new String[]{"registroServizi", "configurazionePdD"};
        de.setValues(stati);
        de.setSelected(tipoxml);
        de.setName("tipoxml");
        dati.add(de);
        de = new DataElement();
        de.setValue("");
        de.setLabel("File");
        de.setType(DataElementType.FILE);
        de.setName("theFile");
        de.setSize(this.getSize());
        dati.add(de);
    }

    public void addEliminazioneXMLtoDati(List<DataElement> dati, String tipoxml) {
        DataElement de = new DataElement();
        de.setLabel("Elimina");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipologia");
        de.setType(DataElementType.SELECT);
        String[] stati = new String[]{"registroServizi", "configurazionePdD"};
        de.setValues(stati);
        de.setSelected(tipoxml);
        de.setName("tipoxml");
        dati.add(de);
        de = new DataElement();
        de.setValue("");
        de.setLabel("File");
        de.setType(DataElementType.FILE);
        de.setName("theFile");
        de.setSize(this.getSize());
        dati.add(de);
    }

    public boolean validateFileXml(Logger log, FormFile ff, StringBuilder errorBuffer, String tipologiaXML) {
        String schemaValidazione = null;
        try {
            ValidatoreXSD validatore = null;
            if ("registroServizi".equals(tipologiaXML)) {
                validatore = new ValidatoreXSD(log, ImportaXML.class.getResourceAsStream("/registroServizi.xsd"));
                schemaValidazione = "registroServizi.xsd";
            } else {
                validatore = new ValidatoreXSD(log, ImportaXML.class.getResourceAsStream("/config.xsd"));
                schemaValidazione = "config.xsd";
            }
            byte[] data = ff.getFileData();
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            validatore.valida((InputStream)bin);
            return true;
        }
        catch (Exception e) {
            errorBuffer.append("Errore validazione xsd (" + schemaValidazione + "): " + e.getMessage());
            return false;
        }
    }
}

