/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.servlet.login;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.loader.servlet.GeneralHelper;
import org.openspcoop2.web.loader.servlet.LoaderHelper;

public final class AuthorisationFilter
implements Filter {
    private FilterConfig filterConfig = null;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession(true);
        GeneralHelper generalHelper = new GeneralHelper(session);
        try {
            String contextPath = request.getContextPath();
            String urlRichiesta = request.getRequestURI();
            if (this.isRisorsaProtetta(request)) {
                String servletRichiesta;
                String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                if (userLogin == null) {
                    if ((contextPath + "/").equals(urlRichiesta)) {
                        this.setErrorMsg(generalHelper, session, request, response, "/jsplib/login.jsp", null);
                    } else {
                        this.setErrorMsg(generalHelper, session, request, response, "/jsplib/login.jsp", "La sessione &egrave; scaduta. Effettuare il login", MessageType.ERROR_SINTETICO);
                    }
                    return;
                }
                if (urlRichiesta.indexOf(".js") == -1 && ("".equals(servletRichiesta = urlRichiesta.substring((contextPath + "/").length())) || "/".equals(servletRichiesta))) {
                    response.sendRedirect(this.getRedirectToMessageServlet());
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            generalHelper.log.error("Errore rilevato durante l'authorizationFilter", (Throwable)e);
            try {
                this.setErrorMsg(generalHelper, session, request, response, "/jsplib/info.jsp", "L'ultima operazione effettuata ha provocato un errore che ha reso l'interfaccia non utilizzabile.<BR><BR>Effettuare nuovamente il login");
                return;
            }
            catch (Exception eClose) {
                generalHelper.log.error("Errore rilevato durante l'authorizationFilter (segnalazione errore)", (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void setErrorMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, String msgErrore) throws IOException, ServletException {
        this.setErrorMsg(gh, session, request, response, servletDispatcher, msgErrore, null, MessageType.ERROR);
    }

    public void setErrorMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, String msgErrore, MessageType messageType) throws IOException, ServletException {
        this.setErrorMsg(gh, session, request, response, servletDispatcher, msgErrore, null, messageType);
    }

    public void setErrorMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, String msgErrore, String msgErroreTitle, MessageType messageType) throws IOException, ServletException {
        String userLogin;
        PageData pd = gh.initPageData();
        GeneralData gd = gh.initGeneralData(request, "login.do");
        if (msgErrore != null) {
            pd.setMessage(msgErrore, msgErroreTitle, messageType);
        }
        if ((userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session)) != null) {
            try {
                LoaderHelper loaderHelper = new LoaderHelper(request, pd, session);
                loaderHelper.makeMenu();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
        this.filterConfig.getServletContext().getRequestDispatcher(servletDispatcher).forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isRisorsaProtetta(HttpServletRequest request) {
        String urlRichiesta = request.getRequestURI();
        return urlRichiesta.indexOf("/login.do") == -1 && urlRichiesta.indexOf("/images") == -1 && urlRichiesta.indexOf("/css") == -1 && urlRichiesta.indexOf("/fonts") == -1 && urlRichiesta.indexOf("/js") == -1;
    }

    private String getRedirectToMessageServlet() {
        return new Parameter("", "messagePage.do", new Parameter[]{new Parameter("mpText", "Console ripristinata con successo."), new Parameter("mpType", MessageType.INFO_SINTETICO.toString())}).getValue();
    }
}

